package it.softecspa.jwebber.common.classes;

import it.softecspa.mvc.utils.RewriteUtils;
import it.softecspa.mvc.utils.StringUtils;

import java.util.Date;

/**
 * Classe di utilit per la gestione dei dati di un 'Contenuto' dinamico
 */
public class Content {
	private int mDBIndex;
	private ContentType mCType = null;
	private String mName = "";
	private String mName4Rewrite = "";
	private String descr = "";
	private boolean mOnline = false;
	private Date mCreated = null;
	private Date mValidFrom = null;
	private Date mExpiry = null;
	private Date mLastModify = null;
	private Date mApproved = null;
	private Date mDeleted = null;
	private String[][] mValueList = null;

	/**
	 * Costruttore.
	 * 
	 * @param p_numDBIndex
	 *            ID del contentuo
	 * @param p_strName
	 *            nome del contenuto
	 */
	public Content(int p_numDBIndex, String p_strName, String descr) {
		mDBIndex = p_numDBIndex;
		mName = StringUtils.stripHtml(p_strName);
		mName4Rewrite = "";
		if (mName != null) {
			StringBuffer ris = new StringBuffer();
			mName4Rewrite = RewriteUtils.rewriteCMSWeb(mName);
			// Prendo le prime 3 parole
			String[] tmpStr = mName4Rewrite.split("-");
			int n = 3;
			if (tmpStr.length < 3)
				n = tmpStr.length;
			for (int i = 0; i < n; i++) {
				if (i > 0)
					ris.append("-");
				ris.append(tmpStr[i]);
			}
			mName4Rewrite = ris.toString();
		}
		this.descr = descr;
	}

	/*----------------------------------------------------------------------
	Metodi.                                                              
	----------------------------------------------------------------------*/
	public void setDBIndex(int p_numDBIndex) {
		mDBIndex = p_numDBIndex;
	}

	public void setContentType(ContentType p_objCType) {
		mCType = p_objCType;
	}

	public void setOnline(boolean p_bolOnline) {
		mOnline = p_bolOnline;
	}

	public void setCreateDate(Date p_datCreate) {
		if (p_datCreate != null) {
			mCreated = p_datCreate;
		}
	}

	public void setValidFromDate(Date p_datValidFrom) {
		mValidFrom = p_datValidFrom;
	}

	public void setExpiryDate(Date p_datExpiry) {
		mExpiry = p_datExpiry;
	}

	public void setLastModifyDate(Date p_datModify) {
		mLastModify = p_datModify;
	}

	public void setApproveDate(Date p_datApprove) {
		mApproved = p_datApprove;
	}

	public void setDeleteDate(Date p_datDelete) {
		mDeleted = p_datDelete;
	}

	public int getDBIndex() {
		return mDBIndex;
	}

	public ContentType getContentType() {
		return mCType;
	}

	public int getCTypeDBIndex() {
		if (mCType != null) {
			return mCType.getDBIndex();
		} else {
			return 0;
		}
	}

	public String getName() {
		if (mName == null) {
			return "";
		} else {
			if (mName.length() > 50) {
				return mName.substring(0, 47) + "...";
			} else {
				return mName;
			}
		}
	}

	public String getName4Rewrite() {
		if (mName4Rewrite == null) {
			return "";
		}
		return mName4Rewrite;
	}

	public String getDescr() {
		if (descr == null) {
			return "";
		} else {
			if (descr.length() > 50) {
				return descr.substring(0, 47) + "...";
			} else {
				return descr;
			}
		}
	}

	public void setDescr(String descr) {
		this.descr = descr;
	}

	public String getCTypeName() {
		if (mCType != null) {
			return mCType.getName();
		} else {
			return "";
		}
	}

	public boolean isOnline() {
		return mOnline;
	}

	public Date getCreateDate() {
		return mCreated;
	}

	public Date getValidFromDate() {
		return mValidFrom;
	}

	public Date getExpiryDate() {
		return mExpiry;
	}

	public Date getLastModifyDate() {
		return mLastModify;
	}

	public Date getApproveDate() {
		return mApproved;
	}

	public Date getDeleteDate() {
		return mDeleted;
	}

	public boolean isApproved() {
		return mApproved != null;
	}

	public boolean isDeleted() {
		return mDeleted != null;
	}

	public void setValueList(String[][] arrList) {
		this.mValueList = arrList;
	}

	/*
	 * public void addValue (String strValue, int numAliasType) { //If Not
	 * mInitDone Then Err.Raise 1, , "Istanza di classe non inizializzata."
	 * 
	 * ReDim Preserve mValueList( 2, UBound( mValueList, 2 ) + 1 );
	 * mValueList[1][UBound( mValueList, 2 )] = p_strValue;
	 * mValueList[2][UBound( mValueList, 2 )] = p_numAliasType; }
	 */

	/*
	 * public void updateValue ( int p_numIndex, String p_strValue ){ //If Not
	 * mInitDone Then Err.Raise 1, , "Istanza di classe non inizializzata." if
	 * (( p_numIndex < 1 ) || ( p_numIndex > UBound( mValueList ))){
	 * "Indice array non valido."; }
	 * 
	 * mValueList[1, p_numIndex] = p_strValue; }
	 */

	/**
	 * Recupera una matrice 2 * N contenete coppie nome alias / valore alias
	 * 
	 * @return La matrice dei valori degli alias associati al contenuto.
	 */
	public String[][] getValueList() {
		return mValueList;
	}

	public int getValueListSize() {
		return mValueList[1].length;
	}

	public String getValue(int numIndex) {
		return mValueList[0][numIndex];
	}

	/*
	 * public String extractCType ( ByRef p_arrCTypes ){
	 * 
	 * int i; String strName = ""; for(i=1; i<=UBound( p_arrCTypes );i++){ if
	 * (p_arrCTypes[i].getDBIndex() == mCType.getDBIndex()) { strName =
	 * p_arrCTypes[i].getName(); break; } } return strName; }
	 */

	/**
	 * Recupera il valore di un alias del contentuo dato il suo nome.
	 * 
	 * @param p_strAlias
	 *            Il nome dell'alias.
	 * @return Il valore dell'alias specificato o la stringa vuota se il
	 *         contenuto non possiede un alias con il nome specificato.
	 */
	public String getElement(String p_strAlias) {
		int numIndex = 0;
		String s = "";

		if (mCType != null) {
			numIndex = mCType.getAliasIndexByValue(p_strAlias);
		}

		if (numIndex >= 0) {
			// Elemento trovato
			s = mValueList[0][numIndex];
		}

		return s;
	}
}
