/*
 * Created on 28-feb-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.classes;

import java.util.Vector;

/**
 * Classe di utilit per la gestione dei dati di un 'Tipo contenuto'.
 */
public class ContentType {
	private int mDBIndex = 0;
	private String mName = "";
	private String mDescription = "";
	private boolean mWorkflow = false;
	private Vector<CntAlias> mAliasList = null;
	private int numMaxCnt = -1;
	private String filterOn = "";
	private String filter = "";

	/**
	 * Costruttore
	 * 
	 * @param p_numDBIndex
	 *            ID del tipo contentuo a DB.
	 * @param p_strName
	 *            Nome del tipo contenuto.
	 * @param p_strDescr
	 *            Descrizione del tipo contenuto.
	 * @param p_bolWorkflow
	 *            TRUE se i contentuti di questo tipo sono sottoposti ad
	 *            approvazione
	 * @param numMaxCnt
	 *            il numero massimo di contenuti che possono essere creati (-1
	 *            nessun limite) per essere pubblicati.
	 */
	public ContentType(int p_numDBIndex, String p_strName, String p_strDescr, boolean p_bolWorkflow, int numMaxCnt) {
		mDBIndex = p_numDBIndex;
		mName = p_strName;
		mDescription = p_strDescr;
		mWorkflow = p_bolWorkflow;
		this.numMaxCnt = numMaxCnt;

		mAliasList = new Vector<CntAlias>();
	}

	/*----------------------------------------------------------------------
	Metodi.                                                              
	----------------------------------------------------------------------*/
	public int getDBIndex() {
		return mDBIndex;
	}

	public String getName() {
		return mName;
	}

	public void setName(String p_strName) {
		mName = p_strName;
	}

	public String getDescription() {
		return mDescription;
	}

	public void setDescription(String p_strDescr) {
		mDescription = p_strDescr;
	}

	public boolean hasWorkflow() {
		return mWorkflow;
	}

	public void setWorkflow(boolean p_bolWorkflow) {
		mWorkflow = p_bolWorkflow;
	}

	public void setAliasList(Vector<CntAlias> arrList) {
		this.mAliasList = arrList;
	}

	public void addAlias(CntAlias objAlias) {
		this.mAliasList.add(objAlias);
	}

	/**
	 * @return Returns the numMaxCnt.
	 */
	public int getNumMaxCnt() {
		return numMaxCnt;
	}

	/**
	 * @param numMaxCnt
	 *            The numMaxCnt to set.
	 */
	public void setNumMaxCnt(int numMaxCnt) {
		this.numMaxCnt = numMaxCnt;
	}

	/**
	 * Restituisce la lista degli alias associati ad un template.
	 * 
	 * @return Un vettore contenente la lista degli alias (oggetti della classe
	 *         'cntAlias').
	 */
	public Vector<CntAlias> getAliasList() {
		return mAliasList;
	}

	/**
	 * Restituisce il numero di alias definiti per il tipo di contenuto.
	 * 
	 * @return Il numero degli alias.
	 */
	public int getAliasListSize() {
		return mAliasList.size();
	}

	/**
	 * Restituisce l'alias con l'indice specificato.
	 * 
	 * @param numIndex
	 *            L'indice dell'alias.
	 * @return L'alias (oggetto della classe 'cntAlias').
	 */
	public CntAlias getAlias(int numIndex) {
		return (CntAlias) mAliasList.get(numIndex);
	}

	/**
	 * Restituisce l'indice di un alias dato il suo nome.
	 * 
	 * @param strValue
	 *            Il nome dell'alias cercato.
	 * @return L'indice dell'alias.
	 */
	public int getAliasIndexByValue(String strValue) {
		int numIndex = -1;
		for (int i = 0; i < mAliasList.size(); i++) {
			CntAlias objAlias = (CntAlias) mAliasList.get(i);
			if (objAlias.getValue().equals(strValue)) {
				numIndex = i;
				break;
			}
		}
		return numIndex;
	}

	/**
	 * @return Returns the filter.
	 */
	public String getFilter() {
		return filter;
	}

	/**
	 * @param filter
	 *            The filter to set.
	 */
	public void setFilter(String filter) {
		this.filter = filter;
	}

	/**
	 * @return Returns the filterOn.
	 */
	public String getFilterOn() {
		return filterOn;
	}

	/**
	 * @param filterOn
	 *            The filterOn to set.
	 */
	public void setFilterOn(String filterOn) {
		this.filterOn = filterOn;
	}
}
