/*
 * Created on 25-feb-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.classes;

/**
 * Classe di utilit per la gestione dei metadati relativi all'alias di un
 * contenuto.
 */
public class ExtAliasMetadata {
	static final int MAX_SIZE = 8;
	private String[] mNames = null;;
	private int[] mMaxCounts = null;
	private int[] mCounts = null;
	private String[] mSQLPrefixes = null;
	private String[] mSQLColumns = null;

	/*----------------------------------------------------------------------
	Costruttore.
	----------------------------------------------------------------------*/
	public ExtAliasMetadata() {
		mNames = new String[MAX_SIZE];
		mMaxCounts = new int[MAX_SIZE];
		mCounts = new int[MAX_SIZE];
		mSQLPrefixes = new String[MAX_SIZE];
		mSQLColumns = new String[MAX_SIZE];
		mNames[0] = "Testo";
		mNames[1] = "Numero float";
		mNames[2] = "Numero intero";
		mNames[3] = "Link";
		mNames[4] = "Immagine";
		mNames[5] = "Data";
		mNames[6] = "Attachment";
		mNames[7] = "Selection";
		mMaxCounts[0] = 10;
		mMaxCounts[1] = 5;
		mMaxCounts[2] = 5;
		mMaxCounts[3] = 5;
		mMaxCounts[4] = 10;
		mMaxCounts[5] = 5;
		mMaxCounts[6] = 10;
		mMaxCounts[7] = 5;
		mSQLPrefixes[0] = "v";
		mSQLPrefixes[1] = "n";
		mSQLPrefixes[2] = "n";
		mSQLPrefixes[3] = "v";
		mSQLPrefixes[4] = "v";
		mSQLPrefixes[5] = "d";
		mSQLPrefixes[6] = "v";
		mSQLPrefixes[7] = "v";
		mSQLColumns[0] = "testo";
		mSQLColumns[1] = "float";
		mSQLColumns[2] = "intero";
		mSQLColumns[3] = "link";
		mSQLColumns[4] = "image";
		mSQLColumns[5] = "data";
		mSQLColumns[6] = "attach";
		mSQLColumns[7] = "selection";

		int numI;
		for (numI = 0; numI < MAX_SIZE; numI++) {
			mCounts[numI] = mMaxCounts[numI];
		}
	}

	/*----------------------------------------------------------------------
	Metodi.                                                              
	----------------------------------------------------------------------*/
	public String getName(int p_numIndex) {
		return mNames[p_numIndex];
	}

	public int getMaxCount(int p_numIndex) {
		return mMaxCounts[p_numIndex];
	}

	public int getCount(int p_numIndex) {
		return mCounts[p_numIndex];
	}

	public void clearCount(int p_numIndex) {
		mCounts[p_numIndex] = 0;
	}

	public void clearCounts() {
		int numI;
		for (numI = 0; numI < MAX_SIZE; numI++) {
			mCounts[numI] = 0;
		}
	}

	public void refillCount(int p_numIndex) {
		mCounts[p_numIndex] = mMaxCounts[p_numIndex];
	}

	public void refillCounts() {
		int numI;
		for (numI = 0; numI < MAX_SIZE; numI++) {
			mCounts[numI] = mMaxCounts[numI];
		}
	}

	public void incrementCount(int p_numIndex) {
		mCounts[p_numIndex] = mCounts[p_numIndex] + 1;
	}

	public void decrementCount(int p_numIndex) {
		mCounts[p_numIndex] = mCounts[p_numIndex] - 1;
	}

	public String getSQLPrefix(int p_numIndex) {
		return mSQLPrefixes[p_numIndex];
	}

	public String getSQLColumn(int p_numIndex) {
		return mSQLColumns[p_numIndex];
	}

	public int getMaxSize() {
		return MAX_SIZE;
	}
}
