package it.softecspa.jwebber.common.classes;

/**
 * Classe di utilit per la gestione dei dati di un 'Contenuto' dinamico
 */
public class Extension {
	private int mDBIndex;
	private ExtensionType extType = null;
	private String mName = "";
	private String[][] mValueList = null;

	/**
	 * Costruttore.
	 * 
	 * @param p_numDBIndex
	 *            ID del contentuo
	 * @param p_strName
	 *            nome del contenuto
	 */
	public Extension(int p_numDBIndex, String p_strName) {
		mDBIndex = p_numDBIndex;
		mName = p_strName;
	}

	/*----------------------------------------------------------------------
	Metodi.                                                              
	----------------------------------------------------------------------*/
	public void setDBIndex(int p_numDBIndex) {
		mDBIndex = p_numDBIndex;
	}

	public void setExtensionType(ExtensionType extType) {
		this.extType = extType;
	}

	public int getDBIndex() {
		return mDBIndex;
	}

	public ExtensionType getExtensionType() {
		return extType;
	}

	public int getExtTypeDBIndex() {
		if (extType != null) {
			return extType.getDBIndex();
		} else {
			return 0;
		}
	}

	public String getName() {
		if (mName == null) {
			return "";
		} else {
			if (mName.length() > 50) {
				return mName.substring(0, 47) + "...";
			} else {
				return mName;
			}
		}
	}

	public String getCTypeName() {
		if (extType != null) {
			return extType.getName();
		} else {
			return "";
		}
	}

	public void setValueList(String[][] arrList) {
		this.mValueList = arrList;
	}

	/*
	 * public void addValue (String strValue, int numAliasType) { //If Not
	 * mInitDone Then Err.Raise 1, , "Istanza di classe non inizializzata."
	 * 
	 * ReDim Preserve mValueList( 2, UBound( mValueList, 2 ) + 1 );
	 * mValueList[1][UBound( mValueList, 2 )] = p_strValue;
	 * mValueList[2][UBound( mValueList, 2 )] = p_numAliasType; }
	 */

	/*
	 * public void updateValue ( int p_numIndex, String p_strValue ){ //If Not
	 * mInitDone Then Err.Raise 1, , "Istanza di classe non inizializzata." if
	 * (( p_numIndex < 1 ) || ( p_numIndex > UBound( mValueList ))){
	 * "Indice array non valido."; }
	 * 
	 * mValueList[1, p_numIndex] = p_strValue; }
	 */

	/**
	 * Recupera una matrice 2 * N contenete coppie nome alias / valore alias
	 * 
	 * @return La matrice dei valori degli alias associati al contenuto.
	 */
	public String[][] getValueList() {
		return mValueList;
	}

	public int getValueListSize() {
		return mValueList[1].length;
	}

	public String getValue(int numIndex) {
		return mValueList[0][numIndex];
	}

	/*
	 * public String extractCType ( ByRef p_arrCTypes ){
	 * 
	 * int i; String strName = ""; for(i=1; i<=UBound( p_arrCTypes );i++){ if
	 * (p_arrCTypes[i].getDBIndex() == mCType.getDBIndex()) { strName =
	 * p_arrCTypes[i].getName(); break; } } return strName; }
	 */

	/**
	 * Recupera il valore di un alias del contentuo dato il suo nome.
	 * 
	 * @param p_strAlias
	 *            Il nome dell'alias.
	 * @return Il valore dell'alias specificato o la stringa vuota se il
	 *         contenuto non possiede un alias con il nome specificato.
	 */
	public String getElement(String p_strAlias) {
		int numIndex = 0;
		String s = "";

		if (extType != null) {
			numIndex = extType.getAliasIndexByValue(p_strAlias);
		}

		if (numIndex >= 0) {
			// Elemento trovato
			s = mValueList[0][numIndex];
		}

		return s;
	}
}
