/*
 * Created on 28-feb-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.classes;

import java.util.Vector;

/**
 * Classe di utilit per la gestione dei dati di un 'Tipo contenuto'.
 */
public class ExtensionType {
	private int mDBIndex = 0;
	private String mName = "";
	private String mDescription = "";
	// private boolean mWorkflow = false;
	private Vector<ExtAlias> mAliasList = null;

	/**
	 * Costruttore
	 * 
	 * @param p_numDBIndex
	 *            ID del tipo contentuo a DB.
	 * @param p_strName
	 *            Nome del tipo contenuto.
	 * @param p_strDescr
	 *            Descrizione del tipo contenuto. per essere pubblicati.
	 */
	public ExtensionType(int p_numDBIndex, String p_strName, String p_strDescr) {
		mDBIndex = p_numDBIndex;
		mName = p_strName;
		mDescription = p_strDescr;
		// mWorkflow = p_bolWorkflow;

		mAliasList = new Vector<ExtAlias>();
	}

	/*----------------------------------------------------------------------
	Metodi.                                                              
	----------------------------------------------------------------------*/
	public int getDBIndex() {
		return mDBIndex;
	}

	public String getName() {
		return mName;
	}

	public void setName(String p_strName) {
		mName = p_strName;
	}

	public String getDescription() {
		return mDescription;
	}

	public void setDescription(String p_strDescr) {
		mDescription = p_strDescr;
	}

	// public boolean hasWorkflow()
	// {
	// return mWorkflow;
	// }

	// public void setWorkflow ( boolean p_bolWorkflow )
	// {
	// mWorkflow = p_bolWorkflow;
	// }

	public void setAliasList(Vector<ExtAlias> arrList) {
		this.mAliasList = arrList;
	}

	public void addAlias(ExtAlias objAlias) {
		this.mAliasList.add(objAlias);
	}

	/**
	 * Restituisce la lista degli alias associati ad un template.
	 * 
	 * @return Un vettore contenente la lista degli alias (oggetti della classe
	 *         'cntAlias').
	 */
	public Vector<ExtAlias> getAliasList() {
		return mAliasList;
	}

	/**
	 * Restituisce il numero di alias definiti per il tipo di contenuto.
	 * 
	 * @return Il numero degli alias.
	 */
	public int getAliasListSize() {
		return mAliasList.size();
	}

	/**
	 * Restituisce l'alias con l'indice specificato.
	 * 
	 * @param numIndex
	 *            L'indice dell'alias.
	 * @return L'alias (oggetto della classe 'cntAlias').
	 */
	public ExtAlias getAlias(int numIndex) {
		return (ExtAlias) mAliasList.get(numIndex);
	}

	/**
	 * Restituisce l'indice di un alias dato il suo nome.
	 * 
	 * @param strValue
	 *            Il nome dell'alias cercato.
	 * @return L'indice dell'alias.
	 */
	public int getAliasIndexByValue(String strValue) {
		int numIndex = -1;
		for (int i = 0; i < mAliasList.size(); i++) {
			ExtAlias objAlias = (ExtAlias) mAliasList.get(i);
			if (objAlias.getValue().equals(strValue)) {
				numIndex = i;
				break;
			}
		}
		return numIndex;
	}
}
