/*
 * Created on 28-feb-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.classes;

import java.util.Vector;

/**
 * Classe di utilit per la gestione dei dati di una 'Pagina'. Ad ogni pagina 
 * associato un template di visualizzazione (una pagina JSP) che determina il
 * modo in cui i contenuti vengono visualizzati.
 */
public class Page implements Cloneable {
	private int mDBIndex = 0;
	private String mName = "";
	private String mDescription = "";
	private String mTemplateRef = "";
	private int oid_pag_mod = 0;
	private boolean isTmp = false;
	private Vector<TPAlias> mAlias = null;

	/*----------------------------------------------------------------------
	Costruttore.                                                         
	----------------------------------------------------------------------*/
	public Page(int p_numDBIndex, String p_strName, String p_strDescr, String p_strTemplateRef, int p_oid_pag_mod) {
		mDBIndex = p_numDBIndex;
		mName = p_strName;
		mDescription = p_strDescr;
		mTemplateRef = p_strTemplateRef;
		oid_pag_mod = p_oid_pag_mod;
		mAlias = new Vector<TPAlias>();
	}

	public Object clone() {
		Object o = null;
		try {
			o = super.clone();
		} catch (CloneNotSupportedException e) {
			System.err.println("MyObject can't clone");
		}
		return o;
	}

	/*----------------------------------------------------------------------
	 Metodi.                                                              
	 ----------------------------------------------------------------------*/
	public int getDBIndex() {
		return mDBIndex;
	}

	public String getName() {
		return mName;
	}

	public void setName(String p_strName) {
		mName = p_strName;
	}

	public String getDescription() {
		return mDescription;
	}

	public void setDescription(String p_strDescr) {
		mDescription = p_strDescr;
	}

	public String getTemplateRef() {
		return mTemplateRef;
	}

	public int getTemplateStaticID() {
		int ret;

		int i = mTemplateRef.indexOf("#");
		String s;

		if (i > 0) {
			s = mTemplateRef.substring(0, i - 1);
		} else {
			s = mTemplateRef;
		}

		try {
			ret = Integer.parseInt(s);
		} catch (Exception e) {
			ret = 0;
		}

		return ret;
	}

	/*
	 * @deprecated
	 * 
	 * @return TRUE se la pagina ha associato un template dinamico
	 */
	/*
	 * public boolean hasTemplateDynamic() { boolean ret = false;
	 * 
	 * int i = mTemplateRef.indexOf("#");
	 * 
	 * if ( i > 0 ) { try {
	 * Integer.parseInt(mTemplateRef.substring(mTemplateRef.length() - i)); ret
	 * = true; } catch(Exception e) { ret = false; } }
	 * 
	 * return ret; }
	 */

	/*
	 * @deprecated
	 * 
	 * @return l'ID del template dinamico associato alla pagina
	 */
	/*
	 * public int getTemplateDynamicID() { int ret = 0;
	 * 
	 * int i = mTemplateRef.indexOf("#");
	 * 
	 * String s = ""; if( i > 0 ) { s =
	 * mTemplateRef.substring(mTemplateRef.length() - i); }
	 * 
	 * try { ret = Integer.parseInt(s); } catch(Exception e) { ret = 0; }
	 * 
	 * return ret; }
	 */

	public void setTemplateRef(String p_strTemplateRef) {
		mTemplateRef = p_strTemplateRef;
	}

	/*
	 * @deprecated
	 * 
	 * @return L'ID del tipo di contenuto dinamico associato alla pagina.
	 */
	/*
	 * public int getContentTypeID() { return mCTypeID; }
	 */

	/*
	 * @deprecated
	 * 
	 * @return TRUE se alla pagina  associato un contenuto dinamico.
	 */
	/*
	 * public boolean hasContentType() { return ( mCTypeID > 0 ); }
	 */

	/*
	 * @deprecated
	 * 
	 * @param p_numCTypeID Setta l'ID del contenuto dinamico associat alla
	 * pagina.
	 */
	/*
	 * public void setContentTypeID ( int p_numCTypeID ) { mCTypeID =
	 * p_numCTypeID; }
	 */

	public void addAlias(TPAlias p_objAlias) {
		mAlias.add(p_objAlias);
	}

	public void setAlias(Vector<TPAlias> p_arrAlias) {
		mAlias = p_arrAlias;
	}

	/**
	 * Recupera la lista degli alias associati alla pagina.
	 * 
	 * @return Vettore degli alias (oggetti della classe 'TPAlias').
	 */
	public Vector<TPAlias> getAlias() {
		return mAlias;
	}

	/**
	 * Recupera uno specifico alias in base al suo indice.
	 * 
	 * @param p_numIndex
	 *            L'indice dell'alias.
	 * @return L'alias richiesto (oggetto della classe 'TPAlias').
	 */
	public TPAlias getOneAlias(int p_numIndex) {
		TPAlias ret = null;

		if (p_numIndex >= 0 && p_numIndex < mAlias.size())
			ret = (TPAlias) mAlias.get(p_numIndex);

		return ret;
	}

	/**
	 * Recupera uno specifico alias in base al suo nome.
	 * 
	 * @param p_strAlias
	 *            Il nome dell'alias.
	 * @return L'alias richiesto (oggetto della classe 'TPAlias').
	 */
	public TPAlias getOneAliasByName(String p_strAlias) {
		TPAlias o = null;

		for (int i = 0; i < mAlias.size(); i++) {
			if (((TPAlias) mAlias.get(i)).getAlias().equals(p_strAlias)) {
				o = (TPAlias) mAlias.get(i);
				break;
			}
		}

		return o;
	}

	/**
	 * Setta il valore di un alias in base al suo indice.
	 * 
	 * @param p_numIndex
	 *            Indice dell'alias.
	 * @param p_strValue
	 *            Valore dell'alias.
	 */
	public void setAliasValue(int p_numIndex, String p_strValue) {
		((TPAlias) mAlias.get(p_numIndex)).setValue(p_strValue);
	}

	/**
	 * Setta il valore di un alias in base al nome dell'alias.
	 * 
	 * @param p_strAlias
	 *            Il nome dell'alias.
	 * @param p_strValue
	 *            Il valore dell'alias.
	 */
	public void setAliasValueByName(String p_strAlias, String p_strValue) {
		for (int i = 0; i < mAlias.size(); i++) {
			TPAlias alias = (TPAlias) mAlias.get(i);
			if (alias.getAlias().equals(p_strAlias)) {
				alias.setValue(p_strValue);
				break;
			}
		}
	}

	/**
	 * Controlla se la pagina possiede l'alias specificato.
	 * 
	 * @param p_strAlias
	 *            Il nome dell'alias.
	 * @return TRUE se l'alias specificato  definito per la pagina.
	 */
	public boolean hasElement(String p_strAlias) {
		TPAlias o = null;
		boolean found = false;

		for (int i = 0; i < mAlias.size(); i++) {
			if (((TPAlias) mAlias.get(i)).getAlias().equals(p_strAlias)) {
				o = (TPAlias) mAlias.get(i);
				break;
			}
		}

		if (o != null) {
			found = o.getValue().trim().length() > 0;
		}

		return found;
	}

	/**
	 * Recupera il valore di un alias della pagina in base al suo nome.
	 * 
	 * @param p_strAlias
	 *            Il nome dell'alias.
	 * 
	 * @return Il valore dell'alias o una stringa vuota se l'alias non esiste.
	 */
	public String getElement(String p_strAlias) {
		TPAlias o = null;
		String s = "";

		for (int i = 0; i < mAlias.size(); i++) {
			if (((TPAlias) mAlias.get(i)).getAlias().equals(p_strAlias)) {
				o = (TPAlias) mAlias.get(i);
				break;
			}
		}

		if (o != null) {
			s = o.getValue();
			switch (o.getType()) {
			case 2: // s = fn_GetIniValue( "Upload Paths|WebberUploadImages"
					// )+s;
				break;
			case 3: // s = fn_GetIniValue( "Upload Paths|WebberUploadObject"
					// )+s;
				break;
			}
		}

		return s;
	}

	/**
	 * @return Returns the oid_pag_mod.
	 */
	public int getOid_pag_mod() {
		return oid_pag_mod;
	}

	/**
	 * @param oid_pag_mod
	 *            The oid_pag_mod to set.
	 */
	public void setOid_pag_mod(int oid_pag_mod) {
		this.oid_pag_mod = oid_pag_mod;
	}

	/**
	 * @return Returns the mDBIndex.
	 */
	public int getMDBIndex() {
		return mDBIndex;
	}

	/**
	 * @param index
	 *            The mDBIndex to set.
	 */
	public void setMDBIndex(int index) {
		mDBIndex = index;
	}

	/**
	 * @return Returns the isTmp.
	 */
	public boolean isTmp() {
		return isTmp;
	}

	/**
	 * @param isTmp
	 *            The isTmp to set.
	 */
	public void setTmp(boolean isTmp) {
		this.isTmp = isTmp;
	}
}
