/*
 * Created on 28-feb-2005
 *
 * Zeno Amerini may 2007 - Copia e sposta canali 
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.common.classes.ChannelType;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il reperimento e il salvataggio a DB dei dati relativi ai Canali.
 */
public class ChanType_mgr {
	/**
	 * Restituisce un vector con i tipi di canale editabili
	 * 
	 * @return ID della pagina.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetChannelTypes(boolean isDefault) throws Exception {
		Vector arrChaType = new Vector();
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT v20_cha_type, v20_cha_type_descr, n20_cha_type_default, v20_cha_container, n20_cha_type_created FROM cms_20_tipo_canale" + " WHERE n20_cha_type_default=" + ((isDefault) ? "1" : "0 AND n20_cha_type_created=0");

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				ChannelType objChaType = new ChannelType(rs.getString("v20_cha_type"), rs.getString("v20_cha_type_descr"), (rs.getInt("n20_cha_type_default") == 1) ? true : false, rs.getString("v20_cha_container"),
						(rs.getInt("n20_cha_type_created") == 1) ? true : false);
				arrChaType.add(objChaType);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrChaType;
	}

	/**
	 * Restituisce un vector con tutti i tipi di canale editabili
	 * 
	 * @return ID della pagina.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetChannelTypesAll() throws Exception {
		Vector arrChaType = new Vector();
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT v20_cha_type, v20_cha_type_descr, n20_cha_type_default, v20_cha_container, n20_cha_type_created FROM cms_20_tipo_canale";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				ChannelType objChaType = new ChannelType(rs.getString("v20_cha_type"), rs.getString("v20_cha_type_descr"), (rs.getInt("n20_cha_type_default") == 1) ? true : false, rs.getString("v20_cha_container"),
						(rs.getInt("n20_cha_type_created") == 1) ? true : false);
				arrChaType.add(objChaType);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrChaType;
	}

	/**
	 * Restituisce un vector con tutti i tipi di canale editabili
	 * 
	 * @return ID della pagina.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetChannelTypesCreated() throws Exception {
		Vector arrChaType = new Vector();
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT v20_cha_type, v20_cha_type_descr, n20_cha_type_default, v20_cha_container, n20_cha_type_created FROM cms_20_tipo_canale WHERE n20_cha_type_created=1";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				ChannelType objChaType = new ChannelType(rs.getString("v20_cha_type"), rs.getString("v20_cha_type_descr"), (rs.getInt("n20_cha_type_default") == 1) ? true : false, rs.getString("v20_cha_container"),
						(rs.getInt("n20_cha_type_created") == 1) ? true : false);
				arrChaType.add(objChaType);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrChaType;
	}

	/**
	 * Restituisce un oggetto channel type per un determinato tipo
	 * 
	 * @param type
	 * 
	 * @return ID della pagina.
	 * 
	 * @throws Exception
	 */
	static public ChannelType fn_GetChannelTypes(String type) throws Exception {
		ChannelType objChaType = null;
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT v20_cha_type, v20_cha_type_descr, n20_cha_type_default, v20_cha_container, n20_cha_type_created FROM cms_20_tipo_canale" + " WHERE v20_cha_type='" + type + "'";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				objChaType = new ChannelType(rs.getString("v20_cha_type"), rs.getString("v20_cha_type_descr"), (rs.getInt("n20_cha_type_default") == 1) ? true : false, rs.getString("v20_cha_container"),
						(rs.getInt("n20_cha_type_created") == 1) ? true : false);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objChaType;
	}

	/**
	 * Crea un nuovo canale.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objChannel
	 *            L'oggetto contenente i dati del nuovo canale.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @return L'ID del nuovo canale creato.
	 * 
	 * @throws Exception
	 */
	public static int fn_CreateChannelTypes(Connection conn, ChannelType objChanTypes, Logger logger) throws Exception {
		int newID = 0;
		String strCmd = "";

		try {
			strCmd = "INSERT INTO cms_20_tipo_canale (v20_cha_type, v20_cha_type_descr, n20_cha_type_default, v20_cha_container, n20_cha_type_created)" + " VALUES (" + Query.toSQL(objChanTypes.getChaType()) + ", "
					+ Query.toSQL(objChanTypes.getChaTypeDescr());

			if (objChanTypes.isDefault())
				strCmd += ", 1";
			else
				strCmd += ", 0";

			strCmd += ", " + Query.toSQL(objChanTypes.getContainer());

			if (objChanTypes.isChaTypeCrea())
				strCmd += ", 1)";
			else
				strCmd += ", 0)";

			if (logger != null && logger.isDebugEnabled()) {
				logger.debug("fn_CreateChannel::Cmd = " + strCmd);
			}
			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateChannel", e);
			throw e;
		}

		return newID;
	}

	/**
	 * Libera il channel type da vincoli quindi riutilizzabile.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objChannel
	 *            L'oggetto contenente i dati del canale da aggiornare.
	 * @param logger
	 *            Il logger (p essere null).
	 * 
	 * @throws Exception
	 */
	public static void fn_UpdateChanTypeFree(Connection conn, String oldChaType, Logger logger) throws Exception {
		try {
			String strCmd = "UPDATE cms_20_tipo_canale SET n20_cha_type_created = 0 WHERE v20_cha_type = '" + oldChaType + "'";

			if (logger != null && logger.isDebugEnabled()) {
				logger.debug("fn_UpdateChannel::Cmd = " + strCmd);
			}
			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateChannel", e);
			throw e;
		}
	}

	/**
	 * Aggiorna i dati di un canale.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objChannel
	 *            L'oggetto contenente i dati del canale da aggiornare.
	 * @param logger
	 *            Il logger (p essere null).
	 * 
	 * @throws Exception
	 */
	public static void fn_UpdateChanType(Connection conn, ChannelType objChanTypes, Logger logger) throws Exception {
		try {
			String strCmd = "";

			strCmd = "UPDATE cms_20_tipo_canale" +
					" SET v20_cha_type_descr = " + Query.toSQL(objChanTypes.getChaTypeDescr());
			if (objChanTypes.isDefault())
				strCmd += ", n20_cha_type_default = 1";
			else
				strCmd += ", n20_cha_type_default = 0";

			strCmd += ", v20_cha_container = " + Query.toSQL(objChanTypes.getContainer());
			if (objChanTypes.isChaTypeCrea())
				strCmd += ", n20_cha_type_created = 1";
			else
				strCmd += ", n20_cha_type_created = 0";
			strCmd += " WHERE v20_cha_type = " + Query.toSQL(objChanTypes.getChaType());

			if (logger != null && logger.isDebugEnabled()) {
				logger.debug("fn_UpdateChannel::Cmd = " + strCmd);
			}
			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			if (objChanTypes.isDefault()) {
				strCmd = "UPDATE cms_20_tipo_canale" +
						" SET n20_cha_type_default = 0";
				strCmd += " WHERE v20_cha_type != " + String.valueOf(objChanTypes.getChaType());

				if (logger != null && logger.isDebugEnabled()) {
					logger.debug("fn_UpdateChannel::Cmd = " + strCmd);
				}
				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}

		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateChannel", e);
			throw e;
		}
	}

	/**
	 * Elimina un canale.
	 * 
	 * @param numDBIndex
	 *            ID del canale da eliminare.
	 * 
	 * @throws Exception
	 */
	public static void fn_DeleteChanType(String type) throws Exception {
		Connection conn = null;
		Statement stmt;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			conn.setAutoCommit(false);

			String strCmd = "DELETE FROM cms_20_tipo_canale WHERE v20_cha_type = '" + type + "'";
			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			conn.commit();
		} catch (Exception e) {
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}
	}
}
