/*
 * Created on 28-feb-2005
 *
 * Zeno Amerini may 2007 - Copia e sposta canali 
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.common.classes.Channel;
import it.softecspa.jwebber.common.classes.ChannelPosition;
import it.softecspa.jwebber.common.classes.ChannelType;
import it.softecspa.jwebber.common.classes.Page;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.portal.Parameters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il reperimento e il salvataggio a DB dei dati relativi
 * ai Canali.
 */
public class Channel_mgr {
	private static Parameters parameters = Parameters.getInstance();

	public static Channel getKeywordsChannel(int numDBIndex) throws Exception {
		Channel channel = fn_GetChannel(numDBIndex);
		if (channel != null && !channel.hasKeywords()) {
			return getKeywordsChannel(channel.getParentChannelID());
		} else {
			return channel;
		}
	}

	/**
	 * Controlla se un certo canale  visibile per un certo profilo utente.
	 * 
	 * @param oid_canale
	 *            L'ID del canale.
	 * @param id_profilo
	 *            L'ID del profilo.
	 * 
	 * @return TRUE se si dispone dell'autorizzazione.
	 * 
	 * @throws Exception
	 */
	static public boolean canSeeChannel(String oid_canale, String id_profilo) throws Exception {
		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT n01_cha_oid" +
							   " FROM cms_01_profilo_canali" +
							  " WHERE n01_cha_oid = " + oid_canale + 
							    " AND id_profilo = '" + id_profilo + "'" +
							    " AND n01_cha_visible = 1";
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				return true;
			}
		} catch (Exception ex) {
			throw ex;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return false;
	}

	/**
	 * Controlla se un certo canale  editabile da un certo profilo utente.
	 * 
	 * @param oid_canale
	 *            L'ID del canale.
	 * @param id_profilo
	 *            L'ID del profilo.
	 * 
	 * @return TRUE se si dispone dell'autorizzazione.
	 * 
	 * @throws Exception
	 */
	static public boolean canEditChannel(String oid_canale, String id_profilo) throws Exception {
		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT n01_cha_oid" +
							   " FROM cms_01_profilo_canali" +
							  " WHERE n01_cha_oid = " + oid_canale + 
							    " AND id_profilo='" + id_profilo + "'" +
							    " AND n01_cha_editable = 1";
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				return true;
			}
		} catch (Exception ex) {
			throw ex;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return false;
	}

	/**
	 * Restituisce un elenco di canali in base ad una serie di condizioni.
	 * 
	 * @param strCondition
	 *            Condizione da applicare come filtro.
	 * @param id_profilo
	 *            Se diverso da "" restituisce la lista dei canali visibili al
	 *            profilo specificato.
	 * @param gruppo_canale
	 *            Se diverso da "" restituisce solo i canali del gruppo
	 *            specificato.
	 * @param action
	 *            Se  uguale a "edit" restituisce la lista dei canali editabili
	 *            che rispettano tutte le altre condizioni altrimenti la lista
	 *            di tutti quelli visibili.
	 * 
	 * @return Un riferimento al Vector che conterr i canali (oggetti di tipo
	 *         Channel).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public Vector fn_GetChannelsByCondition(String strCondition, String id_profilo, String gruppo_canale, String action) throws Exception {
		String strOrderBy = "n09_cha_order ASC";
		return fn_ChannelsByConditionAndOrder(strCondition, strOrderBy, id_profilo, gruppo_canale, action);
	}

	/**
	 * Restituisce l'elenco dei canali in base ad una condizione e ad un
	 * criterio di ordinamento.
	 * 
	 * @param strCondition
	 *            Condizione da applicare come filtro.
	 * @param strOrderBy
	 *            Condizione di ordinamento.
	 * @param id_profilo
	 *            Se diverso da "" restituisce la lista dei canali visibili al
	 *            profilo specificato.
	 * @param gruppo_canale
	 *            Se diverso da "" restituisce solo i canali del gruppo
	 *            specificato.
	 * @param action
	 *            Se  uguale a "edit" restituisce la lista dei canali editabili
	 *            che rispettano tutte le altre condizioni altrimenti la lista
	 *            di tutti quelli visibili.
	 * 
	 * @return Un riferimento al Vector che conterr i canali (oggetti di tipo
	 *         Channel).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	static public Vector fn_ChannelsByConditionAndOrder(String strCondition, String strOrderBy, String id_profilo, String gruppo_canale, String action) throws Exception {
		Vector channelVect = new Vector();
		Connection conn = null;

		try {
			String strQuery = null;
			
			conn = DatabaseManager.getInstance().getConnection();
			if (XString.isBlankNull(id_profilo)) {
				strQuery = "SELECT n09_cha_oid, v09_cha_nome, v09_cha_descr, n09_cha_parent_oid" +
						        ", n09_cha_online_preview, n09_cha_online_produz" +
						        ", n09_cha_workflow, n09_cha_order, v09_cha_usertypes" +
						        ", v09_cha_type, v09_cha_link, n09_cha_islink, n09_cha_isroot" +
						        ", n09_cha_ishttps, v09_cha_position, v09_cha_book, n09_pag_oid" +
						        ", n09_cha_no_map, n09_cha_level, n09_cha_keywords, n09_cha_key_desc" +
						   " FROM cms_09_canali" +
						       ", cms_20_tipo_canale" +
						   " WHERE cms_09_canali.v09_cha_type = cms_20_tipo_canale.v20_cha_type";

				if (strCondition.length() > 0) {
					strQuery += " AND " + strCondition.trim();
				}
				if (gruppo_canale.length() > 0) {
					strQuery += " AND v09_cha_type IN (" + gruppo_canale + ")";
				}
				strQuery += " ORDER BY n09_cha_order";
				if (strOrderBy.length() > 0) {
					strQuery += " , " + strOrderBy.trim();
				}
			} else {
				strQuery = "SELECT n09_cha_oid, v09_cha_nome, v09_cha_descr, n09_cha_parent_oid, n09_cha_online_preview, n09_cha_online_produz" +
								", n09_cha_workflow, n09_cha_order, v09_cha_usertypes, v09_cha_type, v09_cha_link" +
								", n09_cha_islink, n09_cha_isroot, n09_cha_ishttps, v09_cha_position, v09_cha_book" +
								", n09_pag_oid, n09_cha_no_map, n09_cha_level, n09_cha_keywords, n09_cha_key_desc" +
						    " FROM cms_09_canali" +
						    	", cms_01_profilo_canali" +
						    	", cms_20_tipo_canale" +
						    " WHERE cms_09_canali.n09_cha_oid = cms_01_profilo_canali.n01_cha_oid" +
						      " AND cms_09_canali.v09_cha_type = cms_20_tipo_canale.v20_cha_type" +
						      " AND cms_01_profilo_canali.ID_PROFILO ='" + id_profilo + "'";

				if ("edit".equals(action))
					strQuery += " AND cms_01_profilo_canali.n01_cha_editable=1";
				else
					strQuery += " AND cms_01_profilo_canali.n01_cha_visible=1";

				if (strCondition.length() > 0) {
					strQuery += " AND " + strCondition.trim();
				}
				if (gruppo_canale.length() > 0) {
					strQuery += " AND v09_cha_type IN (" + gruppo_canale + ")";
				}
				strQuery += " ORDER BY n09_cha_order";
				if (strOrderBy.length() > 0) {
					strQuery += " , " + strOrderBy.trim();
				}
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				Channel objChannel = new Channel(rs.getInt("n09_cha_oid")
									   , rs.getString("v09_cha_nome")
									   , rs.getString("v09_cha_descr")
									   , rs.getBoolean("n09_cha_online_preview")
									   , rs.getBoolean("n09_cha_online_produz")
									   , rs.getBoolean("n09_cha_workflow")
									   , rs.getString("v09_cha_type")
									   , rs.getString("v09_cha_link")
									   , (rs.getInt("n09_cha_islink") == 1 ? true : false)
									   , (rs.getInt("n09_cha_isroot") == 1 ? true : false)
									   , (rs.getInt("n09_cha_ishttps") == 1 ? true : false)
									   , rs.getString("v09_cha_position")
									   , rs.getString("v09_cha_book")
									   , rs.getInt("n09_cha_level")
									   , rs.getString("n09_cha_keywords")
									   , rs.getString("n09_cha_key_desc")
									   , parameters);
				int order = rs.getInt("n09_cha_order");
				if (!rs.wasNull()) {
					objChannel.setOrder(order);
				}

				objChannel.setNotInMap(rs.getInt("n09_cha_no_map") == 1);
				objChannel.setPageID(rs.getInt("n09_pag_oid"));
				objChannel.setParentChannelID(rs.getInt("n09_cha_parent_oid"));

				// ZZ Mancherebbe v09_cha_usertypes ma non viene usato mai

				channelVect.add(objChannel);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return channelVect;
	}

	/**
	 * Restituisce il canale da usare come Home Page del portale.
	 * 
	 * @param strName
	 *            Il nome del canale di primo livello definito come homepage.
	 * 
	 * @return Un riferimento al canale (oggetto di tipo Channel).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public Channel fn_GetHomeChannel(String strName, String id_profilo, String gruppo_canale, String action, boolean preview) throws Exception {
		
		String strCondition = "(v09_cha_nome = " + Query.toSQL(strName) + ") AND (n09_cha_parent_oid=0) ";
		if (preview) {
			strCondition += " AND (n09_cha_online_preview=1) ";
		} else {
			strCondition += " AND (n09_cha_online_produz=1) ";
		}

		Vector arrChannels = fn_GetChannelsByCondition(strCondition, id_profilo, gruppo_canale, action);
		if (!arrChannels.isEmpty()) {
			return (Channel) arrChannels.elementAt(0);
		}

		return null;
	}

	/**
	 * Restituisce il canale da usare come Home Page del portale.
	 * 
	 * @return Un riferimento al canale (oggetto di tipo Channel).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public Channel fn_GetHomeChannel(boolean preview, String cha_type) throws Exception {
		
		String strCondition = "(n09_cha_isroot=1) ";
		if (preview) {
			strCondition += " AND (n09_cha_online_preview=1) ";
		} else {
			strCondition += " AND (n09_cha_online_produz=1) ";
		}
		strCondition += " AND v09_cha_type='" + cha_type + "'";

		Vector arrChannels = fn_GetChannelsByCondition(strCondition, "", "", "view");
		if (!arrChannels.isEmpty()) {
			return (Channel)arrChannels.elementAt(0);
		}
		return null;
	}

	/**
	 * Restituisce la radice di un gruppo di canali.
	 * 
	 * @param strChaGroup
	 *            Il nome del gruppo di canali.
	 * 
	 * @return Un riferimento al canale (oggetto di tipo Channel).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public Channel fn_GetRootChannel(String strChaGroup) throws Exception {
		Channel channel_ret = null;
		String strCondition = "";
		Vector arrChannels = null;

		strCondition = "(n09_cha_parent_oid=0)";

		arrChannels = fn_GetChannelsByCondition(strCondition, "", "'" + strChaGroup + "'", "view");
		if (!arrChannels.isEmpty()) {
			channel_ret = (Channel) arrChannels.elementAt(0);
		}

		return channel_ret;
	}

	/**
	 * Restituisce il canale a cui  associato il bookmark specificato.
	 * 
	 * @param strBookmark
	 *            Il bookmark.
	 * @param id_profilo
	 *            Se diverso da "" restituisce il canale solo se visibile al profilo specificato.
	 * 
	 * @return Un riferimento al canale (oggetto di tipo Channel).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public Channel fn_GetChannelByBookmark(String strBookmark, String id_profilo, String cha_type, boolean preview) throws Exception {
		Channel channel_ret = null;
		Vector arrChannels = null;

		String strCondition = "(v09_cha_book = " + Query.toSQL(strBookmark) + ") ";
		if (preview) {
			strCondition += " AND (n09_cha_online_preview=1) ";
		} else {
			strCondition += " AND (n09_cha_online_produz=1) ";
		}
		strCondition += " AND v09_cha_type='" + cha_type + "'";

		arrChannels = fn_GetChannelsByCondition(strCondition, id_profilo, "", "view");
		if (!arrChannels.isEmpty()) {
			channel_ret = (Channel) arrChannels.elementAt(0);
		}

		return channel_ret;
	}

	/**
	 * Restituisce i dati di un canale dato il suo ID.
	 * 
	 * @param numDBIndex
	 *            ID del canale.
	 * 
	 * @return Un riferimento al canale (oggetto di tipo Channel).
	 * 
	 * @throws Exception
	 */
	static public Channel fn_GetChannel(int numDBIndex) throws Exception {
		Channel objChannel = null;
		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT v09_cha_nome, v09_cha_descr, n09_cha_parent_oid, n09_pag_oid" +
					        	   ", n09_cha_online_preview, n09_cha_online_produz, n09_cha_workflow" +
					        	   ", n09_cha_order, v09_cha_usertypes, v09_cha_type, v09_cha_link" +
					        	   ", n09_cha_islink, n09_cha_isroot, n09_cha_ishttps, v09_cha_position" +
					        	   ", v09_cha_book, n09_cha_no_map, n09_cha_level, n09_cha_keywords" +
					        	   ", n09_cha_key_desc" +
					           " FROM cms_09_canali" + 
					          " WHERE n09_cha_oid = " + String.valueOf(numDBIndex);
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				objChannel = new Channel(numDBIndex
									   , rs.getString("v09_cha_nome")
									   , rs.getString("v09_cha_descr")
									   , rs.getBoolean("n09_cha_online_preview")
									   , rs.getBoolean("n09_cha_online_produz")
									   , rs.getBoolean("n09_cha_workflow")
									   , rs.getString("v09_cha_type")
									   , rs.getString("v09_cha_link")
									   , (rs.getInt("n09_cha_islink") == 1 ? true : false)
									   , (rs.getInt("n09_cha_isroot") == 1 ? true : false)
									   , (rs.getInt("n09_cha_ishttps") == 1 ? true : false)
									   , rs.getString("v09_cha_position")
									   , rs.getString("v09_cha_book")
									   , rs.getInt("n09_cha_level")
									   , rs.getString("n09_cha_keywords")
									   , rs.getString("n09_cha_key_desc")
									   , parameters);
				int parent_oid = rs.getInt("n09_cha_parent_oid");
				if (rs.wasNull()) {
					objChannel.setParentChannelID(0);
				} else {
					objChannel.setParentChannelID(parent_oid);
				}

				int page_oid = rs.getInt("n09_pag_oid");
				if (rs.wasNull()) {
					objChannel.setPageID(0);
				} else {
					objChannel.setPageID(page_oid);
				}

				int order = rs.getInt("n09_cha_order");
				if (!rs.wasNull()) {
					objChannel.setOrder(order);
				}

				objChannel.setNotInMap(rs.getInt("n09_cha_no_map") == 1);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return objChannel;
	}
	
	
	static public String fn_GetChannelName(int numDBIndex) throws Exception {
		return fn_GetChannelName(""+numDBIndex);
	}
	
	static public String fn_GetChannelName(String numDBIndex) throws Exception {
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT v09_cha_nome" +
							   " FROM cms_09_canali" + 
							  " WHERE n09_cha_oid = " + numDBIndex;
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				return rs.getString("v09_cha_nome");				
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}
		return "Uncknown";
	}
	

	/**
	 * Controlla se esiste gi un dato canale. Il controllo viene fatto in base
	 * al nome del canale.
	 * 
	 * @param numDBIndex
	 *            ID da scartare ( 0 = nessuno scarto ).
	 * @param strName
	 *            Nome del canale da controllare.
	 * 
	 * @return TRUE se il canale esiste.
	 * 
	 * @throws Exception
	 */
	static public boolean fn_ChannelExists(int numDBIndex, String strName, String strChaType) throws Exception {
		
		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT n09_cha_oid" +
							   " FROM cms_09_canali" + 
							  " WHERE v09_cha_nome = " + Query.toSQL(strName) + 
							    " AND v09_cha_type = " + Query.toSQL(strChaType);
			if (numDBIndex > 0) {
				strQuery += " AND n09_cha_oid NOT IN (" + String.valueOf(numDBIndex) + ")";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				return true;
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return false;
	}

	/**
	 * Controlla se esiste gi un canale con un dato bookmark.
	 * 
	 * @param numDBIndex
	 *            ID da scartare ( 0 = nessuno scarto ).
	 * @param strBook
	 *            Bookmark da controllare.
	 * 
	 * @return TRUE se il bookmark esiste.
	 * 
	 * @throws Exception
	 */
	static public boolean fn_BookmarkExists(int numDBIndex, String strBook, String strChaType) throws Exception {
		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT n09_cha_oid" +
					           " FROM cms_09_canali" + 
					          " WHERE v09_cha_book = " + Query.toSQL(strBook) + 
					            " AND v09_cha_type = " + Query.toSQL(strChaType);
			// Pezzino Isabella -- aggiunta del CHANNEL TYPE nell'univocit del
			// BOOKMARK per getione multilingua
			if (numDBIndex > 0) {
				strQuery += " AND n09_cha_oid NOT IN (" + String.valueOf(numDBIndex) + ")";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				return true;
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return false;
	}

	/**
	 * Restituisce il massimo indice gi utilizzato per l'ordinamento dei figli
	 * di un dato canale. Se il canale non ha figli, viene restituito il valore
	 * "0".
	 * 
	 * @param numDBIndex
	 *            ID del canale padre.
	 * 
	 * @return Il massimo indice gi utilizzato per l'ordinamento.
	 * 
	 * @throws Exception
	 */
	public static int fn_GetChildrensMaxOrder(int numDBIndex) throws Exception {
		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT Max( n09_cha_order ) AS maxOrder" +
							   " FROM cms_09_canali" + 
							   " WHERE n09_cha_parent_oid ";
			if (numDBIndex > 0) {
				strQuery += "= " + String.valueOf(numDBIndex);
			} else {
				// strQuery += "IS NULL";
				strQuery += "= 0";
			}
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				return rs.getInt("maxOrder");
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return 0;
	}

	/**
	 * Restituisce l'indice della pagina che gestisce il contenuto del canale (0
	 * se al canale non  associata alcuna pagina).
	 * 
	 * @param numDBIndex
	 *            ID del canale.
	 * 
	 * @return ID della pagina.
	 * 
	 * @throws Exception
	 */
	static public int fn_GetChannelPageID(int numDBIndex, boolean preview) throws Exception {
		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT n09_pag_oid" +
							   " FROM cms_09_canali" +
							  " WHERE n09_cha_oid=" + String.valueOf(numDBIndex);
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				int page_id = rs.getInt("n09_pag_oid");
				if (!rs.wasNull()) {
					Page objPage = Page_mgr.fn_GetPage(page_id);
					if (preview) {
						if (objPage.getOid_pag_mod() <= 0) {
							return page_id;
						} else {
							return objPage.getOid_pag_mod();
						}
					} else {
						if (objPage.getOid_pag_mod() >= 0)
							return page_id;
						else
							return 0;
					}

				}
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return 0;
	}

	/**
	 * Restituisce l'elenco dei figli di un canale. Se il canale non ha figli,
	 * viene restituito un array vuoto.
	 * 
	 * @param numDBIndex
	 *            ID del canale padre.
	 * @param bolOnlineOnly
	 *            se TRUE considera solo i canali online.
	 * @param id_profilo
	 *            ID del profilo: se  diverso dalla stringa vuota allora vede
	 *            solo i canali visibili/editabili dal profilo specificato.
	 * @param gruppo_canale
	 *            Il gruppo del canale: la stringa vuota indica tutti i canali.
	 * @param pos_canale
	 *            Posizione del canale: la stringa vuota indica i canali in
	 *            tutte le posizioni.
	 * @param action
	 *            Se  "edit" considera solo i canali che si possono editare,
	 *            altrimenti quelli di cui si ha visibilit.
	 * 
	 * @return Un riferimento all'array che conterr i figli (oggetti di classe
	 *         Channel).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public Vector fn_GetChildrens(int numDBIndex, boolean bolOnlinePreview, boolean bolOnlineProduz, String id_profilo, String gruppo_canale, String pos_canale, String action) throws Exception {
		String strCondition = "n09_cha_parent_oid = " + String.valueOf(numDBIndex);
		if (!"".equals(pos_canale) && !"---".equals(pos_canale)) {
			strCondition += " AND v09_cha_position IN ('---','" + pos_canale + "')";
		}

		if (bolOnlinePreview) {
			strCondition += " AND n09_cha_online_preview=1";
		} else if (bolOnlineProduz) {
			strCondition += " AND n09_cha_online_produz=1";
		}

		return fn_GetChannelsByCondition(strCondition, id_profilo, gruppo_canale, action);
	}

	/**
	 * Restituisce il padre di un canale. Se il canale non ha padre, viene
	 * restituito il valore null.
	 * 
	 * @param numDBIndex
	 *            ID del canale figlio.
	 * @param id_profilo
	 *            id del profilo: se  diverso dalla stringa vuota allora
	 *            considera solo i canali visibili/editabili dal profilo
	 *            specificato.
	 * @param gruppo_canale
	 *            il gruppo del canale: la stringa vuota indica tutti i canali.
	 * @param action
	 *            Se  "edit" considera solo i canali che si possono editare,
	 *            altrimenti quelli di cui si ha visibilit.
	 * 
	 * @return Un riferimento al canale padre.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public Channel fn_GetParent(int numDBIndex, String id_profilo, String gruppo_canale, String action) throws Exception {
		Channel chan = fn_GetChannel(numDBIndex);
		if (chan != null) {
			String strCondition = "n09_cha_oid IN (" + String.valueOf(chan.getParentChannelID()) + ")";

			Vector arrChannels = fn_GetChannelsByCondition(strCondition, id_profilo, gruppo_canale, action);
			if (!arrChannels.isEmpty()) {
				return (Channel)arrChannels.get(0);
			}
		}
		return null;
	}

	/**
	 * Restituisce l'albero di navigazione a partire dalla radice.
	 * 
	 * @param numDepth
	 *            Livello massimo di profondit dei rami.
	 * @param bolOnlineOnly
	 *            True = considera solo i canali On-line.
	 * @param id_profilo
	 *            ID del profilo: se  diverso dalla stringa vuota allora
	 *            considera solo i canali visibili/editabili dal profilo
	 *            specificato.
	 * @param gruppo_canale
	 *            il gruppo del canale: la stringa vuota indica tutti i canali.
	 * @param pos_canale
	 *            Posizione del canale: la stringa vuota indica i canali in
	 *            tutte le posizioni
	 * @param action
	 *            Se  "edit" considera solo i canali che si possono editare,
	 *            altrimenti quelli di cui si ha visibilit.
	 * 
	 * @return Un riferimento all'array 2 * N che conterr l'abero di
	 *         navigazione: il primo elemento  un canale il secondo  a sua
	 *         volta il suo sottoalbero di navigazione o null se ill canale 
	 *         una foglia.
	 * 
	 * @throws Exception
	 */
	static public Object[][] fn_GetRootTree(int numDepth, boolean bolOnlinePreview, boolean bolOnlineProduz, String id_profilo, String gruppo_canale, String pos_canale, String action) throws Exception {
		return fn_GetChannelTree(0, numDepth, bolOnlinePreview, bolOnlineProduz, id_profilo, gruppo_canale, pos_canale, action);
	}

	/**
	 * Restituisce un canale a partire da un livello dell'albero di navigazione.
	 * '
	 * 
	 * @param arrList
	 *            Elemento dei canali di un livello dell'albero.
	 * @param numIndex
	 *            Indice del canale da estrarre.
	 * 
	 * @return Un riferimento all'oggetto che conterr il canale. '
	 */
	static public Channel fn_GetTreeChannel(Object[][] arrList, int numIndex) {
		if (numIndex >= 0 && numIndex < arrList[0].length) {
			return (Channel) arrList[0][numIndex];
			/*
			Channel objChannel = (Channel) arrList[0][numIndex];
			// if(objChannel != null && objChannel.isOnline())
			if (objChannel != null) {
				return objChannel;
			}
			*/
		}

		return null;
	}

	/**
	 * Restituisce la discendenza di un canale, a partire dal suo ID.
	 * 
	 * @param numDBIndex
	 *            ID del canale.
	 * @param numDepth
	 *            Livello massimo di profondit dei rami.
	 * @param bolOnlineOnly
	 *            True = considera solo i canali On-line.
	 * @param id_profilo
	 *            id del profilo: se  diverso dalla stringa vuota considera
	 *            solo i canali visibili/editabili dal profilo specificato.
	 * @param gruppo_canale
	 *            il gruppo del canale: la stringa vuota indica tutti i canali.
	 * @param pos_canale
	 *            Posizione del canale: la stringa vuota indica i canali in
	 *            tutte le posizioni.
	 * @param action
	 *            Se  "edit" considera solo i canali che si possono editare,
	 *            altrimenti quelli di cui si ha visibilit.
	 * 
	 * @return Un riferimento all'array 2 * N che conterr l'abero di
	 *         navigazione: il primo elemento  un canale il secondo  a sua
	 *         volta il suo sottoalbero di navigazione o null se  una foglia.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	static public java.lang.Object[][] fn_GetChannelTree(int numDBIndex, int numDepth, boolean bolOnlinePreview, boolean bolOnlineProduz, String id_profilo, String gruppo_canale, String pos_canale, String action) throws Exception {
		int numNewDepth = numDepth == -1 ? numDepth : numDepth - 1;
		if (numDepth != 0) {
			Vector arrChilds = fn_GetChildrens(numDBIndex, bolOnlinePreview, bolOnlineProduz, id_profilo, gruppo_canale, pos_canale, action);
			if (!arrChilds.isEmpty()) {
				java.lang.Object[][] arrSubTree = new java.lang.Object[2][arrChilds.size()];
				for (int i = 0; i < arrChilds.size(); i++) {
					Channel chan = (Channel) arrChilds.get(i);
					arrSubTree[0][i] = chan;
					arrSubTree[1][i] = fn_GetChannelTree(chan.getDBIndex(), numNewDepth, bolOnlinePreview, bolOnlineProduz, id_profilo, gruppo_canale, pos_canale, action);
				}
				return arrSubTree;
			}
		}
		return null;
	}

	/**
	 * Restituisce l'elenco delle Breadcrumbs. Nell'elenco vengono inclusi tutti
	 * i canali percorsi, dalla radice fino al canale passato come parametro
	 * (incluso).
	 * 
	 * @param numDBIndex
	 *            ID del canale di destinazione.
	 * 
	 * @return Un riferimento all'array che conterr le Breadcrumbs.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	static public Vector fn_GetBreadcrumbs(int numDBIndex) throws Exception {
		String numIdx;
		Vector arrIdx = new Vector();
		Vector arrOrdered = new Vector();
		Vector arrChannels = new Vector();
		String strQuery = "";
		String strCondition = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT n09_cha_oid, n09_cha_parent_oid FROM cms_09_canali";

			// la chiave  il cha_oid e il valore il cha_parent_oid
			Hashtable hash_cha_oid = new Hashtable();

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				hash_cha_oid.put(String.valueOf(rs.getInt("n09_cha_oid")), String.valueOf(rs.getString("n09_cha_parent_oid")));
			}

			numIdx = String.valueOf(numDBIndex);
			boolean found = true;
			while (found) {
				found = false;
				if (hash_cha_oid.get(numIdx) != null) {
					found = true;
					if (!"".equals(strCondition)) {
						strCondition += ",";
					}
					strCondition += numIdx;
					arrIdx.add(numIdx);
					numIdx = (String) hash_cha_oid.get(numIdx);
				}
			}

			if (!"".equals(strCondition)) {
				strCondition = "n09_cha_oid IN (" + strCondition + ")";
				arrChannels = fn_GetChannelsByCondition(strCondition, "", "", "edit");
			}

			Channel objRoot = new Channel(0, "Root", "Root", true, false, false, "", "", false, false, false, "", "", -1, "", "", parameters);
			arrOrdered.add(objRoot);

			for (int i = 0; i < arrIdx.size(); i++) {
				for (int j = 0; j < arrChannels.size(); j++) {
					if (((Channel) arrChannels.get(j)).getDBIndex() == Integer.parseInt((String) arrIdx.get(arrIdx.size() - i - 1))) {
						arrOrdered.add(arrChannels.get(j));
					}
				}
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return arrOrdered;
	}

	/**
	 * Restituisce i dati di un certo tipo di canale
	 * 
	 * @param cha_type
	 *            Il tipo del canale
	 * 
	 * @return Il tipo di canale (oggetto di tipo ChannelType)
	 * 
	 * @throws Exception
	 */
	public static ChannelType fn_GetChannelType(String cha_type) throws Exception {
		ChannelType objChaType = null;
		
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT v20_cha_type, v20_cha_type_descr, n20_cha_type_default, v20_cha_container, n20_cha_type_created FROM cms_20_tipo_canale" + " WHERE v20_cha_type='" + cha_type + "'";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				objChaType = new ChannelType(rs.getString("v20_cha_type"), rs.getString("v20_cha_type_descr"), (rs.getInt("n20_cha_type_default") == 1) ? true : false, rs.getString("v20_cha_container"),
						(rs.getInt("n20_cha_type_created") == 1) ? true : false);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return objChaType;
	}

	/**
	 * Restituisce un vettore contenente tutti le possibili posizioni di un
	 * canale.
	 * 
	 * @return Il vettore delle posizioni di un canale (oggetti di tipo
	 *         ChannelPosition).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	public static Vector fn_GetChannelPositions() throws Exception {
		Vector arrChaPos = new Vector();
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT v21_pos_code, v21_pos_descr FROM cms_21_posizione_canale";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				ChannelPosition objChaPos = new ChannelPosition(rs.getString("v21_pos_code"), rs.getString("v21_pos_descr"));
				arrChaPos.add(objChaPos);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return arrChaPos;
	}

	public static ChannelPosition fn_GetChannelPosition(String cha_pos) throws Exception {
		ChannelPosition objChaPos = null;
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT v21_pos_code, v21_pos_descr FROM cms_21_posizione_canale WHERE v21_pos_code='" + cha_pos + "'";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				objChaPos = new ChannelPosition(rs.getString("v21_pos_code"), rs.getString("v21_pos_descr"));
			}
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}

		return objChaPos;
	}

	/**
	 * Aggiorna l'indice di ordinamento dei canali figli di un dato canale.
	 * 
	 * @param objChannel
	 *            Il canale del quale si vuole cambiare posizione.
	 * @param conn
	 *            La connessione su cui operare.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void fn_UpdateChannelsOrdering(Channel objChannel, Connection conn) throws Exception {
		String strQuery = "";
		Vector arrOrder = new Vector();

		try {
			int old_cha_order = 0;
			int new_cha_order = objChannel.getOrder();

			strQuery = "SELECT n09_cha_oid, n09_cha_order FROM cms_09_canali WHERE n09_cha_parent_oid = " + String.valueOf(objChannel.getParentChannelID()) + " ORDER BY n09_cha_order";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				int cha_oid = rs.getInt("n09_cha_oid");
				int cha_order = rs.getInt("n09_cha_order");
				if (cha_oid == objChannel.getDBIndex()) {
					old_cha_order = cha_order;
				} else {
					String order = String.valueOf(rs.getInt("n09_cha_oid")) + "-" + String.valueOf(rs.getInt("n09_cha_order"));
					arrOrder.add(order);
				}
			}
			rs.close();
			stmt.close();

			// Riordino gli indici
			for (int i = 0; i < arrOrder.size(); i++) {
				String[] arr = ((String) arrOrder.get(i)).split("-");
				int cha_oid = Integer.parseInt(arr[0]);
				int cha_order = Integer.parseInt(arr[1]);

				if (new_cha_order < old_cha_order) {
					if (cha_order >= new_cha_order && cha_order < old_cha_order) {
						// Aumento l'indice di uno
						int new_order = cha_order + 1;

						String strUpdate = "UPDATE cms_09_canali SET n09_cha_order=" + String.valueOf(new_order) + " WHERE n09_cha_oid=" + String.valueOf(cha_oid);

						stmt = conn.createStatement();
						stmt.executeUpdate(strUpdate);
						stmt.close();
					}
				} else if (new_cha_order > old_cha_order && old_cha_order != 0) {
					if (cha_order > old_cha_order && cha_order <= new_cha_order) {
						// Diminuisco l'indice di uno
						int new_order = cha_order - 1;

						String strUpdate = "UPDATE cms_09_canali SET n09_cha_order=" + String.valueOf(new_order) + " WHERE n09_cha_oid=" + String.valueOf(cha_oid);

						stmt = conn.createStatement();
						stmt.executeUpdate(strUpdate);
						stmt.close();
					}
				} else if (old_cha_order == 0) {
					if (cha_order >= new_cha_order) {
						// Aumento l'indice di uno
						int new_order = cha_order + 1;

						String strUpdate = "UPDATE cms_09_canali SET n09_cha_order=" + String.valueOf(new_order) + " WHERE n09_cha_oid=" + String.valueOf(cha_oid);

						stmt = conn.createStatement();
						stmt.executeUpdate(strUpdate);
						stmt.close();
					}
				}
			}
		} catch (Exception e) {
			throw e;
		} finally {
			// Connessione da non chiudere, passata a parametro
		}
	}

	/**
	 * Aggiorna l'indice di ordinamento dei canali figli di un dato canale.
	 * 
	 * @param objChannel
	 *            Il canale del quale si vuole cambiare posizione.
	 * @param conn
	 *            La connessione su cui operare.
	 * 
	 * @throws Exception
	 */
	public static void fn_UpdateChannelsPosition(Channel objChannel, String position, Connection conn) throws Exception {
		try {
			Statement stmt = conn.createStatement();
			String strUpdate = "UPDATE cms_09_canali SET v09_cha_position='" + position + "' WHERE n09_cha_oid=" + String.valueOf(objChannel.getDBIndex());

			stmt = conn.createStatement();
			stmt.executeUpdate(strUpdate);
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			// Connessione da non chiudere, passata a parametro
		}
	}

	/**
	 * Crea un nuovo canale.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objChannel
	 *            L'oggetto contenente i dati del nuovo canale.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @return L'ID del nuovo canale creato.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("resource")
	public static int fn_CreateChannel(Connection conn, Channel objChannel, Logger logger, boolean orderSet) throws Exception {
		int newID = 0;
		String strCmd = "";

		try {
			// Se il canale  una home sfleggo tutte le altre
			/*
			 * if(objChannel.isHome())// Pezzino Isabella -- con il multilingua
			 * questo update non ha senso { strCmd =
			 * "UPDATE cms_09_canali SET n09_cha_isroot=0 WHERE n09_cha_isroot=1"
			 * ; Statement stmt = conn.createStatement();
			 * stmt.executeUpdate(strCmd); stmt.close(); }
			 */

			// Aggiorno l'ordine dei canali
			if (!orderSet)
				fn_UpdateChannelsOrdering(objChannel, conn);

			strCmd = "INSERT INTO cms_09_canali (" +
					     "v09_cha_nome" +
					  ", v09_cha_descr" +
					  ", n09_cha_parent_oid" + 
					  ", n09_pag_oid" +
					  ", n09_cha_online_preview" +
					  ", n09_cha_online_produz" + 
					  ", n09_cha_workflow" +
					  ", n09_cha_order" +
					  ", v09_cha_userTypes" +
					  ", v09_cha_type" +
					  ", v09_cha_link" +
					  ", n09_cha_islink" +
					  ", n09_cha_isroot" + 
					  ", n09_cha_ishttps" +
					  ", v09_cha_position" +
					  ", v09_cha_book" + 
					  ", n09_cha_no_map" +
					  ", n09_cha_level" +
					  ", n09_cha_keywords" +
					  ", n09_cha_key_desc)" + 
					  " VALUES ("
					+ Query.toSQL(objChannel.getName()) + 
					", " + Query.toSQL(objChannel.getDescription()) + 
					", " + String.valueOf(objChannel.getParentChannelID()) + 
					", " + String.valueOf(objChannel.getPageID());
			if (objChannel.isMIsOnlinePreview())
				strCmd += ", 1";
			else
				strCmd += ", 0";

			if (objChannel.isMIsOnlineProduz())
				strCmd += ", 1";
			else
				strCmd += ", 0";

			if (objChannel.hasWorkflow())
				strCmd += ", 1";
			else
				strCmd += ", 0";

			strCmd += ", " + String.valueOf(objChannel.getOrder())
					+ ", ''" // + objChannel.getUserTypes() + "'"
					+ ", " + Query.toSQL(objChannel.getChaType())
					+ ", " + Query.toSQL(objChannel.getChaLinkRelative())
					+ ", " + (objChannel.isLink() ? "1" : "0")
					+ ", " + (objChannel.isHome() ? "1" : "0")
					+ ", " + (objChannel.isHttps() ? "1" : "0")
					+ ", " + Query.toSQL(objChannel.getChaPosition())
					+ ", " + Query.toSQL(objChannel.getBookmark());

			if (objChannel.notInMap())
				strCmd += ", 1";
			else
				strCmd += ", 0";

			strCmd += ", " + String.valueOf(objChannel.getChaLevel());
			strCmd += ", " + Query.toSQL(objChannel.getKeywords());
			strCmd += ", " + Query.toSQL(objChannel.getKeyDesc()) + ")";

			if (logger != null && logger.isDebugEnabled()) {
				logger.debug("fn_CreateChannel::Cmd = " + strCmd);
			}

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// Recupero l'ID del canale appena creato
			String strQuery = "SELECT MAX(n09_cha_oid) AS MAX_ID FROM cms_09_canali";
			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				newID = rs.getInt("MAX_ID");
			}
			rs.close();
			stmt.close();

			if (objChannel.getParentChannelID() == 0) {
				strCmd = "UPDATE cms_20_tipo_canale" +
						   " SET n20_cha_type_created = 1" +
						 " WHERE v20_cha_type = '" + objChannel.getChaType() + "'";
				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}

			String chaLink = objChannel.getChaLinkRelative();
			String cnl = "channel_id=";
			if (chaLink.lastIndexOf(cnl) > -1)
				chaLink = chaLink.substring(0, chaLink.lastIndexOf(cnl) + cnl.length());
			if (objChannel.isLink()) {
				strCmd = "UPDATE cms_09_canali" + 
				           " SET v09_cha_link = " + Query.toSQL(chaLink + String.valueOf(newID)) + 
				           " WHERE n09_cha_oid = " + String.valueOf(newID);

				if (logger != null && logger.isDebugEnabled()) {
					logger.debug("fn_CreateChannel::Cmd = " + strCmd);
				}

				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			} else {
				if (chaLink.indexOf("?") > 0) {
					strCmd = "UPDATE cms_09_canali" + 
					           " SET v09_cha_link = " + Query.toSQL(objChannel.getChaLinkRelative() + String.valueOf(newID))  + 
					           " WHERE n09_cha_oid = " + String.valueOf(newID);

					if (logger != null && logger.isDebugEnabled()) {
						logger.debug("fn_CreateChannel::Cmd = " + strCmd);
					}

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				} else {
					strCmd = "UPDATE cms_09_canali" + 
					          " SET v09_cha_link = " + Query.toSQL(objChannel.getChaLinkRelative() + String.valueOf(newID)) + 
					          " WHERE n09_cha_oid = " + String.valueOf(newID);

					if (logger != null && logger.isDebugEnabled()) {
						logger.debug("fn_CreateChannel::Cmd = " + strCmd);
					}

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			if (logger != null)	logger.error("fn_CreateChannel", e);
			throw e;
		} finally {
			// Connessione da non chiudere, passata a parametro
		}

		return newID;
	}

	/**
	 * Aggiorna i dati di un canale.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objChannel
	 *            L'oggetto contenente i dati del canale da aggiornare.
	 * @param logger
	 *            Il logger (p essere null).
	 * 
	 * @throws Exception
	 */
	public static void fn_UpdateChannel(Connection conn, Channel objChannel, Logger logger) throws Exception {
		try {
			String strCmd = "";

			// Se il canale  una home sfleggo tutte le altre
			/*
			 * if(objChannel.isHome())// Pezzino Isabella -- con il multilingua
			 * questo update non ha senso { strCmd =
			 * "UPDATE cms_09_canali SET n09_cha_isroot=0 WHERE n09_cha_isroot=1"
			 * ; Statement stmt = conn.createStatement();
			 * stmt.executeUpdate(strCmd); stmt.close(); }
			 */

			// Aggiorno l'ordine dei canali
			fn_UpdateChannelsOrdering(objChannel, conn);

			strCmd = "UPDATE cms_09_canali" + 
					   " SET v09_cha_nome = " + Query.toSQL(objChannel.getName()) + 
						  ", v09_cha_descr = " + Query.toSQL(objChannel.getDescription()) + 
						  ", n09_cha_parent_oid = " + String.valueOf(objChannel.getParentChannelID()) +
						  ", n09_pag_oid = " + String.valueOf(objChannel.getPageID());

			if (objChannel.isMIsOnlinePreview())
				strCmd += ", n09_cha_online_preview = 1";
			else
				strCmd += ", n09_cha_online_preview = 0";

			if (objChannel.isMIsOnlineProduz())
				strCmd += ", n09_cha_online_produz = 1";
			else
				strCmd += ", n09_cha_online_produz = 0";

			if (objChannel.hasWorkflow())
				strCmd += ", n09_cha_workflow = 1";
			else
				strCmd += ", n09_cha_workflow = 0";

			strCmd += ", n09_cha_order = " + String.valueOf(objChannel.getOrder());
			strCmd += ", v09_cha_type = " + Query.toSQL(objChannel.getChaType());
			strCmd += ", v09_cha_link = " + Query.toSQL(objChannel.getChaLinkRelative());
			strCmd += ", n09_cha_islink = " + (objChannel.isLink() ? "1" : "0");
			strCmd += ", n09_cha_isroot = " + (objChannel.isHome() ? "1" : "0");
			strCmd += ", n09_cha_ishttps = " + (objChannel.isHttps() ? "1" : "0");
			strCmd += ", v09_cha_position = " + Query.toSQL(objChannel.getChaPosition());
			strCmd += ", v09_cha_book = " + Query.toSQL(objChannel.getBookmark());
			strCmd += ", n09_cha_no_map = " + (objChannel.notInMap() ? "1" : "0");
			strCmd += ", n09_cha_level = " + String.valueOf(objChannel.getChaLevel());
			strCmd += ", n09_cha_keywords = " + Query.toSQL(objChannel.getKeywords());
			strCmd += ", n09_cha_key_desc = " + Query.toSQL(objChannel.getKeyDesc());
			strCmd += " WHERE n09_cha_oid = " + String.valueOf(objChannel.getDBIndex());

			if (logger != null && logger.isDebugEnabled()) {
				logger.debug("fn_UpdateChannel::Cmd = " + strCmd);
			}
			
			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

		} catch (Exception e) {
			if (logger != null) logger.error("fn_UpdateChannel", e);
			throw e;
		} finally {
			// Connessione da non chiudere, passata a parametro
		}
	}

	/**
	 * Elimina un canale.
	 * 
	 * @param numDBIndex
	 *            ID del canale da eliminare.
	 * 
	 * @throws Exception
	 */
	public static void fn_DeleteChannel(int numDBIndex) throws Exception {
		Connection conn = null;
		Statement stmt;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			conn.setAutoCommit(false);

			// Aggiorno gli indici dei canali con indice maggiore di quello che
			// sto cancellando
			Channel objChannel = fn_GetChannel(numDBIndex);
			objChannel.setOrder(10000);
			fn_UpdateChannelsOrdering(objChannel, conn);

			String strCmd = "DELETE FROM cms_01_profilo_canali" +
					        " WHERE n01_cha_oid = " + String.valueOf(numDBIndex);
			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			strCmd = "DELETE FROM cms_09_canali" +
					 " WHERE n09_cha_oid = " + String.valueOf(numDBIndex);
			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			if (objChannel.hasPage()) {
				strCmd = "DELETE FROM cms_07_pagine" +
						 " WHERE n07_pag_oid = " + String.valueOf(objChannel.getPageID());
				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}

			if (objChannel.getParentChannelID() == 0) {
				strCmd = "UPDATE cms_20_tipo_canale" +
						   " SET n20_cha_type_created = 0" +
						 " WHERE v20_cha_type = '" + objChannel.getChaType() + "'";
				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}

			conn.commit();
		} catch (Exception e) {
			throw e;
		} finally {
			DatabaseManager.closeConnection(conn);
		}
	}
}
