/*
 * Created on 14-apr-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.DateUtil;
import it.softecspa.jwebber.common.classes.Channel;
import it.softecspa.jwebber.common.classes.CntAliasMetadata;
import it.softecspa.jwebber.common.classes.CntFilter;
import it.softecspa.jwebber.common.classes.Content;
import it.softecspa.jwebber.common.classes.ContentType;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.utils.RewriteUtils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il reperimento e il salvataggio a DB dei dati relativi
 * ai Contentuti (dinamici).
 */
public class Content_mgr {

	private static String v11_vista_contenuti_count = "SELECT COUNT(T11.n11_cnt_oid) AS num_contents " + "FROM cms_12_contenuti_metadata AS T12, cms_11_contenuti AS T11, cms_10_tipi_contenuto AS T10 "
			+ "WHERE T10.n10_tic_oid=T11.n11_tic_oid AND T12.n12_cnt_oid=T11.n11_cnt_oid";

	private static String v11_vista_contenuti_profili_count = "SELECT COUNT(T11.n11_cnt_oid) AS num_contents " + "FROM cms_12_contenuti_metadata AS T12, cms_11_contenuti AS T11, cms_10_tipi_contenuto AS T10, " + "cms_14_profilo_contenuti AS T14 "
			+ "WHERE T10.n10_tic_oid=T11.n11_tic_oid AND T12.n12_cnt_oid=T11.n11_cnt_oid " + "AND T11.n11_cnt_oid=T14.n14_cnt_oid";

	private static String v11_vista_contenuti = "SELECT T11.*, T10.v10_tic_nome AS v11_tic_nome, T10.n10_tic_workflow AS n11_tic_workflow, T10.n10_tic_max_cnt AS n11_tic_max_cnt, "
			+ "T12.n12_cmd_online AS n11_cnt_online, T12.d12_cmd_dat_creaz AS d11_cnt_dat_creaz, " + "T12.d12_cmd_dat_iniz AS d11_cnt_dat_iniz, T12.d12_cmd_dat_fine AS d11_cnt_dat_fine, "
			+ "T12.d12_cmd_dat_mod AS d11_cnt_dat_mod, T12.d12_cmd_approved AS d11_cnt_approved, " + "T12.d12_cmd_deleted AS d11_cnt_deleted, T12.v12_cmd_descr AS v11_cnt_descr "
			+ "FROM cms_12_contenuti_metadata AS T12, cms_11_contenuti AS T11, cms_10_tipi_contenuto AS T10 " + "WHERE T10.n10_tic_oid=T11.n11_tic_oid AND T12.n12_cnt_oid=T11.n11_cnt_oid";

	private static String v11_vista_contenuti_profili = "SELECT T11.*, T10.v10_tic_nome AS v11_tic_nome, T10.n10_tic_workflow AS n11_tic_workflow, T10.n10_tic_max_cnt AS n11_tic_max_cnt, "
			+ "T12.n12_cmd_online AS n11_cnt_online, T12.d12_cmd_dat_creaz AS d11_cnt_dat_creaz, " + "T12.d12_cmd_dat_iniz AS d11_cnt_dat_iniz, T12.d12_cmd_dat_fine AS d11_cnt_dat_fine, "
			+ "T12.d12_cmd_dat_mod AS d11_cnt_dat_mod, T12.d12_cmd_approved AS d11_cnt_approved, " + "T12.d12_cmd_deleted AS d11_cnt_deleted, T12.v12_cmd_descr AS v11_cnt_descr "
			+ "FROM cms_12_contenuti_metadata AS T12, cms_11_contenuti AS T11, cms_10_tipi_contenuto AS T10, " + "cms_14_profilo_contenuti AS T14 " + "WHERE T10.n10_tic_oid=T11.n11_tic_oid AND T12.n12_cnt_oid=T11.n11_cnt_oid "
			+ "AND T11.n11_cnt_oid=T14.n14_cnt_oid";

	private static String v11_vista_contenuti_ext = "SELECT T11.*, T10.v10_tic_nome AS v11_tic_nome, T10.n10_tic_workflow AS n11_tic_workflow,  T10.n10_tic_max_cnt AS n11_tic_max_cnt, "
			+ "T10.v10_tic_descr AS v11_tic_descr, T10.v10_tic_testo1 AS v11_tic_testo1, " + "T10.v10_tic_testo2 AS v11_tic_testo2, T10.v10_tic_testo3 AS v11_tic_testo3, "
			+ "T10.v10_tic_testo4 AS v11_tic_testo4, T10.v10_tic_testo5 AS v11_tic_testo5, " + "T10.v10_tic_testo6 AS v11_tic_testo6, T10.v10_tic_testo7 AS v11_tic_testo7, "
			+ "T10.v10_tic_testo8 AS v11_tic_testo8, T10.v10_tic_testo9 AS v11_tic_testo9, " + "T10.v10_tic_testo10 AS v11_tic_testo10, T10.v10_tic_float1 AS v11_tic_float1, "
			+ "T10.v10_tic_float2 AS v11_tic_float2, T10.v10_tic_intero1 AS v11_tic_intero1, " + "T10.v10_tic_intero2 AS v11_tic_intero2, T10.v10_tic_link1 AS v11_tic_link1, "
			+ "T10.v10_tic_link2 AS v11_tic_link2, T10.v10_tic_link3 AS v11_tic_link3, " + "T10.v10_tic_link4 AS v11_tic_link4, T10.v10_tic_link5 AS v11_tic_link5, " + "T10.v10_tic_image1 AS v11_tic_image1, T10.v10_tic_image2 AS v11_tic_image2, "
			+ "T10.v10_tic_image3 AS v11_tic_image3, T10.v10_tic_image4 AS v11_tic_image4, " + "T10.v10_tic_image5 AS v11_tic_image5, T10.v10_tic_data1 AS v11_tic_data1, " + "T10.v10_tic_data2 AS v11_tic_data2, T10.v10_tic_data3 AS v11_tic_data3, "
			+ "T10.v10_tic_data4 AS v11_tic_data4, T10.v10_tic_data5 AS v11_tic_data5, " + "T10.v10_tic_attach1 AS v11_tic_attach1, T10.v10_tic_attach2 AS v11_tic_attach2, "
			+ "T10.v10_tic_attach3 AS v11_tic_attach3, T10.v10_tic_attach4 AS v11_tic_attach4, " + "T10.v10_tic_attach5 AS v11_tic_attach5, T10.v10_tic_attach6 AS v11_tic_attach6, "
			+ "T10.v10_tic_attach7 AS v11_tic_attach7, T10.v10_tic_attach8 AS v11_tic_attach8, " + "T10.v10_tic_attach9 AS v11_tic_attach9, T10.v10_tic_attach10 AS v11_tic_attach10, " + "T10.v10_tic_selection1 AS v11_tic_selection1, "
			+ "T10.v10_tic_selection2 AS v11_tic_selection2, T10.v10_tic_selection3 AS v11_tic_selection3, " + "T10.v10_tic_selection4 AS v11_tic_selection4, T10.v10_tic_selection5 AS v11_tic_selection5, " + "T12.n12_cmd_online AS n11_cnt_online, "
			+ "T12.d12_cmd_dat_creaz AS d11_cnt_dat_creaz, T12.d12_cmd_dat_iniz AS d11_cnt_dat_iniz, " + "T12.d12_cmd_dat_fine AS d11_cnt_dat_fine, T12.d12_cmd_dat_mod AS d11_cnt_dat_mod, "
			+ "T12.d12_cmd_approved AS d11_cnt_approved, T12.d12_cmd_deleted AS d11_cnt_deleted, " + "T12.v12_cmd_descr AS v11_cnt_descr " + "FROM cms_12_contenuti_metadata AS T12, cms_11_contenuti AS T11, cms_10_tipi_contenuto AS T10 "
			+ "WHERE T10.n10_tic_oid=T11.n11_tic_oid AND T12.n12_cnt_oid=T11.n11_cnt_oid";

	private static String v11_vista_contenuti_ext_profili = "SELECT T11.*, T10.v10_tic_nome AS v11_tic_nome, T10.n10_tic_workflow AS n11_tic_workflow, T10.n10_tic_max_cnt AS n11_tic_max_cnt,"
			+ "T10.v10_tic_descr AS v11_tic_descr, T10.v10_tic_testo1 AS v11_tic_testo1, " + "T10.v10_tic_testo2 AS v11_tic_testo2, T10.v10_tic_testo3 AS v11_tic_testo3, "
			+ "T10.v10_tic_testo4 AS v11_tic_testo4, T10.v10_tic_testo5 AS v11_tic_testo5, " + "T10.v10_tic_testo6 AS v11_tic_testo6, T10.v10_tic_testo7 AS v11_tic_testo7, "
			+ "T10.v10_tic_testo8 AS v11_tic_testo8, T10.v10_tic_testo9 AS v11_tic_testo9, " + "T10.v10_tic_testo10 AS v11_tic_testo10, T10.v10_tic_float1 AS v11_tic_float1, "
			+ "T10.v10_tic_float2 AS v11_tic_float2, T10.v10_tic_intero1 AS v11_tic_intero1, " + "T10.v10_tic_intero2 AS v11_tic_intero2, T10.v10_tic_link1 AS v11_tic_link1, "
			+ "T10.v10_tic_link2 AS v11_tic_link2, T10.v10_tic_link3 AS v11_tic_link3, " + "T10.v10_tic_link4 AS v11_tic_link4, T10.v10_tic_link5 AS v11_tic_link5, " + "T10.v10_tic_image1 AS v11_tic_image1, T10.v10_tic_image2 AS v11_tic_image2, "
			+ "T10.v10_tic_image3 AS v11_tic_image3, T10.v10_tic_image4 AS v11_tic_image4, " + "T10.v10_tic_image5 AS v11_tic_image5, T10.v10_tic_data1 AS v11_tic_data1, " + "T10.v10_tic_data2 AS v11_tic_data2, T10.v10_tic_data3 AS v11_tic_data3, "
			+ "T10.v10_tic_data4 AS v11_tic_data4, T10.v10_tic_data5 AS v11_tic_data5, " + "T10.v10_tic_attach1 AS v11_tic_attach1, T10.v10_tic_attach2 AS v11_tic_attach2, "
			+ "T10.v10_tic_attach3 AS v11_tic_attach3, T10.v10_tic_attach4 AS v11_tic_attach4, " + "T10.v10_tic_attach5 AS v11_tic_attach5, T10.v10_tic_attach6 AS v11_tic_attach6, "
			+ "T10.v10_tic_attach7 AS v11_tic_attach7, T10.v10_tic_attach8 AS v11_tic_attach8, " + "T10.v10_tic_attach9 AS v11_tic_attach9, T10.v10_tic_attach10 AS v11_tic_attach10, " + "T10.v10_tic_selection1 AS v11_tic_selection1, "
			+ "T10.v10_tic_selection2 AS v11_tic_selection2, T10.v10_tic_selection3 AS v11_tic_selection3, " + "T10.v10_tic_selection4 AS v11_tic_selection4, T10.v10_tic_selection5 AS v11_tic_selection5, " + "T12.n12_cmd_online AS n11_cnt_online, "
			+ "T12.d12_cmd_dat_creaz AS d11_cnt_dat_creaz, T12.d12_cmd_dat_iniz AS d11_cnt_dat_iniz, " + "T12.d12_cmd_dat_fine AS d11_cnt_dat_fine, T12.d12_cmd_dat_mod AS d11_cnt_dat_mod, "
			+ "T12.d12_cmd_approved AS d11_cnt_approved, T12.d12_cmd_deleted AS d11_cnt_deleted, " + "T12.v12_cmd_descr AS v11_cnt_descr " + "FROM cms_12_contenuti_metadata AS T12, cms_11_contenuti AS T11, cms_10_tipi_contenuto AS T10, "
			+ "cms_14_profilo_contenuti AS T14 " + "WHERE T10.n10_tic_oid=T11.n11_tic_oid AND T12.n12_cnt_oid=T11.n11_cnt_oid " + "AND T11.n11_cnt_oid=T14.n14_cnt_oid";

	/**
	 * Controlla se il profilo specificato pu modificare il contenuto.
	 * 
	 * @param oid_cnt
	 *            L'ID del contenuto.
	 * @param id_profilo
	 *            L'ID del profilo.
	 * 
	 * @return TRUE se si ha l'autorizzazione.
	 * 
	 * @throws Exception
	 */
	static public boolean canEditContent(String oid_cnt, String id_profilo, String userid, boolean filterContents, Logger logger) throws Exception {
		boolean ret = false;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT n11_cnt_oid FROM cms_11_contenuti, cms_14_profilo_contenuti" + " WHERE cms_11_contenuti.n11_cnt_oid = cms_14_profilo_contenuti.n14_cnt_oid" + " AND n11_cnt_oid = " + oid_cnt + " AND id_profilo = "
					+ Query.toSQL(id_profilo) + " AND n14_cnt_visible = 1";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = true;
			}
			rs.close();
			stmt.close();

			if (filterContents) {
				Content objCnt = fn_GetContentWithAlias(Integer.parseInt(oid_cnt), false, null, true);
				ContentType objCType = Ctype_mgr.fn_GetContentTypeJoin(objCnt.getCTypeDBIndex());

				String filterOn = objCType.getFilterOn();
				if (filterOn != null && !"".equals(filterOn)) {
					strQuery = objCType.getFilter();
					strQuery = strQuery.replaceAll("@userid", userid);
					strQuery = strQuery.replaceAll("@id_profilo", id_profilo);

					String value = objCnt.getElement(filterOn);
					if (logger != null) {
						logger.info("fn_canEditContent:: filtro su'" + filterOn + "' = " + value);
					}

					value = value.split("#")[0];
					ret = false;
					stmt = conn.createStatement();
					rs = stmt.executeQuery(strQuery);
					while (rs.next()) {
						if (rs.getString(1).equals(value)) {
							ret = true;
							break;
						}
					}
					rs.close();
					stmt.close();
				}
			}
		} catch (Exception ex) {
			ret = false;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Restituisce un elenco di contenuti in base a delle condizioni.
	 * 
	 * @param strWhere
	 *            Condizione da applicare come filtro.
	 * @param strOrderBy
	 *            Condizione da applicare come ordinamento.
	 * @param id_profilo
	 *            ID_PROFILO dell'utente (recupera solo i contentuti visibili a
	 *            quel profilo).
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         'Content').
	 * 
	 * @throws Exception
	 *             '
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_ContentsByCondition(String strWhere, String strOrderBy, String id_profilo, int numMaxRows, Logger logger) throws Exception {
		Vector arrContents = new Vector();
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			if (!"".equals(id_profilo))
				strQuery = v11_vista_contenuti_ext_profili;
			else
				strQuery = v11_vista_contenuti_ext;

			if (!"".equals(strWhere))
				strQuery += " AND " + strWhere;

			if (!"".equals(id_profilo))
				strQuery += " AND n14_cnt_visible=1 AND id_profilo = " + Query.toSQL(id_profilo);

			if (!"".equals(strOrderBy))
				strQuery += " ORDER BY " + strOrderBy;

			if (logger != null)
				logger.info("fn_ContentsByCondition::Query=" + strQuery);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			boolean bolDone = false;
			int numRows = 0;
			CntAliasMetadata objAliasMD = new CntAliasMetadata();

			while (rs.next() && !bolDone) {
				Content objCnt = new Content(rs.getInt("n11_cnt_oid"), rs.getString("v11_cnt_testo1"), rs.getString("v11_cnt_descr"));
				objCnt.setOnline(rs.getInt("n11_cnt_online") == 1);
				objCnt.setCreateDate(rs.getDate("d11_cnt_dat_creaz"));
				objCnt.setValidFromDate(rs.getTimestamp("d11_cnt_dat_iniz"));
				objCnt.setExpiryDate(rs.getTimestamp("d11_cnt_dat_fine"));
				objCnt.setLastModifyDate(rs.getDate("d11_cnt_dat_mod"));
				objCnt.setApproveDate(rs.getDate("d11_cnt_approved"));
				objCnt.setDeleteDate(rs.getDate("d11_cnt_deleted"));

				ContentType objCType = Ctype_mgr.fn_GetContentType(rs.getInt("n11_tic_oid"));

				String[][] arrValues = new String[2][objCType.getAliasListSize()];

				int index = 0;
				for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						String strColumn = "v11_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						String strValue = rs.getString(strColumn);
						if (strValue != null && strValue.length() > 0) {
							// CntAlias objAlias = new CntAlias(i,
							// objAliasMD.getName(i), strValue);
							// objCType.addAlias(objAlias);

							strColumn = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);

							switch (i) {
							case 0:
							case 3:
							case 4:
							case 6:
							case 7:
								// recupero un testo
								arrValues[0][index] = rs.getString(strColumn);
								break;
							case 1:
								// recupero un double
								arrValues[0][index] = String.valueOf(rs.getDouble(strColumn));
								break;
							case 2:
								// recupero un intero
								arrValues[0][index] = String.valueOf(rs.getInt(strColumn));
								break;
							case 5:
								// recupero una data
								arrValues[0][index] = DateUtil.date2String(rs.getTimestamp(strColumn), "dd/MM/yyyy HH:mm:ss");
								break;
							}

							arrValues[1][index] = String.valueOf(i);
							index++;
						} else {
							arrValues[1][index] = null;
							index++;
						}
					}
				}

				objCnt.setValueList(arrValues);

				objCnt.setContentType(objCType);

				arrContents.add(objCnt);

				numRows++;
				if (numMaxRows > 0)
					bolDone = numRows == numMaxRows;
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_ContentsByCondition", e);
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrContents;
	}

	/**
	 * Restituisce il numero di contenuti che soffisfano le condizoni
	 * specificate.
	 * 
	 * @param strWhere
	 *            Condizione da applicare come filtro.
	 * @param strOrderBy
	 *            Condizione da applicare come ordinamento.
	 * @param id_profilo
	 *            ID_PROFILO dell'utente (recupera solo i contentuti visibili a
	 *            quel profilo).
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Il numero di contewnuti.
	 * 
	 * @throws Exception
	 */
	static public int fn_ContentsByConditionCount(String strWhere, String strOrderBy, String id_profilo, int numMaxRows, Logger logger) throws Exception {
		int numContents = 0;
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			if (!"".equals(id_profilo))
				strQuery = v11_vista_contenuti_profili_count;
			else
				strQuery = v11_vista_contenuti_count;

			if (!"".equals(strWhere))
				strQuery += " AND " + strWhere;

			if (!"".equals(id_profilo))
				strQuery += " AND n14_cnt_visible=1 AND id_profilo = " + Query.toSQL(id_profilo);

			if (!"".equals(strOrderBy))
				strQuery += " ORDER BY " + strOrderBy;

			if (logger != null)
				logger.info("fn_ContentsByConditionCount::Query=" + strQuery);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery.toLowerCase());

			if (rs.next()) {
				numContents = rs.getInt("num_contents");
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_ContentsByConditionCount", e);
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return numContents;
	}

	/**
	 * Restituisce un elenco di contenuti di un certo tipo, ordinati in base ad
	 * un certo elemento del tipo contenuto.
	 * 
	 * @param numDBIndex
	 *            Indice del tipo di contenuto di cui si vogliono i contenuti.
	 * @param p_strOrderBy
	 *            Nome dell'elemento in base a cui effettuare l'ordinamento.
	 * @param strOrderDir
	 *            Direzione di ordinamento ( A = ascendente, D = discendente ).
	 * @param id_profilo
	 *            ID del profilo utente (visualizza solo i contenuti visibili a
	 *            quel profilo)
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         'Content').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_ContentsByTypeOrdered(int numDBIndex, String p_strOrderBy, String strOrderDir, String id_profilo, int numMaxRows, Logger logger, boolean preview) throws Exception {
		Vector arrContent = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strWhere = "n11_tic_oid = " + String.valueOf(numDBIndex) + " AND ( ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine IS NULL )" + " OR ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine >= CURRENT_TIMESTAMP )"
					+ " OR ( d12_cmd_dat_fine IS NULL AND d12_cmd_dat_iniz <= CURRENT_TIMESTAMP )" + " OR ( CURRENT_TIMESTAMP BETWEEN d12_cmd_dat_iniz AND d12_cmd_dat_fine ) )" + " AND ( d12_cmd_deleted IS NULL )";

			if (!preview) {
				strWhere += " AND ( d12_cmd_approved IS NOT NULL ) AND n12_cmd_online = 1";
			}

			String strOrderBy = "";

			String strQuery = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			if (logger != null)
				logger.info("fn_ContentsByTypeOrdered::Query = " + strQuery);

			String strColumn = "";
			String strValue = "";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				CntAliasMetadata objAliasMD = new CntAliasMetadata();
				boolean bolDone = false;
				int i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(p_strOrderBy.trim())) {
								strOrderBy = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
								bolDone = true;
								break;
							}
						}
					}
				}
			}

			if (strOrderBy.length() > 0 && strOrderDir.equals("D"))
				strOrderBy += " DESC";

			arrContent = fn_ContentsByCondition(strWhere, strOrderBy, id_profilo, numMaxRows, logger);
		} catch (Exception e) {
			arrContent.clear();
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrContent;
	}

	/**
	 * Restituisce un elenco di contenuti di un certo tipo, ordinati in base ad
	 * un certo elemento del tipo contenuto.
	 * 
	 * @param numDBIndex
	 *            Indice del tipo di contenuto di cui si vogliono i contenuti.
	 * @param p_strOrderBy
	 *            Nome dell'elemento in base a cui effettuare l'ordinamento.
	 * @param strOrderDir
	 *            Direzione di ordinamento ( A = ascendente, D = discendente ).
	 * @param id_profilo
	 *            ID del profilo utente (visualizza solo i contenuti visibili a
	 *            quel profilo)
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato.
	 * @param start_from
	 *            Indice di partenza della limit
	 * @param count
	 *            Qunati elementi recuperare a partire da start_from
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         'Content').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_ContentsByTypeOrderedLimit(int numDBIndex, String p_strOrderBy, String strOrderDir, String id_profilo, int numMaxRows, int start_from, int count, Logger logger) throws Exception {
		Vector arrContent = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strWhere = "n11_tic_oid = " + String.valueOf(numDBIndex) + " AND n12_cmd_online = 1" + " AND ( ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine IS NULL )"
					+ " OR ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine >= CURRENT_TIMESTAMP )" + " OR ( d12_cmd_dat_fine IS NULL AND d12_cmd_dat_iniz <= CURRENT_TIMESTAMP )"
					+ " OR ( CURRENT_TIMESTAMP BETWEEN d12_cmd_dat_iniz AND d12_cmd_dat_fine ) )" + " AND ( d12_cmd_deleted IS NULL )" + " AND ( d12_cmd_approved IS NOT NULL )";

			String strOrderBy = "";

			String strQuery = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			if (logger != null)
				logger.info("fn_ContentsByTypeOrderedLimit::Query = " + strQuery);

			String strColumn = "";
			String strValue = "";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				CntAliasMetadata objAliasMD = new CntAliasMetadata();
				boolean bolDone = false;
				int i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(p_strOrderBy.trim())) {
								strOrderBy = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
								bolDone = true;
								break;
							}
						}
					}
				}
			}

			if (strOrderBy.length() > 0 && strOrderDir.equals("D"))
				strOrderBy += " DESC";

			strOrderBy += " LIMIT " + start_from + ", " + count;

			arrContent = fn_ContentsByCondition(strWhere, strOrderBy, id_profilo, numMaxRows, logger);
		} catch (Exception e) {
			arrContent.clear();
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrContent;
	}

	/**
	 * Restituisce il numero di contenuti di un certo tipo, ordinati in base ad
	 * un certo elemento del tipo contenuto.
	 * 
	 * @param numDBIndex
	 *            Indice del tipo di contenuto di cui si vogliono i contenuti.
	 * @param p_strOrderBy
	 *            Nome dell'elemento in base a cui effettuare l'ordinamento.
	 * @param strOrderDir
	 *            Direzione di ordinamento ( A = ascendente, D = discendente ).
	 * @param id_profilo
	 *            ID del profilo utente (visualizza solo i contenuti visibili a
	 *            quel profilo)
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         'Content').
	 * 
	 * @throws Exception
	 */
	static public int fn_ContentsByTypeOrderedCount(int numDBIndex, String p_strOrderBy, String strOrderDir, String id_profilo, int numMaxRows, Logger logger) throws Exception {
		int numContents = 0;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strWhere = "n11_tic_oid = " + String.valueOf(numDBIndex) + " AND n12_cmd_online = 1" + " AND ( ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine IS NULL )"
					+ " OR ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine >= CURRENT_TIMESTAMP )" + " OR ( d12_cmd_dat_fine IS NULL AND d12_cmd_dat_iniz <= CURRENT_TIMESTAMP )"
					+ " OR ( CURRENT_TIMESTAMP BETWEEN d12_cmd_dat_iniz AND d12_cmd_dat_fine ) )" + " AND ( d12_cmd_deleted IS NULL )" + " AND ( d12_cmd_approved IS NOT NULL )";

			String strOrderBy = "";

			String strQuery = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			if (logger != null)
				logger.info("fn_ContentsByTypeOrderedCount::Query = " + strQuery);

			String strColumn = "";
			String strValue = "";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				CntAliasMetadata objAliasMD = new CntAliasMetadata();
				boolean bolDone = false;
				int i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(p_strOrderBy.trim())) {
								strOrderBy = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
								bolDone = true;
								break;
							}
						}
					}
				}
			}

			if (strOrderBy.length() > 0 && strOrderDir.equals("D"))
				strOrderBy += " DESC";

			numContents = fn_ContentsByConditionCount(strWhere, strOrderBy, id_profilo, numMaxRows, logger);
		} catch (Exception e) {
			numContents = 0;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return numContents;
	}

	/**
	 * Restituisce un elenco di contenuti di un certo tipo, ordinati in base ad
	 * un certo elemento del tipo contenuto.
	 * 
	 * @param numDBIndex
	 *            Indice del tipo di contenuto di cui si vogliono i contenuti.
	 * @param p_strOrderBy
	 *            Nome dell'elemento in base a cui effettuare l'ordinamento.
	 * @param strOrderDir
	 *            Direzione di ordinamento ( A = ascendente, D = discendente ).
	 * @param strField
	 *            Nome del campo del contenuto su cui si vuole specificare la
	 *            condizione di ricerca.
	 * @param strFieldCond
	 *            Condizione da imporre sul campo (=, >, <, >=, <=, <>)
	 * @param strFieldValue
	 *            Valore del campo.
	 * @param id_profilo
	 *            ID del profilo utente (visualizza solo i contenuti visibili a
	 *            quel profilo)
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         'Content').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_ContentsByTypeAndFieldOrdered(int numDBIndex, String p_strOrderBy, String strOrderDir, String strField, String strFieldCond, String strFieldValue, String id_profilo, int numMaxRows, Logger logger, boolean preview)
			throws Exception {
		Vector arrContent = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strWhere = "n11_tic_oid = " + String.valueOf(numDBIndex) + " AND ( ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine IS NULL )" + " OR ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine >= CURRENT_TIMESTAMP )"
					+ " OR ( d12_cmd_dat_fine IS NULL AND d12_cmd_dat_iniz <= CURRENT_TIMESTAMP )" + " OR ( CURRENT_TIMESTAMP BETWEEN d12_cmd_dat_iniz AND d12_cmd_dat_fine ) )" + " AND ( d12_cmd_deleted IS NULL )";

			if (!preview) {
				strWhere += " AND ( d12_cmd_approved IS NOT NULL ) AND n12_cmd_online = 1";
			}

			String strOrderBy = "";

			String strQuery = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			if (logger != null)
				logger.info("fn_ContentsByTypeAndFieldOrdered::Query = " + strQuery);

			String strColumn = "";
			String strValue = "";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				CntAliasMetadata objAliasMD = new CntAliasMetadata();
				boolean bolDone = false;
				int i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(p_strOrderBy.trim())) {
								strOrderBy = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
								bolDone = true;
								break;
							}
						}
					}
				}

				bolDone = false;
				i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(strField.trim())) {
								switch (i) {
								case 0: // testo
								case 3: // link
								case 4: // image
								case 6: // attach
								case 7: // selection
									strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
									strWhere += Query.toSQL(strFieldValue);
									break;
								case 1: // float
									try {
										Float.parseFloat(strFieldValue);
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += strFieldValue;
									} catch (Exception e) {
									}
									break;
								case 2: // intero
									try {
										Integer.parseInt(strFieldValue);
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += strFieldValue;
									} catch (Exception e) {
									}
									break;
								case 5: // data
									Date data = DateUtil.string2Date(strFieldValue, "dd/MM/yyyy");
									if (data == null)
										data = DateUtil.string2Date(strFieldValue, "dd/MM/yyyy HH:mm:ss");

									if (data != null) {
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += "'" + DateUtil.date2String(data) + "'";
									}
									break;
								}
								bolDone = true;
								break;
							}
						}
					}
				}
			}

			if (strOrderBy.length() > 0 && strOrderDir.equals("D"))
				strOrderBy += " DESC";

			arrContent = fn_ContentsByCondition(strWhere, strOrderBy, id_profilo, numMaxRows, logger);
		} catch (Exception e) {
			arrContent.clear();
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrContent;
	}

	/**
	 * Restituisce un elenco di contenuti di un certo tipo, ordinati in base ad
	 * un certo elemento del tipo contenuto.
	 * 
	 * @param numDBIndex
	 *            Indice del tipo di contenuto di cui si vogliono i contenuti.
	 * @param p_strOrderBy
	 *            Nome dell'elemento in base a cui effettuare l'ordinamento.
	 * @param strOrderDir
	 *            Direzione di ordinamento ( A = ascendente, D = discendente ).
	 * @param strField
	 *            Nome del campo del contenuto su cui si vuole specificare la
	 *            condizione di ricerca.
	 * @param strFieldCond
	 *            Condizione da imporre sul campo (=, >, <, >=, <=, <>)
	 * @param strFieldValue
	 *            Valore del campo.
	 * @param id_profilo
	 *            ID del profilo utente (visualizza solo i contenuti visibili a
	 *            quel profilo)
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato. * @param start_from Indice di
	 *            partenza della limit
	 * @param count
	 *            Qunati elementi recuperare a partire da start_from
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         'Content').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_ContentsByTypeAndFieldOrderedLimit(int numDBIndex, String p_strOrderBy, String strOrderDir, String strField, String strFieldCond, String strFieldValue, String id_profilo, int numMaxRows, int start_from, int count,
			Logger logger) throws Exception {
		Vector arrContent = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strWhere = "n11_tic_oid = " + String.valueOf(numDBIndex) + " AND n12_cmd_online = 1" + " AND ( ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine IS NULL )"
					+ " OR ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine >= CURRENT_TIMESTAMP )" + " OR ( d12_cmd_dat_fine IS NULL AND d12_cmd_dat_iniz <= CURRENT_TIMESTAMP )"
					+ " OR ( CURRENT_TIMESTAMP BETWEEN d12_cmd_dat_iniz AND d12_cmd_dat_fine ) )" + " AND ( d12_cmd_deleted IS NULL )" + " AND ( d12_cmd_approved IS NOT NULL )";

			String strOrderBy = "";

			String strQuery = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			if (logger != null)
				logger.info("fn_ContentsByTypeAndFieldOrderedLimit::Query = " + strQuery);

			String strColumn = "";
			String strValue = "";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				CntAliasMetadata objAliasMD = new CntAliasMetadata();
				boolean bolDone = false;
				int i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(p_strOrderBy.trim())) {
								strOrderBy = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
								bolDone = true;
								break;
							}
						}
					}
				}

				bolDone = false;
				i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(strField.trim())) {
								switch (i) {
								case 0: // testo
								case 3: // link
								case 4: // image
								case 6: // attach
								case 7: // selection
									strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
									strWhere += Query.toSQL(strFieldValue);
									break;
								case 1: // float
									try {
										Float.parseFloat(strFieldValue);
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += strFieldValue;
									} catch (Exception e) {
									}
									break;
								case 2: // intero
									try {
										Integer.parseInt(strFieldValue);
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += strFieldValue;
									} catch (Exception e) {
									}
									break;
								case 5: // data
									Date data = DateUtil.string2Date(strFieldValue, "dd/MM/yyyy");
									if (data == null)
										data = DateUtil.string2Date(strFieldValue, "dd/MM/yyyy HH:mm:ss");

									if (data != null) {
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += "'" + DateUtil.date2String(data) + "'";
									}
									break;
								}
								bolDone = true;
								break;
							}
						}
					}
				}
			}

			if (strOrderBy.length() > 0 && strOrderDir.equals("D"))
				strOrderBy += " DESC";

			strOrderBy += " LIMIT " + start_from + ", " + count;

			arrContent = fn_ContentsByCondition(strWhere, strOrderBy, id_profilo, numMaxRows, logger);
		} catch (Exception e) {
			arrContent.clear();
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrContent;
	}

	/**
	 * Restituisce il numero di contenutii di un certo tipo, ordinati in base ad
	 * un certo elemento del tipo contenuto.
	 * 
	 * @param numDBIndex
	 *            Indice del tipo di contenuto di cui si vogliono i contenuti.
	 * @param p_strOrderBy
	 *            Nome dell'elemento in base a cui effettuare l'ordinamento.
	 * @param strOrderDir
	 *            Direzione di ordinamento ( A = ascendente, D = discendente ).
	 * @param strField
	 *            Nome del campo del contenuto su cui si vuole specificare la
	 *            condizione di ricerca.
	 * @param strFieldCond
	 *            Condizione da imporre sul campo (=, >, <, >=, <=, <>)
	 * @param strFieldValue
	 *            Valore del campo.
	 * @param id_profilo
	 *            ID del profilo utente (visualizza solo i contenuti visibili a
	 *            quel profilo)
	 * @param numMaxRows
	 *            Massimo numero di risultati da restituire. Se vale -1, questo
	 *            parametro non viene considerato.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Il numero di contenuti.
	 * 
	 * @throws Exception
	 */
	static public int fn_ContentsByTypeAndFieldOrderedCount(int numDBIndex, String p_strOrderBy, String strOrderDir, String strField, String strFieldCond, String strFieldValue, String id_profilo, int numMaxRows, Logger logger) throws Exception {
		int numContents = 0;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strWhere = "n11_tic_oid = " + String.valueOf(numDBIndex) + " AND n12_cmd_online = 1" + " AND ( ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine IS NULL )"
					+ " OR ( d12_cmd_dat_iniz IS NULL AND d12_cmd_dat_fine >= CURRENT_TIMESTAMP )" + " OR ( d12_cmd_dat_fine IS NULL AND d12_cmd_dat_iniz <= CURRENT_TIMESTAMP )"
					+ " OR ( CURRENT_TIMESTAMP BETWEEN d12_cmd_dat_iniz AND d12_cmd_dat_fine ) )" + " AND ( d12_cmd_deleted IS NULL )" + " AND ( d12_cmd_approved IS NOT NULL )";

			String strOrderBy = "";

			String strQuery = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			if (logger != null)
				logger.info("fn_ContentsByTypeAndFieldOrderedCount::Query = " + strQuery);

			String strColumn = "";
			String strValue = "";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				CntAliasMetadata objAliasMD = new CntAliasMetadata();
				boolean bolDone = false;
				int i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(p_strOrderBy.trim())) {
								strOrderBy = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
								bolDone = true;
								break;
							}
						}
					}
				}

				bolDone = false;
				i = -1;
				while (i < objAliasMD.getMaxSize() && !bolDone) {
					i++;
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						strColumn = "v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						strValue = rs.getString(strColumn);
						if (!rs.wasNull()) {
							if (strValue.trim().equals(strField.trim())) {
								switch (i) {
								case 0: // testo
								case 3: // link
								case 4: // image
								case 6: // attach
								case 7: // selection
									strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
									strWhere += Query.toSQL(strFieldValue);
									break;
								case 1: // float
									try {
										Float.parseFloat(strFieldValue);
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += strFieldValue;
									} catch (Exception e) {
									}
									break;
								case 2: // intero
									try {
										Integer.parseInt(strFieldValue);
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += strFieldValue;
									} catch (Exception e) {
									}
									break;
								case 5: // data
									Date data = DateUtil.string2Date(strFieldValue, "dd/MM/yyyy");
									if (data == null)
										data = DateUtil.string2Date(strFieldValue, "dd/MM/yyyy HH:mm:ss");

									if (data != null) {
										strWhere += " AND " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + strFieldCond;
										strWhere += "'" + DateUtil.date2String(data) + "'";
									}
									break;
								}
								bolDone = true;
								break;
							}
						}
					}
				}
			}

			if (strOrderBy.length() > 0 && strOrderDir.equals("D"))
				strOrderBy += " DESC";

			numContents = fn_ContentsByConditionCount(strWhere, strOrderBy, id_profilo, numMaxRows, logger);
		} catch (Exception e) {
			numContents = 0;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return numContents;
	}

	/**
	 * Restituisce un elenco di contenuti in base ad un filtro.
	 * 
	 * @param objFilter
	 *            Filtro da usare nell'estrazione dei dati.
	 * @param arrCTypes
	 *            Un array contenente gli ID dei tipi contenuto di cui si
	 *            vogliono visualizzare i contentui.
	 * @param id_profilo
	 *            Il profilo dell'utente (recupera solo i contenuti visilbili a
	 *            quel profilo: se  la stringa vuota "" allora li recupera
	 *            tutti)
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         Content).
	 * 
	 * @throws Exception
	 *             '
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetContents(CntFilter objFilter, Vector arrCTypes, String id_profilo, Logger logger) throws Exception {
		Vector arrContents = new Vector();
		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			if ("".equals(id_profilo)) {
				strQuery = v11_vista_contenuti + " AND d12_cmd_deleted IS NULL" + objFilter.getFilter(arrCTypes) + " ORDER BY v11_tic_nome ASC, " + objFilter.getFilterOrderBy();
			} else {
				strQuery = v11_vista_contenuti_profili + " AND d12_cmd_deleted IS NULL" + objFilter.getFilter(arrCTypes) + " AND n14_cnt_visible=1 AND ID_PROFILO = " + Query.toSQL(id_profilo) + " ORDER BY v11_tic_nome ASC, "
						+ objFilter.getFilterOrderBy();
			}
			// ZZ
			strQuery += " " + objFilter.getFilterPage();

			if (logger != null)
				logger.info("fn_GetContents::Query=" + strQuery);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				Content objCnt = new Content(rs.getInt("n11_cnt_oid"), rs.getString("v11_cnt_testo1"), rs.getString("v11_cnt_descr"));

				ContentType objCType = new ContentType(rs.getInt("n11_tic_oid"), rs.getString("v11_tic_nome"), "", rs.getInt("n11_tic_workflow") == 1, rs.getInt("n11_tic_max_cnt"));

				objCnt.setContentType(objCType);
				objCnt.setOnline(rs.getInt("n11_cnt_online") == 1);
				objCnt.setCreateDate(rs.getDate("d11_cnt_dat_creaz"));
				objCnt.setApproveDate(rs.getDate("d11_cnt_approved"));

				arrContents.add(objCnt);
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_GetContents", e);
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrContents;
	}

	/**
	 * Restituisce un elenco di contenuti in base ad un filtro e in base a una
	 * condizione specificata nella tabella dei tipi di contenuto che ritorna i
	 * valori che deve avere una delle colone della tabella.
	 * 
	 * @param objFilter
	 *            Filtro da usare nell'estrazione dei dati.
	 * @param arrCTypes
	 *            Un array contenente gli ID dei tipi contenuto di cui si
	 *            vogliono visualizzare i contentui.
	 * @param id_profilo
	 *            Il profilo dell'utente (recupera solo i contenuti visilbili a
	 *            quel profilo: se  la stringa vuota "" allora li recupera
	 *            tutti)
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'array dei contenuti (oggetti di classe
	 *         Content).
	 * 
	 * @throws Exception
	 *             '
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetContentsByTableCondition(CntFilter objFilter, Vector arrCTypes, String id_profilo, String userid, Logger logger) throws Exception {
		Vector arrContents = new Vector();
		String strQuery = "";
		Vector arrCTypes1 = null;
		ContentType objCType = null;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			if ("".equals(id_profilo)) {
				// Gli editor vedono comunque tutto
				strQuery += v11_vista_contenuti + " AND d12_cmd_deleted IS NULL" + objFilter.getFilter(arrCTypes);
			} else {
				if (objFilter.getMCType() != 0) {
					for (int i = 0; i < arrCTypes.size(); i++) {
						objCType = (ContentType) arrCTypes.get(i);
						if (objCType.getDBIndex() == objFilter.getMCType())
							break;
					}
					arrCTypes1 = new Vector();
					arrCTypes1.add(objCType);
				} else {
					arrCTypes1 = (Vector) arrCTypes.clone();
				}

				// Scorro tutti i tipi di contenuto su cui l'utente pu lavorare
				for (int i = 0; i < arrCTypes1.size(); i++) {
					objCType = (ContentType) arrCTypes1.get(i);
					objFilter.setMCType(objCType.getDBIndex());
					if (i > 0)
						strQuery += " UNION ";

					strQuery += v11_vista_contenuti_profili + " AND d12_cmd_deleted IS NULL" + objFilter.getFilter(arrCTypes1) + " AND n14_cnt_visible = 1 " + " AND id_profilo = " + Query.toSQL(id_profilo);

					if (objCType.getFilterOn() != null && !"".equals(objCType.getFilterOn())) {
						String filterOn = objCType.getFilterOn();

						String strQueryCType = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(objCType.getDBIndex());

						String strColumn = "";
						String strValue = "";

						Statement stmt = conn.createStatement();
						ResultSet rs = stmt.executeQuery(strQueryCType);
						boolean found = false;
						if (rs.next()) {
							CntAliasMetadata objAliasMD = new CntAliasMetadata();
							int ii = 0;
							while (ii < objAliasMD.getMaxSize() && !found) {
								for (int jj = 0; jj < objAliasMD.getMaxCount(ii); jj++) {
									strColumn = "v10_tic_" + objAliasMD.getSQLColumn(ii) + String.valueOf(jj + 1);
									strValue = rs.getString(strColumn);
									if (!rs.wasNull()) {
										if (strValue.trim().equals(filterOn.trim())) {
											filterOn = objAliasMD.getSQLPrefix(ii) + "11_cnt_" + objAliasMD.getSQLColumn(ii) + String.valueOf(jj + 1);
											found = true;
											break;
										}
									}
								}
								ii++;
							}
						}
						rs.close();
						stmt.close();

						if (found) {
							String filter = objCType.getFilter();
							filter = filter.replaceAll("@userid", userid);
							filter = filter.replaceAll("@id_profilo", id_profilo);
							strQuery += " AND " + filterOn + " IN (" + filter + ") ";
						}
					}
				}
			}

			strQuery += " ORDER BY v11_tic_nome ASC, " + objFilter.getFilterOrderBy();
			// ZZ
			strQuery += " " + objFilter.getFilterPage();

			if (logger != null)
				logger.info("fn_GetContentsByTableCondition::Query=" + strQuery);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				Content objCnt = new Content(rs.getInt("n11_cnt_oid"), rs.getString("v11_cnt_testo1"), rs.getString("v11_cnt_descr"));

				objCType = new ContentType(rs.getInt("n11_tic_oid"), rs.getString("v11_tic_nome"), "", rs.getInt("n11_tic_workflow") == 1, rs.getInt("n11_tic_max_cnt"));

				objCnt.setContentType(objCType);
				objCnt.setOnline(rs.getInt("n11_cnt_online") == 1);
				objCnt.setCreateDate(rs.getDate("d11_cnt_dat_creaz"));
				objCnt.setApproveDate(rs.getDate("d11_cnt_approved"));

				arrContents.add(objCnt);
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_GetContentsByTableCondition", e);
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrContents;
	}

	/**
	 * Restituisce i dati di un contenuto.
	 * 
	 * @param numBDIndex
	 *            ID del contenuto.
	 * @param bolDeleted
	 *            se TRUE recupera il contenuto anche se  stato annullato.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento al contenuto (oggetto di classe Content).
	 * 
	 * @throws Exception
	 */
	public static Content fn_GetContent(int numBDIndex, boolean bolDeleted, Logger logger) throws Exception {
		Content objCnt = null;

		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = v11_vista_contenuti + " AND n11_cnt_oid = " + String.valueOf(numBDIndex);

			if (!bolDeleted)
				strQuery += " AND d12_cmd_deleted IS NULL";

			if (logger != null)
				logger.info("fn_GetContent::Query=" + strQuery);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				objCnt = new Content(numBDIndex, rs.getString("v11_cnt_testo1"), rs.getString("v11_cnt_descr"));

				ContentType objCType = new ContentType(rs.getInt("n11_tic_oid"), rs.getString("v11_tic_nome"), "", rs.getInt("n11_tic_workflow") == 1, rs.getInt("n11_tic_max_cnt"));
				objCnt.setContentType(objCType);

				objCnt.setOnline(rs.getInt("n11_cnt_online") == 1);
				objCnt.setCreateDate(rs.getDate("d11_cnt_dat_creaz"));
				objCnt.setValidFromDate(rs.getDate("d11_cnt_dat_iniz"));
				objCnt.setExpiryDate(rs.getDate("d11_cnt_dat_fine"));
				objCnt.setLastModifyDate(rs.getDate("d11_cnt_dat_mod"));
				objCnt.setApproveDate(rs.getDate("d11_cnt_approved"));
				objCnt.setDeleteDate(rs.getDate("d11_cnt_deleted"));
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_GetContents", e);
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objCnt;
	}

	/**
	 * Restituisce tutti i dati di un contenuto, compresi i valori degli alias.
	 * 
	 * @param numDBIndex
	 *            ID del contenuto.
	 * @param bolDeleted
	 *            se TRUE recupera il contenuto anche se  stato annullato.
	 * 
	 * @return Un riferimento al contenuto (oggetto di classe clsContent).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Content fn_GetContentWithAlias(int numDBIndex, boolean bolDeleted, Logger logger, boolean preview) throws Exception {
		Content objCnt = null;

		String strWhere = "n11_cnt_oid = " + String.valueOf(numDBIndex);
		if (!bolDeleted)
			strWhere += " AND d12_cmd_deleted IS NULL";
		if (!preview) {
			strWhere += " AND ( d12_cmd_approved IS NOT NULL ) AND n12_cmd_online = 1";
		}

		Vector arrContents = fn_ContentsByCondition(strWhere, "", "", 1, logger);

		if (arrContents.size() > 0)
			objCnt = (Content) arrContents.get(0);

		return objCnt;
	}

	/**
	 * Recupera dalla Request il valore di un alias del contenuto. Se necessario
	 * il valore viene inizializzato.
	 * 
	 * @param strTag
	 *            Nome del parametro della Request.
	 * @param numTypeIndex
	 *            Indice del tipo di alias, necessario per la inizializzazione
	 *            del valore.
	 * 
	 * @return Una stringa contenente il valore dell'alias.
	 */
	static public String fn_GetAliasValueFromRequest(String strTag, int numTypeIndex) {
		String retStr = strTag != null ? strTag : "";

		switch (numTypeIndex) {
		case 1:
		case 2:
			// numeri float e int
			if (strTag == null || strTag.length() == 0) {
				retStr = "0";
			}
			break;
		case 3:
			// link
			if (strTag == null || strTag.length() == 0) {
				retStr = "http://";
			}
			break;
		}

		return retStr;
	}

	/**
	 * Recupera il valore di un alias dal contenuto. Se necessario il valore
	 * viene inizializzato.
	 * 
	 * @param objCnt
	 *            Contenuto da utilizzare.
	 * @param numIndex
	 *            Indice dell'alias da recuperare.
	 * 
	 * @return Una stringa contenente il valore dell'alias.
	 */
	static public String fn_GetAliasValueFromContent(Content objCnt, int numIndex) {
		String str = objCnt.getValue(numIndex);

		switch (objCnt.getContentType().getAlias(numIndex).getTypeIndex()) {
		case 1:
			// float
			if (str == null || str.length() == 0)
				str = "0";
			str = String.valueOf(new Float(str).intValue());
			break;
		case 2:
			// interi
			if (str == null || str.length() == 0)
				str = "0";
			break;
		case 3:
			// link
			if (str == null || str.length() == 0)
				str = "http://";
			break;
		case 5:
			// data
			if (str != null && !"".equals(str)) {
				if (str.length() > 10)
					str = str.substring(0, 10);
			}
		}

		return str;
	}

	/**
	 * Ritorna il numero di Contenuti di un certo Tipo contenuto
	 * 
	 * @param ctype_id
	 *            L'ID del Tipo contenuto
	 * 
	 * @return Il numero di contenuti
	 * 
	 * @throws Exception
	 */
	static public int fn_GetNumContents(int ctype_id) throws Exception {
		int ret = 0;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT count(n11_cnt_oid) AS numCnt FROM cms_11_contenuti WHERE n11_tic_oid=" + String.valueOf(ctype_id);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				ret = rs.getInt("numCnt");
			}
		} catch (Exception e) {
			ret = 0;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Crea un nuovo contenuto.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param objCnt
	 *            L'oggetto con i dati del nuovo contenuto.
	 * @param logger
	 *            Il logger (pu essere null)
	 * 
	 * @return L'ID del nuovo contenuto creato.
	 * 
	 * @throws Exception
	 */
	static public int fn_CreateContent(Connection conn, Content objCnt, Logger logger) throws Exception {
		int new_id = 0;

		try {
			CntAliasMetadata objAliasMD = new CntAliasMetadata();
			objAliasMD.clearCounts();

			String strColumns = "";
			String strValues = "";

			for (int i = 0; i < objCnt.getValueListSize(); i++) {
				String strValue = objCnt.getValue(i);
				int numType = objCnt.getContentType().getAlias(i).getTypeIndex();
				if (numType == -1)
					continue;

				objAliasMD.incrementCount(numType);

				strColumns = strColumns + ", " + objAliasMD.getSQLPrefix(numType) + "11_cnt_" + objAliasMD.getSQLColumn(numType) + String.valueOf(objAliasMD.getCount(numType));

				switch (numType) {
				case 0:
				case 3:
				case 4:
				case 6:
				case 7:
					strValues += ", " + Query.toSQL(strValue);
					break;
				case 1:
				case 2:
					// float e int
					strValues += ", " + ("".equals(strValue.trim()) ? "NULL" : strValue);
					break;
				case 5:
					// data
					String data = "NULL";
					if (strValue != null && !"".equals(strValue)) {
						if (strValue.length() == 10)
							strValue += " 00:00:00";
						data = DateUtil.date2String(DateUtil.string2Date(strValue, "dd/MM/yyyy HH:mm:ss"));
						strValues += ", '" + data + "'";
					} else {
						// la data null messa senza apici altrimenti da errore
						// il connettore jdbc
						strValues += ", " + data;
					}

				}
			}

			// inserisco il nuovo contenuto
			String strCmd = "INSERT INTO cms_11_contenuti (n11_tic_oid" + strColumns + ") VALUES (" + String.valueOf(objCnt.getCTypeDBIndex()) + strValues + ")";

			if (logger != null)
				logger.info("fn_CreateContent::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// recupero l'ID del contenuto appena inserito
			String strQuery = "SELECT MAX(n11_cnt_oid) AS idMax FROM cms_11_contenuti";

			logger.info("fn_CreateContent::Query = " + strQuery);

			stmt = conn.createStatement();
			stmt.executeQuery(strQuery);
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				new_id = rs.getInt("idMax");
			}

			rs.close();
			stmt.close();

			// Inserisco i dati nella tabella dei metadati del contenuto
			boolean hasWorkflow = objCnt.getContentType().hasWorkflow();

			strCmd = "INSERT INTO cms_12_contenuti_metadata (n12_cnt_oid, n12_cmd_online" + ", d12_cmd_dat_creaz, d12_cmd_dat_iniz, d12_cmd_dat_fine";

			strCmd += ", d12_cmd_approved, v12_cmd_descr";

			strCmd += ") VALUES (" + String.valueOf(new_id) + ", " + (objCnt.isOnline() ? "1" : "0") + ", CURRENT_TIMESTAMP";

			if (objCnt.getValidFromDate() == null)
				strCmd += ", NULL";
			else
				strCmd += ", '" + DateUtil.date2String(objCnt.getValidFromDate(), "yyyy-MM-dd HH:mm") + "'";

			if (objCnt.getExpiryDate() == null)
				strCmd += ", NULL";
			else
				strCmd += ", '" + DateUtil.date2String(objCnt.getExpiryDate(), "yyyy-MM-dd HH:mm") + "'";

			if (hasWorkflow) {
				if (objCnt.getApproveDate() != null)
					strCmd += ", CURRENT_TIMESTAMP ";
				else
					strCmd += ", NULL ";
			} else {
				strCmd += ", CURRENT_TIMESTAMP ";
			}

			strCmd += ", " + Query.toSQL(objCnt.getDescr());

			strCmd += ")";

			if (logger != null)
				logger.info("fn_CreateContent::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			conn.commit();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateContents", e);
			throw e;
		}

		return new_id;
	}

	/**
	 * Aggiorna i dati di un contenuto.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param objCnt
	 *            Oggetto con i dati del contenuto da aggiornare.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	static public void fn_UpdateContent(Connection conn, Content objCnt, Logger logger) throws Exception {
		try {
			CntAliasMetadata objAliasMD = new CntAliasMetadata();
			objAliasMD.clearCounts();

			String strColumns = "";

			ContentType objCType = objCnt.getContentType();

			for (int i = 0; i < objCnt.getValueListSize(); i++) {
				if ("".equals(objCType.getAlias(i).getValue()))
					continue;

				String strValue = objCnt.getValue(i);

				int numType = objCnt.getContentType().getAlias(i).getTypeIndex();

				objAliasMD.incrementCount(numType);

				if (i > 0)
					strColumns += ", ";

				strColumns += objAliasMD.getSQLPrefix(numType) + "11_cnt_" + objAliasMD.getSQLColumn(numType) + String.valueOf(objAliasMD.getCount(numType));

				switch (numType) {
				case 0:
				case 3:
				case 4:
				case 6:
				case 7:
					// sono tutte stringhe
					strColumns += "= " + Query.toSQL(strValue);
					break;
				case 1:
				case 2:
					// double e int
					strColumns += "= " + strValue;
					break;
				case 5:
					// data
					String data = "NULL";
					if (strValue != null && !"".equals(strValue)) {
						if (strValue.length() == 10)
							strValue += " 00:00:00";
						data = "'" + DateUtil.date2String(DateUtil.string2Date(strValue, "dd/MM/yyyy HH:mm:ss")) + "'";
					}
					strColumns += " = " + data + "";
					break;
				}
			}

			// Aggiorno la tabella dei contenuti
			String strCmd = "UPDATE cms_11_contenuti SET " + strColumns + " WHERE n11_cnt_oid = " + String.valueOf(objCnt.getDBIndex());

			if (logger != null)
				logger.info("fn_UpdateContent::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			boolean hasWorkflow = objCnt.getContentType().hasWorkflow();

			strCmd = "UPDATE cms_12_contenuti_metadata SET";
			strCmd += " n12_cmd_online = " + (objCnt.isOnline() ? "1" : "0");
			if (objCnt.getValidFromDate() == null)
				strCmd += ", d12_cmd_dat_iniz = NULL";
			else
				strCmd += ", d12_cmd_dat_iniz = '" + DateUtil.date2String(objCnt.getValidFromDate(), "yyyy-MM-dd HH:mm") + "'";
			if (objCnt.getExpiryDate() == null)
				strCmd += ", d12_cmd_dat_fine = NULL";
			else
				strCmd += ", d12_cmd_dat_fine = '" + DateUtil.date2String(objCnt.getExpiryDate(), "yyyy-MM-dd HH:mm") + "'";
			if (hasWorkflow) {
				if (objCnt.getApproveDate() == null)
					strCmd += ", d12_cmd_approved = NULL";
				else
					strCmd += ", d12_cmd_approved = CURRENT_TIMESTAMP";
			} else {
				strCmd += ", d12_cmd_approved = CURRENT_TIMESTAMP";
			}
			strCmd += ", d12_cmd_dat_mod = CURRENT_TIMESTAMP";
			strCmd += ", v12_cmd_descr = " + Query.toSQL(objCnt.getDescr());
			strCmd += " WHERE n12_cnt_oid = " + String.valueOf(objCnt.getDBIndex());

			if (logger != null)
				logger.info("fn_UpdateContent::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateContents", e);
			throw e;
		}
	}

	/**
	 * Elimina un contenuto.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param numDBIndex
	 *            ID del contenuto da eliminare.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	static public void fn_DeleteContent(Connection conn, int numDBIndex, Logger logger) throws Exception {
		try {
			String strCmd = "UPDATE cms_12_contenuti_metadata SET d12_cmd_deleted = CURRENT_TIMESTAMP" + " WHERE n12_cnt_oid = " + String.valueOf(numDBIndex);

			if (logger != null)
				logger.info("fn_DeleteContent::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateContents", e);
			throw e;
		}
	}

	public static String getLinkContent(Channel objChannel, Content objContent) {
		StringBuffer ris = new StringBuffer();
		if (objChannel != null) {
			ris.append(RewriteUtils.rewriteCMSWeb(objChannel.getDescription()));
			ris.append("-");
			ris.append(objChannel.getDBIndex());
		} else {
			/* TODO gestire meglio l'errore */
			return "#";
		}

		if (objContent != null) {
			ris.append("_");
			ris.append(objContent.getName4Rewrite());
			ris.append("-");
			ris.append(objContent.getDBIndex());
		}
		ris.append(".htm");

		return ris.toString();
	}
}
