/*
 * Created on 3-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.common.classes.CntAlias;
import it.softecspa.jwebber.common.classes.CntAliasMetadata;
import it.softecspa.jwebber.common.classes.ContentType;
import it.softecspa.jwebber.common.classes.Option;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il recupero e il salvataggio a DB dei dati relativi ai
 * tipi di contenuto.
 */
public class Ctype_mgr {
	/**
	 * Controlla se esiste uno specifico tipo di contenuto.
	 * 
	 * @param oid_tic
	 *            L'ID del tipo di contenuto
	 * 
	 * @return TRUE se il tipo di contentuo esiste.
	 * 
	 * @throws Exception
	 */
	static public boolean existsContentTYpe(String oid_tic) throws Exception {
		boolean ret = false;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT n10_tic_oid FROM cms_10_tipi_contenuto WHERE n10_tic_oid=" + oid_tic;

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = true;
			}
		} catch (Exception ex) {
			ret = false;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Recupera l'ID di un tipo contenuto dato il suo nome.
	 * 
	 * @param tic_name
	 *            Il nome del tipo di contenuto
	 * 
	 * @return L'ID del tipo contenuto o 0 se non esiste.
	 * 
	 * @throws Exception
	 */
	static public int fn_GetContentTypeID(String tic_name) throws Exception {
		int ret = 0;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT n10_tic_oid" + " FROM cms_10_tipi_contenuto" + " WHERE v10_tic_nome = " + Query.toSQL(tic_name);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = rs.getInt("n10_tic_oid");
			}
		} catch (Exception ex) {
			ret = 0;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Controlla se il profilo specificato pu creare contenuti del tipo
	 * specificato.
	 * 
	 * @param oid_tic
	 *            L'ID del tipo contenuto.
	 * @param id_profilo
	 *            L'ID del profilo.
	 * 
	 * @return TRUE se si ha l'autorizzazione.
	 * 
	 * @throws Exception
	 */
	static public boolean canCreateContent(String oid_tic, String id_profilo) throws Exception {
		boolean ret = false;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT n03_tic_oid" + " FROM cms_03_profilo_tipi_contenuto" + " WHERE n03_tic_oid = " + oid_tic + " AND id_profilo = " + Query.toSQL(id_profilo) + " AND n03_tic_editable = 1";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = true;
			}
		} catch (Exception ex) {
			ret = false;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Restituisce l'elenco dei tipi di contenuto editabili da un determinato
	 * profilo.
	 * 
	 * @param id_profilo
	 *            id del profilo, "" se si vogliono vedere tutti i tipi di
	 *            contentuo.
	 * 
	 * @return Un riferimento all'array che conterr i tipi contenuto (oggetti
	 *         di classe 'ContentType').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetContentTypes(String id_profilo) throws Exception {
		Vector arrCTypes = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "";

			if ("".equals(id_profilo)) {
				strQuery = "SELECT n10_tic_oid, v10_tic_nome, v10_tic_descr, n10_tic_workflow, n10_tic_max_cnt" + " FROM cms_10_tipi_contenuto ORDER BY v10_tic_nome ASC";
			} else {
				strQuery = "SELECT n10_tic_oid, v10_tic_nome, v10_tic_descr, n10_tic_workflow, n10_tic_max_cnt" + " FROM cms_10_tipi_contenuto, cms_03_profilo_tipi_contenuto"
						+ " WHERE cms_10_tipi_contenuto.n10_tic_oid=cms_03_profilo_tipi_contenuto.n03_tic_oid" + " AND cms_03_profilo_tipi_contenuto.id_profilo = " + Query.toSQL(id_profilo) + " AND cms_03_profilo_tipi_contenuto.n03_tic_editable = 1"
						+ " ORDER BY v10_tic_nome ASC";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			int i = 0;
			while (rs.next()) {
				ContentType objCType = new ContentType(rs.getInt("n10_tic_oid"), rs.getString("v10_tic_nome"), rs.getString("v10_tic_descr"), (rs.getInt("n10_tic_workflow") == 1), rs.getInt("n10_tic_max_cnt"));
				arrCTypes.add(i, objCType);
				i++;
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrCTypes;
	}

	/**
	 * Restituisce l'elenco dei tipi di contenuto editabili da un determinato
	 * profilo.
	 * 
	 * @param id_profilo
	 *            id del profilo, "" se si vogliono vedere tutti i tipi di
	 *            contentuo.
	 * 
	 * @return Un riferimento all'array che conterr i tipi contenuto (oggetti
	 *         di classe 'ContentType').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetContentTypesJoin(String id_profilo) throws Exception {
		Vector arrCTypes = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "";

			if ("".equals(id_profilo)) {
				strQuery = "SELECT n10_tic_oid, v10_tic_nome, v10_tic_descr, n10_tic_workflow, n10_tic_max_cnt," + " v23_tic_filter_on, v23_tic_filter" + " FROM cms_10_tipi_contenuto LEFT OUTER JOIN cms_23_tic_filter"
						+ " ON cms_10_tipi_contenuto.v10_tic_nome=cms_23_tic_filter.v23_tic_nome" + " ORDER BY v10_tic_nome ASC";
			} else {
				strQuery = "SELECT n10_tic_oid, v10_tic_nome, v10_tic_descr, n10_tic_workflow, n10_tic_max_cnt," + " v23_tic_filter_on, v23_tic_filter" + " FROM cms_10_tipi_contenuto INNER JOIN cms_03_profilo_tipi_contenuto"
						+ " ON cms_10_tipi_contenuto.n10_tic_oid=cms_03_profilo_tipi_contenuto.n03_tic_oid" + " LEFT OUTER JOIN cms_23_tic_filter" + " ON cms_10_tipi_contenuto.v10_tic_nome=cms_23_tic_filter.v23_tic_nome"
						+ " WHERE cms_10_tipi_contenuto.n10_tic_oid=cms_03_profilo_tipi_contenuto.n03_tic_oid" + " AND cms_03_profilo_tipi_contenuto.id_profilo = " + Query.toSQL(id_profilo) + " AND cms_03_profilo_tipi_contenuto.n03_tic_editable = 1"
						+ " ORDER BY v10_tic_nome ASC";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			int i = 0;
			while (rs.next()) {
				ContentType objCType = new ContentType(rs.getInt("n10_tic_oid"), rs.getString("v10_tic_nome"), rs.getString("v10_tic_descr"), (rs.getInt("n10_tic_workflow") == 1), rs.getInt("n10_tic_max_cnt"));
				objCType.setFilter(rs.getString("v23_tic_filter"));
				objCType.setFilterOn(rs.getString("v23_tic_filter_on"));
				arrCTypes.add(i, objCType);
				i++;
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrCTypes;
	}

	/**
	 * Restituisce i dati di un tipo di contenuto.
	 * 
	 * @param numDBIndex
	 *            : ID del tipo di contenuto
	 * 
	 * @return Un riferimento all'oggetto che conterr il tipo (oggetto di
	 *         classe classe ContentType).
	 * 
	 *@throws Exception
	 */
	static public ContentType fn_GetContentType(int numDBIndex) throws Exception {
		ContentType objCType = null;

		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT * FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				objCType = new ContentType(numDBIndex, rs.getString("v10_tic_nome"), rs.getString("v10_tic_descr"), (rs.getInt("n10_tic_workflow") == 1), rs.getInt("n10_tic_max_cnt"));

				CntAliasMetadata objAliasMD = new CntAliasMetadata();

				for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
					for (int j = 1; j <= objAliasMD.getCount(i); j++) {
						String strValue = rs.getString("v10_tic_" + objAliasMD.getSQLColumn(i) + "" + j + "");
						if (!rs.wasNull() && strValue.length() > 0) {
							int order = rs.getInt("d10_tic_" + objAliasMD.getSQLColumn(i) + "" + j + "");
							boolean requested = rs.getInt("n10_ob_" + objAliasMD.getSQLColumn(i) + "" + j + "") == 1;
							boolean inList = rs.getInt("n10_inl_" + objAliasMD.getSQLColumn(i) + "" + j + "") == 1;
							String contentsColumnName = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + "" + j + "";

							CntAlias objAlias = new CntAlias(i, objAliasMD.getName(i), strValue.trim(), order, requested, inList, contentsColumnName);
							objCType.addAlias(objAlias);
						} else {
							CntAlias objAlias = new CntAlias(i, objAliasMD.getName(i), "", 0, false, false, "");
							objCType.addAlias(objAlias);
						}
					}
				}
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objCType;

	}

	/**
	 * Restituisce i dati di un tipo di contenuto.
	 * 
	 * @param numDBIndex
	 *            : ID del tipo di contenuto
	 * 
	 * @return Un riferimento all'oggetto che conterr il tipo (oggetto di
	 *         classe classe ContentType).
	 * 
	 *@throws Exception
	 */
	static public ContentType fn_GetContentTypeJoin(int numDBIndex) throws Exception {
		ContentType objCType = null;

		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT cms_10_tipi_contenuto.*, cms_23_tic_filter.v23_tic_filter, cms_23_tic_filter.v23_tic_filter_on" + " FROM cms_10_tipi_contenuto LEFT OUTER JOIN cms_23_tic_filter"
					+ " ON cms_10_tipi_contenuto.v10_tic_nome=cms_23_tic_filter.v23_tic_nome" + " WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				objCType = new ContentType(numDBIndex, rs.getString("v10_tic_nome"), rs.getString("v10_tic_descr"), (rs.getInt("n10_tic_workflow") == 1), rs.getInt("n10_tic_max_cnt"));
				objCType.setFilter(rs.getString("v23_tic_filter"));
				objCType.setFilterOn(rs.getString("v23_tic_filter_on"));

				CntAliasMetadata objAliasMD = new CntAliasMetadata();

				for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
					for (int j = 1; j <= objAliasMD.getCount(i); j++) {
						String strValue = rs.getString("v10_tic_" + objAliasMD.getSQLColumn(i) + "" + j + "");
						if (!rs.wasNull() && strValue.length() > 0) {
							int order = rs.getInt("d10_tic_" + objAliasMD.getSQLColumn(i) + "" + j + "");
							boolean requested = rs.getInt("n10_ob_" + objAliasMD.getSQLColumn(i) + "" + j + "") == 1;
							boolean inList = rs.getInt("n10_inl_" + objAliasMD.getSQLColumn(i) + "" + j + "") == 1;
							String contentsColumnName = objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + "" + j + "";

							CntAlias objAlias = new CntAlias(i, objAliasMD.getName(i), strValue.trim(), order, requested, inList, contentsColumnName);
							objCType.addAlias(objAlias);
						} else {
							CntAlias objAlias = new CntAlias(i, objAliasMD.getName(i), "", 0, false, false, "");
							objCType.addAlias(objAlias);
						}
					}
				}
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objCType;

	}

	/**
	 * Restituisce la lista dei valori delle selection.
	 * 
	 * @return Un vettore con i nomi delle selection.
	 * 
	 *@throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetSelections() throws Exception {
		Vector arrSelections = new Vector();

		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT v22_sel_nome FROM cms_22_selections ORDER BY v22_sel_nome";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				arrSelections.add(rs.getString("v22_sel_nome"));
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrSelections;
	}

	/**
	 * Restituisce la lista dei valori delle option della selection specificata.
	 * 
	 * @param selection
	 *            Il nome della selction.
	 * @return Un vettore con tutti i valori della selection (oggetti di tipo
	 *         Option).
	 * 
	 *@throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetSelectionOptions(String selection, String userid, String id_profilo) throws Exception {
		Vector arrOptions = new Vector();

		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();

			// Recupero la query per popolare la selection
			String strQuery = "SELECT v22_sel_query" + " FROM cms_22_selections" + " WHERE v22_sel_nome = " + Query.toSQL(selection);
			String strSelection = "";
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				strSelection = rs.getString("v22_sel_query");
			}
			rs.close();
			stmt.close();

			if (!"".equals(strSelection)) {
				String query = strSelection.toUpperCase();
				query = query.substring(0, query.indexOf("FROM"));

				// Controllo se la query deve essere filtrata per utente o
				// profilo
				if (query.indexOf("userid") >= 0) {
					strSelection = "SELECT id, value FROM (" + strSelection + ") AS QRYSEL WHERE userid=" + userid;
				} else if (query.indexOf("ID_PROFILO") >= 0) {
					strSelection = "SELECT id, value" + " FROM (" + strSelection + ") AS QRYSEL" + " WHERE id_profilo = " + Query.toSQL(id_profilo);
				}

				stmt = conn.createStatement();
				rs = stmt.executeQuery(strSelection);

				while (rs.next()) {
					Option objOpt = new Option(rs.getString("id"), rs.getString("value"));
					arrOptions.add(objOpt);
				}
				rs.close();
				stmt.close();
			}

		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrOptions;
	}

	/**
	 * Restituisce l'elenco di alias disponibili per un tipo di contenuto.
	 * L'elenco  composto dagli alias non ancora assegnati al tipo.
	 * 
	 * @param arrAliasUsed
	 *            : Elemento degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias ancora
	 *         disponibili.
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetAvailableAlias(Vector arrAliasUsed) {

		Vector arrAliasAvail = new Vector();

		CntAliasMetadata objAliasMD = new CntAliasMetadata();

		// Decremento il totale alias delle quantit gi utilizzate
		for (int i = 0; i < arrAliasUsed.size(); i++) {
			objAliasMD.decrementCount(((CntAlias) arrAliasUsed.get(i)).getTypeIndex());
		}

		// Creo l'elenco degli alias disponibili
		for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
			if (objAliasMD.getCount(i) > 0) {
				arrAliasAvail.add(i + "_" + objAliasMD.getName(i) + "_" + objAliasMD.getCount(i));
			}
		}

		return arrAliasAvail;
	}

	/**
	 * Restituisce l'elenco di alias disponibili per un tipo di contenuto.
	 * L'elenco  composto dagli alias non ancora assegnati al tipo.
	 * 
	 * @param arrAliasUsed
	 *            L'elenco degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias ancora
	 *         disponibili.
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetAvailableAliasEdit(Vector arrAliasUsed) {

		Vector arrAliasAvail = new Vector();

		CntAliasMetadata objAliasMD = new CntAliasMetadata();

		// Decremento il totale alias delle quantit gi utilizzate
		for (int i = 0; i < arrAliasUsed.size(); i++) {
			CntAlias objAlias = (CntAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias.getValue()))
				objAliasMD.decrementCount(objAlias.getTypeIndex());
		}

		// Creo l'elenco degli alias disponibili
		for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
			if (objAliasMD.getCount(i) > 0) {
				arrAliasAvail.add(i + "_" + objAliasMD.getName(i) + "_" + objAliasMD.getCount(i));
			}
		}

		return arrAliasAvail;
	}

	@SuppressWarnings("unchecked")
	static public Vector fn_MoveAliasDown(int alias1Index, Vector arrAliasUsed) {
		boolean found = false;
		int alias2Index = 0;
		CntAlias objAlias2 = null;

		CntAlias objAlias1 = (CntAlias) arrAliasUsed.get(alias1Index);
		int alias1Order = objAlias1.getOrder();

		for (int i = 0; i < arrAliasUsed.size(); i++) {
			objAlias2 = (CntAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias2) && objAlias2.getOrder() == alias1Order + 1) {
				alias2Index = i;
				found = true;
				break;
			}
		}

		if (found) {
			objAlias1.setOrder(alias1Order + 1);
			objAlias2.setOrder(alias1Order);
			arrAliasUsed.set(alias1Index, objAlias1);
			arrAliasUsed.set(alias2Index, objAlias2);
		}

		return arrAliasUsed;
	}

	@SuppressWarnings("unchecked")
	static public Vector fn_MoveAliasUp(int alias1Index, Vector arrAliasUsed) {
		boolean found = false;
		int alias2Index = 0;
		CntAlias objAlias2 = null;

		CntAlias objAlias1 = (CntAlias) arrAliasUsed.get(alias1Index);
		int alias1Order = objAlias1.getOrder();

		for (int i = 0; i < arrAliasUsed.size(); i++) {
			objAlias2 = (CntAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias2.getValue()) && objAlias2.getOrder() == alias1Order - 1) {
				alias2Index = i;
				found = true;
				break;
			}
		}

		if (found) {
			objAlias1.setOrder(alias1Order - 1);
			objAlias2.setOrder(alias1Order);
			arrAliasUsed.set(alias1Index, objAlias1);
			arrAliasUsed.set(alias2Index, objAlias2);
		}

		return arrAliasUsed;
	}

	/**
	 * Aggiunge un alias di un dato tipo all'elenco degli alias utilizzati in un
	 * tipo di contenuto.
	 * 
	 * @param numAliasType
	 *            : Tipo dell'alias da aggiungere all'elenco.
	 * @param arrAliasUsed
	 *            : Elemento degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array arrAliasUsed, aggiornato.
	 */
	/*
	 * static public Vector fn_AddAliasToArray (int numAliasType, Vector
	 * arrAliasUsed) { if ((numAliasType >= 0)&& (numAliasType <= 6)) {
	 * CntAliasMetadata objAliasMD = new CntAliasMetadata();
	 * 
	 * // Recupero l'indice di inserimento del nuovo alias //int numIndex =
	 * arrAliasUsed.size()+ 1; //for(int i=0; i<arrAliasUsed.size(); i++) //{ //
	 * if(((CntAlias) arrAliasUsed.elementAt(i)).getTypeIndex() > numAliasType )
	 * // { // numIndex = i; // break; // } //}
	 * 
	 * // Aggiungo il nuovo alias in posizione numIndex nell'array //CntAlias
	 * objAlias = new CntAlias( // numAliasType, //
	 * objAliasMD.getName(numAliasType), // ""); //if(numIndex ==
	 * arrAliasUsed.size()+1) // arrAliasUsed.add(objAlias); //else //
	 * arrAliasUsed.add(numIndex,objAlias);
	 * 
	 * CntAlias objAlias = new CntAlias( numAliasType,
	 * objAliasMD.getName(numAliasType), "", arrAliasUsed.size());
	 * arrAliasUsed.add(objAlias); }
	 * 
	 * return arrAliasUsed; }
	 */

	/**
	 * Aggiunge un alias di un dato tipo all'elenco degli alias utilizzati in un
	 * tipo di contenuto.
	 * 
	 * @param numAliasType
	 *            Tipo dell'alias da aggiungere all'elenco.
	 * @param arrAliasUsed
	 *            L'elenco degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array arrAliasUsed, aggiornato.
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_AddAliasToArrayEdit(int numAliasType, Vector arrAliasUsed, int order) {
		if ((numAliasType >= 0) && (numAliasType <= 7)) {
			CntAliasMetadata objAliasMD = new CntAliasMetadata();

			// Recupero l'indice di inserimento del nuovo alias
			int numIndex = 0;
			for (int i = 0; i < arrAliasUsed.size(); i++) {
				CntAlias objAlias = (CntAlias) arrAliasUsed.get(i);
				if (objAlias.getTypeIndex() == numAliasType && "".equals(objAlias.getValue())) {
					numIndex = i;
					break;
				}
			}

			// Aggiungo il nuovo alias in posizione numIndex nell'array
			CntAlias objAlias = new CntAlias(numAliasType, objAliasMD.getName(numAliasType), " ", order, false, false, "");
			arrAliasUsed.set(numIndex, objAlias);
		}

		return arrAliasUsed;
	}

	/**
	 * Rimuove un dato alias dall'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @param numAliasIndex
	 *            : Indice dell'alias da rimuovere.
	 * @param arrAliasUsed
	 *            : Elemento degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array p_arrAliasUsed, aggiornato.
	 * 
	 */
	/*
	 * static public Vector fn_RemoveAliasFromArray (int numAliasIndex, Vector
	 * arrAliasUsed) { int numIndex = numAliasIndex; if ((numIndex >= 0) &&
	 * (numIndex<arrAliasUsed.size())) { arrAliasUsed.removeElementAt(numIndex);
	 * }
	 * 
	 * return arrAliasUsed; }
	 */

	/**
	 * Rimuove un dato alias dall'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @param numAliasIndex
	 *            Indice dell'alias da rimuovere.
	 * @param arrAliasUsed
	 *            L'elenco degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array aggiornato.
	 * 
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_RemoveAliasFromArrayEdit(int numAliasIndex, Vector arrAliasUsed) {
		CntAlias objAlias = (CntAlias) arrAliasUsed.get(numAliasIndex);
		int order = objAlias.getOrder();

		for (int i = 0; i < arrAliasUsed.size(); i++) {
			objAlias = (CntAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias.getValue()) && objAlias.getOrder() == order) {
				CntAlias objNew = new CntAlias(objAlias.getTypeIndex(), objAlias.getTypeName(), "", 0, false, false, objAlias.getContentColumnName());
				arrAliasUsed.set(i, objNew);
			} else if (!"".equals(objAlias.getValue()) && objAlias.getOrder() > order) {
				CntAlias objNew = new CntAlias(objAlias.getTypeIndex(), objAlias.getTypeName(), objAlias.getValue(), objAlias.getOrder() - 1, objAlias.isRequested(), objAlias.isInList(), objAlias.getContentColumnName());
				arrAliasUsed.set(i, objNew);
			}
		}

		return arrAliasUsed;
	}

	/**
	 * Controlla se esiste gi un dato tipo di contenuto. Il controllo viene
	 * fatto in base al nome del tipo di contenuto.
	 * 
	 * @param numDBIndex
	 *            ID da scartare ( 0 = nessuno scarto ).
	 * @param strName
	 *            Nome del tipo di contenuto da controllare.
	 * 
	 * @return TRUE se il tipo di contenuto esiste, FALSE altrimenti.
	 * 
	 * @throws Exception
	 */
	static public boolean fn_ContentTypeExists(int numDBIndex, String strName) throws Exception {
		boolean bolFound = false;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT n10_tic_oid FROM cms_10_tipi_contenuto" + " WHERE v10_tic_nome = " + Query.toSQL(strName);
			if (numDBIndex > 0) {
				strQuery += " AND n10_tic_oid NOT IN (" + numDBIndex + ")";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				bolFound = true;
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return bolFound;

	}

	/**
	 * Crea un nuovo tipo di contenuto.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objCType
	 *            Oggetto contenente i dati del nuovo tipo di contenuto.
	 * 
	 * @return l'ID del nuovo tipo di contenuto creato.
	 * 
	 * @throws Exception
	 */
	static public int fn_CreateContentType(Connection conn, ContentType objCType, Logger logger) throws Exception {
		CntAliasMetadata objAliasMD = new CntAliasMetadata();

		String strColumns = "";
		String strValues = "";
		int arrIndex = 0;
		for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
			for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
				CntAlias objAlias = (CntAlias) objCType.getAliasList().get(arrIndex);

				strColumns += ", v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + ", d10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + ", n10_ob_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + ", n10_inl_"
						+ objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
				strValues += ", " + Query.toSQL(objAlias.getValue()) + ", " + String.valueOf(objAlias.getOrder()) + ", " + (objAlias.isRequested() ? "1" : "0") + ", " + (objAlias.isInList() ? "1" : "0");

				arrIndex++;
			}
		}

		int numIDMax = 0;

		try {
			String strCmd = "INSERT INTO cms_10_tipi_contenuto (v10_tic_nome, v10_tic_descr, n10_tic_workflow, n10_tic_max_cnt" + strColumns + ") VALUES (" + Query.toSQL(objCType.getName()) + ", " + Query.toSQL(objCType.getDescription()) + ", "
					+ (objCType.hasWorkflow() ? "1" : "0") + ", " + String.valueOf(objCType.getNumMaxCnt()) + strValues + ")";

			if (logger != null)
				logger.info("fn_CreateContentType::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.execute(strCmd);
			stmt.close();

			String strQuery = "SELECT MAX(n10_tic_oid) AS idMax FROM cms_10_tipi_contenuto";

			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				numIDMax = rs.getInt("idMax");
			}

			rs.close();
			stmt.close();
			rs.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateContentType", e);
			throw e;
		}

		return numIDMax;

	}

	/**
	 * Aggiorna i dati di un tipo di contenuto.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objCType
	 *            Oggetto contenente i dati del tipo di contenuto da aggiornare.
	 * 
	 * @throws Exception
	 */
	static public void fn_UpdateContentType(Connection conn, ContentType objCType, Logger logger) throws Exception {
		CntAliasMetadata objAliasMD = new CntAliasMetadata();

		String strCmdAlias = "";
		Statement stmt;

		try {
			int arrIndex = 0;
			for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
				for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
					CntAlias objAlias = (CntAlias) objCType.getAliasList().get(arrIndex);
					strCmdAlias += ", v10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + " = " + Query.toSQL(objAlias.getValue().trim()) + ", d10_tic_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + " = "
							+ String.valueOf(objAlias.getOrder()) + ", n10_ob_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + " = " + (objAlias.isRequested() ? "1" : "0") + ", n10_inl_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1)
							+ " = " + (objAlias.isInList() ? "1" : "0");

					arrIndex++;

					if ("".equals(objAlias.getValue().trim())) {
						// Azzero i valori del campo corrispondente per tutti i
						// contenuti gi inseriti del tipo in esame
						String strCmdContents = "UPDATE cms_11_contenuti SET " + objAliasMD.getSQLPrefix(i) + "11_cnt_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + " = NULL WHERE n11_tic_oid = " + String.valueOf(objCType.getDBIndex());

						if (logger != null)
							logger.info("fn_UpdateContentType::Cmd = " + strCmdContents);

						stmt = conn.createStatement();
						stmt.execute(strCmdContents);
						stmt.close();
					}
				}
			}

			String strCmd = "UPDATE cms_10_tipi_contenuto SET" + " v10_tic_nome = " + Query.toSQL(objCType.getName()) + ", v10_tic_descr = " + Query.toSQL(objCType.getDescription()) + ", n10_tic_workflow = " + (objCType.hasWorkflow() ? "1" : "0")
					+ ", n10_tic_max_cnt = " + String.valueOf(objCType.getNumMaxCnt()) + strCmdAlias + " WHERE n10_tic_oid = " + objCType.getDBIndex();

			if (logger != null)
				logger.info("fn_UpdateContentType::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.execute(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateContentType", e);
			throw e;
		}
	}

	/**
	 * Elimina un tipo di contenuto.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param numDBIndex
	 *            ID del tipo di contenuto da eliminare.
	 * 
	 * @return TRUE = Tipo eliminato, se FALSE esistono pagine che fanno
	 *         rferimento a questo tipo di contenuto
	 * 
	 * @throws Exception
	 */
	static public boolean fn_DeleteContentType(Connection conn, int numDBIndex) throws Exception {
		boolean ret = false;

		int numResult = 0;

		try {
			String strQuery = "SELECT Count(n13_pag_oid) AS totItems FROM cms_13_pagina_tipi_contenuto" + " WHERE n13_tic_oid = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				numResult = rs.getInt("totItems");
			}
			stmt.close();
			rs.close();

			if (numResult == 0) {
				String strCmd = "DELETE FROM cms_10_tipi_contenuto WHERE n10_tic_oid = " + String.valueOf(numDBIndex);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				ret = true;
			}
		} catch (Exception e) {
			throw e;
		}

		return ret;
	}
}
