/*
 * Created on 3-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.common.classes.ExtAlias;
import it.softecspa.jwebber.common.classes.ExtAliasMetadata;
import it.softecspa.jwebber.common.classes.ExtensionType;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il recupero e il salvataggio a DB dei dati relativi ai
 * tipi di contenuto.
 */
public class ExtType_mgr {
	/**
	 * Restituisce l'elenco dei tipi di estensioni editabili da un determinato
	 * profilo.
	 * 
	 * @param id_profilo
	 *            id del profilo, "" se si vogliono vedere tutti i tipi di
	 *            contentuo.
	 * 
	 * @return Un riferimento all'array che conterr i tipi contenuto (oggetti
	 *         di classe 'ExtensionType').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetExtensionTypes(String id_profilo) throws Exception {
		Vector arrExtTypes = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "";

			if ("".equals(id_profilo)) {
				strQuery = "SELECT id_t_tipo_ext, nome, descr" + " FROM cms_35_tipo_ext ORDER BY nome ASC";
			}
			// else
			// {
			// strQuery =
			// "SELECT n10_tic_oid, v10_tic_nome, v10_tic_descr, n10_tic_workflow"
			// + " FROM t10_tipi_contenuto, t03_profilo_tipi_contenuto"
			// +
			// " WHERE t10_tipi_contenuto.n10_tic_oid=t03_profilo_tipi_contenuto.n03_tic_oid"
			// + " AND t03_profilo_tipi_contenuto.ID_PROFILO='" + id_profilo +
			// "'"
			// +
			// " AND t03_profilo_tipi_contenuto.n03_tic_editable=1 ORDER BY v10_tic_nome ASC";
			// }

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			int i = 0;
			while (rs.next()) {
				ExtensionType objExtType = new ExtensionType(rs.getInt("id_t_tipo_ext"), rs.getString("nome"), rs.getString("descr"));
				arrExtTypes.add(i, objExtType);
				i++;
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrExtTypes;
	}

	/**
	 * Restituisce i dati di un tipo di estensione.
	 * 
	 * @param numDBIndex
	 *            : ID del tipo di contenuto
	 * 
	 * @return Un riferimento all'oggetto che conterr il tipo (oggetto di
	 *         classe classe ExtensionType).
	 * 
	 *@throws Exception
	 */
	static public ExtensionType fn_GetExtensionType(int numDBIndex) throws Exception {
		ExtensionType objExtType = null;

		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT * FROM cms_35_tipo_ext WHERE id_t_tipo_ext = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				objExtType = new ExtensionType(numDBIndex, rs.getString("nome"), rs.getString("descr"));

				ExtAliasMetadata objAliasMD = new ExtAliasMetadata();

				for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
					for (int j = 1; j <= objAliasMD.getCount(i); j++) {
						String strValue = rs.getString("tb_" + objAliasMD.getSQLColumn(i) + "" + j + "");
						if (!rs.wasNull() && strValue.length() > 0) {
							int order = rs.getInt("ord_" + objAliasMD.getSQLColumn(i) + "" + j + "");
							boolean requested = rs.getInt("ob_" + objAliasMD.getSQLColumn(i) + "" + j + "") == 1;
							ExtAlias objAlias = new ExtAlias(i, objAliasMD.getName(i), strValue.trim(), order, requested);
							objExtType.addAlias(objAlias);
						} else {
							ExtAlias objAlias = new ExtAlias(i, objAliasMD.getName(i), "", 0, false);
							objExtType.addAlias(objAlias);
						}
					}
				}
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objExtType;

	}

	/**
	 * Aggiunge un alias di un dato tipo all'elenco degli alias utilizzati in un
	 * tipo di contenuto.
	 * 
	 * @param numAliasType
	 *            Tipo dell'alias da aggiungere all'elenco.
	 * @param arrAliasUsed
	 *            L'elenco degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array arrAliasUsed, aggiornato.
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_AddAliasToArrayEdit(int numAliasType, Vector arrAliasUsed, int order) {
		if ((numAliasType >= 0) && (numAliasType <= 7)) {
			ExtAliasMetadata objAliasMD = new ExtAliasMetadata();

			// Recupero l'indice di inserimento del nuovo alias
			int numIndex = 0;
			for (int i = 0; i < arrAliasUsed.size(); i++) {
				ExtAlias objAlias = (ExtAlias) arrAliasUsed.get(i);
				if (objAlias.getTypeIndex() == numAliasType && "".equals(objAlias.getValue())) {
					numIndex = i;
					break;
				}
			}

			// Aggiungo il nuovo alias in posizione numIndex nell'array
			ExtAlias objAlias = new ExtAlias(numAliasType, objAliasMD.getName(numAliasType), " ", order, false);
			arrAliasUsed.set(numIndex, objAlias);
		}

		return arrAliasUsed;
	}

	/**
	 * Rimuove un dato alias dall'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @param numAliasIndex
	 *            Indice dell'alias da rimuovere.
	 * @param arrAliasUsed
	 *            L'elenco degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array aggiornato.
	 * 
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_RemoveAliasFromArrayEdit(int numAliasIndex, Vector arrAliasUsed) {
		ExtAlias objAlias = (ExtAlias) arrAliasUsed.get(numAliasIndex);
		int order = objAlias.getOrder();

		for (int i = 0; i < arrAliasUsed.size(); i++) {
			objAlias = (ExtAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias.getValue()) && objAlias.getOrder() == order) {
				ExtAlias objNew = new ExtAlias(objAlias.getTypeIndex(), objAlias.getTypeName(), "", 0, false);
				arrAliasUsed.set(i, objNew);
			} else if (!"".equals(objAlias.getValue()) && objAlias.getOrder() > order) {
				ExtAlias objNew = new ExtAlias(objAlias.getTypeIndex(), objAlias.getTypeName(), objAlias.getValue(), objAlias.getOrder() - 1, objAlias.isRequested());
				arrAliasUsed.set(i, objNew);
			}
		}

		return arrAliasUsed;
	}

	@SuppressWarnings("unchecked")
	static public Vector fn_MoveAliasDown(int alias1Index, Vector arrAliasUsed) {
		boolean found = false;
		int alias2Index = 0;
		ExtAlias objAlias2 = null;

		ExtAlias objAlias1 = (ExtAlias) arrAliasUsed.get(alias1Index);
		int alias1Order = objAlias1.getOrder();

		for (int i = 0; i < arrAliasUsed.size(); i++) {
			objAlias2 = (ExtAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias2) && objAlias2.getOrder() == alias1Order + 1) {
				alias2Index = i;
				found = true;
				break;
			}
		}

		if (found) {
			objAlias1.setOrder(alias1Order + 1);
			objAlias2.setOrder(alias1Order);
			arrAliasUsed.set(alias1Index, objAlias1);
			arrAliasUsed.set(alias2Index, objAlias2);
		}

		return arrAliasUsed;
	}

	@SuppressWarnings("unchecked")
	static public Vector fn_MoveAliasUp(int alias1Index, Vector arrAliasUsed) {
		boolean found = false;
		int alias2Index = 0;
		ExtAlias objAlias2 = null;

		ExtAlias objAlias1 = (ExtAlias) arrAliasUsed.get(alias1Index);
		int alias1Order = objAlias1.getOrder();

		for (int i = 0; i < arrAliasUsed.size(); i++) {
			objAlias2 = (ExtAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias2.getValue()) && objAlias2.getOrder() == alias1Order - 1) {
				alias2Index = i;
				found = true;
				break;
			}
		}

		if (found) {
			objAlias1.setOrder(alias1Order - 1);
			objAlias2.setOrder(alias1Order);
			arrAliasUsed.set(alias1Index, objAlias1);
			arrAliasUsed.set(alias2Index, objAlias2);
		}

		return arrAliasUsed;
	}

	/**
	 * Restituisce l'elenco di alias disponibili per un tipo di estensione.
	 * L'elenco  composto dagli alias non ancora assegnati al tipo.
	 * 
	 * @param arrAliasUsed
	 *            L'elenco degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias ancora
	 *         disponibili.
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetAvailableAliasEdit(Vector arrAliasUsed) {

		Vector arrAliasAvail = new Vector();

		ExtAliasMetadata objAliasMD = new ExtAliasMetadata();

		// Decremento il totale alias delle quantit gi utilizzate
		for (int i = 0; i < arrAliasUsed.size(); i++) {
			ExtAlias objAlias = (ExtAlias) arrAliasUsed.get(i);
			if (!"".equals(objAlias.getValue()))
				objAliasMD.decrementCount(objAlias.getTypeIndex());
		}

		// Creo l'elenco degli alias disponibili
		for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
			if (objAliasMD.getCount(i) > 0) {
				arrAliasAvail.add(i + "_" + objAliasMD.getName(i) + "_" + objAliasMD.getCount(i));
			}
		}

		return arrAliasAvail;
	}

	/**
	 * Controlla se esiste gi un dato tipo di estensione. Il controllo viene
	 * fatto in base al nome del tipo di estensione.
	 * 
	 * @param numDBIndex
	 *            ID da scartare ( 0 = nessuno scarto ).
	 * @param strName
	 *            Nome del tipo di estensione da controllare.
	 * 
	 * @return TRUE se il tipo di contenuto esiste, FALSE altrimenti.
	 * 
	 * @throws Exception
	 */
	static public boolean fn_ExtensionTypeExists(int numDBIndex, String strName) throws Exception {
		boolean bolFound = false;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT nome FROM cms_35_tipo_ext" + " WHERE nome = " + Query.toSQL(strName);
			if (numDBIndex > 0) {
				strQuery += " AND id_t_tipo_ext NOT IN (" + numDBIndex + ")";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				bolFound = true;
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return bolFound;

	}

	/**
	 * Crea un nuovo tipo di estensione.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objExtType
	 *            Oggetto contenente i dati del nuovo tipo di estensione.
	 * 
	 * @return l'ID del nuovo tipo di estensione creato.
	 * 
	 * @throws Exception
	 */
	static public int fn_CreateExtensionType(Connection conn, ExtensionType objExtType, Logger logger) throws Exception {
		ExtAliasMetadata objAliasMD = new ExtAliasMetadata();

		String strColumns = "";
		String strValues = "";
		int arrIndex = 0;
		for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
			for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
				ExtAlias objAlias = (ExtAlias) objExtType.getAliasList().get(arrIndex);

				strColumns += ", tb_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + ", ord_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + ", ob_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
				strValues += ", " + Query.toSQL(objAlias.getValue()) + ", " + String.valueOf(objAlias.getOrder()) + ", " + (objAlias.isRequested() ? "1" : "0");

				arrIndex++;
			}
		}

		int numIDMax = 0;

		try {
			String strCmd = "INSERT INTO cms_35_tipo_ext (nome, descr" + strColumns + ") VALUES (" + Query.toSQL(objExtType.getName()) + ", " + Query.toSQL(objExtType.getDescription()) + strValues + ")";

			if (logger != null)
				logger.info("fn_CreateExtensionType::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.execute(strCmd);
			stmt.close();

			String strQuery = "SELECT MAX(id_t_tipo_ext) AS idMax FROM cms_35_tipo_ext";

			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				numIDMax = rs.getInt("idMax");
			}

			rs.close();
			stmt.close();
			rs.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateExtensionType", e);
			throw e;
		}

		return numIDMax;

	}

	/**
	 * Aggiorna i dati di un tipo di estensione.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objExtType
	 *            Oggetto contenente i dati del tipo di estensione da
	 *            aggiornare.
	 * @param logger
	 *            Il logger
	 * 
	 * @throws Exception
	 */
	static public void fn_UpdateExtensionType(Connection conn, ExtensionType objExtType, Logger logger) throws Exception {
		ExtAliasMetadata objAliasMD = new ExtAliasMetadata();

		String strCmdAlias = "";
		Statement stmt;

		try {
			int arrIndex = 0;
			for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
				for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
					ExtAlias objAlias = (ExtAlias) objExtType.getAliasList().get(arrIndex);
					strCmdAlias += ", tb_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + " = " + Query.toSQL(objAlias.getValue().trim()) + ", ord_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + " = "
							+ String.valueOf(objAlias.getOrder()) + ", ob_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1) + " = " + (objAlias.isRequested() ? "1" : "0");

					arrIndex++;

					if ("".equals(objAlias.getValue().trim())) {
						// Azzero i valori del campo corrispondente per tutti i
						// contenuti gi inseriti del tipo in esame
						String strCmdExtennsions = "UPDATE cms_34_estensioni SET " + objAliasMD.getSQLColumn(i) + "_" + String.valueOf(j + 1) + " = NULL WHERE id_t_tipo_ext = " + String.valueOf(objExtType.getDBIndex());

						if (logger != null)
							logger.info("fn_UpdateExtensionType::Cmd = " + strCmdExtennsions);

						stmt = conn.createStatement();
						stmt.execute(strCmdExtennsions);
						stmt.close();
					}
				}
			}

			String strCmd = "UPDATE cms_35_tipo_ext SET" + " nome = " + Query.toSQL(objExtType.getName()) + ", descr = " + Query.toSQL(objExtType.getDescription()) + strCmdAlias + " WHERE id_t_tipo_ext = " + objExtType.getDBIndex();

			if (logger != null)
				logger.info("fn_UpdateExtensionType::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.execute(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateExtensionType", e);
			throw e;
		}
	}

	/**
	 * Elimina un tipo di estensione.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param numDBIndex
	 *            ID del tipo di estensione da eliminare.
	 * 
	 * @return TRUE = Tipo eliminato tipo di contenuto
	 * 
	 * @throws Exception
	 */
	static public boolean fn_DeleteExtensionType(Connection conn, int numDBIndex) throws Exception {
		boolean ret = false;

		int numResult = 0;

		try {
			// String strQuery =
			// "SELECT Count(n13_pag_oid) AS totItems FROM t13_pagina_tipi_contenuto"
			// + " WHERE n13_tic_oid = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			// ResultSet rs = stmt.executeQuery(strQuery);

			// if(rs.next())
			// {
			// numResult = rs.getInt("totItems");
			// }
			// stmt.close();
			// rs.close();

			if (numResult == 0) {
				String strCmd = "DELETE FROM cms_35_tipo_ext WHERE id_t_tipo_ext = " + String.valueOf(numDBIndex);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				ret = true;
			}
		} catch (Exception e) {
			throw e;
		}

		return ret;
	}
}
