/*
 * Created on 14-apr-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.DateUtil;
import it.softecspa.jwebber.common.classes.ExtAliasMetadata;
import it.softecspa.jwebber.common.classes.Extension;
import it.softecspa.jwebber.common.classes.ExtensionType;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il reperimento e il salvataggio a DB dei dati relativi
 * ai Contentuti (dinamici).
 */
public class Extension_mgr {

	private static String vista_estensioni = "SELECT T11.*, T10.NOME AS V_EXT_NOME, ".toLowerCase() + "FROM cms_34_estensioni AS T11, cms_35_tipo_ext AS T10 ".toLowerCase() + "WHERE T10.ID_T_TIPO_EXT=T11.ID_T_TIPO_EXT".toLowerCase();

	@SuppressWarnings("unused")
	private static String vista_estensioni_ext = "SELECT T11.*, T10.NOME AS V_EXT_NOME, ".toLowerCase() + "T10.DESCR AS V_EXT_DESCR, T10.TB_TESTO1 AS V_EXT_TESTO1, ".toLowerCase()
			+ "T10.TB_TESTO2 AS V_EXT_TESTO2, T10.TB_TESTO3 AS V_EXT_TESTO3, ".toLowerCase() + "T10.TB_TESTO4 AS V_EXT_TESTO4, T10.TB_TESTO5 AS V_EXT_TESTO5, ".toLowerCase()
			+ "T10.TB_TESTO6 AS V_EXT_TESTO6, T10.TB_TESTO7 AS V_EXT_TESTO7, ".toLowerCase() + "T10.TB_TESTO8 AS V_EXT_TESTO8, T10.TB_TESTO9 AS V_EXT_TESTO9, ".toLowerCase()
			+ "T10.TB_TESTO10 AS V_EXT_TESTO10, T10.TB_FLOAT1 AS v11_tic_float1, ".toLowerCase() + "T10.TB_FLOAT2 AS V_EXT_FLOAT2, T10.TB_FLOAT3 AS V_EXT_FLOAT3, ".toLowerCase()
			+ "T10.TB_FLOAT4 AS V_EXT_FLOAT4, T10.TB_FLOAT5 AS V_EXT_FLOAT5, ".toLowerCase() + "T10.TB_INTERO1 AS v11_tic_intero1, T10.TB_INTERO2 AS V_EXT_INTERO2, ".toLowerCase()
			+ "T10.TB_INTERO3 AS v11_tic_intero3, T10.TB_INTERO4 AS V_EXT_INTERO4, ".toLowerCase() + "T10.TB_INTERO5 AS v11_tic_intero5, T10.TB_LINK1 AS T_EXT_LINK1, ".toLowerCase()
			+ "T10.TB_LINK2 AS T_EXT_LINK2, T10.TB_LINK3 AS T_EXT_LINK3, ".toLowerCase() + "T10.TB_LINK4 AS T_EXT_LINK4, T10.TB_LINK5 AS T_EXT_LINK5, ".toLowerCase() + "T10.TB_IMAGE1 AS V_EXT_IMAGE1, T10.TB_IMAGE2 AS V_EXT_IMAGE2, ".toLowerCase()
			+ "T10.TB_IMAGE3 AS V_EXT_IMAGE3, T10.TB_IMAGE4 AS V_EXT_IMAGE4, ".toLowerCase() + "T10.TB_IMAGE5 AS V_EXT_IMAGE5, T10.TB_IMAGE6 AS V_EXT_IMAGE6, ".toLowerCase()
			+ "T10.TB_IMAGE7 AS V_EXT_IMAGE7, T10.TB_IMAGE8 AS V_EXT_IMAGE8, ".toLowerCase() + "T10.TB_IMAGE9 AS V_EXT_IMAGE9, T10.TB_IMAGE10 AS V_EXT_IMAGE10, ".toLowerCase() + "T10.TB_DATA1 AS V_EXT_DATA1, ".toLowerCase()
			+ "T10.TB_DATA2 AS V_EXT_DATA2, T10.TB_DATA3 AS V_EXT_DATA3, ".toLowerCase() + "T10.TB_DATA4 AS V_EXT_DATA4, T10.TB_DATA5 AS V_EXT_DATA5, ".toLowerCase()
			+ "T10.TB_ATTACH1 AS V_EXT_ATTACH1, T10.TB_ATTACH2 AS V_EXT_ATTACH2, ".toLowerCase() + "T10.TB_ATTACH3 AS V_EXT_ATTACH3, T10.TB_ATTACH4 AS V_EXT_ATTACH4, ".toLowerCase()
			+ "T10.TB_ATTACH5 AS V_EXT_ATTACH5, T10.TB_ATTACH6 AS V_EXT_ATTACH6, ".toLowerCase() + "T10.TB_ATTACH7 AS V_EXT_ATTACH7, T10.TB_ATTACH8 AS V_EXT_ATTACH8, ".toLowerCase()
			+ "T10.TB_ATTACH9 AS V_EXT_ATTACH9, T10.TB_ATTACH10 AS V_EXT_ATTACH10, ".toLowerCase() + "T10.TB_SELECTION1 AS V_EXT_SELECTION1, ".toLowerCase()
			+ "T10.TB_SELECTION2 AS V_EXT_SELECTION2, T10.TB_SELECTION3 AS V_EXT_SELECTION3, ".toLowerCase() + "T10.TB_SELECTION4 AS V_EXT_SELECTION4, T10.TB_SELECTION5 AS V_EXT_SELECTION5, ".toLowerCase()
			+ "FROM cms_34_estensioni AS T11, cms_35_tipo_ext AS T10 ".toLowerCase() + "WHERE T10.ID_T_TIPO_EXT=T11.ID_T_TIPO_EXT".toLowerCase();

	/**
	 * Restituisce i dati di un'estensione.
	 * 
	 * @param numBDIndex
	 *            ID dell'estensione.
	 * @param logger
	 *            Il logger (pu essere anche null).
	 * 
	 * @return Un riferimento all'estensione.
	 * 
	 * @throws Exception
	 */
	public static Extension fn_GetExtension(int numBDIndex, Logger logger) throws Exception {
		Extension objExt = null;

		String strQuery = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = vista_estensioni + " AND id_t_estensioni = " + String.valueOf(numBDIndex);

			if (logger != null)
				logger.info("fn_GetContent::Query=" + strQuery);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				objExt = new Extension(numBDIndex, rs.getString("v_ext_testo1"));

				ExtensionType objExtType = ExtType_mgr.fn_GetExtensionType(rs.getInt("id_t_tipo_ext"));

				String[][] arrValues = new String[2][objExtType.getAliasListSize()];

				ExtAliasMetadata objAliasMD = new ExtAliasMetadata();

				int index = 0;
				for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
					for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
						String strColumn = "tb_" + objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);
						String strValue = rs.getString(strColumn);
						if (strValue != null && strValue.length() > 0) {
							strColumn = objAliasMD.getSQLColumn(i) + String.valueOf(j + 1);

							switch (i) {
							case 0:
							case 3:
							case 4:
							case 6:
							case 7:
								// recupero un testo
								arrValues[0][index] = rs.getString(strColumn);
								break;
							case 1:
								// recupero un double
								arrValues[0][index] = String.valueOf(rs.getDouble(strColumn));
								break;
							case 2:
								// recupero un intero
								arrValues[0][index] = String.valueOf(rs.getInt(strColumn));
								break;
							case 5:
								// recupero una data
								arrValues[0][index] = DateUtil.date2String(rs.getTimestamp(strColumn), "dd/MM/yyyy HH:mm:ss");
								break;
							}

							arrValues[1][index] = String.valueOf(i);
							index++;
						} else {
							arrValues[1][index] = null;
							index++;
						}
					}
				}

				objExt.setValueList(arrValues);

				objExt.setExtensionType(objExtType);
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_GetContents", e);
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objExt;
	}

	/**
	 * Recupera dalla Request il valore di un alias dell'estensione contenuto.
	 * Se necessario il valore viene inizializzato.
	 * 
	 * @param strTag
	 *            Nome del parametro della Request.
	 * @param numTypeIndex
	 *            Indice del tipo di alias, necessario per la inizializzazione
	 *            del valore.
	 * 
	 * @return Una stringa contenente il valore dell'alias.
	 */
	static public String fn_GetAliasValueFromRequest(String strTag, int numTypeIndex) {
		String retStr = strTag != null ? strTag : "";

		switch (numTypeIndex) {
		case 1:
		case 2:
			// numeri float e int
			if (strTag == null || strTag.length() == 0) {
				retStr = "0";
			}
			break;
		case 3:
			// link
			if (strTag == null || strTag.length() == 0) {
				retStr = "http://";
			}
			break;
		}

		return retStr;
	}

	/**
	 * Recupera il valore di un alias dall'estensione. Se necessario il valore
	 * viene inizializzato.
	 * 
	 * @param objExt
	 *            Estensione da utilizzare.
	 * @param numIndex
	 *            Indice dell'alias da recuperare.
	 * 
	 * @return Una stringa contenente il valore dell'alias.
	 */
	static public String fn_GetAliasValueFromContent(Extension objExt, int numIndex) {
		String str = objExt.getValue(numIndex);

		switch (objExt.getExtensionType().getAlias(numIndex).getTypeIndex()) {
		case 1:
		case 2:
			// float e interi
			if (str == null || str.length() == 0)
				str = "0";
			break;
		case 3:
			// link
			if (str == null || str.length() == 0)
				str = "http://";
			break;
		}

		return str;
	}

	/**
	 * Crea una nuova estensione.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param objExt
	 *            L'oggetto con i dati della nuova estensione.
	 * @param logger
	 *            Il logger (pu essere null)
	 * 
	 * @return L'ID della nuova estensione creata.
	 * 
	 * @throws Exception
	 */
	static public int fn_CreateContent(Connection conn, Extension objExt, Logger logger) throws Exception {
		int new_id = 0;

		try {
			ExtAliasMetadata objAliasMD = new ExtAliasMetadata();
			objAliasMD.clearCounts();

			String strColumns = "";
			String strValues = "";

			for (int i = 0; i < objExt.getValueListSize(); i++) {
				String strValue = objExt.getValue(i);
				int numType = objExt.getExtensionType().getAlias(i).getTypeIndex();
				if (numType == -1)
					continue;

				objAliasMD.incrementCount(numType);

				strColumns = strColumns + ", " + objAliasMD.getSQLColumn(numType) + String.valueOf(objAliasMD.getCount(numType));

				switch (numType) {
				case 0:
				case 3:
				case 4:
				case 6:
				case 7:
					strValues += ", " + Query.toSQL(strValue);
					break;
				case 1:
				case 2:
					// float e int
					strValues += ", " + ("".equals(strValue.trim()) ? "NULL" : strValue);
					break;
				case 5:
					// data
					String data = "NULL";
					if (strValue != null && !"".equals(strValue))
						data = DateUtil.date2String(DateUtil.string2Date(strValue, "dd/MM/yyyy HH:mm:ss"));
					strValues += ", '" + data + "'";
				}
			}

			// inserisco il nuovo contenuto
			String strCmd = "INSERT INTO cms_34_estensioni (id_t_tipo_ext" + strColumns + ") VALUES (" + String.valueOf(objExt.getExtTypeDBIndex()) + strValues + ")";

			if (logger != null)
				logger.info("fn_CreateContent::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// recupero l'ID del contenuto appena inserito
			String strQuery = "SELECT MAX(id_t_estensioni) AS idMax FROM cms_34_estensioni";

			logger.info("fn_CreateContent::Query = " + strQuery);

			stmt = conn.createStatement();
			stmt.executeQuery(strQuery);
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				new_id = rs.getInt("idMax");
			}

			rs.close();
			stmt.close();

			conn.commit();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateContents", e);
			throw e;
		}

		return new_id;
	}

	/**
	 * Aggiorna i dati di un'estensione.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param objCnt
	 *            Oggetto con i dati dell'estensione da aggiornare.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	static public void fn_UpdateContent(Connection conn, Extension objExt, Logger logger) throws Exception {
		try {
			ExtAliasMetadata objAliasMD = new ExtAliasMetadata();
			objAliasMD.clearCounts();

			String strColumns = "";

			ExtensionType objExtType = objExt.getExtensionType();

			for (int i = 0; i < objExt.getValueListSize(); i++) {
				if ("".equals(objExtType.getAlias(i).getValue()))
					continue;

				String strValue = objExt.getValue(i);

				int numType = objExt.getExtensionType().getAlias(i).getTypeIndex();

				objAliasMD.incrementCount(numType);

				if (i > 0)
					strColumns += ", ";

				strColumns += objAliasMD.getSQLColumn(numType) + String.valueOf(objAliasMD.getCount(numType));

				switch (numType) {
				case 0:
				case 3:
				case 4:
				case 6:
				case 7:
					// sono tutte stringhe
					strColumns += "= " + Query.toSQL(strValue);
					break;
				case 1:
				case 2:
					// double e int
					strColumns += "= " + strValue;
					break;
				case 5:
					// data
					String data = "NULL";
					if (strValue != null && !"".equals(strValue))
						data = "'" + DateUtil.date2String(DateUtil.string2Date(strValue, "dd/MM/yyyy HH:mm:ss")) + "'";
					strColumns += " = " + data + "";
					break;
				}
			}

			// Aggiorno la tabella delle estensioni
			String strCmd = "UPDATE cms_34_estensioni SET " + strColumns + " WHERE id_t_estensioni = " + String.valueOf(objExt.getDBIndex());

			if (logger != null)
				logger.info("fn_UpdateExtension::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateExtension", e);
			throw e;
		}
	}

	/**
	 * Elimina un'estensione.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param numDBIndex
	 *            ID dell'estensione da eliminare.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	static public void fn_DeleteExtension(Connection conn, int numDBIndex, Logger logger) throws Exception {
		try {
			// String strCmd =
			// "UPDATE t12_contenuti_metadata SET d12_cmd_deleted = CURRENT_TIMESTAMP"
			// + " WHERE n12_cnt_oid = " + String.valueOf(numDBIndex);

			// if(logger != null)
			// logger.info("fn_DeleteContent::Cmd = " + strCmd);

			// Statement stmt = conn.createStatement();
			// stmt.executeUpdate(strCmd);
			// stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateContents", e);
			throw e;
		}
	}
}
