/*
 * Created on 18-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.common.classes.Policy;
import it.softecspa.jwebber.common.classes.ProfiloUtente;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per la gestione dei profili utente.
 */
public class Group_mgr {
	/**
	 * Recupera tutti i profili definiti sul DB
	 * 
	 * @return Il vettore contenente gli id dei profili
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetProfili() throws Exception {
		Vector arrGroup = new Vector();

		String strQuery = "";
		Connection conn = null;

		try {
			// arrGroup.add(CMSConstants.PROFILO_ANONIMO);

			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo FROM cms_30_profilo ORDER BY id_profilo";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				arrGroup.add(rs.getString("id_profilo"));
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrGroup;
	}

	/**
	 * Recupera tutti i profili definiti sul DB
	 * 
	 * @return Il vettore contenente gli i profili (oggetti di classe Profilo).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetProfiliObj() throws Exception {
		Vector arrGroup = new Vector();

		String strQuery = "";
		Connection conn = null;

		try {
			// arrGroup.add(new ProfiloUtente(CMSConstants.PROFILO_ANONIMO,
			// "Utente anonimo"));

			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo, denominazione FROM cms_30_profilo ORDER BY id_profilo";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				ProfiloUtente objProfilo = new ProfiloUtente(rs.getString("id_profilo"), rs.getString("denominazione"));
				arrGroup.add(objProfilo);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrGroup;
	}

	/**
	 * Recupera i dati di un profilo
	 * 
	 * @param id_profilo
	 *            L'ID del profilo.
	 * 
	 * @return L'oggetto contenente i dati del profilo.
	 * 
	 * @throws Exception
	 */
	public static ProfiloUtente fn_GetProfilo(String id_profilo) throws Exception {
		ProfiloUtente objProfile = null;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo, denominazione FROM cms_30_profilo" + " WHERE id_profilo = " + Query.toSQL(id_profilo);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				objProfile = new ProfiloUtente(rs.getString("id_profilo"), rs.getString("denominazione"));
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objProfile;
	}

	/**
	 * Recupera tutti le policies definiti sul DB
	 * 
	 * @return Il vettore contenente gli id delle policies
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetPolicies() throws Exception {
		Vector vecPolicies = new Vector();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT policy, descr FROM cms_31_policies ORDER BY policy";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				Policy p = new Policy(rs.getString("policy"), rs.getString("descr"));
				vecPolicies.add(p);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return vecPolicies;
	}

	public static Policy fn_GetPolicy(String policy) throws Exception {
		Policy p = null;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT policy, descr FROM cms_31_policies WHERE policy = '" + policy + "' AND is_admin = 0 ORDER BY policy";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				p = new Policy(rs.getString("policy"), rs.getString("descr"));
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return p;
	}

	public static void fn_CreatePolicy(Connection conn, String policy, String description, Logger logger) throws Exception {
		try {
			String strCmd = "INSERT INTO cms_31_policies (policy, descr, is_admin) " + "VALUES ('" + policy + "', '" + description + "', 0)";

			if (logger != null)
				logger.info("fn_CreatePolicy::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreatePolicy", e);
			throw e;
		}
	}

	public static void fn_UpdatePolicy(Connection conn, String policy, String newPolicy, String description, Logger logger) throws Exception {
		try {
			String strCmd = "UPDATE cms_31_policies SET policy = '" + newPolicy + "', descr = '" + description + "' WHERE policy = '" + policy + "'";

			if (logger != null)
				logger.info("fn_UpdatePolicy::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdatePolicy", e);
			throw e;
		}
	}

	public static void fn_DeletePolicy(Connection conn, String policy, Logger logger) throws Exception {
		try {
			String strCmd = "DELETE FROM cms_31_policies WHERE policy = '" + policy + "'";

			if (logger != null)
				logger.info("fn_DeletePolicy::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// cancellazione profili associati alla policy cancellata
			strCmd = "DELETE FROM cms_32_prof_policy WHERE id_policy = '" + policy + "'";

			if (logger != null)
				logger.info("fn_DeletePolicy::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_DeletePolicy", e);
			throw e;
		}
	}

	/**
	 * Recupera lo stato di visibilit di tutti i proflili per il canale
	 * specificato
	 * 
	 * @param cha_oid
	 *            l'ID del canale
	 * @return Hashtable con le associazioni tra profili e visibilit
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Hashtable fn_GetProfiliCanaleView(int cha_oid) throws Exception {
		Hashtable profili = new Hashtable();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo, n01_cha_visible FROM cms_01_profilo_canali WHERE n01_cha_oid=" + String.valueOf(cha_oid) + " ORDER BY id_profilo";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				String profilo = rs.getString("id_profilo");
				String visible = (rs.getInt("n01_cha_visible") == 1) ? "true" : "false";

				profili.put(profilo, visible);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return profili;
	}

	/**
	 * Recupera lo stato di editabilit di tutti i proflili per il canale
	 * specificato
	 * 
	 * @param cha_oid
	 *            l'ID del canale
	 * @return Hashtable con le associazioni tra profili e visibilit
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Hashtable fn_GetProfiliCanaleEdit(int cha_oid) throws Exception {
		Hashtable profili = new Hashtable();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo, n01_cha_editable FROM cms_01_profilo_canali WHERE n01_cha_oid=" + String.valueOf(cha_oid) + " ORDER BY id_profilo";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				String profilo = rs.getString("id_profilo");
				String visible = (rs.getInt("n01_cha_editable") == 1) ? "true" : "false";

				profili.put(profilo, visible);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return profili;
	}

	/**
	 * Recupero le policies associate ad un profilo
	 * 
	 * @param id_profilo
	 *            l'ID del profilo
	 * 
	 * @return Hashtable con le associazioni tra profilo e policies
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Hashtable fn_GetProfilePolicies(String id_profilo) throws Exception {
		Hashtable policies = new Hashtable();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_policy FROM cms_32_prof_policy" + " WHERE id_profilo = " + Query.toSQL(id_profilo);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				String policy = rs.getString("id_policy");

				policies.put(policy, "true");
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return policies;
	}

	/**
	 * Recupero i profili associate ad una policy
	 * 
	 * @param id_policy
	 *            l'ID della policy
	 * 
	 * @return Hashtable con le associazioni tra policies e profilo
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetPoliciesProfile(String id_policy) throws Exception {
		Vector profili = new Vector();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo FROM cms_32_prof_policy" + " WHERE id_policy = " + Query.toSQL(id_policy);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				String profilo = rs.getString("id_profilo");

				profili.add(profilo);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return profili;
	}

	/**
	 * Crea le associazione tra un nuovo canale e i profili a cui  stato
	 * associato
	 * 
	 * @param conn
	 *            La connessione su cui operare
	 * @param cha_oid
	 *            Indice del canale che si  appena creato
	 * @param profiliView
	 *            Hashtable contenente le relazioni del canale con i vari
	 *            profili
	 * @param profiliEdit
	 *            Hashtable contenente le relazioni del canale con i vari
	 *            profili
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_CreateProfiliCanale(Connection conn, int cha_oid, Hashtable profiliView, Hashtable profiliEdit, Logger logger) throws Exception {
		try {
			Enumeration en = profiliView.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String visible = "true".equals((String) profiliView.get(profilo)) ? "1" : "0";
				String editable = "true".equals((String) profiliEdit.get(profilo)) ? "1" : "0";

				String strCmd = "INSERT INTO cms_01_profilo_canali (id_profilo, n01_cha_oid, n01_cha_visible, n01_cha_editable) " + "VALUES ('" + profilo + "', " + String.valueOf(cha_oid) + ", " + visible + ", " + editable + ")";

				if (logger != null)
					logger.info("fn_CreateProfiliCanale::Cmd = " + strCmd);

				Statement stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateProfiliCanale", e);
			throw e;
		}
	}

	/**
	 * Modifica le associazioni per la visibilit tra un canale e i profili
	 * definiti a DB.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param cha_oid
	 *            L'ID del canale.
	 * @param profiliView
	 *            Hashtable contenente le relazioni del canale con i vari
	 *            profili.
	 * @param profiliEdit
	 *            Hashtable contenente le relazioni del canale con i vari
	 *            profili.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_UpdateProfiliCanale(Connection conn, int cha_oid, Hashtable profiliView, Hashtable profiliEdit, Logger logger) throws Exception {
		Statement stmt;
		ResultSet rs;

		String strQuery = "";
		String strCmd = "";

		try {
			Enumeration en = profiliView.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String visible = "true".equals((String) profiliView.get(profilo)) ? "1" : "0";
				String editable = "true".equals((String) profiliEdit.get(profilo)) ? "1" : "0";
				boolean update = false;

				// Controllo se il profilo  gi stato censito
				strQuery = "SELECT id_profilo FROM cms_01_profilo_canali" + " WHERE id_profilo = " + Query.toSQL(profilo) + " AND n01_cha_oid = " + String.valueOf(cha_oid);

				if (logger != null)
					logger.info("fn_UpdateProfiliCanale::Cmd = " + strQuery);

				stmt = conn.createStatement();
				rs = stmt.executeQuery(strQuery);
				if (rs.next()) {
					update = true;
				}
				rs.close();
				stmt.close();

				if (update) {
					strCmd = "UPDATE cms_01_profilo_canali SET n01_cha_visible=" + visible + ", n01_cha_editable=" + editable + " WHERE id_profilo = " + Query.toSQL(profilo) + " AND n01_cha_oid = " + String.valueOf(cha_oid);

					if (logger != null)
						logger.info("fn_UpdateProfiliCanale::Cmd = " + strCmd);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				} else {
					strCmd = "INSERT INTO cms_01_profilo_canali (id_profilo, n01_cha_oid, n01_cha_visible, n01_cha_editable) " + "VALUES (" + Query.toSQL(profilo) + ", " + String.valueOf(cha_oid) + ", " + visible + ", " + editable + ")";

					if (logger != null)
						logger.info("fn_UpdateProfiliCanale::Cmd = " + strCmd);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateProfiliCanale", e);
			throw e;
		}
	}

	/**
	 * Crea le associazioni tra una nuova pagina e i profili a cui  stata
	 * associata
	 * 
	 * @param pag_oid
	 *            Indice della pagina che si  appena creata
	 * @param profiliEdit
	 *            Hashtable contenente le relazioni del canale con i vari
	 *            profili
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_CreateProfiliPagina(Connection conn, int pag_oid, Hashtable profiliEdit, Logger logger) throws Exception {
		try {
			Enumeration en = profiliEdit.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String editable = "true".equals((String) profiliEdit.get(profilo)) ? "1" : "0";

				String strCmd = "INSERT INTO cms_02_profilo_pagine (id_profilo, n02_pag_oid, n02_pag_editable) " + "VALUES (" + Query.toSQL(profilo) + ", " + String.valueOf(pag_oid) + ", " + editable + ")";

				if (logger != null)
					logger.info("fn_CreateProfiliPagina::Cmd = " + strCmd);

				Statement stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}

		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateProfiliPagina", e);
			throw e;
		}
	}

	/**
	 * Modifica le associazioni per l'editabilit tra una pagina e i profili
	 * definiti a DB.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param pag_oid
	 *            L'ID della pagina
	 * @param profiliEdit
	 *            Hashtable contenente le relazioni della pagina con i vari
	 *            profili
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_UpdateProfiliPagina(Connection conn, int pag_oid, Hashtable profiliEdit, Logger logger) throws Exception {
		Statement stmt;
		ResultSet rs;

		String strQuery = "";
		String strCmd = "";

		try {
			Enumeration en = profiliEdit.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String editable = "true".equals((String) profiliEdit.get(profilo)) ? "1" : "0";
				boolean update = false;

				// Controllo se il profilo  gi stato censito
				strQuery = "SELECT id_profilo FROM cms_02_profilo_pagine" + " WHERE id_profilo = " + Query.toSQL(profilo) + " AND n02_pag_oid=" + String.valueOf(pag_oid);

				if (logger != null)
					logger.info("fn_UpdateProfiliPagina::Cmd = " + strQuery);

				stmt = conn.createStatement();
				rs = stmt.executeQuery(strQuery);
				if (rs.next()) {
					update = true;
				}
				rs.close();
				stmt.close();

				if (update) {
					strCmd = "UPDATE cms_02_profilo_pagine SET n02_pag_editable=" + editable + " WHERE id_profilo = " + Query.toSQL(profilo) + " AND n02_pag_oid=" + String.valueOf(pag_oid);

					if (logger != null)
						logger.info("fn_UpdateProfiliPagina::Cmd = " + strCmd);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				} else {
					strCmd = "INSERT INTO cms_02_profilo_pagine (id_profilo, n02_pag_oid, n02_pag_editable) " + "VALUES (" + Query.toSQL(profilo) + ", " + String.valueOf(pag_oid) + ", " + editable + ")";

					if (logger != null)
						logger.info("fn_UpdateProfiliPagina::Cmd = " + strCmd);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateProfiliPagina", e);
			throw e;
		}
	}

	/**
	 * Recupera lo stato di editabilit di tutti i proflili per la pagina
	 * specificata
	 * 
	 * @param pag_oid
	 *            l'ID del canale
	 * @return Hashtable con le associazioni tra profili e editabilit
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Hashtable fn_GetProfiliPaginaEdit(int pag_oid) throws Exception {
		Hashtable profili = new Hashtable();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo, n02_pag_editable FROM cms_02_profilo_pagine WHERE n02_pag_oid=" + String.valueOf(pag_oid) + " ORDER BY id_profilo";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				String profilo = rs.getString("id_profilo");
				String visible = (rs.getInt("n02_pag_editable") == 1) ? "true" : "false";

				profili.put(profilo, visible);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return profili;
	}

	/**
	 * Crea le associazioni tra un tipo contenuto e i profili a cui  stato
	 * associato
	 * 
	 * @param conn
	 *            la connessione su cui si opera
	 * @param ctype_oid
	 *            Indice della pagina che si  appena creata
	 * @param profiliEdit
	 *            Hashtable contenente le relazioni del tipo contenuto con i
	 *            vari profili
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_CreateProfiliTipoContenuto(Connection conn, int ctype_oid, Hashtable profiliEdit, Logger logger) throws Exception {
		try {
			Enumeration en = profiliEdit.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String editable = "true".equals((String) profiliEdit.get(profilo)) ? "1" : "0";

				String strCmd = "INSERT INTO cms_03_profilo_tipi_contenuto (id_profilo, n03_tic_oid, n03_tic_editable) " + "VALUES (" + Query.toSQL(profilo) + ", " + String.valueOf(ctype_oid) + ", " + editable + ")";

				Statement stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * Modifica le associazioni per l'editabilit tra un tipo contenuto e i
	 * profili definiti a DB.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param ctype_oid
	 *            Indice della pagina.
	 * @param profiliEdit
	 *            Hashtable contenente le relazioni della pagina con i vari
	 *            profili.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_UpdateProfiliTipoContenuto(Connection conn, int ctype_oid, Hashtable profiliEdit, Logger logger) throws Exception {
		Statement stmt;
		ResultSet rs;

		String strQuery = "";
		String strCmd = "";

		try {
			Enumeration en = profiliEdit.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String editable = "true".equals((String) profiliEdit.get(profilo)) ? "1" : "0";
				boolean update = false;

				// Controllo se il profilo  gi stato censito
				strQuery = "SELECT id_profilo FROM cms_03_profilo_tipi_contenuto WHERE id_profilo='" + profilo + "'" + " AND n03_tic_oid=" + String.valueOf(ctype_oid);

				stmt = conn.createStatement();
				rs = stmt.executeQuery(strQuery);
				if (rs.next()) {
					update = true;
				}
				rs.close();
				stmt.close();

				if (update) {
					strCmd = "UPDATE cms_03_profilo_tipi_contenuto SET n03_tic_editable=" + editable + " WHERE id_profilo=" + Query.toSQL(profilo) + " AND n03_tic_oid=" + String.valueOf(ctype_oid);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				} else {
					strCmd = "INSERT INTO cms_03_profilo_tipi_contenuto (id_profilo, n03_tic_oid, n03_tic_editable) " + "VALUES (" + Query.toSQL(profilo) + ", " + String.valueOf(ctype_oid) + ", " + editable + ")";

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * Recupera lo stato di editabilit di tutti i proflili per il tipo
	 * contenuto specificato
	 * 
	 * @param ctype_oid
	 *            l'ID del canale
	 * @return Hashtable con le associazioni tra profili e editabilit
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Hashtable fn_GetProfiliTipoContenutoEdit(int ctype_oid) throws Exception {
		Hashtable profili = new Hashtable();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo, n03_tic_editable FROM cms_03_profilo_tipi_contenuto WHERE n03_tic_oid=" + String.valueOf(ctype_oid) + " ORDER BY id_profilo";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				String profilo = rs.getString("id_profilo");
				String visible = (rs.getInt("n03_tic_editable") == 1) ? "true" : "false";

				profili.put(profilo, visible);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return profili;
	}

	/**
	 * Crea le associazioni tra un profilo e le policies a cui  stato associato
	 * 
	 * @param conn
	 *            la connessione su cui si opera
	 * 
	 * @param id_profilo
	 *            L'ID del profilo
	 * 
	 * @param policies
	 *            Hashtable contenente le relazioni tra profilo e policies
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_CreatePoliciesProfile(Connection conn, String id_profilo, Hashtable policies, Logger logger) throws Exception {
		try {
			Enumeration en = policies.keys();
			while (en.hasMoreElements()) {
				String policy = (String) en.nextElement();
				if ("true".equals((String) policies.get(policy))) {
					String strCmd = "INSERT INTO cms_32_prof_policy (id_profilo, id_policy) " + "VALUES ('" + id_profilo + "', '" + policy + "')";

					Statement stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * Modifica le associazioni per l'editabilit tra un profilo e le policies
	 * ad esso associate.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * 
	 * @param id_profilo
	 *            L'ID del profilo.
	 * 
	 * @param policies
	 *            Hashtable contenente le relazioni tra il profilo e le policies
	 *            associate.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_UpdatePoliciesProfile(Connection conn, String id_profilo, Hashtable policies, Logger logger) throws Exception {
		Statement stmt;
		ResultSet rs;

		String strQuery = "";
		String strCmd = "";

		try {
			Enumeration en = policies.keys();
			while (en.hasMoreElements()) {
				String policy = (String) en.nextElement();
				if ("true".equals((String) policies.get(policy))) {
					boolean insert = false;

					// Controllo se la policy  gi stata censita
					strQuery = "SELECT id_policy FROM cms_32_prof_policy WHERE id_policy=" + Query.toSQL(policy) + " AND id_profilo='" + id_profilo + "'";

					stmt = conn.createStatement();
					rs = stmt.executeQuery(strQuery);
					if (!rs.next()) {
						insert = true;
					}
					rs.close();
					stmt.close();

					if (insert) {
						strCmd = "INSERT INTO cms_32_prof_policy (id_profilo, id_policy) " + "VALUES ('" + id_profilo + "', " + Query.toSQL(policy) + ")";

						stmt = conn.createStatement();
						stmt.executeUpdate(strCmd);
						stmt.close();
					}
				} else {
					// Cancello l'associazione
					strCmd = "DELETE FROM cms_32_prof_policy WHERE id_profilo='" + id_profilo + "' AND id_policy='" + policy + "'";

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * Crea le associazioni tra un contenuto e i profili a cui  stato associato
	 * 
	 * @param conn
	 *            la connessione su cui si opera
	 * @param cnt_oid
	 *            ID del contentup
	 * @param profiliView
	 *            Hashtable contenente le relazioni tipo contenuto con i profili
	 *            che ne hanno visibilit
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_CreateProfiliContenuto(Connection conn, int cnt_oid, Hashtable profiliView, Logger logger) throws Exception {
		try {
			Enumeration en = profiliView.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String visible = "true".equals((String) profiliView.get(profilo)) ? "1" : "0";

				String strCmd = "INSERT INTO cms_14_profilo_contenuti (id_profilo, n14_cnt_oid, n14_cnt_visible) " + "VALUES (" + Query.toSQL(profilo) + ", " + String.valueOf(cnt_oid) + ", " + visible + ")";

				if (logger != null)
					logger.info("fn_CreateProfiliContenuto::Cmd = " + strCmd);

				Statement stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateProfiliContenuto", e);
			throw e;
		}
	}

	/**
	 * Modifica le associazioni per l'editabilit tra un tipo contenuto e i
	 * profili definiti a DB.
	 * 
	 * @param conn
	 *            La connessione su cui si opera.
	 * @param cnt_oid
	 *            ID del contenuto.
	 * @param profiliView
	 *            Hashtable contenente le relazioni del contenuto con i vari
	 *            profili abilitati a visualizzarlo.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_UpdateProfiliContenuto(Connection conn, int cnt_oid, Hashtable profiliView, Logger logger) throws Exception {
		Statement stmt;
		ResultSet rs;

		String strQuery = "";
		String strCmd = "";

		try {
			Enumeration en = profiliView.keys();
			while (en.hasMoreElements()) {
				String profilo = (String) en.nextElement();
				String visible = "true".equals((String) profiliView.get(profilo)) ? "1" : "0";
				boolean update = false;

				// Controllo se il profilo  gi stato censito
				strQuery = "SELECT id_profilo FROM cms_14_profilo_contenuti WHERE id_profilo=" + Query.toSQL(profilo) + " AND n14_cnt_oid=" + String.valueOf(cnt_oid);

				if (logger != null)
					logger.info("fn_CreateUpdateContenuto::Cmd = " + strQuery);

				stmt = conn.createStatement();
				rs = stmt.executeQuery(strQuery);
				if (rs.next()) {
					update = true;
				}
				rs.close();
				stmt.close();

				if (update) {
					strCmd = "UPDATE cms_14_profilo_contenuti SET n14_cnt_visible=" + visible + " WHERE id_profilo=" + Query.toSQL(profilo) + " AND n14_cnt_oid=" + String.valueOf(cnt_oid);

					if (logger != null)
						logger.info("fn_UpdateProfiliContenuto::Cmd = " + strCmd);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				} else {
					strCmd = "INSERT INTO cms_14_profilo_contenuti (id_profilo, n14_cnt_oid, n14_cnt_visible) " + "VALUES (" + Query.toSQL(profilo) + ", " + String.valueOf(cnt_oid) + ", " + visible + ")";

					if (logger != null)
						logger.info("fn_CreateUpdateContenuto::Cmd = " + strCmd);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateProfiliContenuto", e);
			throw e;
		}
	}

	/**
	 * Recupera lo stato di visibilit di tutti i proflili per il contenuto
	 * specificato
	 * 
	 * @param cnt_oid
	 *            ID del contenuto
	 * @return Hashtable con le associazioni tra profili e visibilit
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Hashtable fn_GetProfiliContenutoView(int cnt_oid) throws Exception {
		Hashtable profili = new Hashtable();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo, n14_cnt_visible FROM cms_14_profilo_contenuti WHERE n14_cnt_oid=" + String.valueOf(cnt_oid) + " ORDER BY id_profilo";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				String profilo = rs.getString("id_profilo");
				String visible = (rs.getInt("n14_cnt_visible") == 1) ? "true" : "false";

				profili.put(profilo, visible);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return profili;
	}

	/**
	 * Controlla se un dato profilo esiste gi.
	 * 
	 * @param id_profilo
	 *            L'ID del profilo
	 * 
	 * @return Hashtable TRUE Se il profilo esiste, FALSE in caso contrario
	 * 
	 * @throws Exception
	 */
	public static boolean fn_ExistsProfile(String id_profilo) throws Exception {
		String strQuery = "";
		Connection conn = null;
		boolean ret = false;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT id_profilo FROM cms_30_profilo WHERE id_profilo=" + Query.toSQL(id_profilo);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = true;
			}
		} catch (Exception e) {
			ret = false;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Crea un nuovo profilo.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objProfile
	 *            L'oggetto contenente i dati del profilo.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @return L'ID del nuovo profilo.
	 * 
	 * @throws Exception
	 */
	public static String fn_CreateProfile(Connection conn, ProfiloUtente objProfile, Logger logger) throws Exception {
		try {
			String strCmd = "INSERT INTO cms_30_profilo (id_profilo, denominazione)" + " VALUES (" + Query.toSQL(objProfile.getIdProfilo()) + ", " + Query.toSQL(objProfile.getDescr()) + ")";

			if (logger != null)
				logger.info("fn_CreateProfile::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateProfile", e);
			throw e;
		}

		return objProfile.getIdProfilo();
	}

	/**
	 * Modifica i dati di un profilo.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objProfile
	 *            L'oggetto contenente i dati del profilo.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	public static void fn_UpdateProfile(Connection conn, ProfiloUtente objProfile, Logger logger) throws Exception {
		try {
			String strCmd = "UPDATE cms_30_profilo SET denominazione=" + Query.toSQL(objProfile.getDescr()) + " WHERE id_profilo=" + Query.toSQL(objProfile.getIdProfilo());

			if (logger != null)
				logger.info("fn_UpdateProfile::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateProfile", e);
			throw e;
		}
	}

	/**
	 * Elimina un profilo.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objProfile
	 *            L'oggetto contenente i dati del profilo.
	 * @param logger
	 *            Il logger.
	 * 
	 * @return TRUE = Tipo eliminato, se FALSE esistono utenti associati al
	 *         profilo
	 * 
	 * @throws Exception
	 */
	static public boolean fn_DeleteProfile(Connection conn, ProfiloUtente objProfile, Logger logger) throws Exception {
		boolean ret = false;

		int numResult = 0;

		try {
			String strQuery = "SELECT Count(userid) AS totItems FROM cms_33_utente" + " WHERE id_profilo = '" + objProfile.getIdProfilo() + "'";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				numResult = rs.getInt("totItems");
			}
			stmt.close();
			rs.close();

			if (numResult == 0) {
				// Cancello le associazioni con le policies
				String strCmd = "DELETE FROM cms_32_prof_policy WHERE id_profilo = " + Query.toSQL(objProfile.getIdProfilo());

				if (logger != null)
					logger.info("fn_DeleteProfile::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				// Cancello le associazioni con i canali
				strCmd = "DELETE FROM cms_01_profilo_canali WHERE id_profilo = " + Query.toSQL(objProfile.getIdProfilo());

				if (logger != null)
					logger.info("fn_DeleteProfile::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				// Cancello le associazioni con le pagine
				strCmd = "DELETE FROM cms_02_profilo_pagine WHERE id_profilo = " + Query.toSQL(objProfile.getIdProfilo());

				if (logger != null)
					logger.info("fn_DeleteProfile::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				// Cancello le associazioni con i tipi contenuto
				strCmd = "DELETE FROM cms_03_profilo_tipi_contenuto WHERE id_profilo = " + Query.toSQL(objProfile.getIdProfilo());

				if (logger != null)
					logger.info("fn_DeleteProfile::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				// Cancello le associazioni con i contenuti
				strCmd = "DELETE FROM cms_14_profilo_contenuti WHERE id_profilo = " + Query.toSQL(objProfile.getIdProfilo());

				if (logger != null)
					logger.info("fn_DeleteProfile::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				// Cancello il profilo
				strCmd = "DELETE FROM cms_30_profilo WHERE id_profilo = " + Query.toSQL(objProfile.getIdProfilo());

				if (logger != null)
					logger.info("fn_DeleteProfile::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				ret = true;
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateProfile", e);
			throw e;
		}

		return ret;
	}
}
