/*
 * Created on 2-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.common.classes.Page;
import it.softecspa.jwebber.common.classes.TPAlias;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il recupero e il salvataggio a DB dei dati relativi
 * alle pagine.
 */
public class Page_mgr {
	/**
	 * 
	 * @param oid_pag
	 * @param id_profilo
	 * @return
	 * @throws Exception
	 */
	static public int getPageChannelID(String oid_pag, String id_profilo) throws Exception {
		int ret = 0;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			if ("".equals(id_profilo)) {
				strQuery = "SELECT n09_cha_oid" +
						    " FROM cms_09_canali" +
						   " WHERE cms_09_canali.n09_pag_oid = " + oid_pag;
			} else {
				strQuery = "SELECT n09_cha_oid" +
						    " FROM cms_09_canali, cms_01_profilo_canali" +
						   " WHERE cms_01_profilo_canali.n01_cha_oid = cms_09_canali.n09_cha_oid" +
						     " AND cms_09_canali.n09_pag_oid = " + oid_pag + 
						     " AND id_profilo = " + Query.toSQL(id_profilo) + 
						     " AND n01_cha_visible = 1";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = rs.getInt("n09_cha_oid");
			}
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Controlla se una certa pagina  modificabile da un certo profilo utente.
	 * 
	 * @param oid_pag
	 *            L'ID della pagina.
	 * @param id_profilo
	 *            L'ID del profilo.
	 * 
	 * @return TRUE se si dispone dell'autorizzazione.
	 * 
	 * @throws Exception
	 *             Se si verifica un errore di accesso a DB.
	 */
	static public boolean canEditPage(String oid_pag, String id_profilo) throws Exception {
		boolean ret = false;

		String strQuery = "";
		Connection conn = null;

		try {
			int channelId = Page_mgr.getPageChannelID(oid_pag, id_profilo);
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT n01_cha_oid FROM cms_01_profilo_canali WHERE n01_cha_oid=" + channelId + " AND id_profilo=" + Query.toSQL(id_profilo) + " AND n01_cha_editable=1";

			/*
			 * strQuery =
			 * "SELECT n02_pag_oid FROM cms_02_profilo_pagine WHERE n02_pag_oid="
			 * + oid_pag + " AND ID_PROFILO='" + Query.toSQL(id_profilo) +
			 * "' AND n02_pag_editable=1";
			 */

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = true;
			}
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Restituisce l'elenco di tutte le pagine editabili da un certo profilo.
	 * 
	 * @param numDNIndex
	 *            ID della pagina da scartare (0 = nessuno scarto).
	 * @param id_profilo
	 *            ID del profilo o la stringa vuota se si vogliono tutte le
	 *            pagine.
	 * 
	 * @return Un riferimento all'array che conterr le pagine (oggetti di
	 *         classe 'Page').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetPages(int numDNIndex, String id_profilo) throws Exception {
		String strQuery = "";
		Vector arrPages = new Vector();

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			if ("".equals(id_profilo)) {
				strQuery = "SELECT n07_pag_oid, v07_pag_nome, v07_pag_descr, v07_tmp_ref, n07_pag_mod_oid, n07_pag_istmp" + " FROM cms_07_pagine WHERE n07_pag_istmp=0 or (n07_pag_mod_oid=-1 and n07_pag_istmp=1)";
				if (numDNIndex > 0) {
					strQuery += " AND n07_pag_oid NOT IN (" + String.valueOf(numDNIndex) + ")";
				}
				strQuery += " ORDER BY v07_pag_nome ASC";
			} else {
				strQuery = "SELECT n07_pag_oid, v07_pag_nome, v07_pag_descr, v07_tmp_ref, n07_pag_mod_oid, n07_pag_istmp FROM cms_07_pagine, cms_02_profilo_pagine "
						+ "WHERE cms_07_pagine.n07_pag_oid=cms_02_profilo_pagine.n02_pag_oid AND cms_02_profilo_pagine.id_profilo=" + Query.toSQL(id_profilo)
						+ " AND cms_02_profilo_pagine.n02_pag_editable=1 AND (cms_07_pagine.n07_pag_istmp=0 or (cms_07_pagine.n07_pag_mod_oid=-1 and cms_07_pagine.n07_pag_istmp=1))";

				if (numDNIndex > 0) {
					strQuery += " AND n07_pag_oid NOT IN (" + String.valueOf(numDNIndex) + ")";
				}
				strQuery += " ORDER BY v07_pag_nome ASC";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				Page objPage = new Page(rs.getInt("n07_pag_oid"), rs.getString("v07_pag_nome"), rs.getString("v07_pag_descr"), rs.getString("v07_tmp_ref"), rs.getInt("n07_pag_mod_oid"));
				objPage.setTmp(rs.getInt("n07_pag_istmp") == 1);
				arrPages.add(objPage);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrPages;
	}

	/**
	 * Restituisce i dati di una pagina.
	 * 
	 * @param numDBIndex
	 *            L'ID della pagina.
	 * 
	 * @return Un riferimento all'oggetto che conterr la pagina (oggetto di
	 *         classe 'Page').
	 * 
	 * @throws Exception
	 */
	static public Page fn_GetPage(int numDBIndex) throws Exception {
		String strQuery = "";
		Page objPage = null;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();
			strQuery = "SELECT v07_pag_nome, v07_pag_descr, v07_tmp_ref, n07_tic_oid, n07_pag_mod_oid, n07_pag_istmp FROM cms_07_pagine" + " WHERE n07_pag_oid = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				objPage = new Page(numDBIndex, rs.getString("v07_pag_nome"), rs.getString("v07_pag_descr"), rs.getString("v07_tmp_ref"), rs.getInt("n07_pag_mod_oid"));
				objPage.setTmp(rs.getInt("n07_pag_istmp") == 1);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objPage;
	}

	/**
	 * Restituisce i dati di una pagina, compreso il vettore contenente gli
	 * alias ad essa associati.
	 * 
	 * @param numDBIndex
	 *            ID della pagina.
	 * 
	 * @return Un riferimento all'oggetto che conterr la pagina (oggetto di
	 *         'Page').
	 * 
	 * @throws Exception
	 */
	public static Page fn_GetPageWithAlias(int numDBIndex) throws Exception {
		Page objPage = null;
		TPAlias objAlias = null;

		Connection conn = null;
		try {
			conn = DatabaseManager.getInstance().getConnection();
			String strQuery = "SELECT cms_07_pagine.n07_pag_oid AS n07_pag_oid, cms_07_pagine.v07_pag_nome AS v07_pag_nome, " + "cms_07_pagine.v07_pag_descr AS v07_pag_descr, cms_07_pagine.v07_tmp_ref AS v07_tmp_ref, "
					+ "cms_07_pagine.n07_tic_oid AS n07_tic_oid, cms_07_pagine.n07_pag_mod_oid AS n07_pag_mod_oid, " + "cms_07_pagine.n07_pag_istmp AS n07_pag_istmp, cms_05_template_alias.n05_tal_oid AS n07_pal_oid, "
					+ "cms_05_template_alias.v05_tal_alias AS v07_pal_alias, cms_05_template_alias.n05_tal_tipo AS n07_pal_tipo, " + "cms_08_pagine_alias.v08_pal_value AS v07_pal_value "
					+ "FROM cms_07_pagine, cms_05_template_alias, cms_08_pagine_alias " + "WHERE cms_05_template_alias.n05_tal_oid=cms_08_pagine_alias.n08_tal_oid " + "AND cms_07_pagine.n07_pag_oid=cms_08_pagine_alias.n08_pag_oid "
					+ "AND n07_pag_oid = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				if (objPage == null) {
					objPage = new Page(numDBIndex, rs.getString("v07_pag_nome"), rs.getString("v07_pag_descr"), rs.getString("v07_tmp_ref"), rs.getInt("n07_pag_mod_oid"));
					objPage.setTmp(rs.getInt("n07_pag_istmp") == 1);
				}

				objAlias = new TPAlias(rs.getInt("n07_pal_oid"), rs.getString("v07_pal_alias"), rs.getInt("n07_pal_tipo"));
				objAlias.setValue(rs.getString("v07_pal_value"));

				objPage.addAlias(objAlias);
			}

			if (objPage == null)
				objPage = fn_GetPage(numDBIndex);
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objPage;
	}

	/**
	 * Controlla se esiste gi una data pagina. Il controllo viene fatto in base
	 * al nome della pagina.
	 * 
	 * @param strIndexes
	 *            IDs, separati da virgole, delle pagine da scartare ( "" =
	 *            nessuno scarto ).
	 * @param strName
	 *            Nome della pagina da controllare.
	 * 
	 * @return TRUE se la pagina esiste.
	 * 
	 * @throws Exception
	 */
	public static boolean fn_PageExists(String strIndexes, String strName) throws Exception {
		boolean found = false;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT n07_pag_oid FROM cms_07_pagine" + " WHERE v07_pag_nome = " + Query.toSQL(strName);

			if (!"".equals(strIndexes)) {
				strQuery += " AND n07_pag_oid NOT IN (" + strIndexes + ")";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				found = true;
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return found;
	}

	public static int fn_GetPageAntID(int page_id) throws Exception {
		int id = 0;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT n07_pag_oid FROM cms_07_pagine" + " WHERE n07_pag_mod_oid = " + page_id + " AND n07_pag_istmp = 1";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				id = rs.getInt("n07_pag_oid");
			}
		} catch (Exception e) {
			id = 0;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return id;
	}

	/**
	 * Crea una nuova pagina.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objPage
	 *            Nuova pagina.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @return L'ID della nuova pagina appena creata.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static int fn_CreatePage(Connection conn, Page objPage, Logger logger) throws Exception {
		int new_page_id = 0;
		String strCmd = "";
		Statement stmt = null;
		ResultSet rs = null;

		try {
			strCmd = "INSERT INTO cms_07_pagine (v07_pag_nome, v07_pag_descr, v07_tmp_ref, n07_tic_oid, n07_pag_mod_oid, n07_pag_istmp)" + " VALUES (" + Query.toSQL(objPage.getName()) + ", " + Query.toSQL(objPage.getDescription()) + ", "
					+ String.valueOf(objPage.getTemplateRef()) + ", 0, " + String.valueOf(objPage.getOid_pag_mod()) + ", " + (objPage.isTmp() ? "1" : "0") + ")";

			if (logger != null)
				logger.info("fn_CreatePage::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// Recupero l'ID della pagina appena creata
			String strQuery = "SELECT MAX(n07_pag_oid) AS MAX_ID FROM cms_07_pagine";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				new_page_id = rs.getInt("MAX_ID");
			}
			rs.close();
			stmt.close();

			Vector arrAlias = objPage.getAlias();
			for (int i = 0; i < arrAlias.size(); i++) {
				TPAlias objAlias = (TPAlias) arrAlias.get(i);

				strCmd = "INSERT INTO cms_08_pagine_alias (n08_pag_oid, n08_tal_oid, v08_pal_value)" + " VALUES (" + String.valueOf(new_page_id) + ", " + objAlias.getDBIndex() + "," + Query.toSQL(objAlias.getValue()) + ")";

				if (logger != null)
					logger.info("fn_CreatePage::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreatePage", e);
			throw e;
		}

		return new_page_id;
	}

	/**
	 * Aggiorna i dati di una pagina.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objPage
	 *            La pagina da aggiornare.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_UpdatePage(Connection conn, Page objPage, Logger logger) throws Exception {
		String strCmd = "";
		Statement stmt = null;
		try {
			strCmd = "UPDATE cms_07_pagine SET" + " v07_pag_nome = " + Query.toSQL(objPage.getName()) + ", v07_pag_descr = " + Query.toSQL(objPage.getDescription()) + ", v07_tmp_ref = " + Query.toSQL(objPage.getTemplateRef()) + ", n07_tic_oid = 0"
					+ ", n07_pag_mod_oid = " + String.valueOf(objPage.getOid_pag_mod()) + ", n07_pag_istmp = " + (objPage.isTmp() ? "1" : "0") + " WHERE n07_pag_oid = " + String.valueOf(objPage.getDBIndex());

			if (logger != null)
				logger.info("fn_UpdatePage::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// Elimino le vecchie associazioni con gli alias
			strCmd = "DELETE FROM cms_08_pagine_alias WHERE n08_pag_oid = " + String.valueOf(objPage.getDBIndex());

			if (logger != null)
				logger.info("fn_UpdatePage::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// Effettuo le nuove associazioni
			Vector arrAlias = objPage.getAlias();
			for (int i = 0; i < arrAlias.size(); i++) {
				TPAlias objAlias = (TPAlias) arrAlias.get(i);
				strCmd = "INSERT INTO cms_08_pagine_alias (n08_pag_oid, n08_tal_oid, v08_pal_value)" + " VALUES (" + String.valueOf(objPage.getDBIndex()) + ", " + objAlias.getDBIndex() + ", " + Query.toSQL(objAlias.getValue()) + ")";

				if (logger != null)
					logger.info("fn_UpdatePage::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdatePage", e);
			throw e;
		}
	}

	/**
	 * Elimina una pagina.
	 * 
	 * @param conn
	 *            La connessione su cui operare
	 * @param objPage
	 *            La pagina da eliminare.
	 * @param logger
	 *            Il logger
	 * 
	 * @return TRUE se la pagina  stata eliminata.
	 * 
	 * @throws Exception
	 */
	static public boolean fn_DeletePage(Connection conn, Page objPage, Logger logger) throws Exception {
		boolean ret = false;

		try {
			int numResult = 0;

			String strQuery = "SELECT COUNT( n09_cha_oid ) AS totItems FROM cms_09_canali" + " WHERE n09_pag_oid = " + String.valueOf(objPage.getMDBIndex());

			// Call fn_DebugLog( "fn_DeletePage::Query = " & strQuery )

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				numResult = rs.getInt("totItems");

				if (objPage.isTmp()) {
					// La pagina pu essere cancellata

					// Cancello le associazioni con i contenuti dinamici
					String strCmd = "DELETE FROM cms_13_pagina_tipi_contenuto WHERE n13_pag_oid=" + String.valueOf(objPage.getMDBIndex());
					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();

					// Cancello la pagina
					strCmd = "DELETE FROM cms_07_pagine WHERE n07_pag_oid = " + String.valueOf(objPage.getMDBIndex());

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();

					ret = true;
				} else if (numResult == 0) {
					// Se esitono cancello anche le pagine provvisorie
					String in = String.valueOf(objPage.getDBIndex());
					if (objPage.getOid_pag_mod() != 0) {
						in += "," + String.valueOf(objPage.getOid_pag_mod());
					}
					int id_anteprima = fn_GetPageAntID(objPage.getDBIndex());
					if (id_anteprima != 0) {
						in += "," + String.valueOf(id_anteprima);
					}
					// Controllo se esiste anche una pagina temporanea creata da
					// dentro la form di modifica

					// Cancello le associazioni con i contenuti dinamici
					String strCmd = "DELETE FROM cms_13_pagina_tipi_contenuto WHERE n13_pag_oid IN (" + in + ")";
					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();

					// Cancello la pagina
					strCmd = "DELETE FROM cms_07_pagine WHERE n07_pag_oid IN (" + in + ")";

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();

					ret = true;
				}
			} else {
				rs.close();
				stmt.close();
			}
		} catch (Exception e) {
			throw e;
		}

		return ret;
	}

	/**
	 * Recupera gli ID dei contenuti dinamici associati alla pagina
	 * 
	 * @param pag_oid
	 *            L'ID della pagina,
	 * 
	 * @return Un vettore di String contenente gli ID dei contentuti dinamici
	 *         associati alla pagina.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_GetPageTic(int pag_oid) throws Exception {
		Vector arrTic = new Vector();
		int numCTypes = 0;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			// Recupero il numero di contenuti dinamici trattati dal template
			Page objPage = Page_mgr.fn_GetPage(pag_oid);

			String strQuery = "SELECT n04_tmp_num_ctypes FROM cms_04_template WHERE n04_tmp_oid = " + String.valueOf(objPage.getTemplateStaticID());

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				numCTypes = rs.getInt("n04_tmp_num_ctypes");
			}
			rs.close();
			stmt.close();

			arrTic.setSize(numCTypes);
			for (int i = 0; i < numCTypes; i++) {
				arrTic.set(i, "0");
			}

			strQuery = "SELECT n13_tic_oid, n13_tic_order FROM cms_13_pagina_tipi_contenuto WHERE" + " n13_pag_oid=" + String.valueOf(pag_oid);

			stmt = conn.createStatement();
			rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				int tic = rs.getInt("n13_tic_oid");
				int order = rs.getInt("n13_tic_order");
				if (order < arrTic.size())
					arrTic.set(order, String.valueOf(tic));
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			arrTic.clear();
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrTic;
	}

	@SuppressWarnings("unchecked")
	public static void fn_SetPageTic(Connection conn, int pag_oid, Vector arrTic, Logger logger) throws Exception {
		try {
			// rimuovo le vecchie associazioni
			String strCmd = "DELETE FROM cms_13_pagina_tipi_contenuto WHERE n13_pag_oid=" + String.valueOf(pag_oid);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// creo le nuove associazioni
			for (int i = 0; i < arrTic.size(); i++) {
				strCmd = "INSERT INTO cms_13_pagina_tipi_contenuto (n13_pag_oid, n13_tic_oid, n13_tic_order)" + " VALUES (" + String.valueOf(pag_oid) + ", " + (String) arrTic.get(i) + ", " + String.valueOf(i) + ")";

				if (logger != null)
					logger.info("fn_SetPageTic::Cmd = " + strCmd);

				stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_SetPageTic", e);
			throw e;
		}
	}
}
