/*
 * Created on 2-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.common.classes.TPAlias;
import it.softecspa.jwebber.common.classes.TPAliasMetadata;
import it.softecspa.jwebber.common.classes.Template;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per il recupero e il salvataggio a DB dei dati relativi ai
 * template.
 */
public class Template_mgr {
	/**
	 * Controlla se esiste gi un dato template. Il controllo viene fatto in
	 * base al nome del template.
	 * 
	 * @param numDBIndex
	 *            ID da scartare ( 0 = nessuno scarto ).
	 * @param strName
	 *            Nome del template da controllare.
	 * 
	 * @return TRUE se il template esiste.
	 * 
	 * @throws Exception
	 */
	static public boolean fn_TemplateExists(int numDBIndex, String strName) throws Exception {
		String strQuery = "";
		boolean bolFound = false;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT n04_tmp_oid FROM cms_04_template" + " WHERE v04_tmp_nome = " + Query.toSQL(strName);

			if (numDBIndex > 0) {
				strQuery += " AND n04_tmp_oid NOT IN (" + String.valueOf(numDBIndex) + ")";
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				bolFound = true;
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return bolFound;
	}

	/**
	 * Restituisce l'elenco degli alias per un dato template.
	 * 
	 * @param strRef
	 *            ID del template.
	 * 
	 * @return Un riferimento all'array contenente l'elenco degli alias (oggetti
	 *         di classe 'TPAlias').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetTemplateAliasByRef(String strRef) throws Exception {
		Vector arrRet = null;

		int i = strRef.indexOf("#");

		String s = i > 0 ? strRef.substring(0, i) : strRef;

		try {
			if (CMSUtilities.isIntValue(s)) {
				arrRet = fn_GetTemplateAlias(Integer.parseInt(s));
			} else {
				arrRet = fn_GetTemplateAlias(0);
			}
		} catch (Exception e) {
			throw e;
		}

		return arrRet;
	}

	/**
	 * Restituisce l'elenco degli alias per un dato template.
	 * 
	 * @param numDBIndex
	 *            Indice del template.
	 * 
	 * @return Un riferimento all'array contenente l'elenco degli alias (oggetti
	 *         di classe 'TPAlias').
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetTemplateAlias(int numDBIndex) throws Exception {
		Vector arrAlias = new Vector();
		TPAlias objAlias = null;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT n05_tal_oid, v05_tal_alias, n05_tal_tipo FROM cms_05_template_alias" + " WHERE n05_tmp_oid = " + String.valueOf(numDBIndex);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				objAlias = new TPAlias(rs.getInt("n05_tal_oid"), rs.getString("v05_tal_alias"), rs.getInt("n05_tal_tipo"));
				arrAlias.add(objAlias);
			}

			rs.close();
			stmt.close();

		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrAlias;
	}

	/**
	 * Restituisce il percorso su disco della pagina ASP associata ad un dato
	 * template.
	 * 
	 * @param p_numDBIndex
	 *            ID del template.
	 * 
	 * @return Una stringa contenente il percorso. Una stringa vuota se l'indice
	 *         specificato come parametro non corrisponde ad alcun template.
	 * 
	 * @throws Exception
	 */
	static public String fn_GetTemplatePath(int p_numDBIndex) throws Exception {

		String strPath = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT v04_tmp_path FROM cms_04_template WHERE n04_tmp_oid = " + p_numDBIndex;

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				strPath = rs.getString("v04_tmp_path").trim();
			}

			rs.close();
			stmt.close();
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return strPath;
	}

	/**
	 * Recupera la lista di tutti i templates disponibili.
	 * 
	 * @return La lista dei templates (oggetti di classe 'Template').
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Vector fn_GetTemplatesForPage() throws Exception {
		Vector arrTemplate = new Vector();
		Template objTempl = null;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT n04_tmp_oid, v04_tmp_nome, v04_tmp_descr, v04_tmp_thumbnail, " + "v04_tmp_path, n04_tmp_tipo, n04_tmp_num_ctypes FROM cms_04_template WHERE n04_tmp_tipo=1";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			while (rs.next()) {
				objTempl = new Template(rs.getInt("n04_tmp_oid"), rs.getString("v04_tmp_nome"), rs.getString("v04_tmp_descr"), rs.getInt("n04_tmp_tipo"), rs.getString("v04_tmp_thumbnail"), rs.getString("v04_tmp_path"), rs
						.getInt("n04_tmp_num_ctypes"));
				arrTemplate.add(objTempl);
			}

			rs.close();
			stmt.close();

		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrTemplate;
	}

	/**
	 * Recupera i dati di untemplate spcifico.
	 * 
	 * @param tmp_oid
	 *            L'ID del template.
	 * 
	 * @return Il template (oggetto di classe 'Template').
	 * 
	 * @throws Exception
	 */
	public static Template fn_GetTemplate(int tmp_oid) throws Exception {
		Template objTempl = null;

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT n04_tmp_oid, v04_tmp_nome, v04_tmp_descr, v04_tmp_thumbnail, " + "v04_tmp_path, n04_tmp_tipo, n04_tmp_num_ctypes FROM cms_04_template WHERE n04_tmp_tipo=1" + " AND n04_tmp_oid = " + String.valueOf(tmp_oid);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				objTempl = new Template(rs.getInt("n04_tmp_oid"), rs.getString("v04_tmp_nome"), rs.getString("v04_tmp_descr"), rs.getInt("n04_tmp_tipo"), rs.getString("v04_tmp_thumbnail"), rs.getString("v04_tmp_path"), rs
						.getInt("n04_tmp_num_ctypes"));
			}

			rs.close();
			stmt.close();
			DatabaseManager.closeConnection(conn);

		} catch (Exception e) {
			objTempl = null;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objTempl;
	}

	/**
	 * Restituisce il nome di un template dato il suo ID.
	 * 
	 * @param strId
	 *            L'ID del template.
	 * 
	 * @return Il nome del template.
	 * 
	 * @throws Exception
	 */
	public static String fn_GetTemplateNameById(String strId) throws Exception {
		String strName = "";

		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			String strQuery = "SELECT v04_tmp_nome FROM cms_04_template WHERE n04_tmp_oid = " + strId + "";

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				strName = rs.getString("v04_tmp_nome");
			}

			rs.close();
			stmt.close();

		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return strName;
	}

	/**
	 * Aggiunge un alias di un dato tipo all'elenco degli alias utilizzati in un
	 * template.
	 * 
	 * @param numAliasType
	 *            : Tipo dell'alias da aggiungere all'elenco.
	 * @param arrAliasUsed
	 *            : Elemento degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array arrAliasUsed, aggiornato.
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_AddAliasToArray(int numAliasType, Vector arrAliasUsed) {
		if ((numAliasType >= 0) && (numAliasType <= 4)) {
			TPAliasMetadata objAliasMD = new TPAliasMetadata();

			// Recupero l'indice di inserimento del nuovo alias
			// int numIndex = arrAliasUsed.size() + 1;
			// for(int i=0; i<arrAliasUsed.size(); i++)
			// {
			// if(((TPAlias) arrAliasUsed.elementAt(i)).getType() > numAliasType
			// )
			// {
			// numIndex = i;
			// break;
			// }
			// }

			// Aggiungo il nuovo alias in posizione numIndex nell'array
			TPAlias objAlias = new TPAlias(0, "", objAliasMD.getType(numAliasType));
			// if(numIndex == arrAliasUsed.size()+1)
			arrAliasUsed.add(objAlias);
			// else
			// arrAliasUsed.add(numIndex,objAlias);
		}

		return arrAliasUsed;
	}

	/**
	 * Rimuove un dato alias dall'elenco degli alias utilizzati in template.
	 * 
	 * @param numAliasIndex
	 *            : Indice dell'alias da rimuovere.
	 * @param arrAliasUsed
	 *            : Elemento degli alias gi utilizzati.
	 * 
	 * @return Un riferimento all'array p_arrAliasUsed, aggiornato.
	 * 
	 */
	@SuppressWarnings("unchecked")
	static public Vector fn_RemoveAliasFromArray(int numAliasIndex, Vector arrAliasUsed) {
		int numIndex = numAliasIndex;
		if ((numIndex >= 0) && (numIndex < arrAliasUsed.size())) {
			TPAlias objAlias = (TPAlias) arrAliasUsed.get(numIndex);
			if (objAlias.getDBIndex() == 0) {
				// Ancora non  stato salvato a db e quindi lo rimuovo dal
				// vettrore
				arrAliasUsed.removeElementAt(numIndex);
			} else {
				// Marco l'alias per la cancellazione
				objAlias.setDeleted(true);
				arrAliasUsed.setElementAt(objAlias, numIndex);
			}
		}

		return arrAliasUsed;
	}

	/**
	 * Crea un nuovo template.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objTmp
	 *            L'oggetto contenente i dati del nuovo template.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @return L'ID del nuovo template creato.
	 * 
	 * @throws Exception
	 */
	public static int fn_CreateTemplate(Connection conn, Template objTmp, Logger logger) throws Exception {
		int newID = 0;
		String strCmd = "";

		try {
			strCmd = "INSERT INTO cms_04_template (v04_tmp_nome, v04_tmp_descr, v04_tmp_thumbnail" + ", v04_tmp_path, n04_tmp_tipo, n04_tmp_num_ctypes)" + " VALUES (" + Query.toSQL(objTmp.getName()) + ", " + Query.toSQL(objTmp.getDescription())
					+ ", " + Query.toSQL(objTmp.getThumbnail()) + ", " + Query.toSQL(objTmp.getPath()) + ", " + objTmp.getType() + ", " + objTmp.getNumCTypes() + ")";

			if (logger != null)
				logger.info("fn_CreateTemplate::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// Recupero l'ID del template appena creato
			String strQuery = "SELECT MAX(n04_tmp_oid) AS MAX_ID FROM cms_04_template";
			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				newID = rs.getInt("MAX_ID");
			}
			rs.close();
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateTemplate", e);
			throw e;
		}

		return newID;
	}

	/**
	 * Modifica i dati di un template.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objTmp
	 *            L'oggetto contenente i dati del template.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	public static void fn_UpdateTemplate(Connection conn, Template objTmp, Logger logger) throws Exception {
		String strCmd = "";

		try {
			strCmd = "UPDATE cms_04_template SET v04_tmp_nome = '" + Query.toSQL(objTmp.getName()) + "'" + ", v04_tmp_descr = " + Query.toSQL(objTmp.getDescription()) + ", v04_tmp_thumbnail = " + Query.toSQL(objTmp.getThumbnail())
					+ ", v04_tmp_path = " + Query.toSQL(objTmp.getPath()) + ", n04_tmp_tipo = " + objTmp.getType() + ", n04_tmp_num_ctypes = " + objTmp.getNumCTypes() + " WHERE n04_tmp_oid = " + objTmp.getDBIndex();

			if (logger != null)
				logger.info("fn_UpdateTemplate::Cmd = " + strCmd);

			Statement stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateTemplate", e);
			throw e;
		}
	}

	/**
	 * Crea gli alias di un nuovo template.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objTmp
	 *            L'oggetto contenente i dati del nuovo template.
	 * @param arrAlias
	 *            Il vettore degli alias.
	 * @param tmp_oid
	 *            L'ID del template.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_CreateTemplateAlias(Connection conn, Template objTmp, Vector arrAlias, int tmp_oid, Logger logger) throws Exception {
		String strCmd = "";

		try {
			for (int i = 0; i < arrAlias.size(); i++) {
				TPAlias objAlias = (TPAlias) arrAlias.get(i);

				strCmd = "INSERT INTO cms_05_template_alias (n05_tmp_oid, v05_tal_alias, n05_tal_tipo)" + " VALUES (" + tmp_oid + ", " + Query.toSQL(objAlias.getAlias()) + ", " + objAlias.getType() + ")";

				if (logger != null)
					logger.info("fn_CreateTemplateAlias::Cmd = " + strCmd);

				Statement stmt = conn.createStatement();
				stmt.executeUpdate(strCmd);
				stmt.close();
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateTemplateAlias", e);
			throw e;
		}
	}

	/**
	 * Aggiorna gli alias di un template.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objTmp
	 *            L'oggetto contenente i dati del template.
	 * @parma arrAlias Il vettore degli alias.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static void fn_UpdateTemplateAlias(Connection conn, Template objTmp, Vector arrAlias, Logger logger) throws Exception {
		String strCmd = "";
		String strQuery = "";

		try {
			for (int i = 0; i < arrAlias.size(); i++) {
				TPAlias objAlias = (TPAlias) arrAlias.get(i);

				if (objAlias.getDBIndex() == 0) {
					// Gestisco l'aggiunta di un nuovo alias
					strCmd = "INSERT INTO cms_05_template_alias (n05_tmp_oid, v05_tal_alias, n05_tal_tipo)" + " VALUES (" + objTmp.getDBIndex() + ", " + Query.toSQL(objAlias.getAlias()) + ", " + objAlias.getType() + ")";

					if (logger != null)
						logger.info("fn_UpdateTemplateAlias::Cmd = " + strCmd);

					Statement stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();

					// Recupero l'ID del nuovo alias
					int newID = 0;
					strQuery = "SELECT MAX(n05_tal_oid) AS MAX_ID FROM cms_05_template_alias";
					stmt = conn.createStatement();
					ResultSet rs = stmt.executeQuery(strQuery);
					if (rs.next()) {
						newID = rs.getInt("MAX_ID");
					}
					rs.close();
					stmt.close();

					// Recupero tutte le pagine che hanno associato il template
					// e aggiungo il nuovo alias vuoto
					strQuery = "SELECT n07_pag_oid FROM cms_07_pagine WHERE v07_tmp_ref = '" + objTmp.getDBIndex() + "'";

					if (logger != null)
						logger.info("fn_UpdateTemplateAlias::Query = " + strQuery);

					stmt = conn.createStatement();
					rs = stmt.executeQuery(strQuery);
					while (rs.next()) {
						strCmd = "INSERT INTO cms_08_pagine_alias (n08_pag_oid, n08_tal_oid, v08_pal_value)" + " VALUES (" + rs.getInt("n07_pag_oid") + ", " + newID + ", '')";

						if (logger != null)
							logger.info("fn_UpdateTemplateAlias::Cmd = " + strCmd);

						Statement stmtIns = conn.createStatement();
						stmtIns.executeUpdate(strCmd);
						stmtIns.close();
					}
					rs.close();
					stmt.close();
				} else if (objAlias.getDBIndex() != 0 && objAlias.isDeleted()) {
					// Gestisco la rimozione di un alias esistente

					// Recupero tutte le pagine che hanno associato il template
					// e rimuovo l'alias
					strQuery = "SELECT n07_pag_oid FROM cms_07_pagine WHERE v07_tmp_ref = '" + objTmp.getDBIndex() + "'";

					if (logger != null)
						logger.info("fn_UpdateTemplateAlias::Query = " + strQuery);

					Statement stmt = conn.createStatement();
					ResultSet rs = stmt.executeQuery(strQuery);
					while (rs.next()) {
						strCmd = "DELETE FROM cms_08_pagine_alias WHERE n08_tal_oid = " + objAlias.getDBIndex();

						if (logger != null)
							logger.info("fn_UpdateTemplateAlias::Cmd = " + strCmd);

						Statement stmtIns = conn.createStatement();
						stmtIns.executeUpdate(strCmd);
						stmtIns.close();
					}
					rs.close();
					stmt.close();

					// Rimuovo l'alias dal template
					strCmd = "DELETE FROM cms_05_template_alias WHERE n05_tal_oid = " + objAlias.getDBIndex();

					if (logger != null)
						logger.info("fn_UpdateTemplateAlias::Cmd = " + strCmd);

					stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				} else {
					// Aggiorno il valore del nome dell'alias
					strCmd = "UPDATE cms_05_template_alias SET v05_tal_alias = " + Query.toSQL(objAlias.getAlias()) + " WHERE n05_tal_oid = " + objAlias.getDBIndex();

					if (logger != null)
						logger.info("fn_UpdateTemplateAlias::Cmd = " + strCmd);

					Statement stmt = conn.createStatement();
					stmt.executeUpdate(strCmd);
					stmt.close();
				}
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateTemplateAlias", e);
			throw e;
		}
	}

	/**
	 * Elimina un template.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objTmp
	 *            Il template da eliminare.
	 * @param logger
	 *            Il logger
	 * 
	 * @return TRUE = Template eliminato, se FALSE esistono pagine che
	 *         utilizzano questo template
	 * 
	 * @throws Exception
	 */
	static public boolean fn_DeleteTemplate(Connection conn, Template objTmp, Logger logger) throws Exception {
		boolean ret = false;

		int numResult = 0;

		try {
			String strQuery = "SELECT Count(n07_pag_oid) AS totItems FROM cms_07_pagine" + " WHERE v07_tmp_ref = '" + objTmp.getDBIndex() + "' AND n07_pag_istmp=0";

			if (logger != null)
				logger.info("fn_DeleteTemplate::Query = " + strQuery);

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);

			if (rs.next()) {
				numResult = rs.getInt("totItems");
			}
			stmt.close();
			rs.close();

			if (numResult == 0) {
				String strCmd = "DELETE FROM cms_04_template WHERE n04_tmp_oid = " + objTmp.getDBIndex();

				if (logger != null)
					logger.info("fn_DeleteTemplate::Query = " + strCmd);

				stmt = conn.createStatement();
				stmt.execute(strCmd);
				stmt.close();

				ret = true;
			}
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_DeleteTemplate", e);
			throw e;
		}

		return ret;
	}
}
