/*
 * Created on 11-mag-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.modules;

import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.jwebber.common.classes.CMSUser;
import it.softecspa.jwebber.frameworkImpl.security.CMSAdminImplSecurityManager;
import it.softecspa.kahuna.sql.QueryFormatter;
import it.softecspa.mvc.businessobject.DatabaseManager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Classe di utilit per la gestione degli utenti.
 */
public class Users_mgr {

	private static Logger logSQL = DatabaseStatement.getLoggerSQL();

	/**
	 * Recupera tutti gli utenti definiti a DB.
	 * 
	 * @return Il vettore contenente gli utenti (oggetti della classe 'CMSUser')
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static Vector fn_GetUsers() throws Exception {
		Vector arrUsers = new Vector();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT ut.USERID, ut.USERNAME, ut.PASSWORD, ut.ID_PROFILO, ut.STATO, eu.NOME, eu.COGNOME, eu.EMAIL, ut.CAN_SEE_PREVIEW ".toLowerCase() + 
					   " FROM cms_33_utente UT" + 
					       ", cms_36_e_utente EU" + 
					       " WHERE ut.USERID=eu.USERID"
					+ " ORDER BY eu.NOME, eu.COGNOME".toLowerCase();
			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL, strQuery);
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				CMSUser user = new CMSUser(rs.getInt("userid"), rs.getString("nome"), rs.getString("cognome"), rs.getString("username"), rs.getString("password"), rs.getString("id_profilo"), rs.getString("email"), rs.getString("stato"), rs
						.getInt("can_see_preview") == 1 ? true : false);

				arrUsers.add(user);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrUsers;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static Vector fn_GetUsers(String orderBy, String orderDir) throws Exception {
		Vector arrUsers = new Vector();

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT ut.userid, ut.USERNAME, ut.PASSWORD, ut.ID_PROFILO, ut.STATO, eu.NOME, eu.COGNOME, eu.EMAIL, ut.CAN_SEE_PREVIEW ".toLowerCase() + 
			          " FROM cms_33_utente ut" + 
			              ", cms_36_e_utente eu"
					+ " WHERE ut.userid = eu.userid".toLowerCase();

			if (!"".equals(orderBy)) {
				switch (Integer.parseInt(orderBy)) {
				case 1:
					orderBy = "ut.username";
					break;
				case 2:
					orderBy = "eu.nome";
					break;
				case 3:
					orderBy = "eu.cognome";
					break;
				case 4:
					orderBy = "ut.id_profilo";
					break;
				}
				strQuery += " ORDER BY " + orderBy + " " + orderDir;
			}

			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL,strQuery);
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			while (rs.next()) {
				CMSUser user = new CMSUser(rs.getInt("userid"), rs.getString("nome"), rs.getString("cognome"), rs.getString("username"), rs.getString("password"), rs.getString("id_profilo"), rs.getString("email"), rs.getString("stato"), rs
						.getInt("can_see_preview") == 1 ? true : false);

				arrUsers.add(user);
			}
		} catch (Exception e) {
			throw e;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return arrUsers;
	}

	/**
	 * Recupera i dati di un utente.
	 * 
	 * @param oid_user
	 *            L'ID dell'utente.
	 * @return I dati dell'utente (oggetto della classe 'CMSUser').
	 * 
	 * @throws Exception
	 */
	public static CMSUser fn_GetUser(int oid_user) throws Exception {
		CMSUser objUser = null;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT ut.USERID, ut.USERNAME, ut.PASSWORD, ut.ID_PROFILO, ut.STATO, eu.NOME, eu.COGNOME, eu.EMAIL, ut.CAN_SEE_PREVIEW ".toLowerCase() + 
					   " FROM cms_33_utente UT" +
					       ", cms_36_e_utente EU" +
					   " WHERE ut.USERID=eu.USERID AND ut.USERID="
					+ String.valueOf(oid_user).toLowerCase();

			if (logSQL.isTraceEnabled()) {
				logSQL.debug("Statement SQL: \n\n" + strQuery);
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				objUser = new CMSUser(rs.getInt("userid"), rs.getString("nome"), rs.getString("cognome"), rs.getString("username"), rs.getString("password"), rs.getString("id_profilo"), rs.getString("email"), rs.getString("stato"), rs.getInt("can_see_preview") == 1 ? true : false);
			}
		} catch (Exception e) {
			objUser = null;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return objUser;
	}

	/**
	 * Controlla se esiste gi un utente con lo user_name specificato.
	 * 
	 * @param user_name
	 *            Lo user_name dell'utente.
	 * 
	 * @return TRUE se esiste gi un utente con lo user_name specificato.
	 * 
	 * @throws Exception
	 */
	public static boolean fn_ExistsUser(String user_name, int skip_id) throws Exception {
		boolean ret = false;

		String strQuery = "";
		Connection conn = null;

		try {
			conn = DatabaseManager.getInstance().getConnection();

			strQuery = "SELECT nome, cognome FROM cms_33_utente WHERE username = " + Query.toSQL(user_name);

			if (skip_id != 0) {
				strQuery += " AND userid<>" + String.valueOf(skip_id);
			}
			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL,strQuery);
			}

			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				ret = true;
			}
		} catch (Exception e) {
			ret = false;
		} finally {
			if (conn != null && !conn.isClosed())
				DatabaseManager.closeConnection(conn);
		}

		return ret;
	}

	/**
	 * Inserisce un nuovo utente a db.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objUser
	 *            L'oggetto contenente i dati dell'utente.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @return L'ID del nuovo utente.
	 * 
	 * @throws Exception
	 */
	public static int fn_CreateUser(Connection conn, CMSUser objUser, Logger logger) throws Exception {
		int new_user_id = 0;
		String strCmd = "";
		Statement stmt = null;
		ResultSet rs = null;

		try {

			strCmd = "INSERT INTO cms_33_utente (username, password, id_profilo, nome, cognome, stato, can_see_preview)" + " VALUES ('" + objUser.getUser_id() + "'" + ", " + Query.toSQL(CMSAdminImplSecurityManager.criptaPassword(objUser.getPwd()))
					+ ", " + Query.toSQL(objUser.getIdProfilo()) + ", " + Query.toSQL(objUser.getNome()) + ", " + Query.toSQL(objUser.getCognome()) + ", " + Query.toSQL(objUser.getAttivo()) + ", " + (objUser.isCanSeePreview() ? "1" : "0") + ")";

			if (logger != null)
				logger.info("fn_CreateUser::Cmd = " + strCmd);

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// Recupero l'ID della pagina appena creata
			String strQuery = "SELECT MAX(userid) AS MAX_ID FROM cms_33_utente";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(strQuery);
			if (rs.next()) {
				new_user_id = rs.getInt("MAX_ID");
			}
			rs.close();
			stmt.close();

			// Inserisco i dati nella tabella estensione utente
			strCmd = "INSERT INTO cms_36_e_utente (userid, nome, cognome, email)" + " VALUES (" + String.valueOf(new_user_id) + "" + ", " + Query.toSQL(objUser.getNome()) + ", " + Query.toSQL(objUser.getCognome()) + ", "
					+ Query.toSQL(objUser.getEmail()) + ")";

			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL,strQuery);
			} else if (logger != null) {
				logger.info("fn_CreateUser::Cmd = " + strCmd);
			}

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_CreateUser", e);
			throw e;
		}

		return new_user_id;
	}

	/**
	 * Aggiorna i dati di un utente.
	 * 
	 * @param conn
	 *            La connessione su cui operare.
	 * @param objUser
	 *            L'oggetto contenente i dati dell'utente.
	 * @param logger
	 *            Il logger (pu essere null).
	 * 
	 * @throws Exception
	 */
	public static void fn_UpdateUser(Connection conn, CMSUser objUser, Logger logger) throws Exception {
		String strCmd = "";
		Statement stmt = null;
		
		try {
			strCmd = "UPDATE cms_33_utente" + " SET username = " + Query.toSQL(objUser.getUser_id()) + ", id_profilo = " + Query.toSQL(objUser.getIdProfilo()) + ", nome = " + Query.toSQL(objUser.getNome()) + ", cognome = "
					+ Query.toSQL(objUser.getCognome()) + ", stato = " + objUser.getAttivo() + ", can_see_preview = " + (objUser.isCanSeePreview() ? "1" : "0");

			if (!"".equals(objUser.getPwd())) {
				strCmd += ", password = " + Query.toSQL(CMSAdminImplSecurityManager.criptaPassword(objUser.getPwd()));
			}

			strCmd += " WHERE userid = " + String.valueOf(objUser.getNumDBIndex());

			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL,strCmd);
			} else if (logger != null) {
				logger.info("fn_UpdateUser::Cmd = " + strCmd);
			}

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			// Aggiorno i dati nella tabella estensione utente
			strCmd = "UPDATE cms_36_e_utente" + " SET nome = " + Query.toSQL(objUser.getNome()) + ", cognome = " + Query.toSQL(objUser.getCognome()) + ", email = " + Query.toSQL(objUser.getEmail()) + " WHERE userid = " + objUser.getNumDBIndex();

			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL,strCmd);
			} else if (logger != null) {
				logger.info("fn_UpdateUser::Cmd = " + strCmd);
			}

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_UpdateUser", e);
			throw e;
		}
	}

	/**
	 * Elimina un utente.
	 * 
	 * @param conn
	 *            La connessione su cui operare
	 * @param objUser
	 *            L'oggetto contenente i dati dell'utente.
	 * @param logger
	 *            Il logger.
	 * 
	 * @return TRUE se l'utente  stato cancellato.
	 * 
	 * @throws Exception
	 */
	static public boolean fn_DeleteUser(Connection conn, CMSUser objUser, Logger logger) throws Exception {
		boolean ret = false;

		String strCmd = "";
		Statement stmt = null;

		try {
			//int numResult = 0;

			strCmd = "DELETE FROM cms_36_e_utente WHERE userid=" + String.valueOf(objUser.getNumDBIndex());
			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL,strCmd);
			} else if (logger != null) {
				logger.info("fn_DeleteUser::Cmd = " + strCmd);
			}

			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			strCmd = "DELETE FROM cms_33_utente WHERE userid=" + objUser.getNumDBIndex();
			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL,strCmd);
			} else if (logger != null) {
				logger.info("fn_DeleteUser::Cmd = " + strCmd);
			}
			stmt = conn.createStatement();
			stmt.executeUpdate(strCmd);
			stmt.close();

			ret = true;
		} catch (Exception e) {
			if (logger != null)
				logger.error("fn_DeleteUser", e);
			throw e;
		}

		return ret;
	}
}
