package it.softecspa.jwebber.frameworkImpl;

/**
 * Definisce le costanti valide per l'intera applicazione
 */
public interface AppCostanti {

	// Costanti che descrivono gli ambienti. Sono le propriet che vengono pasate come
	// properties di sistema dallo script di startup dell'application server
	public static final String AMBIENTE_SVILUPPO = "sviluppo";
	public static final String AMBIENTE_COLLAUDO = "collaudo";
	public static final String AMBIENTE_FORMAZIONE = "formazione";
	public static final String AMBIENTE_PRODUZIONE = "operativo";

	/**
	 * Questo campo viene utilizzato per riconoscere con quale application server sta girando l'applicazione.
	 * E' necessaria questa distinzione per un problema che ha Weblogic nel castare BLOB a Blob e che quindi
	 * rende necessario un diverso comportamento rispetto a codice J2EE standard 
	 */
	public static final String WEBLOGIC = "Weblogic";
    
  /**
   * Questo campo viene utilizzato per riconoscere con quale application server sta girando l'applicazione.
   * E' necessaria questa distinzione per un problema che ha Weblogic nel castare BLOB a Blob e che quindi
   * rende necessario un diverso comportamento rispetto a codice J2EE standard 
   */
  public static final String TOMCAT = "Tomcat";

	/**
	 * Stato di cancellazione logica
	 */
	public static final String STATO_DELETED = "D";

	/**
	 * Stato di "attivo"
	 */
	public static final String STATO_ATTIVO = "A";

	/**
	 * Questa costante  il separatore di chiavi che viene utilizzato per i metodi
	 * degli oggetti di business che restituiscono le proprie Chiavi primarie sottoforma
	 * di stringa.
	 */
	public static final String PK_DB_GEN_SEPARATOR = "-";

}