package it.softecspa.jwebber.frameworkImpl;

import it.softecspa.mvc.WebApp;

import javax.servlet.ServletException;

import org.apache.log4j.Logger;

/**
 * Classe di visibilit ed utilit generale per tutta la webApp
 */
@SuppressWarnings("serial")
public class CMSImplWebApp extends WebApp {
	
	private static Logger logger = Logger.getLogger(CMSImplWebApp.class);

    private static String adobeAcroReaderUrl = null;

    private static String mailServer = null;

    public static String urlKeepSessionAlive = null;

    private static String urlWebService = null;

    /**
     * Definisce quanto pu rimanere attiva una oneTimePassword prima di non
     * considerarla pi valida
     */
    private static int otpScadenzaMillis = 0;

    /**
     * E' il codice che identifica univocamente la Webapp per gli altri attori
     * con cui si integra tramite l'sso. Questo stratagemma serve perch
     * utilizzando l'sso  necessario che chi riceve la one time password riceva
     * anche la url del server a cui chiedere conferma della coppia login/otp.
     * E' superfluo ricordare che se fosse passata la url di check sarebbe
     * scandalosamente semplice aggirare il meccanismo di sicurezza. Grazie a
     * questo codice  necessario che la url collegata ad esso sia censita sulla
     * base dati di chi riceve il codice; in questo modo i server interrogati
     * saranno sempre autoritativi e quindi diranno sempre la verit.
     */
    private static String idOtpUrl = null;

    // Initialize global variables
    public void init(final javax.servlet.ServletConfig config) throws ServletException {

        try {
            super.init(config);

            // carico il valore del mail server
            CMSImplWebApp.mailServer = config.getServletContext().getInitParameter("mailServer");

            // prelevo la scadenza delle otp
            if (config.getServletContext().getInitParameter("otpScadenzaMillis") != null) {
                otpScadenzaMillis = Integer.parseInt(config.getServletContext().getInitParameter("otpScadenzaMillis"));
            }

            // prelevo il codice univoco della webapp per l'sso
            idOtpUrl = config.getServletContext().getInitParameter("idOtpUrl");

            logger.info("WebApp. Inizializzazione completata con successo");
        } catch (final Exception e) {
        	logger.error("ERRORE nell'inizializzazione dell'applicazione", e);
            throw new ServletException(e.getMessage(), e);
        } 
    }

    /**
     * @return Il link di collegamento al sito dell'Adobe per il download di
     *         Acrobat Reader
     */
    public static String getAdobeAcroReaderUrl() {
        return adobeAcroReaderUrl;
    }

    /**
     * @return
     */
    public static String getMailServer() {
        return mailServer;
    }

    /**
     * Restituisce il codice html per la visualizzazione di una gif trasparente
     * che tiene in vita la sessione di applicazioni esterne. E' bruttissimo
     * fare un metodo che fa questo ma in questo modo nessuno si dovr ricordare
     * di modificare l'applicazione se un giorno il rating si staccher
     * dall'applicazione esterna, perch il metodo restituisce una stringa vuota
     * se la url dell'applicazione esterna  null
     * 
     * @return
     */
    public static String getHtmlCodeForKeepSessionAlive() {
        if (urlKeepSessionAlive != null) {
            return "<img src=\"" + urlKeepSessionAlive + "\">";
        } else {
            return "";
        }
    }

    /**
     * @return
     */
    public static String getUrlWebService() {
        return urlWebService;
    }

    /**
     * @return Returns the otpScadenzaSecondi.
     */
    public static int getOtpScadenzaMillis() {
        return otpScadenzaMillis;
    }

    /**
     * @return Returns the idOtpUrl.
     */
    public static String getIdOtpUrl() {
        return idOtpUrl;
    }

}
