package it.softecspa.jwebber.frameworkImpl.bo;

import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.jwebber.frameworkImpl.AppCostanti;
import it.softecspa.mvc.businesslogic.Paginatore;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.businessobject.DbGeneric;
import it.softecspa.mvc.utils.SecurityUtils;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;

/**
  * Profilo
  */
@SuppressWarnings("serial")
public class Profilo implements DbGeneric, Serializable {

	private Logger logSQL = DatabaseStatement.getLoggerSQL();
	
    /**
     * Contiene gli alias di tutti i campi del db. Utile nelle query
     * impedisce che nelle select in join con altre tabelle ci siano campi con lo stesso nome
     */
    public static final String SQL_STAR = "cms_30_profilo.id_profilo as PROFILO_0000, cms_30_profilo.denominazione as PROFILO_0001";

    private String idProfilo;

    private String denominazione;

    /**
     * Definisce il livello di ricorsione di alcune query in join
     * La sua impostazione  prerogativa esclusiva dei metodi che eseguono le query
     */
    private int livelloRicorsione = 0;

    public Profilo() {
    }

    /**
     * Costruttore che inizializza il livello di ricorsione di default
     */
    public Profilo(int livelloRicorsione) {
        this.livelloRicorsione = livelloRicorsione;
    }

    /**
     * Costruttore che inizializza i campi con valori di default
     * @param init un flag che indica se i campi devono essere inizializzati o no
     */
    public Profilo(boolean init) {
        if (init) {
            inizializza();
        }
    }

    /**
     * Imposta il valore di idProfilo
     */
    public void setIdProfilo(String idProfilo) {
        this.idProfilo = idProfilo;
    }

    /**
     * Restituisce il valore di idProfilo
     */
    public String getIdProfilo() {
        return idProfilo;
    }

    /**
     * Imposta il valore di denominazione
     */
    public void setDenominazione(String denominazione) {
        this.denominazione = denominazione;
    }

    /**
     * Restituisce il valore di denominazione
     */
    public String getDenominazione() {
        return denominazione;
    }

    /**
     * Aggiorna l'oggetto con il contenuto del ResultSet.
     * @param r Il risultato della query su db
     */
    public void getFromResultSet(ResultSet r) throws SQLException {
        idProfilo = r.getString("PROFILO_0000");
        denominazione = r.getString("PROFILO_0001");
    }

    /**
     * Aggiorna l'oggetto con il contenuto del ResultSet. Dal momento che questa classe potrebbe
     * contenere oggetti complessi che potrei non aver voluto tirare fuori da una query, un indicatore
     * di livello mi dice il punto in cui fermarmi.
     * @param r Il risultato della query su db
     * @param livello il livello a cui fermarsi. Il livello inizia con 0 ed indica i campi di questa classe
     */
    public void getFromResultSet(ResultSet r, int livello) throws SQLException {
        this.livelloRicorsione = livello;
        this.getFromResultSet(r);
    }

    /**
     * Recupera i dati dal db
     * @param conn La connessione al database
     * @param ID_PROFILO
     * @return L'esito della ricerca
     */
    public boolean retrieveByKey(Connection conn) throws SQLException {
        boolean TGstatus = false;
        this.livelloRicorsione = 99;
        String query = "select " + getSql_starForJoin(this.livelloRicorsione) + 
        			  " from " + getTableNameForJoin(this.livelloRicorsione) + 
        			  " where cms_30_profilo.id_profilo=?";
        if (logSQL.isTraceEnabled()) {
			logSQL.trace("PreparedStatement SQL: \n\n" + query);			
		}
        
        PreparedStatement pstm = conn.prepareStatement(query);
        pstm.setString(1,this.idProfilo);
        ResultSet r = null;
        try {
        	r = pstm.executeQuery();
        	if (r.next()) {
        		getFromResultSet(r);
        		TGstatus = true;
        	}
        } finally {
        	DatabaseManager.closeResultSet(r);
        	DatabaseManager.closeStatement(pstm);
        }
        
        return TGstatus;
    }

    /**
      * Aggiorna l'oggetto sul database.
      * @param conn La connessione al DB
      * @return Il numero di record modificati
      */
    public int updateByKey(Connection conn) throws SQLException {
        String query="update cms_30_profilo set id_profilo=?, denominazione=?" +
         			" where id_profilo=?";
        if (logSQL.isTraceEnabled()) {
			logSQL.trace("PreparedStatement SQL: \n\n" + query);			
		}
        
        PreparedStatement pstm = conn.prepareStatement(query);
        pstm.setString(1,this.idProfilo);
        pstm.setString(2,this.denominazione);
        pstm.setString(3,this.idProfilo);
        int updated = pstm.executeUpdate();
        DatabaseManager.closeStatement(pstm);

        return updated;
    }

    /**
     * Cancella dalla tabella "PROFILO"
     * @param conn La connessione al database
     */
    public int deleteByKey(Connection conn) throws SQLException {
        String query = "delete cms_30_profilo"+" where id_profilo=?";
        if (logSQL.isTraceEnabled()) {
			logSQL.trace("PreparedStatement SQL: \n\n" + query);			
		}
        
        PreparedStatement pstm = conn.prepareStatement(query);
        pstm.setString(1,this.idProfilo);
        int deleted = pstm.executeUpdate();
        DatabaseManager.closeStatement(pstm);

        return deleted;
    }

    /**
     * Restituisce tutti i nomi delle tabelle incluse in una select di join. 
     * Il metodo chiama anche un metodo chiamato come questo
     * negli oggetti relazionati, cos che la cosa possa essere ricorsiva
     * Es: Cliente contiene l'oggetto Indirizzo che a sua volta contiene l'oggetto Provincia
     *     Chiamando il metodo writeGetTableNameForJoin() di Indirizzo che a sua volta chiama il
     *     metodo writeGetTableNameForJoin() di Provincia, i nomi delle tabelle dei campi relazionati
     *     verranno inseriti e si potr fare una join fra tutti gli oggetti in gioco
     * I livelli iniziano da 0 (che il livello dell'oggetto corrente)
     * @param livello Il livello di profondit che voglio raggiungere della query
     */
    public static String getTableNameForJoin(int livello) {
        String tableNames = "cms_30_profilo";
        return tableNames;
    }

    /**
     * Restituisce tutti i campi della tabella pi i campi delle tabelle ad essa relazionate. 
     * Il metodo chiama anche un metodo chiamato come questo
     * negli oggetti relazionati, cos che la cosa possa essere ricorsiva
     * Es: Cliente contiene l'oggetto Indirizzo che a sua volta contiene l'oggetto Provincia
     *     Chiamando il metodo getSql_starForJoin() di Indirizzo che a sua volta chiama il
     *     metodo getSql_starForJoin() di Provincia, i campi verranno inserite tutti e si
     *     potr fare una join fra tutti gli oggetti in gioco
     * I livelli iniziano da 0 (che il livello dell'oggetto corrente)
     * @param livello Il livello di profondit che voglio raggiungere della query
     */
    public static String getSql_starForJoin(int livello) {
        String sqlStar = SQL_STAR;
        return sqlStar;
    }

    /**
     * Restituisce le eguaglianze di relazione della tabella in questione.
     * Dal momento che alcuni oggetti inclusi in questo sono semplicemente
     * id legati ad altre tabelle questo metodo genera una clausola SQL
     * che permette di legare tutte le tabelle legate alla tabella che
     * rappresenta l'oggetto. Il metodo chiama anche un metodo chiamato come questo
     * negli oggetti relazionati, cos che la cosa possa essere ricorsiva
     * Es: Cliente contiene l'oggetto Indirizzo che a sua volta contiene l'oggetto Provincia
     *     Chiamando il metodo getClausolaForJoin() di Indirizzo che a sua volta chiama il
     *     metodo getClausolaForJoin() di Provincia, le clausole verranno inserite tutte e si
     *     potr fare una join fra tutti gli oggetti in gioco
     * I livelli iniziano da 0 (che il livello dell'oggetto corrente)
     * @param livello Il livello di profondit che voglio raggiungere della query
     */
    public static String getClausolaForJoin(int livello,String clausolaAnd) {
        String joinClausole = "";
        return joinClausole;
    }

    /**
     * Recupera tutti i dati dal database
     * @param conn La connessione al database
     * @param orderBy L'elenco dei campi di cui chiedere l'ordinamento. 
     *                Tali campi sono quelli della tabella e sono separati dal carattere ",".
     * @return L'elenco degli oggetti reperiti dal db
     */
    @SuppressWarnings("rawtypes")
	public List retrieveAll(Connection conn,String orderBy,Paginatore paginatore) throws Exception {
        this.livelloRicorsione = 1;
        String query = "select " + getSql_starForJoin(this.livelloRicorsione) + " from " + getTableNameForJoin(this.livelloRicorsione) ;
        if (orderBy != null) {
            query += " order by " + orderBy;
        }
        if (logSQL.isTraceEnabled()) {
			logSQL.trace("PreparedStatement SQL: \n\n" + query);			
		}
        
        PreparedStatement pstm = conn.prepareStatement(query);
        ResultSet r = pstm.executeQuery();
        paginatore.getFromQuery(r,this);
        DatabaseManager.closeResultSet(r);
        DatabaseManager.closeStatement(pstm);
        return paginatore.getVBusinessObj();
    }

    /**
      * Inserisce l'oggetto nel database database.
      * @param conn La connessione al DB
      * @return Il numero di record inseriti
      */
    public int insert (Connection conn) throws SQLException {
        String query="insert into cms_30_profilo ( id_profilo,denominazione ) values (?,?)";
        if (logSQL.isTraceEnabled()) {
			logSQL.trace("PreparedStatement SQL: \n\n" + query);			
		}
        
        PreparedStatement pstm = conn.prepareStatement(query);
        pstm.setString(1,this.idProfilo);
        pstm.setString(2,this.denominazione);
        int inseriti = pstm.executeUpdate();
        DatabaseManager.closeStatement(pstm);

        return inseriti;
    }

    /**
      * Restituisce la chiave primaria dell'oggetto in formato Stringa
      */
    public String getPrimaryKey() throws Exception {
        return String.valueOf(this.idProfilo);
    }

    /**
      * Restituisce la chiave primaria dell'oggetto in formato Stringa
      */
    public void setPrimaryKey(String pk) throws Exception {
        StringTokenizer st = new StringTokenizer(pk,AppCostanti.PK_DB_GEN_SEPARATOR);
        this.setIdProfilo(st.nextToken());

    }

    /**
     * Stampa tutti i campi dell'oggetto
     * @return L'oggetto in formato Stringa
     */
    public String toString() {
         String out = "";
         out += ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n";
         out += "Oggetto: " + this.getClass() + " - " + super.toString() + "\n";
         out += "Idprofilo: <" + this.idProfilo + ">\n";
         out += "Denominazione: <" + this.denominazione + ">\n";
         out += ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n";
         return out;
    }
 
    /**
     * Imposta tutti i campi nulli inizializzandoli (cio fancendo semplici new)
     */
    public void inizializza() {
         this.idProfilo = new String();
         this.denominazione = new String();
    }
 
    /**
     * Crea un'istanza della classe (con il livello di ricorsione impostato in 
     * quel momento)e la restituisce
     * @return l'istanza della classe
     */
    public DbGeneric getIstance() {
        return new Profilo(this.livelloRicorsione);
    }
    
    /*
     * questo metodo restituisce un oggetto uguale all'oggetto clonato
     */
    public Object clone(){
        Profilo profilo = new Profilo(true);
        profilo.setIdProfilo(idProfilo);
        profilo.setDenominazione(denominazione);
        return profilo;
    }

    
    public final String getCodedName() throws Exception {
		return SecurityUtils.criptaInStringaByHash(getClass().getName());
	}
    
}