/*
 * Created on 14-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.frameworkImpl.security;

/**
 * @author d.cristofani
 *
 */
import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.kahuna.services.PortalSettings;
import it.softecspa.mvc.FwGenericServlet;
import it.softecspa.mvc.businesslogic.KeyStore;
import it.softecspa.mvc.businesslogic.StandardSecurityManager;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.businessobject.User;
import it.softecspa.mvc.exceptions.AppException;
import it.softecspa.mvc.exceptions.AuthenticationException;
import it.softecspa.mvc.exceptions.AuthorizationException;
import it.softecspa.mvc.exceptions.ChangePasswordException;
import it.softecspa.mvc.session.Session;
import it.softecspa.mvc.utils.LogUtils;
import it.softecspa.mvc.utils.SecurityUtils;
import it.softecspa.portal.Bundle;
import it.softecspa.portal.KeyStorage;
import it.softecspa.portal.Parameters;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * Gestisce la sicurezza applicativa
 */
public class CMSAdminImplSecurityManager extends StandardSecurityManager {

	private static Logger accessLogger = Logger.getLogger("access");

	// parametri che devono essere presenti in una form di login per poter
	// effettuare
	// l'autenticazione dell'utente
	public static String REQUEST_PARAM_USERNAME = "Login_USERNAME";
	public static String REQUEST_PARAM_PASSWORD = "Login_PASSWORD";
	public static String REQUEST_PARAM_LANGUAGE = "Login_LANGUAGE";

	/**
	 * Questo parametro rappresenta la password e deve arrivare se si desidera
	 * effettuare una login utilizando il meccanismo di one time password. Pu
	 * essere utile per un tipo di single sign-on
	 */
	public static String REQUEST_PARAM_OTP = "Login_OTP";

	/**
	 * Questo parametro rappresenta l'id della url a cui chiedere la verifica e
	 * deve arrivare se si desidera effettuare una login utilizando il
	 * meccanismo di one time password. Pu essere utile per un tipo di single
	 * sign-on
	 */
	public static String REQUEST_PARAM_OTP_URL_CHECK_ID = "Login_OTP_URL_CHECK_ID";

	// parametri che devono essere presenti in una form per poter effettuare il
	// cambio
	// password dell'utente.
	public static String REQUEST_PARAM_NEW_PASSWORD = "chPwd_NEW_PASSWORD";
	public static String REQUEST_PARAM_CONFIRM_PASSWORD = "chPwd_CONFIRM_PASSWORD";

	/**
	 * Controlla se un dato utente possiede l'autorizzazione ad accedere ad una
	 * data funzione.
	 * 
	 * @param conn
	 *            La connesisone al database
	 * @param funzione
	 *            La funzione a cui si desidera accedere
	 */
	public boolean checkAuthorization(HttpServletRequest request, HttpServletResponse response, Hashtable<String,Object> fod, Session session) throws AuthorizationException {
		
		@SuppressWarnings("unused")
		User user = (User) session.getUser();
		
		return false;
	}

	/**
	 * Effettua la login di un utente ma solo se nella form sono presenti i
	 * parametri necessari per effettuarla. Questo metodo NON serve per
	 * autorizzare l'utente ad accedere ad una data funzione (per la quale
	 * esiste il metodo "checkAuthorization") ma solamente per autenticarlo nel
	 * sistema e quindi stabilirne l'identit. Per questo motivo, se al metodo
	 * non arrivano i parametri richiesti per il login ("login", "password",
	 * "codice abi", questo non viene effettuato e nessuna eccezione viene
	 * restituita).
	 * 
	 * @param servlet
	 *            La servlet che ha scatenato la chiamata al metodo
	 * @param session
	 *            La sesisone dell'utente
	 * @throws AuthenticationException
	 *             Se l'autenticazione fallisce. Per fallimento
	 *             dell'utenticazione si intende una richista di login con i
	 *             dati appropriati che non ha sortito risultato.
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void myLogin(Hashtable fod, HttpServletRequest request, Session session) throws AuthenticationException {
		// per effettuare il login controllo che dalla form siano arrivati i
		// parametri
		// necessari e che l'utente non si sia appena loggato (controllando la
		// presenza di un
		// parametro creato poco pi in basso, dopo il successo di una login
		// "appenaLoggato"  un attributo della request e non un parametro nel
		// bus dati
		// per evitare che mi possa arrivare dalla form. In effetti non
		// succederebbe nulla
		// ma meglio non rischiare... :)
		if (request.getAttribute("appenaLoggato") == null && fod.get(REQUEST_PARAM_USERNAME) != null && (fod.get(REQUEST_PARAM_PASSWORD) != null || fod.get(REQUEST_PARAM_OTP) != null)) {
			Connection conn = null;
			try {
				Utente utente = new Utente();
				utente.setUserName((String) fod.get(REQUEST_PARAM_USERNAME));
				utente.setPassword((String) fod.get(REQUEST_PARAM_PASSWORD));
				String language = (String) fod.get(REQUEST_PARAM_LANGUAGE);
				//
				utente.setLanguage(language);
				language = utente.getLanguage();
				//
				session.setAttribute(CMSConstants.LANGUAGE, language);

				/*
				ResourceBundle bundlePortal = Bundle.getInstance().getPortalBundle(utente);
				ResourceBundle bundle = Bundle.getInstance().getBundle(utente);
				*/
				
				conn = DatabaseManager.getInstance().getConnection();

				// autentico l'utente con la password solo se questa mi 
				// arrivata
				// altrimenti  un'autenticazione tramite one time password
				if ((String) fod.get(REQUEST_PARAM_PASSWORD) != null) {
					try {
						if (!utente.login(conn)) {
							utente = Utente.getUtenteAnonimo();
							fod.put(FwGenericServlet.ERROR_MESSAGE, CMSConstants.LOGIN_KO);
						} else if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_AREA_ACCESS)) {
							fod.put("MsgErroreCMS", CMSConstants.NON_AREA_ADMIN_USER);
						}
					} catch (AuthenticationException e) {
						utente = Utente.getUtenteAnonimo();
						fod.put(FwGenericServlet.ERROR_MESSAGE, CMSConstants.LOGIN_KO);
					}
				}

				// FIXME tolto utente.loadUserPolicy(conn);

				// ripulisce la sessione dei valori che sono rimasti in sessione
				session.cleanAll();
				session.setUser(utente);
				// session.setAttribute("bundle", bundle);
				// session.setAttribute("bundlePortal", bundlePortal);

				// metto nella request un parametro che mi fa capire che mi sono
				// gi
				// loggato, dal momento che dopo questa login ci potrebbe essere
				// una redirect ad un'altra servlet che farebbe ripetere la
				// login
				//  un attributo che viene creato e gestito in questo metodo ed
				// in nessun altro posto
				request.setAttribute("appenaLoggato", "Y");

				// Loggo l'accesso dell'utente
				if (accessLogger.isInfoEnabled())
					accessLogger.info(LogUtils.getMessage(session.getUser(), request, (FwGenericServlet) fod.get(FwGenericServlet.SERVLET_FOD_LABEL), fod));
			} catch (Exception e) {
				throw new AuthenticationException("", e);
			} finally {
				DatabaseManager.closeConnection(conn);
			}
		}
	}

	/**
	 * Si occupa del cambio di password dell'utente. Se trova alcuni parametri
	 * nella request e l'utente in sessione, provvede all'aggiornamento dello
	 * stato dell'utente e della sua password.
	 * 
	 * @param servlet
	 *            L'istanza della servlet che ha chiamato il metodo
	 * @param request
	 *            La request
	 * @param session
	 *            La sessione dell'utente
	 * @throws AuthenticationException
	 *             Se l'utente non esiste in sessione o si  verificato un
	 *             errore nell'aggiornamento della password
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void changePassword(Hashtable fod, HttpServletRequest request, Session session) throws AuthenticationException, ChangePasswordException {
		ResourceBundle bundle = null;
		try {
			Utente utente = (Utente)session.getUser();
			bundle = Bundle.getInstance().getBundle(utente);
			
			fod.put("ch_password_targetPage", request.getRequestURI());
			// Controllo che ci siano i parametri necessari per il cambio
			// password.
			if (fod.get(REQUEST_PARAM_PASSWORD) != null && fod.get(REQUEST_PARAM_NEW_PASSWORD) != null && fod.get(REQUEST_PARAM_CONFIRM_PASSWORD) != null) {
				// se la password vecchia  quella dell'utente e le password
				// nuove
				// corrispondono aggiorno la password sul db
				if (utente.verificaPassword((String) fod.get(REQUEST_PARAM_PASSWORD)) && ((String) fod.get(REQUEST_PARAM_NEW_PASSWORD)).equals((String) fod.get(REQUEST_PARAM_CONFIRM_PASSWORD))) {
					// controllo che la lunghezza della password non sia
					// inferiore agli 8 caratteri
					if (!checkLunghezzaPassword((String) fod.get(REQUEST_PARAM_NEW_PASSWORD))) {
						throw new ChangePasswordException(bundle.getString("msgLengthPwdError"));
					}
					utente.setPassword((String) fod.get(REQUEST_PARAM_NEW_PASSWORD));
					// se la nuova password che l'utente ha impostato  la prima
					// che imposta, questa viene registrata per poter essere
					// reimpostata
					// successivamente in caso l'utente abbia smarrito quella
					// attuale
					// if (utente.getFirstPassword() == null) {
					// utente.setFirstPassword(utente.getPassword());
					// }
					utente.setStato(Utente.STATO_ATTIVO);
					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						utente.updatePasswd(conn, true);
						conn.commit();
					} catch (Exception sqlEx) {
						throw new AuthenticationException(bundle.getString("msgChangePwdError"), sqlEx);
					} finally {
						DatabaseManager.closeConnection(conn);
					}
				} else {
					// fod.put(PcSecurityManager.REQUEST_PARAM_LOGIN,utente.getIdUtente());
					throw new ChangePasswordException(bundle.getString("msgInsertingPwdError"));
				}
			} else {
				// se non ci sono o parametri necessari sicuramente devo
				// visualizzare
				// la shermata di cambio password perch se sono in questo
				// metodo
				// vuol dire che sono gi gi autenticato e sono un utente che
				// la deve
				// per forza cambiare.
				throw new ChangePasswordException(bundle.getString("msgModifyPwd"));
			}
		} catch (ChangePasswordException cpe) {
			throw cpe;
			
		} catch (Exception e) {
			if (bundle==null) bundle = Bundle.getInstance().getBundle();
			throw new AuthenticationException(bundle.getString("msgChangePwdError"), e);
		}
	}

	/**
	 * Effettua la login e gestisce il meccanismo del cambio password.
	 * 
	 * @param fod
	 *            Il bus dati
	 * @param session
	 *            La sesisone dell'utente
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public boolean login(HttpServletRequest request, HttpServletResponse response, Hashtable fod, Session session) throws AuthenticationException {
		// chiamo la login per autenticare l'utente. La login viene fatta prima
		// di tutto
		// perch dopo aver fatto la login viene controllato lo stato
		// dell'utente.
		myLogin(fod, request, session);
		if (session.getUser() == null || session.getUser().getIdProfilo().equals("")) {
			// La login  fallita
			fod.put(FwGenericServlet.ERROR_MESSAGE, CMSConstants.LOGIN_KO);
			Utente utente = Utente.getUtenteAnonimo();
			utente.setLanguage(Parameters.getInstance().get(PortalSettings.LANGUAGE_DEFAULT,"it"));
			session.setUser(utente);
			fod.put("MsgErroreCMS", CMSConstants.NON_AREA_ADMIN_USER);
		}

		return false;
	}

	/**
	 * Consente di criptare la password dell'utente
	 * 
	 * @param passwordInChiaro
	 * @return La password criptata
	 */
	public static String criptaPassword(String passwordInChiaro) throws Exception {
		return SecurityUtils.criptaPasswordInStringaByHash(passwordInChiaro + KeyStorage.getInstance().getKeyStore().getKey(KeyStore.CHIAVE_PASSWORD_LABEL));
	}

	/**
	 * Effettua un controllo di sicurezza per verificare che la password
	 * dell'utente non sia pi corta di 8 caratteri
	 * 
	 * @param password
	 *            La password da controllare
	 * @return false se la password  inferiore ad 8 caratteri
	 */
	public static boolean checkLunghezzaPassword(String password) throws AppException {
		if (password.length() < 8) {
			return false;
		} else {
			return true;
		}
	}

}
