/*
 * Created on 5-apr-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.frameworkImpl.security;

import it.softecspa.mvc.businessobject.User;

/**
 * Gestisce la sicurezza applicativa di secondo livello (cio controlla le
 * autorizzazioni in base alle policy di sicurezza di un dato profilo utente)
 */
public class CMSImplPolicyManager {

    /**
     * Definisce che un utente che passa per il generatore di OTP per il single sign-on (SSO)
     * debba essere effettivamente registrato  per il controllo incrociato
     * che avverr in caso di passaggio da un'applicazione ad un'altra.
     * Questa policy  stata creata perch nel caso in cui l'utente che operi fosse
     * anonimo, non avrebbe senso registrare la sua user-id per i controlli incrociati
     * in quanto, essendo anonimo, basta che passi da un'applicazione all'altra
     * senza alcuna credenziale. Anche questa  considerata una policy perch in
     * effetti  un privilegio poter passare le proprie credenziali ad altre applicazioni
     * ed in effetti permette di fare in modo che alcuni profili passino ad altre
     * applicazioni come anonimi (possibilit senz'altro remota ma effetto collaterale positivo)
     */
    public static String SSO_GEN="SSO_GEN";
    
    /**
     * indica da quale profilo preferito iniziare la ricerca ed e' solo un suffisso. 
     * Nella tabella delle policy e' presente per esteso es: PROF_PREF_CLIENTE
     */
    public static final String POLICY_PROF_PREF = "PROF_PREF_";
    
    /**
     * Controlla che l'utente debba passare per la generazione della OTP per il SSO
     * 
     * @param user L'utente di cui controllare i permessi
     * @return boolean L'esito del controllo (true se pu operare)
     */
    public static boolean checkForSsoGen(User user) {
        boolean granted = false;
        if (user.hasPolicy(SSO_GEN)) {
            granted = true;
        }
        return granted;
    }
    
}