/*
 * Created on 14-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.frameworkImpl.security;

/**
 * @author m.veroni
 *
 * Classe utilizzata per la verifica utente con parametri passati in GET/POST
 *
 */



import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.CMSUser;
import it.softecspa.jwebber.common.modules.Users_mgr;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.services.PortalSettings;
import it.softecspa.mvc.businesslogic.StandardSecurityManager;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.AuthenticationException;
import it.softecspa.mvc.session.Session;
import it.softecspa.portal.DMSsoClientSettings;
import it.softecspa.portal.Parameters;
import it.softecspa.sso.client.AuthStatus;
import it.softecspa.sso.client.HttpSsoController;
import it.softecspa.sso.common.SsoException;
import it.softecspa.sso.common.UserInfo;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


public class DMSsoSecurityManager extends StandardSecurityManager {
	
	public final static String KEY_SSO_USER_INFO 	 	= "sso.userInfo";
	public final static String KEY_SSO_TOKEN_INFO 	 	= "sso.tokenInfo";
	public final static String KEY_SSO_ACCESS_TOKEN 	= "sso.accessToken";
	public final static String KEY_SSO_REFRESH_TOKEN 	= "sso.refreshToken";
	
	
	public final static String PARAMETER_SSO_STATUS 	= "sso_status";
	public final static String PARAMETER_ACCESS_TOKEN 	= "access_token";
	public final static String PARAMETER_ORGANIZATION 	= "organization";
	
	private Parameters parameters = Parameters.getInstance();
	
	public DMSsoSecurityManager() {
		super();
	}

	private final String AUTOURL = "autourl"; 
	
	private void normalizeServerUrl(HttpSsoController controller, StringBuffer servlet) {
		if (log.isDebugEnabled()) log.debug("Normalize SSO redirect URL");
		
		if (servlet==null) return;
		String autourl = servlet.toString();
		
		
		Matcher matcher = Pattern.compile("(\\$\\{"+AUTOURL+"\\})").matcher(controller.getUsedRedirectURI());
		boolean found = matcher.find();
		if (found) {
			controller.changeRedirectURI(matcher.replaceAll(autourl));				
		}	
		
		matcher = Pattern.compile("(\\$\\{"+AUTOURL+"\\})").matcher(controller.getUsedLogoutURI());
		found = matcher.find();
		if (found) {
			controller.changeLogoutURI(matcher.replaceAll(autourl));				
		}
		
		matcher = Pattern.compile("(\\$\\{"+AUTOURL+"\\})").matcher(controller.getUsedErrorURI());
		found = matcher.find();
		if (found) {
			controller.changeErrorURI(matcher.replaceAll(autourl));				
		}
	}
	
	
	public static final String SSO_REDIRECT_URL 	= "sso.redirect.url";
	public static final String SSO_LOGOUT_URL 		= "sso.logout.url";
	public static final String SSO_ERROR_URL 		= "sso.error.url";
	
	/**
	 * Salva in sessione le info legate agli url di redirect utilizzati per la connessione
	 * @param controller
	 * @param session2
	 */
	public void archiveSsoRedirectUrl(HttpSession session, HttpSsoController controller) {
		if (session==null) {
			log.warn("Session is null, do not archive SSO redirect url");
			return;
		}
		if (log.isDebugEnabled()) log.debug("Archive SSO redirect url to session");
		session.setAttribute(SSO_REDIRECT_URL, controller.getUsedRedirectURI());
		session.setAttribute(SSO_LOGOUT_URL, controller.getUsedLogoutURI());
		session.setAttribute(SSO_ERROR_URL, controller.getUsedErrorURI());
	}
	
	
	public boolean login(HttpServletRequest request, HttpServletResponse response, Hashtable<String,Object> fod, Session session) throws AuthenticationException {
		String language = parameters.get(PortalSettings.LANGUAGE_DEFAULT, "en");
		session.setAttribute(CMSConstants.LANGUAGE, language);

		// Recupero l'utente dalla session
		Utente utente = (Utente)session.getUser();
	
		// Gestione LOGOUT e richiesta con ACCESS_TOKEN
		boolean logout = false;
		String token = null;
		String sso_status = request.getParameter(PARAMETER_SSO_STATUS);
		
		if (XString.isNotBlankNullTrim(sso_status)) {
			if (log.isDebugEnabled()) log.debug("Call with parameter sso = '"+sso_status+"'");
			
			if ("ERROR".equalsIgnoreCase(sso_status)) {
				log.warn("SSO/Authentication error request income; throw exception");
				throw new AuthenticationException("Exception in in SSO authentication (redirect)");
			}
			if ("LOGOUT".equalsIgnoreCase(sso_status)) {
				log.info("SSO/Authentication logout request income; invalidate user");
				logout=true;
			}
		} else {
			token = request.getParameter(PARAMETER_ACCESS_TOKEN);
			if (XString.isNotBlankNullTrim(token)) {
				utente = Utente.getUtenteAnonimo();
				session.setUser(utente);
			}
		}
		
		
		if (utente == null || utente.isAnonimo() || logout) {
			try {
				HttpSsoController controller = new HttpSsoController(DMSsoClientSettings.getInstance().getSettings());
			
				normalizeServerUrl(controller, request.getRequestURL());
				archiveSsoRedirectUrl(request.getSession(false), controller);
				
				
				String organization = (String)fod.get(PARAMETER_ORGANIZATION); 
				if (XString.isNotBlankNullTrim(organization)) {
					if (log.isDebugEnabled()) log.debug("Found 'organization' parameter in request call");
					// Preimposto l'organizzazione di defaultn
					controller.presetOrganization(organization);
				}	
				
				if (!logout) {
					// Eseguo la chiamata di controllo credenziali
					if (XString.isNotBlankNullTrim(token)) {
						// E' stato passato un access token, lo verifico
						AuthStatus status = controller.validateAccessToken(request, response);
						
						// Verifica match organizzazione
						if (status.getOrganization()==null || 
							!status.getOrganization().equalsIgnoreCase(controller.getConfig().getDefaultOrganization())) {
							// L'organizzazione del TOKEN non corrisponde a quella del controller
							// Buttofuori
							throw new AuthenticationException("Token organization do not match with required ["+status.getOrganization()+" vs "+controller.getConfig().getDefaultOrganization()+"]");
						}
												
					} else  {
						// Non sono loggato, faccio la richiesta a SSO
						controller.accessCheck(request, response);
					}
				} else {
					// Faccio la logout
					controller.revokeToken(request, response);
					session.cleanAll();
					session.setUser(Utente.getUtenteAnonimo());
				}
				if (controller.isRedirected()) {
					return true;
				}
				
				if (!controller.isLogged()) {
					// Buttofuori
					if (log.isDebugEnabled()) log.debug("Not logged!");
					return false;
				}
				
				AuthStatus authStatus = controller.getAuthStatus();
				if (log.isDebugEnabled()) {
					log.debug("User '"+authStatus.getToken().getName()+"' logged with token '"+authStatus.getToken().getValue()+"'");
				}
				
				/* -------- Verifica utente sul sistema locale --------- */
				Connection connection = null;
				try {
					connection = DatabaseManager.getInstance().getConnection();
					connection.setAutoCommit(false);
					
					//  possibile fare l'autocensimento
					autocensus_permitted = true;					
					utente.setUserName(authStatus.getToken().getName());
					login(connection, fod, utente);
				
				} catch (AuthenticationException e) {
					// L'utente (record su DB) esiste!
					if (e.userExist()) throw e;
					
					// Verifico se  possibile l'autocreazione dell'utente 
					if (!autocensus(connection, fod, utente, controller)) throw e;
					
				} finally {
					DatabaseManager.closeConnection(connection);
				}
						
				
				/* ---- Estrazione dati utente dal server SSO -----*/
				try {
					UserInfo userInfo = controller.acquireUserInfo();
					if (userInfo!=null) {
						utente.addCustomInfo(KEY_SSO_USER_INFO, userInfo);
					}
				} catch (SsoException e) {
					/*
					 * Non sono riuscito a recuperare i dati utente
					 * questo pu essere derivato dal fatto che il token  ancora valido ma SSO non ha nel suo database le info utente
					 * Non segnalo un vero e rpriro errore, ma traccio un warning
					 */
					log.warn("SSO remote user info not found:"+e);
				}
				utente.addCustomInfo(KEY_SSO_TOKEN_INFO, authStatus.getTokenInfo());
				utente.addCustomInfo(KEY_SSO_ACCESS_TOKEN, authStatus.getToken().getValue());
				utente.addCustomInfo(KEY_SSO_REFRESH_TOKEN, "?");
				
				
			} catch (SsoException e) {
				// ...di sicurezza
				session.cleanAll();
				session.setUser(Utente.getUtenteAnonimo());
				//
				throw new AuthenticationException("Error in SSO authentication",e);
			
			} catch (AuthenticationException e) {
				throw new AuthenticationException("Error authentication",e);
			} catch (Exception e) {
				// ...di sicurezza
				session.cleanAll();
				session.setUser(Utente.getUtenteAnonimo());
				//
				throw new AuthenticationException("Unhandled exception in in SSO authentication",e);
			}
			
			// ripulisce la sessione dei valori che sono rimasti in sessione
			session.cleanAll();
			session.setUser(utente);
			if (utente.isAnonimo()) {
				throw new AuthenticationException(CMSConstants.LOGIN_KO);
			}
		}
		
		
		return false;
	}


	private void login(Connection connection, Hashtable<String, Object> fod, Utente utente) throws SQLException, AuthenticationException {
		if (!utente.loginWithoutPassword(connection)) {
			// Trovato utente ma non valido
			autocensus_permitted = false;
			utente = Utente.getUtenteAnonimo();
			throw new AuthenticationException(CMSConstants.LOGIN_KO);	
		} else {
			if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_AREA_ACCESS)) {
				// Trovato utente ma non valido
				autocensus_permitted = false;
				log.warn("User do not have granted "+CMSConstants.POLICY_ADMIN_AREA_ACCESS);
				utente = Utente.getUtenteAnonimo();
				fod.put("MsgErroreCMS", CMSConstants.NON_AREA_ADMIN_USER);
				throw new AuthenticationException(CMSConstants.NON_AREA_ADMIN_USER);
			}
		}		
	}

	
	
	private boolean autocensus_permitted;
	
	private boolean autocensus(Connection connection, Hashtable<String, Object> fod, Utente utente, HttpSsoController controller) throws SsoException, SQLException, AuthenticationException {
		if (!autocensus_permitted) return false;
		if (!parameters.getBoolean(PortalSettings.AUTOCENSUS_LOGIN,false)) return false;
		String default_profile = parameters.get(PortalSettings.AUTOCENSUS_PROFILE);
		if (XString.isBlankNull(default_profile)) return false;
		
		log.info("Autocensus for username '"+utente.getUserName()+"' with profile '"+default_profile+"'");
		
		UserInfo userInfo = controller.acquireUserInfo();	
		// Inserisco il record relativo all'utente come farebbe il CMS
		CMSUser user = new CMSUser(0
								 , userInfo.getGivenName()
								 , userInfo.getFamilyName()
								 , userInfo.getUsername()
								 , "???"
								 , default_profile
								 , userInfo.getEmail()
								 , "A"
								 , true);
		
		try {
			Users_mgr.fn_CreateUser(connection, user, log);
			connection.commit();
		} catch (Exception e) {
			log.error("Error insert new user in database (autocensus)");
			connection.rollback();
		}
		
		login(connection, fod, utente);
		return true;
	}
}
