/*
 * Created on 14-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.frameworkImpl.security;

/**
 * @author m.veroni
 *
 * Classe utilizzata per la verifica utente con parametri passati in GET/POST
 *
 */


import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.services.PortalSettings;
import it.softecspa.mvc.FwGenericServlet;
import it.softecspa.mvc.businesslogic.StandardSecurityManager;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.AuthenticationException;
import it.softecspa.mvc.session.Session;
import it.softecspa.portal.Parameters;

import java.sql.Connection;
import java.util.Hashtable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class RequestSecurityManager extends StandardSecurityManager {

	public static String USERNAME = "usr";
	public static String PASSWORD = "pwd";
	public static String PASSWORD_CRIPTED = "pwd-crypted";
	
	public RequestSecurityManager() {
	}

	public boolean login(HttpServletRequest request, HttpServletResponse response, Hashtable<String,Object> fod, Session session) throws AuthenticationException {
		String language = Parameters.getInstance().get(PortalSettings.LANGUAGE_DEFAULT, "it");
		session.setAttribute(CMSConstants.LANGUAGE, language);

	
		Utente utente = (Utente)session.getUser();
		if (utente == null || utente.isAnonimo()) {
			try {
				// Verifico le credenziali
				// 1) cerco i parametri nell HEADER
				String usr = request.getHeader(USERNAME);
				String pwd = request.getHeader(PASSWORD);
				String pwdx = request.getHeader(PASSWORD_CRIPTED);
				
				// 2) Se nell'Header il valore  nullo, provo a cercare nella REQUEST
				if (XString.isBlankNull(usr)) usr = (String)fod.get(USERNAME);				
				if (XString.isBlankNull(pwd)) pwd = (String)fod.get(PASSWORD);
				if (XString.isBlankNull(pwdx)) pwdx = (String)fod.get(PASSWORD_CRIPTED);
				
				// ...e vai!
				if (XString.isNotBlankNull(pwd) || 
					XString.isNotBlankNull(pwdx)) {

					utente.setUserName(usr);
					if (XString.isNotBlankNull(pwdx)) {
						utente.setUncryptedPassword(pwdx);
					} else {
						utente.setPassword(pwd);
					}

					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						if (!utente.login(conn)) {
							utente = Utente.getUtenteAnonimo();
							fod.put(FwGenericServlet.ERROR_MESSAGE, CMSConstants.LOGIN_KO);

						} else {
							// FIXME tolto  utente.loadUserPolicy(conn);
							if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_AREA_ACCESS)) {
								log.warn("User do not have granted "+CMSConstants.POLICY_ADMIN_AREA_ACCESS);
								utente = Utente.getUtenteAnonimo();
								fod.put("MsgErroreCMS", CMSConstants.NON_AREA_ADMIN_USER);
							}
						}

					} catch (AuthenticationException e) {
						utente = Utente.getUtenteAnonimo();
						fod.put(FwGenericServlet.ERROR_MESSAGE, CMSConstants.LOGIN_KO);
					} finally {
						DatabaseManager.closeConnection(conn);
					}
				}

			} catch (Exception e) {
				utente = Utente.getUtenteAnonimo();
				fod.put(FwGenericServlet.ERROR_MESSAGE, CMSConstants.LOGIN_KO);
			}

			// ripulisce la sessione dei valori che sono rimasti in sessione
			session.cleanAll();
			session.setUser(utente);
			
		}
		return false;
		
	}
}
