/*
 * Created on 5-apr-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.frameworkImpl.session;

import it.softecspa.jwebber.bo.Utente;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.AppException;
import it.softecspa.mvc.exceptions.AuthenticationException;
import it.softecspa.mvc.session.Session;
import it.softecspa.mvc.session.StandardSession;
import it.softecspa.mvc.session.StandardSessionFactory;
import it.softecspa.portal.Bundle;

import java.sql.Connection;

import javax.servlet.http.HttpServletRequest;

/**
 * Questa classe permette di integrare in sessione dati dipendenti dal profilo
 * dell'utente che si  autenticato in sessione. La classe contiene un metodo
 * che interroga una sorgente di dati per vedere quale metodo chiamare per un
 * dato profilo dell'utente e lo chiama di conseguenza. La sessione viene quindi
 * manipolata dal metodo chiamato (sia per integrazione che per altri scopi).
 */
public class CMSImplSessionFactory extends StandardSessionFactory {

    /**
     * E' il metodo standard per l'integrazione nella sessione di dati
     * applicativi dipendenti dal profilo dell'utente. Questo metodo  quello
     * che viene chiamato anche se ad un profilo non corrisponde nessuna Factory
     * particolare (perch non deve essere integrato alcun dato in sessione)
     * @param session La sessione dell'utente in cou vanno integrati i dati
     * @throws AuthenticationException
     */
    public void standardCreateSession(CMSImplSession session) throws AuthenticationException {
    }
    
    
    public Session createSession(HttpServletRequest request)  throws AppException {
        
        CMSImplSession session = new CMSImplSession();
        
        // imposto il servletCode a "". Mi  utile per il controllo del workflow 
        // quando tento di accedere ad una servlet non avendo sessione
        session.setServletCode(StandardSession.SERVLET_CODE_NO_FUNCTION);
        
        Connection conn = null;
        Utente user = Utente.getUtenteAnonimo();
        if(request.getAttribute("language")!=null)
        	user.setLanguage((String)request.getAttribute("language"));
        try {
            conn = DatabaseManager.getInstance().getConnection();
            // FIXME tolto user.loadUserPolicy(conn);
        } catch (Exception e) {
        	String messaggio = Bundle.getInstance().getBundle().getString("msgDatabaseError");
            throw new AppException(messaggio);
        } finally {
            DatabaseManager.closeConnection(conn);
        }
        
        // creo un utente anonimo
        session.setUser(user);
    
        return session;
        
    }
}