/*
 * Created on 21-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.CntAlias;
import it.softecspa.jwebber.common.classes.CntAliasMetadata;
import it.softecspa.jwebber.common.classes.ContentType;
import it.softecspa.jwebber.common.modules.Ctype_mgr;
import it.softecspa.jwebber.common.modules.Group_mgr;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSCTypesIV extends InputValidator {
	
	private int new_order = 0;

	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";

			// Recupero tutti i profili definiti a db
			Vector arrProfili = Group_mgr.fn_GetProfili();
			fod.put("profili", arrProfili);
			Vector arrProfiliObj = Group_mgr.fn_GetProfiliObj();
			fod.put("profiliObj", arrProfiliObj);

			String strName = "";
			String strDescr = "";
			String numMaxCnt = "0";
			boolean bolWorkflow = false;
			Vector arrAliasUsed = null;
			Vector arrAliasAvail = null;

			if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di un nuovo tipo di contenuto
				// -----------------------------------------------------------------------
				if (chkForm) {
					strName = ((String) fod.get("name")).trim();
					strDescr = ((String) fod.get("descr")).trim();
					numMaxCnt = ((String) fod.get("numMaxCnt")).trim();
					bolWorkflow = fod.get("workflow") != null ? true : false;

					// Recupero lo stato delle checkBox dei profili per
					// l'editing
					Hashtable profiliEdit = new Hashtable();
					for (int i = 0; i < arrProfili.size(); i++) {
						String profilo = (String) arrProfili.get(i);
						String checkName = "chk_edit_" + profilo;
						if (fod.get(checkName) != null) {
							fod.put(checkName, "checked");
							profiliEdit.put(profilo, "true");
						} else {
							profiliEdit.put(profilo, "false");
						}
					}

					arrAliasUsed = fn_getUsedAliasFromRequestEdit(request);
					int alias_sel = Integer.parseInt((String) fod.get("alias_sel"));
					int chkIndex = Integer.parseInt((String) fod.get("chkIndex"));

					if ("aliasAdd".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_AddAliasToArrayEdit(alias_sel, arrAliasUsed, new_order);
						new_order++;
					} else if ("aliasRemove".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_RemoveAliasFromArrayEdit(chkIndex, arrAliasUsed);
						new_order--;
					} else if ("aliasMoveDown".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_MoveAliasDown(chkIndex, arrAliasUsed);
					} else if ("aliasMoveUp".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_MoveAliasUp(chkIndex, arrAliasUsed);
					} else {
						String strAliasOk = "";

						Enumeration en = request.getParameterNames();
						while (en.hasMoreElements()) {
							String elem = (String) en.nextElement();
							String value = (String) request.getParameter(elem);
							if (elem.indexOf("aliasval_") == 0) {
								String[] arrName = elem.split("_");
								if (arrName.length == 4) {
									if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[2])) {
										if ("".equals(value.trim())) {
											int index = Integer.parseInt(arrName[2]);
											strAliasOk = "Alias " + String.valueOf(index + 1);
											break;
										}
									}
								}
							}
						}

						if (strName.length() == 0)
							strWarning = bundle.getString("msgMFContentTypeName");
						else if (strName.length() > 50)
							strWarning = bundle.getString("msgWRNContentTypeNameLength");
						else if (Ctype_mgr.fn_ContentTypeExists(0, strName))
							strWarning = bundle.getString("msgWRNContentTypeNameExist");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNChannelDescrLength");
						else if (!CMSUtilities.isIntValue(numMaxCnt))
							strWarning = bundle.getString("NUM_CONTENTS_NAN");
						else if (Integer.parseInt(numMaxCnt) < 0)
							strWarning = bundle.getString("msgWRNContentsNumNumberNotZero");
						else if (new_order == 0)
							strWarning = bundle.getString("msgWRNContentTypeAlias");
						else if (strAliasOk.length() > 0)
							strWarning = bundle.getString("msgMFAliasName") + "'" + strAliasOk + "'.";
						else {
							ContentType objCType = new ContentType(0, strName, strDescr, bolWorkflow, Integer.parseInt(numMaxCnt));
							objCType.setAliasList(arrAliasUsed);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								int new_id = Ctype_mgr.fn_CreateContentType(conn, objCType, logger);
								Group_mgr.fn_CreateProfiliTipoContenuto(conn, new_id, profiliEdit, logger);
								fod.put(CMSConstants.INSERT, "ok");

								conn.commit();
							} catch (Exception e) {
								strWarning = bundle.getString("msgSavingDataError");
								conn.rollback();
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					}
				} else {
					arrAliasUsed = new Vector();
				}

				arrAliasAvail = Ctype_mgr.fn_GetAvailableAliasEdit(arrAliasUsed);

				fod.put("name", strName);
				fod.put("descr", strDescr);
				fod.put("numMaxCnt", numMaxCnt);
				fod.put("arrAliasUsed", arrAliasUsed);
				fod.put("arrAliasAvail", arrAliasAvail);

			}// Fine creazione nuovo tipo contenuto
			else if ("edit".equals(action)) {
				// -----------------------------------------------------------------------
				// Modifica di un tipo di contenuto
				// -----------------------------------------------------------------------

				// Recupero l'ID del tipo contenuto
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				ContentType objCType = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati del tipo contenuto
					numDBIndex = Integer.parseInt(id);
					objCType = Ctype_mgr.fn_GetContentType(numDBIndex);

					if (objCType == null) {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					}
				}

				if (chkForm) {
					// Gestione di un postBack

					strName = ((String) fod.get("name")).trim();
					strDescr = ((String) fod.get("descr")).trim();
					numMaxCnt = ((String) fod.get("numMaxCnt")).trim();
					bolWorkflow = fod.get("workflow") != null ? true : false;

					// Recupero lo stato delle checkBox dei profili per
					// l'editing
					Hashtable profiliEdit = new Hashtable();
					for (int i = 0; i < arrProfili.size(); i++) {
						String profilo = (String) arrProfili.get(i);
						String checkName = "chk_edit_" + profilo;
						if (fod.get(checkName) != null) {
							fod.put(checkName, "checked");
							profiliEdit.put(profilo, "true");
						} else {
							profiliEdit.put(profilo, "false");
						}
					}

					arrAliasUsed = fn_getUsedAliasFromRequestEdit(request);
					int alias_sel = Integer.parseInt((String) fod.get("alias_sel"));
					int chkIndex = Integer.parseInt((String) fod.get("chkIndex"));

					if ("aliasAdd".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_AddAliasToArrayEdit(alias_sel, arrAliasUsed, new_order);
						new_order++;
					} else if ("aliasRemove".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_RemoveAliasFromArrayEdit(chkIndex, arrAliasUsed);
						new_order--;
					} else if ("aliasMoveDown".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_MoveAliasDown(chkIndex, arrAliasUsed);
					} else if ("aliasMoveUp".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Ctype_mgr.fn_MoveAliasUp(chkIndex, arrAliasUsed);
					} else {
						String strAliasOk = "";

						Enumeration en = request.getParameterNames();
						while (en.hasMoreElements()) {
							String elem = (String) en.nextElement();
							String value = (String) request.getParameter(elem);
							if (elem.indexOf("aliasval_") == 0) {
								String[] arrName = elem.split("_");
								if (arrName.length == 4) {
									if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[2])) {
										if ("".equals(value.trim())) {
											int index = Integer.parseInt(arrName[2]);
											strAliasOk = "Alias " + String.valueOf(index + 1);
											break;
										}
									}
								}
							}
						}
						if (strName.length() == 0)
							strWarning = bundle.getString("msgMFContentTypeName");
						else if (strName.length() > 50)
							strWarning = bundle.getString("msgWRNContentTypeNameLength");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNChannelDescrLength");
						else if (!CMSUtilities.isIntValue(numMaxCnt))
							strWarning = bundle.getString("NUM_CONTENTS_NAN");
						else if (Integer.parseInt(numMaxCnt) < 0)
							strWarning = bundle.getString("msgWRNContentsNumNumberNotZero");
						else if (new_order == 0)
							strWarning = bundle.getString("msgWRNContentTypeAlias");
						else if (strAliasOk.length() > 0)
							strWarning = bundle.getString("msgMFAliasName") + "'" + strAliasOk + "'.";
						else {
							objCType.setName(strName);
							objCType.setDescription(strDescr);
							objCType.setWorkflow(bolWorkflow);
							objCType.setNumMaxCnt(Integer.parseInt(numMaxCnt));
							objCType.setAliasList(arrAliasUsed);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								Ctype_mgr.fn_UpdateContentType(conn, objCType, logger);
								Group_mgr.fn_UpdateProfiliTipoContenuto(conn, numDBIndex, profiliEdit, logger);
								fod.put(CMSConstants.UPDATE, "ok");

								conn.commit();
							} catch (Exception e) {
								strWarning = bundle.getString("msgSavingDataError");
								conn.rollback();
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					}
				} else {
					// La pagina viene caricata per la prima volta

					// Recupero i dati sull'editabilit del tipo contenuto
					Hashtable profiliEdit = Group_mgr.fn_GetProfiliTipoContenutoEdit(numDBIndex);
					Enumeration en = profiliEdit.keys();
					while (en.hasMoreElements()) {
						String profilo = (String) en.nextElement();
						boolean checked = "true".equals((String) profiliEdit.get(profilo)) ? true : false;
						if (checked)
							fod.put("chk_edit_" + profilo, "checked");
					}

					strName = objCType.getName();
					strDescr = objCType.getDescription();
					numMaxCnt = String.valueOf(objCType.getNumMaxCnt());
					bolWorkflow = objCType.hasWorkflow();
					arrAliasUsed = objCType.getAliasList();

					new_order = 0;
					for (int i = 0; i < arrAliasUsed.size(); i++) {
						if (!"".equals(((CntAlias) arrAliasUsed.get(i)).getValue()))
							new_order++;
					}
				}

				arrAliasAvail = Ctype_mgr.fn_GetAvailableAliasEdit(arrAliasUsed);

				fod.put("name", strName);
				fod.put("descr", strDescr);
				if (bolWorkflow)
					fod.put("workflow", "checked");
				fod.put("numMaxCnt", numMaxCnt);
				fod.put("arrAliasUsed", arrAliasUsed);
				fod.put("arrAliasAvail", arrAliasAvail);

			} // Fine modifica di un tipo contenuto
			else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un tipo contenuto
				// -----------------------------------------------------------------------

				// Recupero l'ID del tipo contenuto
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				ContentType objCtype = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati della pagina
					numDBIndex = Integer.parseInt(id);
					objCtype = Ctype_mgr.fn_GetContentType(numDBIndex);
					if (objCtype == null) {
						// fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
						fod.put(CMSConstants.WARNING_MESSAGE, bundle.getString("msgWRNContentTypeNotExist"));
						return;
					}
				} else {
					// fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					fod.put(CMSConstants.WARNING_MESSAGE, bundle.getString("msgWRNContentTypeNotExist"));
					return;
				}

				fod.put("numDBIndex", id);

				if (chkForm) {
					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						if (Ctype_mgr.fn_DeleteContentType(conn, objCtype.getDBIndex())) {
							fod.put(CMSConstants.DELETE, "ok");
						} else {
							strWarning = bundle.getString("msgDeleteContentTypeError");
							// fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
						}

						conn.commit();
					} catch (Exception e) {
						conn.rollback();
						strWarning = bundle.getString("msgSavingDataError");
						// fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}
				} else {
					fod.put("objCType", objCtype);
				}

			} // Fine eliminazione di un tipo contenuto
			else {

			}
			// Fine controllo della ACTION

			// Paasso alla jsp il numero di campi definiti nel tipo contenuto
			fod.put("field_count", String.valueOf(new_order));
			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}

	/**
	 * Recupera dalla Request l'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias gi
	 *         utilizzati (oggetti di classe CntAlias).
	 */
	/*
	 * private Vector fn_getUsedAliasFromRequest(HttpServletRequest request) {
	 * Vector arrAliasUsed = new Vector();
	 * 
	 * int arrSize = 0; Enumeration en = request.getParameterNames();
	 * while(en.hasMoreElements()) { String elem = (String) en.nextElement();
	 * if(elem.indexOf("aliasval_") == 0) { arrSize++; } }
	 * 
	 * arrAliasUsed.setSize(arrSize);
	 * 
	 * CntAliasMetadata objAliasMD = new CntAliasMetadata();
	 * 
	 * new_order = 0; en = request.getParameterNames();
	 * while(en.hasMoreElements()) { String elem = (String) en.nextElement();
	 * String value = (String) request.getParameter(elem);
	 * if(elem.indexOf("aliasval_") == 0) { String[] arrName = elem.split("_");
	 * if(arrName.length == 4) { new_order++;
	 * if(CMSUtilities.isIntValue(arrName[2]) &&
	 * CMSUtilities.isIntValue(arrName[3])) { CntAlias objAlias = new CntAlias(
	 * Integer.parseInt(arrName[3]),
	 * objAliasMD.getName(Integer.parseInt(arrName[3])), value,
	 * Integer.parseInt(arrName[2]));
	 * arrAliasUsed.set(Integer.parseInt(arrName[2]), objAlias); } } } }
	 * 
	 * return arrAliasUsed; }
	 */

	/**
	 * Recupera dalla Request l'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias gi
	 *         utilizzati (oggetti di classe CntAlias).
	 */
	@SuppressWarnings("unchecked")
	private Vector fn_getUsedAliasFromRequestEdit(HttpServletRequest request) {
		Vector arrAliasUsed = new Vector();

		CntAliasMetadata objAliasMD = new CntAliasMetadata();

		// Creo l'elenco di tutti gli alias vuoti
		for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
			for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
				CntAlias objAlias = new CntAlias(i, objAliasMD.getName(i), "", 0, false, false, "");
				arrAliasUsed.add(objAlias);
			}
		}

		new_order = 0;
		Enumeration en = request.getParameterNames();
		while (en.hasMoreElements()) {
			String elem = (String) en.nextElement();
			String value = (String) request.getParameter(elem);
			if (elem.indexOf("aliasval_") == 0) {
				String[] arrName = elem.split("_");
				if (arrName.length == 4) {
					new_order++;
					if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[3])) {
						String check = elem.replaceFirst("aliasval_", "aliascheck_");
						boolean checked = (request.getParameter(check) != null && !"".equals(request.getParameter(check))) ? true : false;
						String checkInl = elem.replaceFirst("aliasval_", "aliascheckinl_");
						boolean checkedInl = (request.getParameter(checkInl) != null && !"".equals(request.getParameter(checkInl))) ? true : false;

						CntAlias objAlias = new CntAlias(Integer.parseInt(arrName[3]), objAliasMD.getName(Integer.parseInt(arrName[3])), "".equals(value) ? " " : value, Integer.parseInt(arrName[2]), checked, checkedInl, "");
						arrAliasUsed.set(Integer.parseInt(arrName[1]), objAlias);
					}
				}
			}
		}

		return arrAliasUsed;
	}
}
