/*
 * Created on 16-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.ChannelType;
import it.softecspa.jwebber.common.modules.ChanType_mgr;
import it.softecspa.mvc.FwGenericServlet;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSChanTypesIV extends InputValidator {
	
	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			// Recupero il nome della servlet che gestisce la visualizzazione
			// dei contenuti
			FwGenericServlet servlet = ((FwGenericServlet) fod.get(FwGenericServlet.SERVLET_FOD_LABEL));
			String CMSServletWeb = servlet.getServletConfig().getServletContext().getInitParameter(CMSConstants.CMS_SERVLET_WEB);
			fod.put(CMSConstants.CMS_SERVLET_WEB, CMSServletWeb);

			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;
			String strWarning = "";

			String strId = fod.get("id") != null ? (String) fod.get("id") : "";
			String strDescr = fod.get("descr") != null ? (String) fod.get("descr") : "";
			boolean isDefault = fod.get("default") != null ? true : false;
			String strContainer = fod.get("container") != null ? (String) fod.get("container") : "";
			boolean isTypeCreated = false;

			if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di un nuovo tipo di canale
				// -----------------------------------------------------------------------
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNEL_TYPE) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					// L'utente non  un editor
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

					if (chkForm) {
						if (strId.trim().length() == 0)
							strWarning = bundle.getString("msgMFChannelTypeID");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNChannelTypeDescrLength");
						else if (strContainer.trim().length() == 0)
							strWarning = bundle.getString("msgMFContainerName");
						else if (ChanType_mgr.fn_GetChannelTypes(strId) != null)
							strWarning = bundle.getString("msgWRNChannelTypeIDExist");
						else {
							ChannelType objChaType = new ChannelType(strId, strDescr, isDefault, strContainer, isTypeCreated);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								ChanType_mgr.fn_CreateChannelTypes(conn, objChaType, logger);

								conn.commit();
								fod.put(CMSConstants.INSERT, "ok");
								fod.put("chType", ChanType_mgr.fn_GetChannelTypesAll());
							} catch (Exception e) {
								conn.rollback();
								fod.put(CMSConstants.INSERT, "ko");
								strWarning = bundle.getString("msgSavingDataError");
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					}
				}
			}// Fine crezione nuovo canale
			else if ("edit".equals(action)) {
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNEL_TYPE) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

					// -----------------------------------------------------------------------
					// Modifica di un tipo di canale
					// -----------------------------------------------------------------------
					if (chkForm) {
						if (strId.trim().length() == 0)
							strWarning = bundle.getString("msgMFChannelTypeID");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNChannelTypeDescrLength");
						else if (strContainer.trim().length() == 0)
							strWarning = bundle.getString("msgMFContainerName");
						else {
							ChannelType objChaType = new ChannelType(strId, strDescr, isDefault, strContainer, isTypeCreated);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								ChanType_mgr.fn_UpdateChanType(conn, objChaType, logger);

								conn.commit();
								fod.put(CMSConstants.UPDATE, "ok");
								fod.put("chType", ChanType_mgr.fn_GetChannelTypesAll());
							} catch (Exception e) {
								conn.rollback();
								fod.put(CMSConstants.UPDATE, "ko");
								strWarning = bundle.getString("msgSavingDataError");
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					} else {
						// Sto aprendo la pagina di edit per la prima volta
						ChannelType objChaType = ChanType_mgr.fn_GetChannelTypes(strId);

						fod.put("id", objChaType.getChaType());
						fod.put("descr", objChaType.getChaTypeDescr());
						fod.put("default", "" + objChaType.isDefault());
						fod.put("container", objChaType.getContainer());
						fod.put("typeCreated", "" + objChaType.isChaTypeCrea());
					}
				}
			} else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un tipo di canale
				// -----------------------------------------------------------------------

				// Recupero il valore dell'ID del canale che si vuole cancellare
				ChannelType objChaType = ChanType_mgr.fn_GetChannelTypes(strId);

				// Controllo che l'utente sia un editor altrimenti non pu
				// cancellare il tipo canale
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNEL_TYPE) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
					fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					return;
				}

				fod.put("ChannelType", objChaType);
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

				if (chkForm) {
					try {
						if (objChaType == null) {
							fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
							strWarning = bundle.getString("msgDeleteChannelTypeError");
							fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
						} else {
							fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
							ChanType_mgr.fn_DeleteChanType(strId);
							fod.put(CMSConstants.DELETE, "ok");
							fod.put("chType", ChanType_mgr.fn_GetChannelTypesAll());
						}
					} catch (Exception e) {
						fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
						strWarning = bundle.getString("msgWRNChannelDelete");
					}
				}
			}// fine eliminazione di un canale
			else {
				if (utente != null && utente.hasPolicy(CMSConstants.POLICY_ADMIN_AREA_ACCESS)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
					fod.put("chType", ChanType_mgr.fn_GetChannelTypesAll());
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
				}
			}
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}
}