/*
 * Created on 16-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.Channel;
import it.softecspa.jwebber.common.classes.ChannelType;
import it.softecspa.jwebber.common.classes.Page;
import it.softecspa.jwebber.common.modules.ChanType_mgr;
import it.softecspa.jwebber.common.modules.Channel_mgr;
import it.softecspa.jwebber.common.modules.Group_mgr;
import it.softecspa.jwebber.common.modules.Page_mgr;
import it.softecspa.mvc.FwGenericServlet;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSChannelsIV extends InputValidator {
	
	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			// Recupero il nome della servlet che gestisce la visualizzazione
			// dei contenuti
			FwGenericServlet servlet = ((FwGenericServlet) fod.get(FwGenericServlet.SERVLET_FOD_LABEL));
			String CMSServletWeb = servlet.getServletConfig().getServletContext().getInitParameter(CMSConstants.CMS_SERVLET_WEB);
			fod.put(CMSConstants.CMS_SERVLET_WEB, CMSServletWeb);

			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";

			// Recupero l'ID e il livello del canale padre
			String parent_id = fod.get("parent_id") != null ? (String) fod.get("parent_id") : "0";
			Channel objParentChannel = null;
			int chaParentLevel = -1;
			if (!"0".equals(parent_id)) {
				objParentChannel = Channel_mgr.fn_GetChannel(Integer.parseInt(parent_id));
				chaParentLevel = objParentChannel.getChaLevel();
			} else {
				chaParentLevel = 0; // ROOT
			}

			// ID del canale che si sta editando (se in fase di edit)
			String channel_id = (String) fod.get("id");

			// Recupero tutti i profili definiti a db
			Vector arrProfili = Group_mgr.fn_GetProfili();
			fod.put("profili", arrProfili);
			Vector arrProfiliObj = Group_mgr.fn_GetProfiliObj();
			fod.put("profiliObj", arrProfiliObj);

			if ("updateflags".equals(action)) {
				// Recupero il valore dell'ID del canale che si sta editando
				int id = Integer.parseInt(channel_id);

				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES)	&& !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN) && !Channel_mgr.canEditChannel(channel_id, utente.getIdProfilo())) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

					// -----------------------------------------------------------------------
					// Modifica di un canale
					// -----------------------------------------------------------------------

					String onlinePreview = (String) fod.get("online_preview");
					String onlineProduz = (String) fod.get("online_produz");
					String isHome = (String) fod.get("ishome");
					Channel objChannel = Channel_mgr.fn_GetChannel(id);
					if (onlinePreview != null)
						objChannel.setMIsOnlinePreview(!objChannel.isMIsOnlinePreview());
					if (onlineProduz != null)
						objChannel.setMIsOnlineProduz(!objChannel.isMIsOnlineProduz());

					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						if (isHome != null) {
							ChannelType chTypes = ChanType_mgr.fn_GetChannelTypes(objChannel.getChaType());
							objChannel.setHome(true);
							chTypes.setDefault(objChannel.isHome());
							ChanType_mgr.fn_UpdateChanType(conn, chTypes, logger);
						}

						Channel_mgr.fn_UpdateChannel(conn, objChannel, logger);
						conn.commit();
						fod.put(CMSConstants.UPDATE, "ok");
						fod.put("parent_id", String.valueOf(parent_id));
					} catch (Exception e) {
						conn.rollback();
						fod.put(CMSConstants.UPDATE, "ko");
						strWarning = bundle.getString("msgSavingDataError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}
				}

			} else if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di un nuovo canale
				// -----------------------------------------------------------------------
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					// L'utente non  un editor
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

					if (chkForm) {
						String strName = (String) fod.get("name");
						String strDescr = (String) fod.get("descr");
						String strBookmark = (String) fod.get("bookmark");
						@SuppressWarnings("unused")
						String pageID = (String) fod.get("page_id");
						String onlinePreview = (String) fod.get("online_preview");
						String onlineProduz = (String) fod.get("online_produz");
						boolean bolOnlinePreview = onlinePreview != null ? true : false;
						boolean bolOnlineProduz = onlineProduz != null ? true : false;
						// boolean isLink = fod.get("link") != null;
						boolean isHome = fod.get("root") != null;
						boolean isHttps = fod.get("https") != null;
						boolean notInMap = fod.get("notinmap") != null;
						boolean bolWorkflow = false;
						Integer order = CMSUtilities.getInteger((String) fod.get("order"));
						String chaType = (String) fod.get("cha_type");
						// String chaLink = (String) fod.get("cha_link");
						String chaPosition = (String) fod.get("cha_pos");
						String keywords = (String) fod.get("keywords");
						String key_desc = (String) fod.get("key_desc");

						// Recupero lo stato delle checkBox dei profili per la
						// visualizzazione
						Hashtable profiliView = new Hashtable();
						for (int i = 0; i < arrProfili.size(); i++) {
							String profilo = (String) arrProfili.get(i);
							String checkName = "chk_view_" + profilo;
							if (fod.get(checkName) != null) {
								fod.put(checkName, "checked");
								profiliView.put(profilo, "true");
							} else {
								profiliView.put(profilo, "false");
							}
						}

						// Recupero lo stato delle checkBox dei profili per
						// l'editing
						Hashtable profiliEdit = new Hashtable();
						for (int i = 0; i < arrProfili.size(); i++) {
							String profilo = (String) arrProfili.get(i);
							String checkName = "chk_edit_" + profilo;
							if (fod.get(checkName) != null) {
								fod.put(checkName, "checked");
								profiliEdit.put(profilo, "true");
							} else {
								profiliEdit.put(profilo, "false");
							}
						}

						if (strName.trim().length() == 0)
							strWarning = bundle.getString("msgMFChannelName");
						else if (strDescr.trim().length() == 0)
							strWarning = bundle.getString("msgMFChannelTitle");
						else if (strName.length() > 50)
							strWarning = bundle.getString("msgWRNChannelNameLength");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNChannelDescrLength");
						else if (!"".equals(strBookmark.trim()) && Channel_mgr.fn_BookmarkExists(0, strBookmark, chaType))
							strWarning = bundle.getString("msgWRNBookmarkExist");
						else if ("0".equals(chaType))
							strWarning = bundle.getString("msgMFChannelGroup");
						else if ("0".equals(chaPosition))
							strWarning = bundle.getString("msgMFChannelPosition");
						else if (order == null)
							strWarning = bundle.getString("msgWRNIDNotNumber");
						else if (order.intValue() < 1)
							strWarning = bundle.getString("msgWRNIDNotValid");
						else if (!CMSUtilities.isIntValue(parent_id))
							strWarning = bundle.getString("msgWRNParentIDNotValid");
						else {
							Channel objChannel = new Channel(0, strName, strDescr, bolOnlinePreview, bolOnlineProduz, bolWorkflow, chaType, "", false, isHome, isHttps, chaPosition, strBookmark, (chaParentLevel == 0) ? 0 : chaParentLevel + 1,
									keywords, key_desc, parameters);
							objChannel.setParentChannelID(Integer.parseInt(parent_id));
							// objChannel.setPageID(Integer.parseInt(pageID));
							objChannel.setOrder(order.intValue());
							objChannel.setNotInMap(notInMap);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								int new_id = Channel_mgr.fn_CreateChannel(conn, objChannel, logger, false);
								Group_mgr.fn_CreateProfiliCanale(conn, new_id, profiliView, profiliEdit, logger);

								conn.commit();
								fod.put(CMSConstants.INSERT, "ok");
								fod.put("id", String.valueOf(new_id));
								fod.put("parent_id", String.valueOf(parent_id));
							} catch (Exception e) {
								conn.rollback();
								fod.put(CMSConstants.INSERT, "ko");
								strWarning = bundle.getString("msgSavingDataError");
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					} else {
						String strOrder = String.valueOf(Channel_mgr.fn_GetChildrensMaxOrder(Integer.parseInt(parent_id)) + 1);
						fod.put("order", strOrder);
					}
				}
			}// Fine crezione nuovo canale
			else if ("edit".equals(action)) {
				// Recupero il valore dell'ID del canale che si sta editando
				int id = Integer.parseInt(channel_id);

				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN) && !Channel_mgr.canEditChannel(channel_id, utente.getIdProfilo())) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

					// -----------------------------------------------------------------------
					// Modifica di un canale
					// -----------------------------------------------------------------------
					if (chkForm) {
						String strName = (String) fod.get("name");
						String strDescr = (String) fod.get("descr");
						String strBookmark = (String) fod.get("bookmark");
						String pageID = (String) fod.get("page_id");
						String onlinePreview = (String) fod.get("online_preview");
						String onlineProduz = (String) fod.get("online_produz");
						boolean bolOnlinePreview = onlinePreview != null ? true : false;
						boolean bolOnlineProduz = onlineProduz != null ? true : false;
						boolean bolWorkflow = false;
						Integer order = CMSUtilities.getInteger((String) fod.get("order"));
						String chaType = (String) fod.get("cha_type");
						String chaLink = (String) fod.get("cha_link");
						String chaRedirBook = (String) fod.get("redir_book");

						Channel cnlRedirBook = Channel_mgr.fn_GetChannelByBookmark(chaRedirBook, utente.getIdProfilo(), utente.getLanguage(), fod.get("preview") != null);

						String chaLevel = (String) fod.get("cha_level");
						String stringIsLink = (String) fod.get("link") != null ? (String) fod.get("link") : "0";
						boolean isLink = stringIsLink.equals("1") ? true : false;
						boolean isHome = fod.get("root") != null;
						boolean isHttps = fod.get("https") != null;
						boolean notInmap = fod.get("notinmap") != null;
						String chaPosition = (String) fod.get("cha_pos");
						String keywords = fod.get("keywords") != null ? (String) fod.get("keywords") : "";
						String key_desc = fod.get("key_desc") != null ? (String) fod.get("key_desc") : "";

						// Recupero lo stato delle checkBox dei profili
						Hashtable profiliView = new Hashtable();
						for (int i = 0; i < arrProfili.size(); i++) {
							String profilo = (String) arrProfili.get(i);
							String checkName = "chk_view_" + profilo;
							if (fod.get(checkName) != null) {
								fod.put(checkName, "checked");
								profiliView.put(profilo, "true");
							} else {
								profiliView.put(profilo, "false");
							}
						}

						// Recupero lo stato delle checkBox dei profili per la
						// visualizzazione
						Hashtable profiliEdit = new Hashtable();
						for (int i = 0; i < arrProfili.size(); i++) {
							String profilo = (String) arrProfili.get(i);
							String checkName = "chk_edit_" + profilo;
							if (fod.get(checkName) != null) {
								fod.put(checkName, "checked");
								profiliEdit.put(profilo, "true");
							} else {
								profiliEdit.put(profilo, "false");
							}
						}

						if (strName.trim().length() == 0)
							strWarning = bundle.getString("msgMFChannelName");
						else if (strDescr.trim().length() == 0)
							strWarning = bundle.getString("msgMFChannelTitle");
						else if (strName.length() > 50)
							strWarning = bundle.getString("msgWRNChannelNameLength");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNChannelDescrLength");
						else if (!"".equals(strBookmark.trim()) && Channel_mgr.fn_BookmarkExists(id, strBookmark, chaType))
							strWarning = bundle.getString("msgWRNBookmarkExist");
						else if ("2".equals((String) fod.get("link")) && chaRedirBook.trim().length() == 0)
							strWarning = bundle.getString("msgMFRedirectToBookmark");
						else if ("2".equals((String) fod.get("link")) && cnlRedirBook == null)
							strWarning = bundle.getString("msgWRNRedirectToBookmarkNotExist");
						else if ("0".equals(chaType))
							strWarning = bundle.getString("msgMFChannelGroup");
						else if ("0".equals(chaPosition))
							strWarning = bundle.getString("msgMFChannelPosition");
						else if (order == null)
							strWarning = bundle.getString("msgWRNIDNotNumber");
						else if (order.intValue() < 1)
							strWarning = bundle.getString("msgWRNIDNotValid");
						else if (!CMSUtilities.isIntValue(parent_id))
							strWarning = bundle.getString("msgWRNParentIDNotValid");
						else if (!CMSUtilities.isIntValue(pageID))
							strWarning = bundle.getString("msgWRNPageIDNotValid");
						else {
							if (isLink) {
								// Si sta modificando una funzione
								// ZZ Serve a non far perdere l'associazione con
								// la pagina
								// pageID = "0";

								// Aggiusto il link
								if (chaLink.indexOf("?") > 0) {
									chaLink += "&amp;channel_id=" + String.valueOf(channel_id);
								} else {
									chaLink += "?channel_id=" + String.valueOf(channel_id);
								}
							} else if ("2".equals((String) fod.get("link"))) {// <--
								// 2
								// 
								// il
								// valore
								// del
								// radio
								// Redirect
								// to
								// Bookmark
								chaLink = CMSServletWeb + "?channel_id=" + channel_id + "&cnl_id_redir=" + cnlRedirBook.getDBIndex();
								isLink = true;
							} else {
								// Devo gestire la creazione del link
								chaLink = CMSServletWeb + "?channel_id=" + channel_id;
							}

							Channel objChannel = new Channel(id, strName, strDescr, bolOnlinePreview, bolOnlineProduz, bolWorkflow, chaType, chaLink, isLink, isHome, isHttps, chaPosition, strBookmark, (chaParentLevel == 0) ? 0 : chaParentLevel + 1,
									keywords, key_desc, parameters);
							objChannel.setParentChannelID(Integer.parseInt(parent_id));
							objChannel.setChaLevel(Integer.parseInt(chaLevel));
							// if(Integer.parseInt(pageID) > 0)
							// {
							objChannel.setPageID(Integer.parseInt(pageID));
							// }
							objChannel.setOrder(order.intValue());
							objChannel.setNotInMap(notInmap);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								Channel_mgr.fn_UpdateChannel(conn, objChannel, logger);

								if (!isLink) {
									Page objPage = Page_mgr.fn_GetPageWithAlias(Integer.parseInt(pageID));
									objPage.setName(strName);
									objPage.setDescription(strDescr);
									Page_mgr.fn_UpdatePage(conn, objPage, logger);
								}

								if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
									// Soltanto gli EDITOR possono cambiare le
									// associazioni di visibilit ed editabilit
									// di un canale
									Group_mgr.fn_UpdateProfiliCanale(conn, id, profiliView, profiliEdit, logger);
								}

								conn.commit();
								fod.put(CMSConstants.UPDATE, "ok");
							} catch (Exception e) {
								conn.rollback();
								fod.put(CMSConstants.UPDATE, "ko");
								strWarning = bundle.getString("msgSavingDataError");
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					} else {
						// Sto aprendo la pagina di edit per la prima volta
						Channel objChannel = Channel_mgr.fn_GetChannel(id);
						fod.put("name", objChannel.getName());
						fod.put("descr", objChannel.getDescription());
						fod.put("bookmark", objChannel.getBookmark());
						fod.put("page_id", String.valueOf(objChannel.getPageID()));
						if (objChannel.isMIsOnlinePreview())
							fod.put("online_preview", "on");
						if (objChannel.isMIsOnlineProduz())
							fod.put("online_produz", "on");
						// if(objChannel.hasWorkflow())
						// fod.put("workflow", "on");
						fod.put("order", String.valueOf(objChannel.getOrder()));
						fod.put("cha_type", objChannel.getChaType());
						fod.put("keywords", objChannel.getKeywords());
						fod.put("key_desc", objChannel.getKeyDesc());

						// Elimino dal link le informazioni del channel_id
						String chaLink = objChannel.getChaLinkRelative();
						int pos = chaLink.indexOf("?channel_id=");
						int redir = chaLink.indexOf("&cnl_id_redir=");
						String chaRedirBook = "";
						if (redir > 0) {
							redir = redir + ("&cnl_id_redir=".length());
							chaRedirBook = Channel_mgr.fn_GetChannel(Integer.parseInt((chaLink.substring(redir)))).getBookmark();
						}
						if (pos > 0) {
							chaLink = chaLink.substring(0, pos);
						} else {
							pos = chaLink.indexOf("&amp;channel_id=");
							if (pos > 0) {
								chaLink = chaLink.substring(0, pos);
							}
						}
						fod.put("cha_link", chaLink);
						if (objChannel.isLink())
							fod.put("link", "checked");
						if (objChannel.isHome())
							fod.put("root", "checked");
						if (objChannel.isHttps())
							fod.put("https", "checked");
						if (objChannel.notInMap())
							fod.put("notinmap", "checked");
						fod.put("cha_pos", objChannel.getChaPosition());
						fod.put("redir_book", chaRedirBook);

						// Recupero i dati sulla visibilit del canale
						Hashtable profiliView = Group_mgr.fn_GetProfiliCanaleView(id);
						Enumeration en = profiliView.keys();
						while (en.hasMoreElements()) {
							String profilo = (String) en.nextElement();
							boolean checked = "true".equals((String) profiliView.get(profilo)) ? true : false;
							if (checked)
								fod.put("chk_view_" + profilo, "checked");
						}

						// Recupero i dati sulla editabilit del canale
						Hashtable profiliEdit = Group_mgr.fn_GetProfiliCanaleEdit(id);
						en = profiliEdit.keys();
						while (en.hasMoreElements()) {
							String profilo = (String) en.nextElement();
							boolean checked = "true".equals((String) profiliEdit.get(profilo)) ? true : false;
							if (checked)
								fod.put("chk_edit_" + profilo, "checked");
						}
					}
				}
			} else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un canale
				// -----------------------------------------------------------------------

				// Recupero il valore dell'ID del canale che si vuole cancellare
				int id = Integer.parseInt(channel_id);
				Channel objChannel = Channel_mgr.fn_GetChannel(id);

				// Controllo che l'utente sia un editor altrimenti non pu
				// cancellare il canale
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
					fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					return;
				}

				// Controllo che il canale non possieda dei sotto canali
				Vector childrens = Channel_mgr.fn_GetChildrens(id, false, false, "", "", "", "");
				if (childrens.size() > 0) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgWRNChannelNotRemove");
					fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					return;
				}

				fod.put("objChannel", objChannel);
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

				if (chkForm) {
					try {
						fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
						Channel_mgr.fn_DeleteChannel(id);
						fod.put(CMSConstants.DELETE, "ok");
					} catch (Exception e) {
						fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
						strWarning = bundle.getString("msgWRNChannelDelete");
					}
				}
			}// fine eliminazione di un canale
			else if ("copy".equals(action) || "move".equals(action)) {
				// -----------------------------------------------------------------------
				// Copia o spostamento di un canale
				// -----------------------------------------------------------------------

				// Metto in sessione il canale che sto per copiare o spostare
				// finch non riununcio o effettuo la copia / spostamento

				// Recupero il valore dell'ID del canale che si vuole copiare o
				// spostare
				int id = Integer.parseInt(channel_id);
				Channel ch_to_copy = Channel_mgr.fn_GetChannel(id);

				// Controllo che l'utente sia un editor altrimenti non pu
				// cancellare il canale
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
					fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					return;
				}

				session.setAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE, ch_to_copy);
				session.setAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE_ACTION, action);
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
			}// fine della copia o spostamento di un canale
			else if ("saveCopyMove".equals(action)) {
				// -----------------------------------------------------------------------
				// Esecuzione della copia o spostamento di un canale
				// -----------------------------------------------------------------------

				// Controllo che l'utente sia un editor altrimenti non pu
				// cancellare il canale
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
					fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					return;
				}

				// Non mi fido dell'oggetto in sessione e lo ricarico per
				// sicurezza dal DB usando l'ID
				Channel tmp = (Channel) session.getAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE);
				if (tmp == null) {
					// TODO ERRORE
				}
				Channel ch_to_move_copy = Channel_mgr.fn_GetChannel(tmp.getDBIndex());
				if (ch_to_move_copy == null) {
					// TODO ERRORE
				}

				// Se nel path di destinazione  gi compreso l'id del canale da
				// spostare o copiare  un errore

				int pid = Integer.parseInt(parent_id);
				Channel ch_parent = Channel_mgr.fn_GetChannel(pid);
				if (ch_parent != null) {
					Vector breadcrumbs = Channel_mgr.fn_GetBreadcrumbs(ch_parent.getDBIndex());
					if (breadcrumbs == null) {
						// TODO ERRORE
					}
					for (int i = 0; i < breadcrumbs.size(); i++) {
						tmp = (Channel) breadcrumbs.get(i);
						if (tmp != null && tmp.getDBIndex() == ch_to_move_copy.getDBIndex()) {
							// ERRORE
							if ("copy".equals(session.getAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE_ACTION))) {
								strWarning = bundle.getString("msgChannelCopyUnderItself");
							} else {
								strWarning = bundle.getString("msgChannelMoveUnderItself");
							}
							fod.put("parent_id", String.valueOf(parent_id));
							fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
							fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
							return;
						}
					}
				}

				// Riprendo dalla sessione l'azione "copy" o "move" e il canale
				if ("copy".equals(session.getAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE_ACTION))) {
					// Copia

					// Recupero il channel type del padre e il livello, in modo
					// che possano essere passati alla funzione che ricrea
					// ricorsivamente l'albero copiato
					int cha_level = 0;
					String cha_type = "";
					if (ch_parent == null) {
						cha_level = 0;
						cha_type = (String) fod.get("cha_type");
						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);
							ChannelType chTypes = ChanType_mgr.fn_GetChannelTypes(cha_type);
							chTypes.setChaTypeCrea(true);
							ChanType_mgr.fn_UpdateChanType(conn, chTypes, logger);
						} catch (Exception e) {
							conn.rollback();
							fod.put(CMSConstants.UPDATE, "ko");
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}
					} else {
						cha_level = ch_parent.getChaLevel() + 1;
						cha_type = ch_parent.getChaType();
					}
					ch_to_move_copy.setChaLevel(cha_level);
					ch_to_move_copy.setChaType(cha_type);
					ch_to_move_copy.setName(createLabelCopyNameChannel(bundle, cha_type, ch_to_move_copy));
					if (!"".equals(ch_to_move_copy.getBookmark()))
						ch_to_move_copy.setBookmark(createLabelCopyBookChannel(bundle, cha_type, ch_to_move_copy));

					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						createRecursiveChannelType(conn, bundle, ch_to_move_copy, pid, fod);

						conn.commit();
						fod.put(CMSConstants.UPDATE, "ok");
					} catch (Exception e) {
						conn.rollback();
						fod.put(CMSConstants.UPDATE, "ko");
						strWarning = bundle.getString("msgSavingDataError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}
					// \Copia
				} else if ("move".equals(session.getAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE_ACTION))) {/* TODO */
					// Sposta

					// Verifico che il channel type del canale parent sia uguale
					// a quello del canale spostato e che il livello del canale
					// parent +1 sia uguale al livello del canale spostato
					// Se SI aggiorno solo l'id del parent, se NO devo
					// aggiornare per tutto il sottoalbero anche il gruppo e/o
					// il livello
					int cha_level = 0;
					String cha_type = "";
					if (ch_parent == null) {
						cha_level = 0;
						cha_type = (String) fod.get("cha_type");
						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);
							ChannelType chTypes = ChanType_mgr.fn_GetChannelTypes(cha_type);
							chTypes.setChaTypeCrea(true);
							ChanType_mgr.fn_UpdateChanType(conn, chTypes, logger);
						} catch (Exception e) {
							conn.rollback();
							fod.put(CMSConstants.UPDATE, "ko");
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}
					} else {
						cha_level = ch_parent.getChaLevel() + 1;
						cha_type = ch_parent.getChaType();
					}
					if (!cha_type.equals(ch_to_move_copy.getChaType()) || (cha_level) != ch_to_move_copy.getChaLevel()) {

						if (!ch_to_move_copy.getChaType().equals(cha_type)) {
							// Trovo il bookmark del canale univoco
							String newName = ch_to_move_copy.getName();
							String newBookmark = ch_to_move_copy.getBookmark();
							if (!"".equals(newBookmark)) {
								newName = createLabelCopyNameChannel(bundle, cha_type, ch_to_move_copy);
								if (!"".equals(ch_to_move_copy.getBookmark()))
									newBookmark = createLabelCopyBookChannel(bundle, cha_type, ch_to_move_copy);
								ch_to_move_copy.setName(newName);
								ch_to_move_copy.setBookmark(newBookmark);
							}
						}

						ch_to_move_copy.setChaType(cha_type);
						ch_to_move_copy.setChaLevel(cha_level);
						// Aggiorno ricorsivamente il channel type
						Object[][] ch_tree = Channel_mgr.fn_GetChannelTree(ch_to_move_copy.getDBIndex(), -1, false, false, "", "", "", "");

						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);

							if (ch_tree != null) {
								updateRecursiveChannelType(conn, bundle, cha_level + 1, ch_tree, cha_type);
							}

							conn.commit();
							fod.put(CMSConstants.UPDATE, "ok");
						} catch (Exception e) {
							conn.rollback();
							fod.put(CMSConstants.UPDATE, "ko");
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}

					}

					// A questo punto non resta che aggiornare il parent
					// dell'oggetto channel con il parent_id e salvare nel
					// database

					ch_to_move_copy.setParentChannelID(pid);

					int order = Channel_mgr.fn_GetChildrensMaxOrder(ch_to_move_copy.getParentChannelID()) + 1;
					ch_to_move_copy.setOrder(order);

					if (ch_to_move_copy.getChaLevel() > 1)
						ch_to_move_copy.setChaPosition(Channel_mgr.fn_GetChannel(pid).getChaPosition());

					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						Channel_mgr.fn_UpdateChannel(conn, ch_to_move_copy, logger);
						if ("---".equals(ch_to_move_copy.getChaPosition()))
							Channel_mgr.fn_UpdateChannelsPosition(ch_to_move_copy, CMSConstants.MENU_HIDDEN, conn);

						conn.commit();
						fod.put(CMSConstants.UPDATE, "ok");
					} catch (Exception e) {
						conn.rollback();
						fod.put(CMSConstants.UPDATE, "ko");
						strWarning = bundle.getString("msgSavingDataError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}
					// \Sposta
				} else {
					// TODO Impossibile ERRORE
				}
				// Tolgo dalla sessione i dati ed esco
				session.removeAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE);
				session.removeAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE_ACTION);
				fod.put("parent_id", String.valueOf(parent_id));
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
			}// fine dell'esecuzione della copia o spostamento di un canale
			else if ("cancel".equals(action)) {
				// -----------------------------------------------------------------------
				// Annulla la copia o spostamento di un canale
				// -----------------------------------------------------------------------

				// Tolgo dalla sessione il canale che sto per copiare o spostare
				// finch non riununcio o effettuo la copia / spostamento

				// Controllo che l'utente sia un editor altrimenti non pu
				// cancellare il canale
				if (!utente.hasPolicy(CMSConstants.POLICY_ADMIN_CHANNELS_AND_PAGES) && !utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					strWarning = bundle.getString("msgAuthorizationErrorOperation");
					fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					return;
				}

				session.removeAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE);
				session.removeAttribute(CMSConstants.CHANNEL_TO_COPY_OR_MOVE_ACTION);
				fod.put("parent_id", String.valueOf(parent_id));
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
			} else {
				if (utente != null && utente.hasPolicy(CMSConstants.POLICY_ADMIN_AREA_ACCESS)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
				}
			}
			// Fine controllo della ACTION

			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}

	private void updateRecursiveChannelType(Connection conn, ResourceBundle bundle, int cha_level, Object[][] tree, String cha_type) throws Exception {
		// Aggiorno ricorsivamente il channel type
		for (int i = 0; i < tree[0].length; i++) {
			Channel ch = (Channel) tree[0][i];

			if (!ch.getChaType().equals(cha_type)) {
				// Trovo il bookmark del canale univoco
				String newName = ch.getName();
				String newBookmark = ch.getBookmark();
				if (!"".equals(newBookmark)) {
					newName = createLabelCopyNameChannel(bundle, cha_type, ch);
					if (!"".equals(ch.getBookmark()))
						newBookmark = createLabelCopyBookChannel(bundle, cha_type, ch);
					ch.setName(newName);
					ch.setBookmark(newBookmark);
				}
			}

			ch.setChaType(cha_type);
			ch.setChaLevel(cha_level);
			Channel_mgr.fn_UpdateChannel(conn, ch, logger);
			if (logger.isInfoEnabled())
				logger.info("AGGIORNO canale id=" + ch.getDBIndex() + " ch=" + ch.getName() + " type=" + ch.getChaType() + "\n");
		}

		for (int j = 0; j < tree[1].length; j++) {
			if (tree[1][j] != null) {
				Object[][] subtree = (Object[][]) tree[1][j];
				updateRecursiveChannelType(conn, bundle, cha_level + 1, subtree, cha_type);
			}
		}
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	private void createRecursiveChannelType(Connection conn, ResourceBundle bundle, Channel root, int pid, Hashtable fod) throws Exception {
		// Ricreo il channel root come figlio di pid
		// Trovo il nome del canale univoco
		String cha_type = root.getChaType();
		String strWarning = "";

		// Trovo il bookmark del canale univoco
		String newName = root.getName();
		String newBookmark = root.getBookmark();
		if (!"".equals(newBookmark)) {
			newName = createLabelCopyNameChannel(bundle, cha_type, root);
			if (!"".equals(root.getBookmark()))
				newBookmark = createLabelCopyBookChannel(bundle, cha_type, root);
		}
		Channel newRoot = new Channel(pid, newName, root.getDescription(), root.isMIsOnlinePreview(), root.isMIsOnlineProduz(), root.hasWorkflow(), root.getChaType(), root.getChaLinkRelative(), root.isLink(), root.isHome(), root.isHttps(), root
				.getChaPosition(), newBookmark, root.getChaLevel(), root.getKeywords(), root.getKeyDesc(), parameters);
		if (logger.isInfoEnabled())
			logger.info("CREO la copia del canale id=" + root.getDBIndex() + " ch=" + root.getName() + " type=" + root.getChaType() + "\n");

		int order = Channel_mgr.fn_GetChildrensMaxOrder(newRoot.getParentChannelID()) + 1;
		newRoot.setOrder(order);

		newRoot.setNotInMap(root.notInMap());

		if (root.getChaLevel() > 1)
			newRoot.setChaPosition("---");

		int newIdChannel = Channel_mgr.fn_CreateChannel(conn, newRoot, logger, true);
		newRoot.setDBIndex(newIdChannel);

		if ("---".equals(newRoot.getChaPosition())) {
			Channel_mgr.fn_UpdateChannelsPosition(newRoot, CMSConstants.MENU_HIDDEN, conn);
			newRoot.setChaPosition(CMSConstants.MENU_HIDDEN);
		}

		// se ha una pagina associata (anzich un link) va ricreata
		if (!root.isLink() && root.hasPage()) {
			Page objPage = Page_mgr.fn_GetPageWithAlias(root.getPageID());
			if (objPage != null) {
				objPage.setName(newName);
				try {
					int newIdPage = Page_mgr.fn_CreatePage(conn, objPage, logger);
					Page_mgr.fn_SetPageTic(conn, newIdPage, Page_mgr.fn_GetPageTic(objPage.getDBIndex()), logger);

					newRoot.setPageID(newIdPage);
					newRoot.setLink(false);
					FwGenericServlet servlet = ((FwGenericServlet) fod.get(FwGenericServlet.SERVLET_FOD_LABEL));
					String CMSServletWeb = servlet.getServletConfig().getServletContext().getInitParameter(CMSConstants.CMS_SERVLET_WEB);
					newRoot.setChaLink(CMSServletWeb + "?channel_id=" + newRoot.getDBIndex(), parameters);

					Channel_mgr.fn_UpdateChannel(conn, newRoot, logger);
				} catch (Exception e) {
					conn.rollback();
				}
				fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
			}
		}

		// Riassegnazione stessi diritti di visualizzazione ai profili
		Group_mgr.fn_CreateProfiliCanale(conn, newIdChannel, Group_mgr.fn_GetProfiliCanaleView(root.getDBIndex()), Group_mgr.fn_GetProfiliCanaleEdit(root.getDBIndex()), logger);

		// Richiamo la creazione ricorsiva di ogni figlio di root
		Object[][] tree = Channel_mgr.fn_GetChannelTree(root.getDBIndex(), -1, false, false, "", "", "", "");

		if (tree != null) {
			for (int i = 0; i < tree[0].length; i++) {
				Channel ch = (Channel) tree[0][i];
				ch.setChaLevel(root.getChaLevel() + 1);
				ch.setChaType(root.getChaType());
				createRecursiveChannelType(conn, bundle, ch, newIdChannel, fod);
			}
		}
	}

	private String createLabelCopyNameChannel(ResourceBundle bundle, String cha_type, Channel cnl) throws Exception {
		int i = 1;
		String namePrefix = bundle.getString("lblPrefixCopy");
		String newName = cnl.getName();
		if (Channel_mgr.fn_ChannelExists(0, newName, cha_type))
			newName = namePrefix + " " + cnl.getName();
		while (Channel_mgr.fn_ChannelExists(0, newName, cha_type)) {
			newName = namePrefix + " " + i + " " + cnl.getName();
			i++;
		}
		return newName;
	}

	private String createLabelCopyBookChannel(ResourceBundle bundle, String cha_type, Channel cnl) throws Exception {
		int i = 1;
		String bookNamePrefix = bundle.getString("lblPrefixCopy").toUpperCase();
		String newBookmark = cnl.getBookmark();
		if (Channel_mgr.fn_BookmarkExists(0, newBookmark, cha_type))// ... ed
			// esiste
			// gi metto
			// il
			// prefisso
			newBookmark = bookNamePrefix + " " + cnl.getBookmark();
		while (Channel_mgr.fn_BookmarkExists(0, newBookmark, cha_type)) {
			newBookmark = bookNamePrefix + " " + i + " " + cnl.getBookmark();
			i++;
		}
		return newBookmark;
	}
}