/*
 * Created on 21-mar-2005
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 */
public class CMSContentsIV extends InputValidator {
	
	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			String strWarning = "";

			Locale currentLocale = null;
			Utente utente = (Utente) session.getUser();
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			String action = (String) fod.get("action");
			String hourValid = fod.get("hourValid") == null ? "" : (String) fod.get("hourValid");
			String minutesValid = fod.get("minutesValid") == null ? "" : (String) fod.get("minutesValid");
			String hourExpirity = fod.get("hourExpirity") == null ? "" : (String) fod.get("hourExpirity");
			String minutesExpirity = fod.get("minutesExpirity") == null ? "" : (String) fod.get("minutesExpirity");
			String dateValid = fod.get("date_valid") == null ? "" : (String) fod.get("date_valid");
			String dateExpiry = fod.get("date_expiry") == null ? "" : (String) fod.get("date_expiry");

			if (dateValid.length() > 10)
				dateValid = dateValid.substring(0, 10);
			if (dateExpiry.length() > 10)
				dateExpiry = dateExpiry.substring(0, 10);

			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			if (chkForm && ("new".equals(action) || "edit".equals(action))) {
				if (!"".equals(dateValid)) {
					if (!"".equals(hourValid.trim())) {
						try {
							if (Integer.parseInt(hourValid) > 23)
								strWarning = bundle.getString("msgWRNContentHourStartValid");
							else
								hourValid = (Integer.parseInt(hourValid) < 10 ? "0" : "") + Integer.parseInt(hourValid);
						} catch (NumberFormatException e) {
							strWarning = bundle.getString("msgWRNContentHourStartNamber");
						}
					} else {
						hourValid = "00";
					}
					if (!"".equals(minutesValid.trim())) {
						try {
							if (Integer.parseInt(minutesValid) > 59)
								strWarning = bundle.getString("msgWRNContentHourEndValid");
							else
								minutesValid = (Integer.parseInt(minutesValid) < 10 ? "0" : "") + Integer.parseInt(minutesValid);
						} catch (NumberFormatException e) {
							strWarning = bundle.getString("msgWRNContentHourEndNamber");
						}
					} else {
						minutesValid = "00";
					}
				}
				if (!"".equals(dateExpiry)) {
					if (!"".equals(hourExpirity.trim())) {
						try {
							if (Integer.parseInt(hourExpirity) > 23)
								strWarning = bundle.getString("msgWRNContentMinutesStartValid");
							else
								hourValid = (Integer.parseInt(hourValid) < 10 ? "0" : "") + Integer.parseInt(hourValid);
						} catch (NumberFormatException e) {
							strWarning = bundle.getString("msgWRNContentMinutesStartNamber");
						}
					} else {
						hourExpirity = "00";
					}
					if (!"".equals(minutesExpirity.trim())) {
						try {
							if (Integer.parseInt(minutesExpirity) > 59)
								strWarning = bundle.getString("msgWRNContentMinutesEndValid");
							else
								minutesExpirity = (Integer.parseInt(minutesExpirity) < 10 ? "0" : "") + Integer.parseInt(minutesExpirity);
						} catch (NumberFormatException e) {
							strWarning = bundle.getString("msgWRNContentMinutesEndNamber");
						}
					} else {
						minutesExpirity = "00";
					}
				}

				fod.put("hourValid", hourValid);
				fod.put("minutesValid", minutesValid);
				fod.put("hourExpirity", hourExpirity);
				fod.put("minutesExpirity", minutesExpirity);

				fod.put("date_valid", dateValid);
				fod.put("date_expiry", dateExpiry);
			}

			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
			fod.put("request", request);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}
}
