/*
 * Created on 21-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.ExtAlias;
import it.softecspa.jwebber.common.classes.ExtAliasMetadata;
import it.softecspa.jwebber.common.classes.ExtensionType;
import it.softecspa.jwebber.common.modules.ExtType_mgr;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSExtTypesIV extends InputValidator {
	
	private int new_order = 0;

	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;
			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";
			String strName = "";
			String strDescr = "";
			Vector arrAliasUsed = null;
			Vector arrAliasAvail = null;

			if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di un nuovo tipo di estensione
				// -----------------------------------------------------------------------
				if (chkForm) {
					strName = ((String) fod.get("name")).trim();
					strDescr = ((String) fod.get("descr")).trim();

					arrAliasUsed = fn_getUsedAliasFromRequestEdit(request);
					int alias_sel = Integer.parseInt((String) fod.get("alias_sel"));
					int chkIndex = Integer.parseInt((String) fod.get("chkIndex"));

					if ("aliasAdd".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_AddAliasToArrayEdit(alias_sel, arrAliasUsed, new_order);
						new_order++;
					} else if ("aliasRemove".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_RemoveAliasFromArrayEdit(chkIndex, arrAliasUsed);
						new_order--;
					} else if ("aliasMoveDown".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_MoveAliasDown(chkIndex, arrAliasUsed);
					} else if ("aliasMoveUp".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_MoveAliasUp(chkIndex, arrAliasUsed);
					} else {
						String strAliasOk = "";

						Enumeration en = request.getParameterNames();
						while (en.hasMoreElements()) {
							String elem = (String) en.nextElement();
							String value = (String) request.getParameter(elem);
							if (elem.indexOf("aliasval_") == 0) {
								String[] arrName = elem.split("_");
								if (arrName.length == 4) {
									if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[2])) {
										if ("".equals(value.trim())) {
											int index = Integer.parseInt(arrName[2]);
											strAliasOk = "Alias " + String.valueOf(index + 1);
											break;
										}
									}
								}
							}
						}

						if (strName.length() == 0)
							strWarning = bundle.getString("msgMFExtensionTypeName");
						else if (strName.length() > 50)
							strWarning = bundle.getString("msgWRNExtensionTypeNameLength");
						else if (ExtType_mgr.fn_ExtensionTypeExists(0, strName))
							strWarning = bundle.getString("msgWRNExtensionTypeNameExist");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNExtensionTypeDescrLength");
						else if (new_order == 0)
							strWarning = bundle.getString("msgWRNContentTypeAlias");
						else if (strAliasOk.length() > 0)
							strWarning = CMSUtilities.fn_StringFormatter(bundle.getString("msgMFAliasName"), strAliasOk);
						else {
							ExtensionType objExtType = new ExtensionType(0, strName, strDescr);
							objExtType.setAliasList(arrAliasUsed);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								ExtType_mgr.fn_CreateExtensionType(conn, objExtType, logger);
								fod.put(CMSConstants.INSERT, "ok");

								conn.commit();
							} catch (Exception e) {
								strWarning = bundle.getString("msgDatabaseSaveError");
								conn.rollback();
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					}
				} else {
					arrAliasUsed = new Vector();
				}

				arrAliasAvail = ExtType_mgr.fn_GetAvailableAliasEdit(arrAliasUsed);

				fod.put("name", strName);
				fod.put("descr", strDescr);
				fod.put("arrAliasUsed", arrAliasUsed);
				fod.put("arrAliasAvail", arrAliasAvail);
			}// Fine creazione nuovo tipo contenuto
			else if ("edit".equals(action)) {
				// -----------------------------------------------------------------------
				// Modifica di un tipo di estensione
				// -----------------------------------------------------------------------

				// Recupero l'ID del tipo contenuto
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				ExtensionType objExtType = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati del tipo estensione
					numDBIndex = Integer.parseInt(id);
					objExtType = ExtType_mgr.fn_GetExtensionType(numDBIndex);

					if (objExtType == null) {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					}
				}

				if (chkForm) {
					// Gestione di un postBack

					strName = ((String) fod.get("name")).trim();
					strDescr = ((String) fod.get("descr")).trim();

					arrAliasUsed = fn_getUsedAliasFromRequestEdit(request);
					int alias_sel = Integer.parseInt((String) fod.get("alias_sel"));
					int chkIndex = Integer.parseInt((String) fod.get("chkIndex"));

					if ("aliasAdd".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_AddAliasToArrayEdit(alias_sel, arrAliasUsed, new_order);
						new_order++;
					} else if ("aliasRemove".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_RemoveAliasFromArrayEdit(chkIndex, arrAliasUsed);
						new_order--;
					} else if ("aliasMoveDown".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_MoveAliasDown(chkIndex, arrAliasUsed);
					} else if ("aliasMoveUp".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = ExtType_mgr.fn_MoveAliasUp(chkIndex, arrAliasUsed);
					} else {
						String strAliasOk = "";

						Enumeration en = request.getParameterNames();
						while (en.hasMoreElements()) {
							String elem = (String) en.nextElement();
							String value = (String) request.getParameter(elem);
							if (elem.indexOf("aliasval_") == 0) {
								String[] arrName = elem.split("_");
								if (arrName.length == 4) {
									if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[2])) {
										if ("".equals(value.trim())) {
											int index = Integer.parseInt(arrName[2]);
											strAliasOk = "Alias " + String.valueOf(index + 1);
											break;
										}
									}
								}
							}
						}

						if (strName.length() == 0)
							strWarning = bundle.getString("msgMFExtensionTypeName");
						else if (strName.length() > 50)
							strWarning = bundle.getString("msgWRNExtensionTypeNameLength");
						else if (strDescr.length() > 255)
							strWarning = bundle.getString("msgWRNExtensionTypeDescrLength");
						else if (arrAliasUsed.size() == 0)
							strWarning = bundle.getString("msgWRNContentTypeAlias");
						else if (strAliasOk.length() > 0)
							strWarning = CMSUtilities.fn_StringFormatter(bundle.getString("msgMFAliasName"), strAliasOk);
						else {
							objExtType.setName(strName);
							objExtType.setDescription(strDescr);
							// objExtType.setWorkflow(bolWorkflow);
							objExtType.setAliasList(arrAliasUsed);

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								ExtType_mgr.fn_UpdateExtensionType(conn, objExtType, logger);
								// Group_mgr.fn_UpdateProfiliTipoContenuto(conn,
								// numDBIndex, profiliEdit, logger);
								fod.put(CMSConstants.UPDATE, "ok");

								conn.commit();
							} catch (Exception e) {
								strWarning = bundle.getString("msgDatabaseSaveError");
								conn.rollback();
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					}
				} else {
					strName = objExtType.getName();
					strDescr = objExtType.getDescription();
					arrAliasUsed = objExtType.getAliasList();

					new_order = 0;
					for (int i = 0; i < arrAliasUsed.size(); i++) {
						if (!"".equals(((ExtAlias) arrAliasUsed.get(i)).getValue()))
							new_order++;
					}
				}

				arrAliasAvail = ExtType_mgr.fn_GetAvailableAliasEdit(arrAliasUsed);

				fod.put("name", strName);
				fod.put("descr", strDescr);
				// if(bolWorkflow)
				// fod.put("workflow", "checked");
				fod.put("arrAliasUsed", arrAliasUsed);
				fod.put("arrAliasAvail", arrAliasAvail);

			} // Fine modifica di un tipo contenuto
			else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un tipo estensione
				// -----------------------------------------------------------------------

				// Recupero l'ID del tipo contenuto
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				ExtensionType objExtType = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati della pagina
					numDBIndex = Integer.parseInt(id);
					objExtType = ExtType_mgr.fn_GetExtensionType(numDBIndex);
					if (objExtType == null) {
						// fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
						fod.put(CMSConstants.WARNING_MESSAGE, bundle.getString("msgWRNExtensionNotExist"));
						return;
					}
				} else {
					// fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
					fod.put(CMSConstants.WARNING_MESSAGE, bundle.getString("msgWRNExtensionNotExist"));
					return;
				}

				fod.put("numDBIndex", id);

				if (chkForm) {
					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						if (ExtType_mgr.fn_DeleteExtensionType(conn, objExtType.getDBIndex())) {
							fod.put(CMSConstants.DELETE, "ok");
						}

						conn.commit();
					} catch (Exception e) {
						conn.rollback();
						strWarning = bundle.getString("msgDatabaseSaveError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}
				} else {
					fod.put("objExtType", objExtType);
				}

			} // Fine eliminazione di un tipo contenuto
			else {

			}
			// Fine controllo della ACTION

			// Paasso alla jsp il numero di campi definiti nel tipo contenuto
			fod.put("field_count", String.valueOf(new_order));
			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}

	/**
	 * Recupera dalla Request l'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias gi
	 *         utilizzati (oggetti di classe CntAlias).
	 */
	@SuppressWarnings("unchecked")
	private Vector fn_getUsedAliasFromRequestEdit(HttpServletRequest request) {
		Vector arrAliasUsed = new Vector();

		ExtAliasMetadata objAliasMD = new ExtAliasMetadata();

		// Creo l'elenco di tutti gli alias vuoti
		for (int i = 0; i < objAliasMD.getMaxSize(); i++) {
			for (int j = 0; j < objAliasMD.getMaxCount(i); j++) {
				ExtAlias objAlias = new ExtAlias(i, objAliasMD.getName(i), "", 0, false);
				arrAliasUsed.add(objAlias);
			}
		}

		new_order = 0;
		Enumeration en = request.getParameterNames();
		while (en.hasMoreElements()) {
			String elem = (String) en.nextElement();
			String value = (String) request.getParameter(elem);
			if (elem.indexOf("aliasval_") == 0) {
				String[] arrName = elem.split("_");
				if (arrName.length == 4) {
					new_order++;
					if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[3])) {
						String check = elem.replaceFirst("aliasval_", "aliascheck_");
						boolean checked = (request.getParameter(check) != null && !"".equals(request.getParameter(check))) ? true : false;
						ExtAlias objAlias = new ExtAlias(Integer.parseInt(arrName[3]), objAliasMD.getName(Integer.parseInt(arrName[3])), "".equals(value) ? " " : value, Integer.parseInt(arrName[2]), checked);
						arrAliasUsed.set(Integer.parseInt(arrName[1]), objAlias);
					}
				}
			}
		}

		return arrAliasUsed;
	}
}
