package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.Policy;
import it.softecspa.jwebber.common.modules.Group_mgr;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

public class CMSPoliciesIV extends InputValidator {
	
	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			String id_policy = "";
			String description = "";

			// Recupero tutte le policies definite a db
			Vector arrPolicies = Group_mgr.fn_GetPolicies();
			fod.put("policies", arrPolicies);

			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";

			if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di una nuova policy
				// -----------------------------------------------------------------------
				if (chkForm) {
					id_policy = (String) fod.get("policy");
					description = (String) fod.get("descr");

					if (id_policy.length() == 0)
						strWarning = bundle.getString("msgMFPolicyName");
					else {
						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);

							Group_mgr.fn_CreatePolicy(conn, id_policy, description, logger);

							conn.commit();
							fod.put(CMSConstants.INSERT, "ok");
						} catch (Exception e) {
							conn.rollback();
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}

					}
				}
			} else if ("edit".equals(action)) {

				id_policy = (String) fod.get("policy");

				if (chkForm) {
					String newPolicy = (String) fod.get("newPolicy");
					description = (String) fod.get("descr");

					if (newPolicy.length() == 0)
						strWarning = bundle.getString("msgMFPolicyName");
					else {
						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);

							Group_mgr.fn_UpdatePolicy(conn, id_policy, newPolicy, description, logger);

							conn.commit();
							fod.put(CMSConstants.UPDATE, "ok");
						} catch (Exception e) {
							conn.rollback();
							strWarning = bundle.getString("ERRORE_SALVATAGGIO");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}
					}
				} else {
					// Recupero i dati del template
					Policy p = Group_mgr.fn_GetPolicy(id_policy);

					if (p == null) {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					} else {
						fod.put("descr", p.getDescription() == null ? "" : p.getDescription());
					}

				}

			} // Fine modifica di un profilo
			else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un profilo
				// -----------------------------------------------------------------------

				id_policy = (String) fod.get("policy");

				Vector profili = null;

				if (id_policy == null) {
					fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
					return;
				} else {
					// profili che sono associati alla policy
					profili = Group_mgr.fn_GetPoliciesProfile(id_policy);
					fod.put("profiliAssociati", profili);
				}

				if (chkForm) {
					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						Group_mgr.fn_DeletePolicy(conn, id_policy, logger);
						fod.put(CMSConstants.DELETE, "ok");

						conn.commit();
					} catch (Exception e) {
						conn.rollback();
						strWarning = bundle.getString("msgSavingDataError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}

				}
			} // Fine eliminazione di un profilo
			else {
			}
			// Fine controllo della ACTION

			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}
}
