/*
 * Created on 21-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.Policy;
import it.softecspa.jwebber.common.classes.ProfiloUtente;
import it.softecspa.jwebber.common.modules.Group_mgr;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSProfilesIV extends InputValidator {
	
	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			String strProfilo = "";
			String strDescr = "";

			// Recupero tutte le policies definite a db
			Vector arrPolicies = Group_mgr.fn_GetPolicies();
			fod.put("policies", arrPolicies);

			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";

			if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di un nuovo profilo
				// -----------------------------------------------------------------------
				if (chkForm) {
					strProfilo = (String) fod.get("profilo");
					strDescr = (String) fod.get("descr");

					// Recupero lo stato delle checkBox delle policies
					Hashtable policies = new Hashtable();
					for (int i = 0; i < arrPolicies.size(); i++) {
						Policy p = (Policy) arrPolicies.get(i);
						String checkName = "chk_edit_" + p.getPolicy();
						if (fod.get(checkName) != null) {
							fod.put(checkName, "checked");
							policies.put(p.getPolicy(), "true");
						} else {
							policies.put(p.getPolicy(), "false");
						}
					}

					if (strProfilo.length() == 0)
						strWarning = bundle.getString("msgMFProfileName");
					else if (strProfilo.length() > 20)
						strWarning = bundle.getString("msgWRNProfileNameLength");
					else if (Group_mgr.fn_ExistsProfile(strProfilo))
						strWarning = bundle.getString("msgWRNProfileExist");
					else if (strDescr.length() > 255)
						strWarning = bundle.getString("msgWRNChannelDescrLength");
					else {
						ProfiloUtente objProfile = new ProfiloUtente(strProfilo, strDescr);

						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);

							Group_mgr.fn_CreateProfile(conn, objProfile, logger);
							Group_mgr.fn_CreatePoliciesProfile(conn, strProfilo, policies, logger);

							conn.commit();
							fod.put(CMSConstants.INSERT, "ok");
						} catch (Exception e) {
							conn.rollback();
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}

					}
				} else {
				}
			}// Fine creazione nuovo profilo
			else if ("edit".equals(action)) {
				// -----------------------------------------------------------------------
				// Modifica dei dati di un profilo
				// -----------------------------------------------------------------------

				// Recupero l'ID del profilo
				String id = (String) fod.get("id");

				ProfiloUtente objProfile = null;

				// Recupero i dati del template
				objProfile = Group_mgr.fn_GetProfilo(id);

				if (objProfile == null) {
					fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
					return;
				}

				fod.put("objProfile", objProfile);

				if (chkForm) {
					strProfilo = (String) fod.get("profilo");
					strDescr = (String) fod.get("descr");

					// Recupero lo stato delle checkBox delle policies
					Hashtable policies = new Hashtable();
					for (int i = 0; i < arrPolicies.size(); i++) {
						Policy p = (Policy) arrPolicies.get(i);
						String checkName = "chk_edit_" + p.getPolicy();
						if (fod.get(checkName) != null) {
							fod.put(checkName, "checked");
							policies.put(p.getPolicy(), "true");
						} else {
							policies.put(p.getPolicy(), "false");
						}
					}
					if (strProfilo.length() == 0)
						strWarning = bundle.getString("msgMFProfileName");
					else if (strProfilo.length() > 20)
						strWarning = bundle.getString("msgWRNProfileNameLength");
					else if (strDescr.length() > 255)
						strWarning = bundle.getString("msgWRNChannelDescrLength");
					else {
						objProfile.setDersc(strDescr);

						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);

							Group_mgr.fn_UpdateProfile(conn, objProfile, logger);
							Group_mgr.fn_UpdatePoliciesProfile(conn, strProfilo, policies, logger);

							conn.commit();
							fod.put(CMSConstants.UPDATE, "ok");
						} catch (Exception e) {
							conn.rollback();
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}
					}
				} else {
					// L'utente viene caricato per la prima volta
					fod.put("profilo", objProfile.getIdProfilo());
					fod.put("descr", objProfile.getDescr());

					// Recupero i dati sulle policies associate al profilo
					Hashtable policies = Group_mgr.fn_GetProfilePolicies(id);
					Enumeration en = policies.keys();
					while (en.hasMoreElements()) {
						String policy = (String) en.nextElement();
						boolean checked = "true".equals((String) policies.get(policy)) ? true : false;
						if (checked)
							fod.put("chk_edit_" + policy, "checked");
					}
				}

			} // Fine modifica di un profilo
			else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un profilo
				// -----------------------------------------------------------------------

				// Recupero l'ID del profilo
				String id = (String) fod.get("id");
				ProfiloUtente objProfile = null;

				objProfile = Group_mgr.fn_GetProfilo(id);

				if (objProfile == null) {
					fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
					return;
				}

				fod.put("objProfile", objProfile);

				fod.put("numDBIndex", id);

				if (chkForm) {
					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						if (Group_mgr.fn_DeleteProfile(conn, objProfile, logger)) {
							fod.put(CMSConstants.DELETE, "ok");
						} else {
							strWarning = bundle.getString("msgDeleteProfileError");
						}

						conn.commit();
					} catch (Exception e) {
						conn.rollback();
						strWarning = bundle.getString("msgSavingDataError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}

				}
			} // Fine eliminazione di un profilo
			else {
			}
			// Fine controllo della ACTION

			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}
}
