package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;
import it.softecspa.portal.Bundle;
import it.softecspa.task.DBTask;
import it.softecspa.task.TaskManager;
import it.softecspa.task.WebTimerTask;

import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

public class CMSTasksIV extends InputValidator {

	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";
			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			String idTask = fod.get("idTask") == null ? "0" : (String) fod.get("idTask");
			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;
			Hashtable<String, WebTimerTask> allThreads = TaskManager.getInstance().getAllThreads();

			Utente user = (Utente) session.getUser();
			ResourceBundle bundle = Bundle.getInstance().getBundle(user);

			WebTimerTask timerTask = null;
			try {
				if ("start".equals(action)) {
					timerTask = allThreads.get(idTask);
					if (timerTask.isScheduled()) {
						strWarning = bundle.getString("msgWRNTaskAlreadyScheduled");
					} else {

						Class c = timerTask.getClass();
						WebTimerTask newTimerTask = (WebTimerTask) c.newInstance();
						newTimerTask.setDbTask(timerTask.getDbTask());
						newTimerTask.readParams(timerTask.getDbTask().getParamString());

						Timer timer = new Timer(true);
						long delay = timerTask.getDbTask().getDelay();
						if (timerTask.getDbTask().getRate() >= 0) {
							timer.scheduleAtFixedRate(newTimerTask, delay, timerTask.getDbTask().getRate() * 60000);
						} else {
							timer.schedule(newTimerTask, delay);
						}
						newTimerTask.setScheduled(timer);
						
						newTimerTask.setDbTask(timerTask.getDbTask());
						TaskManager.getInstance().getAllThreads().put(idTask, newTimerTask);
					}
				} else if ("stop".equals(action)) {
					timerTask = (WebTimerTask) allThreads.get(idTask);
					if (!timerTask.isScheduled()) {
						strWarning = bundle.getString("msgWRNTaskAlreadyDeleted");
					} else {
						timerTask.cancelScheduling();
						// Azzero il next run at
						timerTask.getDbTask().resetNextRunAt();
						TaskManager.getInstance().getAllThreads().put(idTask, timerTask);
					}
				} else if ("delete".equals(action)) {
					if (chkForm) {
						DBTask dbTask = new DBTask(Integer.parseInt(idTask));
						if (dbTask != null) {
							dbTask.delete(DatabaseManager.getInstance().getCMSConnectionManager());
							TaskManager.getInstance().getAllThreads().remove(String.valueOf(dbTask.getIdTask()));
						}
					}
				} else {
					DBTask[] arrTaskClasses = DBTask.getTaskClasses();
					fod.put("arrTaskClasses", arrTaskClasses);

					DBTask dbTask = new DBTask();
					if (chkForm) {
						String idTaskClass = (String) fod.get("idTaskClass");
						boolean runOnStartup = ("1".equals((String) fod.get("runOnStartup"))) ? true : false;
						String hour = fod.get("hour") == null ? "" : (String) fod.get("hour");
						String minutes = fod.get("minutes") == null ? "" : (String) fod.get("minutes");
						String day = fod.get("day") == null ? "0" : (String) fod.get("day");
						String rate = (String) fod.get("rate");
						String paramString = fod.get("paramString") == null ? "" : (String) fod.get("paramString");
						String description = fod.get("description") == null ? "" : (String) fod.get("description");

						boolean isNotify = ("1".equals((String) fod.get("isNotify"))) ? true : false;
						String notifyEmail = fod.get("notifyEmail") == null ? "" : (String) fod.get("notifyEmail");
						String notifySubject = fod.get("notifySubject") == null ? "" : (String) fod.get("notifySubject");
						String notifyMessage = fod.get("notifyMessage") == null ? "" : (String) fod.get("notifyMessage");
						boolean isStackTrace = ("1".equals((String) fod.get("isStackTrace"))) ? true : false;

						dbTask.setIdTaskClass(Integer.parseInt(idTaskClass));
						dbTask.setRunOnStartup(runOnStartup);
						if (!hour.trim().equals("") && !minutes.trim().equals("")) {
							dbTask.setHour(hour + ":" + minutes);
						}
						if (hour.trim().equals("") && minutes.trim().equals("")) {
							dbTask.setHour("");
						}
						dbTask.setDay(day);
						dbTask.setParamString(paramString);
						if (rate.trim().length() > 0)
							dbTask.setRate(Long.parseLong(rate));
						dbTask.setTaskDesc(description);

						dbTask.setNotify(isNotify);
						dbTask.setNotifyEmail(notifyEmail);
						dbTask.setNotifySubject(notifySubject);
						dbTask.setNotifyMessage(notifyMessage);
						dbTask.setStackTrace(isStackTrace);

						if ("edit".equals(action)) {
							dbTask.setIdTask(Integer.parseInt(idTask));
							strWarning = validForm(dbTask, bundle, fod);

							if (!"".equals(strWarning)) {
								fod.put("dbTask", dbTask);
								fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
								return;
							}

							if (dbTask != null) {
								dbTask.update(DatabaseManager.getInstance().getCMSConnectionManager());
								timerTask = (WebTimerTask) allThreads.get(idTask);
								timerTask.setDbTask(dbTask);
								TaskManager.getInstance().getAllThreads().put(String.valueOf(idTask), timerTask);
							}
						} else if ("new".equals(action)) {
							int intIdTask = DBTask.getNextId();
							dbTask.setIdTask(intIdTask);

							strWarning = validForm(dbTask, bundle, fod);

							if (!"".equals(strWarning)) {
								fod.put("dbTask", dbTask);
								fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
								return;
							}

							if (dbTask != null) {
								dbTask.insert(DatabaseManager.getInstance().getCMSConnectionManager());
								String className = DBTask.getTaskClassesById(Integer.parseInt(idTaskClass))[0].getClassName();
								Class c = Class.forName(className);
								timerTask = (WebTimerTask) c.newInstance();
								timerTask.setDbTask(dbTask);
								timerTask.readParams(dbTask.getParamString());
								timerTask.setScheduled(null);
								TaskManager.getInstance().getAllThreads().put(String.valueOf(intIdTask), timerTask);
							}
						}
					} else {
						if ("edit".equals(action))
							dbTask = new DBTask(Integer.parseInt(idTask));
						if ("new".equals(action))
							dbTask.setStackTrace(true);
					}
					fod.put("dbTask", dbTask);
				}
			} catch (IllegalStateException e) {
				strWarning = bundle.getString("msgWRNTaskStateError");
				if (!idTask.equals("0")) {
					DBTask dbTask = new DBTask(Integer.parseInt(idTask));
					Class c = Class.forName(dbTask.getClassName());
					timerTask = (WebTimerTask) c.newInstance();
					timerTask.readParams(dbTask.getParamString());
					Thread.sleep(3000);
					// InitWebApp.getTaskManager().getAllThreads().put(idTask,
					// timerTask);
				}
			}
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}

	@SuppressWarnings("unchecked")
	public static String validForm(DBTask dbTask, ResourceBundle bundle, Hashtable fod) {
		String strWarning = "";

		if (dbTask.getIdTaskClass() == 0) {
			strWarning = bundle.getString("msgMFTask");
		} else if (dbTask.getRate() == 0) {
			strWarning = bundle.getString("msgMFTaskRate");
		} else if (dbTask.isNotify()) {
			String strNotifyEmail = dbTask.getNotifyEmail().trim();
			if (strNotifyEmail.equals("")) {
				return strWarning = bundle.getString("msgMFNotifyEmail");
			} else {
				strNotifyEmail = strNotifyEmail.replaceAll(" ", "");
				String[] listNotifyEmail = strNotifyEmail.split(",");
				dbTask.setNotifyEmail(strNotifyEmail);
				for (int i = 0; i < listNotifyEmail.length; i++) {
					if (!checkEmail(listNotifyEmail[i])) {
						return strWarning = bundle.getString("msgWRNTaskFormatEmail");
					}
				}
			}
			if (dbTask.getNotifySubject().trim().equals("")) {
				strWarning = bundle.getString("msgMFNotifySubject");
			} else if (dbTask.getNotifyMessage().trim().equals("")) {
				strWarning = bundle.getString("msgMFNotifyMessage");
			}
		} else {
			String hour = fod.get("hour") == null ? "" : (String) fod.get("hour");
			String minutes = fod.get("minutes") == null ? "" : (String) fod.get("minutes");
			String rate = (String) fod.get("rate");

			if (!hour.trim().equals("")) {
				try {
					int intHour = Integer.parseInt(hour);
					if (intHour > 23) {
						strWarning = bundle.getString("msgWRNTaskHourValid");
					}
				} catch (NumberFormatException e) {
					strWarning = bundle.getString("msgWRNTaskHourNamber");
				}
			}
			if (!minutes.trim().equals("")) {
				try {
					int intMinutes = Integer.parseInt(minutes);
					if (intMinutes > 59) {
						strWarning = bundle.getString("msgWRNTaskMinutesValid");
					}
				} catch (NumberFormatException e) {
					strWarning = bundle.getString("msgWRNTaskMinutesNamber");
				}
			}
			try {
				Integer.parseInt(rate);
			} catch (NumberFormatException e) {
				strWarning = bundle.getString("msgWRNTaskRateMinutesValid");
			}
		}

		return strWarning;
	}

	// FIXME da spostare in PostOffice
	private static boolean checkEmail(String email) {
		if (email != null) {
			email = email.trim();
			Pattern p = Pattern.compile("^[a-zA-Z][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]$");
			Matcher m = p.matcher(email);
			return m.find();
		} else
			return false;
	}

}
