/*
 * Created on 21-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.TPAlias;
import it.softecspa.jwebber.common.classes.TPAliasMetadata;
import it.softecspa.jwebber.common.classes.Template;
import it.softecspa.jwebber.common.modules.Template_mgr;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSTemplatesIV extends InputValidator {
	
	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			String strTmpName = "";
			String strTmpDescription = "";
			String strTmpThumb = "";
			String strTmpJsp = "";
			String numCType = "";

			Vector arrAliasUsed = null;

			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";

			if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di un nuovo template
				// -----------------------------------------------------------------------
				if (chkForm) {
					strTmpName = (String) fod.get("name");
					strTmpDescription = (String) fod.get("descr");
					strTmpThumb = (String) fod.get("thumb");
					strTmpJsp = (String) fod.get("jsp");
					numCType = (String) fod.get("num_ctypes");

					arrAliasUsed = fn_getUsedAliasFromRequestNew(request);
					int alias_sel = Integer.parseInt((String) fod.get("alias_sel"));
					int chkIndex = Integer.parseInt((String) fod.get("chkIndex"));

					if ("aliasAdd".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Template_mgr.fn_AddAliasToArray(alias_sel, arrAliasUsed);
					} else if ("aliasRemove".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Template_mgr.fn_RemoveAliasFromArray(chkIndex, arrAliasUsed);
					} else {
						String strAliasOk = "";
						for (int i = 0; i < arrAliasUsed.size(); i++) {
							TPAlias objAlias = (TPAlias) arrAliasUsed.get(i);
							if ((objAlias.getAlias().trim().length() == 0)) {
								strAliasOk = "Alias " + String.valueOf(i);
							}
						}

						if (strTmpName.length() == 0)
							strWarning = bundle.getString("msgMFTemplateName");
						else if (strTmpName.length() > 20)
							strWarning = bundle.getString("msgWRNTemplateNameLength");
						else if (Template_mgr.fn_TemplateExists(0, strTmpName))
							strWarning = bundle.getString("msgWRNTemplateNameExist");
						else if (strTmpDescription.length() > 255)
							strWarning = bundle.getString("msgWRNChannelDescrLength");
						else if (strTmpThumb.length() == 0)
							strWarning = bundle.getString("msgMFThumbnail");
						else if (strTmpJsp.length() == 0)
							strWarning = bundle.getString("msgMFJSPFile");
						else if (!CMSUtilities.isIntValue(numCType))
							strWarning = bundle.getString("msgWRNDynamicContentsNotValid");
						else if (Integer.parseInt(numCType) < 0 || Integer.parseInt(numCType) > 5)
							strWarning = bundle.getString("msgWRNDynamicContentsNotValid");
						else if (strAliasOk.length() > 0)
							strWarning = CMSUtilities.fn_StringFormatter(bundle.getString("msgMFAliasName"), strAliasOk);
						else {
							Template objTmp = new Template(0, strTmpName, strTmpDescription, 1, strTmpThumb, strTmpJsp, Integer.parseInt(numCType));

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								int new_id = Template_mgr.fn_CreateTemplate(conn, objTmp, logger);
								Template_mgr.fn_CreateTemplateAlias(conn, objTmp, arrAliasUsed, new_id, logger);

								conn.commit();
								fod.put(CMSConstants.INSERT, "ok");
							} catch (Exception e) {
								conn.rollback();
								strWarning = bundle.getString("msgSavingDataError");
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					}
				} else {
					arrAliasUsed = new Vector();
				}

				fod.put("arrAliasUsed", arrAliasUsed);

			}// Fine creazione nuovo template
			else if ("edit".equals(action)) {
				// -----------------------------------------------------------------------
				// Modifica di un template
				// -----------------------------------------------------------------------

				// Recupero l'ID del template
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				Template objTmp = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati del template
					numDBIndex = Integer.parseInt(id);

					objTmp = Template_mgr.fn_GetTemplate(numDBIndex);

					if (objTmp == null) {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					}

					fod.put("objTmp", objTmp);
				} else {
					fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
					return;
				}

				if (chkForm) {
					// Gestione di un postBack
					strTmpName = (String) fod.get("name");
					strTmpDescription = (String) fod.get("descr");
					strTmpThumb = (String) fod.get("thumb");
					strTmpJsp = (String) fod.get("jsp");
					numCType = (String) fod.get("num_ctypes");

					arrAliasUsed = fn_getUsedAliasFromRequestEdit(request);
					int alias_sel = Integer.parseInt((String) fod.get("alias_sel"));
					int chkIndex = Integer.parseInt((String) fod.get("chkIndex"));

					if ("aliasAdd".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Template_mgr.fn_AddAliasToArray(alias_sel, arrAliasUsed);
					} else if ("aliasRemove".equals((String) fod.get("chkEvent"))) {
						arrAliasUsed = Template_mgr.fn_RemoveAliasFromArray(chkIndex, arrAliasUsed);
					} else {
						String strAliasOk = "";
						for (int i = 0; i < arrAliasUsed.size(); i++) {
							TPAlias objAlias = (TPAlias) arrAliasUsed.get(i);
							if ((objAlias.getAlias().trim().length() == 0)) {
								strAliasOk = "Alias " + String.valueOf(i);
							}
						}
						if (strTmpName.length() == 0)
							strWarning = bundle.getString("msgMFTemplateName");
						else if (strTmpName.length() > 20)
							strWarning = bundle.getString("msgWRNTemplateNameLength");
						else if (strTmpDescription.length() > 255)
							strWarning = bundle.getString("msgWRNChannelDescrLength");
						else if (strTmpThumb.length() == 0)
							strWarning = bundle.getString("msgMFThumbnail");
						else if (strTmpJsp.length() == 0)
							strWarning = bundle.getString("msgMFJSPFile");
						else if (!CMSUtilities.isIntValue(numCType))
							strWarning = bundle.getString("msgWRNDynamicContentsNotValid");
						else if (Integer.parseInt(numCType) < 0 || Integer.parseInt(numCType) > 5)
							strWarning = bundle.getString("msgWRNDynamicContentsNotValid");
						else if (strAliasOk.length() > 0)
							strWarning = bundle.getString("msgMFAliasName") + "'" + strAliasOk + "'.";
						else {
							objTmp.setName(strTmpName);
							objTmp.setDescription(strTmpDescription);
							objTmp.setThumbnail(strTmpThumb);
							objTmp.setPath(strTmpJsp);
							objTmp.setNumCTypes(Integer.parseInt(numCType));

							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								Template_mgr.fn_UpdateTemplate(conn, objTmp, logger);
								Template_mgr.fn_UpdateTemplateAlias(conn, objTmp, arrAliasUsed, logger);

								conn.commit();
								fod.put(CMSConstants.UPDATE, "ok");
							} catch (Exception e) {
								conn.rollback();
								strWarning = bundle.getString("msgSavingDataError");
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						}
					}
				} else {
					// Il template viene caricato per la prima volta
					fod.put("name", objTmp.getName());
					fod.put("descr", objTmp.getDescription());
					fod.put("thumb", objTmp.getThumbnail());
					fod.put("jsp", objTmp.getPath());
					fod.put("num_ctypes", String.valueOf(objTmp.getNumCTypes()));

					arrAliasUsed = Template_mgr.fn_GetTemplateAlias(objTmp.getDBIndex());
				}

				fod.put("arrAliasUsed", arrAliasUsed);

			} // Fine modifica di un template
			else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un template
				// -----------------------------------------------------------------------

				// Recupero l'ID del contenuto
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				Template objTmp = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati del tipo contenuto
					numDBIndex = Integer.parseInt(id);

					objTmp = Template_mgr.fn_GetTemplate(numDBIndex);

					if (objTmp == null) {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					}

					fod.put("objTmp", objTmp);
				} else {
					fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
					return;
				}

				fod.put("numDBIndex", id);

				if (chkForm) {
					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						if (Template_mgr.fn_DeleteTemplate(conn, objTmp, logger)) {
							fod.put(CMSConstants.DELETE, "ok");
						} else {
							strWarning = bundle.getString("msgDeleteTemplateError");
						}

						conn.commit();
						fod.put(CMSConstants.DELETE, "ok");
					} catch (Exception e) {
						conn.rollback();
						strWarning = bundle.getString("msgSavingDataError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}
				} else {
					fod.put("objTmp", objTmp);
				}

			} // Fine eliminazione di un template
			else {
			}
			// Fine controllo della ACTION

			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}

	/**
	 * Recupera dalla Request l'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias gi
	 *         utilizzati (oggetti di classe TPAlias).
	 */
	@SuppressWarnings("unchecked")
	private Vector fn_getUsedAliasFromRequestNew(HttpServletRequest request) {
		Vector arrAliasUsed = new Vector();

		int arrSize = 0;
		Enumeration en = request.getParameterNames();
		while (en.hasMoreElements()) {
			String elem = (String) en.nextElement();
			if (elem.indexOf("aliasval_") == 0) {
				arrSize++;
			}
		}

		arrAliasUsed.setSize(arrSize);

		@SuppressWarnings("unused")
		TPAliasMetadata objAliasMD = new TPAliasMetadata();

		en = request.getParameterNames();
		while (en.hasMoreElements()) {
			String elem = (String) en.nextElement();
			String value = (String) request.getParameter(elem);
			if (elem.indexOf("aliasval_") == 0) {
				String[] arrName = elem.split("_");
				if (arrName.length == 3) {
					if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[2])) {
						TPAlias objAlias = new TPAlias(0, value, Integer.parseInt(arrName[2]));
						arrAliasUsed.set(Integer.parseInt(arrName[1]), objAlias);
					}
				}
			}
		}

		return arrAliasUsed;
	}

	/**
	 * Recupera dalla Request l'elenco degli alias utilizzati in un tipo di
	 * contenuto.
	 * 
	 * @return Un riferimento all'array che conterr l'elenco degli alias gi
	 *         utilizzati (oggetti di classe TPAlias).
	 */
	@SuppressWarnings("unchecked")
	private Vector fn_getUsedAliasFromRequestEdit(HttpServletRequest request) {
		Vector arrAliasUsed = new Vector();

		int arrSize = 0;
		Enumeration en = request.getParameterNames();
		while (en.hasMoreElements()) {
			String elem = (String) en.nextElement();
			if (elem.indexOf("aliasval_") == 0) {
				arrSize++;
			}
		}

		arrAliasUsed.setSize(arrSize);

		@SuppressWarnings("unused")
		TPAliasMetadata objAliasMD = new TPAliasMetadata();

		en = request.getParameterNames();
		while (en.hasMoreElements()) {
			String elem = (String) en.nextElement();
			String value = (String) request.getParameter(elem);
			if (elem.indexOf("aliasval_") == 0) {
				String[] arrName = elem.split("_");
				if (arrName.length == 5) {
					if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[2])) {
						TPAlias objAlias = new TPAlias(Integer.parseInt(arrName[3]), value, Integer.parseInt(arrName[2]));
						objAlias.setDeleted(Integer.parseInt(arrName[4]) == 1);
						arrAliasUsed.set(Integer.parseInt(arrName[1]), objAlias);
					}
				}
			}
		}

		return arrAliasUsed;
	}
}
