/*
 * Created on 21-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.CMSUser;
import it.softecspa.jwebber.common.modules.Users_mgr;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSUsersIV extends InputValidator {
	
	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}

			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			String strNome = "";
			String strCognome = "";
			String strUserID = "";
			String strPwd = "";
			String strPwdConf = "";
			String strIDProfilo = "";
			String strEmail = "";
			boolean attivo = false;
			boolean canSeePreview = false;

			// Contiene il messaggio di errore da visualizzare
			String strWarning = "";

			if ("new".equals(action)) {
				// -----------------------------------------------------------------------
				// Creazione di un nuovo utente
				// -----------------------------------------------------------------------
				if (chkForm) {
					strNome = (String) fod.get("nome");
					strCognome = (String) fod.get("cognome");
					strUserID = (String) fod.get("user_id");
					strPwd = (String) fod.get("pwd");
					strPwdConf = (String) fod.get("pwd_conf");
					strIDProfilo = (String) fod.get("id_profilo");
					strEmail = (String) fod.get("email");
					attivo = fod.get("attivo") != null;
					canSeePreview = fod.get("can_see_preview") != null;

					if (strNome.length() == 0)
						strWarning = bundle.getString("msgMFName");
					else if (strNome.length() > 30)
						strWarning = bundle.getString("msgWRNNameLength");
					else if (strCognome.length() == 0)
						strWarning = bundle.getString("msgMFSurname");
					else if (strCognome.length() > 30)
						strWarning = bundle.getString("msgWRNSurnameLength");
					else if (strUserID.length() == 0)
						strWarning = bundle.getString("msgMFUsername");
					else if (strUserID.length() > 12)
						strWarning = bundle.getString("msgWRNUsernameLength");
					else if (Users_mgr.fn_ExistsUser(strUserID, 0))
						strWarning = bundle.getString("msgWRNUsernameExist");
					else if (strPwd.length() < 6)
						strWarning = bundle.getString("msgWRNPwdMinLength");
					else if (strPwd.length() > 24)
						strWarning = bundle.getString("msgWRNPwdMaxLength");
					else if (!strPwd.equals(strPwdConf))
						strWarning = bundle.getString("msgWRNConfPwdEqualPwd");
					else if ("0".equals(strIDProfilo))
						strWarning = bundle.getString("msgMFUserGroup");
					else {
						CMSUser objUser = new CMSUser(0, strNome, strCognome, strUserID, strPwd, strIDProfilo, strEmail, attivo ? "a" : "d", canSeePreview);

						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);

							Users_mgr.fn_CreateUser(conn, objUser, logger);

							conn.commit();
							fod.put(CMSConstants.INSERT, "ok");
						} catch (Exception e) {
							conn.rollback();
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}
					}
				} else {
				}
			}// Fine creazione nuovo utente
			else if ("edit".equals(action)) {
				// -----------------------------------------------------------------------
				// Modifica dei dati di un utente
				// -----------------------------------------------------------------------

				// Recupero l'ID del template
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				CMSUser objUser = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati del template
					numDBIndex = Integer.parseInt(id);

					objUser = Users_mgr.fn_GetUser(numDBIndex);

					if (objUser == null) {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					}

					fod.put("objUser", objUser);
				} else {
					fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
					return;
				}

				if (chkForm) {
					// Gestione di un postback
					strNome = (String) fod.get("nome");
					strCognome = (String) fod.get("cognome");
					strUserID = (String) fod.get("user_id");
					strPwd = (String) fod.get("pwd");
					strPwdConf = (String) fod.get("pwd_conf");
					strIDProfilo = (String) fod.get("id_profilo");
					strEmail = (String) fod.get("email");
					attivo = fod.get("attivo") != null;
					canSeePreview = fod.get("can_see_preview") != null;

					if (strNome.length() == 0)
						strWarning = bundle.getString("OBBL_NOME");
					else if (strNome.length() > 30)
						strWarning = bundle.getString("msgWRNNameLength");
					else if (strCognome.length() == 0)
						strWarning = bundle.getString("OBBL_COGNOME");
					else if (strCognome.length() > 30)
						strWarning = bundle.getString("msgWRNSurnameLength");
					else if (strUserID.length() == 0)
						strWarning = bundle.getString("msgMFUsername");
					else if (strUserID.length() > 12)
						strWarning = bundle.getString("msgWRNUsernameLength");
					else if (Users_mgr.fn_ExistsUser(strUserID, objUser.getNumDBIndex()))
						strWarning = bundle.getString("msgWRNUsernameExist");
					else if (!"".equals(strPwd) && strPwd.length() < 6)
						strWarning = bundle.getString("msgWRNPwdMinLength");
					else if (!"".equals(strPwd) && strPwd.length() > 24)
						strWarning = bundle.getString("msgWRNPwdMaxLength");
					else if (!strPwd.equals(strPwdConf))
						strWarning = bundle.getString("msgWRNConfPwdEqualPwd");
					else if ("0".equals(strIDProfilo))
						strWarning = bundle.getString("msgMFUserGroup");
					else {
						objUser.setNome(strNome);
						objUser.setCognome(strCognome);
						objUser.setId_profilo(strIDProfilo);
						objUser.setUser_id(strUserID);
						objUser.setPwd(strPwd);
						objUser.setEmail(strEmail);
						objUser.setAttivo(attivo ? "a" : "d");
						objUser.setCanSeePreview(canSeePreview);

						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);

							Users_mgr.fn_UpdateUser(conn, objUser, logger);

							conn.commit();
							fod.put(CMSConstants.UPDATE, "ok");
						} catch (Exception e) {
							conn.rollback();
							strWarning = bundle.getString("msgSavingDataError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}
					}
				} else {
					// L'utente viene caricato per la prima volta
					fod.put("nome", objUser.getNome());
					fod.put("cognome", objUser.getCognome());
					fod.put("user_id", objUser.getUser_id());
					fod.put("id_profilo", objUser.getIdProfilo());
					fod.put("email", objUser.getEmail());
					if ("a".equals(objUser.getAttivo()))
						fod.put("attivo", "1");
					if (objUser.isCanSeePreview())
						fod.put("can_see_preview", "1");
				}

			} // Fine modifica di un template
			else if ("delete".equals(action)) {
				// -----------------------------------------------------------------------
				// Eliminazione di un utente
				// -----------------------------------------------------------------------

				// Recupero l'ID dell'utente
				String id = (String) fod.get("id");
				int numDBIndex = 0;
				CMSUser objUser = null;

				if (CMSUtilities.isIntValue(id)) {
					// Recupero i dati del tipo contenuto
					numDBIndex = Integer.parseInt(id);

					objUser = Users_mgr.fn_GetUser(numDBIndex);

					if (objUser == null) {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					}

					fod.put("objUser", objUser);
				} else {
					fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
					return;
				}

				fod.put("numDBIndex", id);

				if (chkForm) {
					Connection conn = null;
					try {
						conn = DatabaseManager.getInstance().getConnection();
						conn.setAutoCommit(false);

						Users_mgr.fn_DeleteUser(conn, objUser, logger);
						fod.put(CMSConstants.DELETE, "ok");

						conn.commit();
						fod.put(CMSConstants.DELETE, "ok");
					} catch (Exception e) {
						conn.rollback();
						strWarning = bundle.getString("msgSavingDataError");
					} finally {
						if (conn != null && !conn.isClosed())
							DatabaseManager.closeConnection(conn);
					}
				} else {
					fod.put("objTmp", objUser);
				}

			} // Fine eliminazione di un template
			else {
			}
			// Fine controllo della ACTION

			// Lista degli utenti
			String orderBy = (fod.get("orderBy") != null) ? (String) fod.get("orderBy") : "1";
			String orderDir = (fod.get("orderDir") != null) ? (String) fod.get("orderDir") : "ASC";

			Vector arrUsers = Users_mgr.fn_GetUsers(orderBy, orderDir);
			fod.put("arrUsers", arrUsers);

			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}
}
