/*
 * Created on 21-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.processRequest;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.DateUtil;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.jwebber.common.classes.CntAlias;
import it.softecspa.jwebber.common.classes.CntFilter;
import it.softecspa.jwebber.common.classes.CntWhereCondition;
import it.softecspa.jwebber.common.classes.Content;
import it.softecspa.jwebber.common.classes.ContentType;
import it.softecspa.jwebber.common.modules.Content_mgr;
import it.softecspa.jwebber.common.modules.Ctype_mgr;
import it.softecspa.jwebber.common.modules.Group_mgr;
import it.softecspa.mvc.businesslogic.ProcessRequest;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.ProcessingException;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;


public class CMSContentsPR extends ProcessRequest {
	
	public void doProcess(Hashtable<String,Object> fod) throws ProcessingException {
		try {

			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			HttpServletRequest request = (HttpServletRequest) fod.get("request");

			// Indica il tipo di azione che si sta compiendo
			String action = (String) fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			String hourValid = fod.get("hourValid") == null ? "" : (String) fod.get("hourValid");
			String minutesValid = fod.get("minutesValid") == null ? "" : (String) fod.get("minutesValid");
			String hourExpirity = fod.get("hourExpirity") == null ? "" : (String) fod.get("hourExpirity");
			String minutesExpirity = fod.get("minutesExpirity") == null ? "" : (String) fod.get("minutesExpirity");
			String dateValid = fod.get("date_valid") == null ? "" : (String) fod.get("date_valid");
			String dateExpiry = fod.get("date_expiry") == null ? "" : (String) fod.get("date_expiry");

			// Se true si ha a che fare con un post_back
			boolean chkForm = ("1".equals((String) fod.get("chkForm"))) ? true : false;

			// Controllo se i contenuti devono essere filtrati
			boolean filterContents = ("1".equals((String) fod.get(CMSConstants.FILTER_CONTENTS))) ? true : false;

			// Recupero il tipo di contenuto
			String ctypeID = fod.get("filter_ctype") != null ? (String) fod.get("filter_ctype") : "";
			int numCTypeID = 0;
			ContentType objSelCType = null;

			if (CMSUtilities.isIntValue(ctypeID))
				numCTypeID = Integer.parseInt(ctypeID);
			fod.put("numCTypeID", String.valueOf(numCTypeID));

			if (numCTypeID > 0)
				objSelCType = Ctype_mgr.fn_GetContentType(numCTypeID);
			if (objSelCType != null)
				fod.put("objSelCType", objSelCType);

			// Recupero i tipi di contentuo che l'utente  abilitato a editare
			Vector arrCTypes = null;
			if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_EDITING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN))
				if (filterContents)
					arrCTypes = Ctype_mgr.fn_GetContentTypesJoin("");
				else
					arrCTypes = Ctype_mgr.fn_GetContentTypes("");
			else if (filterContents)
				arrCTypes = Ctype_mgr.fn_GetContentTypesJoin(utente.getIdProfilo());
			else
				arrCTypes = Ctype_mgr.fn_GetContentTypes(utente.getIdProfilo());
			// ZZZ
			for (int i = 0; i < arrCTypes.size(); i++) {
				ContentType objTmp = (ContentType) arrCTypes.get(i);
				Vector arrContents = null;
				CntFilter objFilter = new CntFilter(null, "" + objTmp.getDBIndex(), null, "", "", "", "", "0"); // ZZ
																												// rxp
																												// =
																												// 0
																												// tutti
																												// i
																												// risultati

				if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_EDITING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					if (filterContents)
						arrContents = Content_mgr.fn_GetContentsByTableCondition(objFilter, arrCTypes, "", utente.getIdUtenteAsString(), logger);
					else
						arrContents = Content_mgr.fn_GetContents(objFilter, arrCTypes, "", logger);
				} else {
					if (filterContents) {
						arrContents = Content_mgr.fn_GetContentsByTableCondition(objFilter, arrCTypes, utente.getIdProfilo(), utente.getIdUtenteAsString(), logger);
					} else {
						arrContents = Content_mgr.fn_GetContents(objFilter, arrCTypes, utente.getIdProfilo(), logger);
					}
				}
				objTmp.setNumMaxCnt(arrContents.size());
				// ZZ mi fa cagare all'ennesima potenza !!! serve per far vedere
				// il numero totale di contenuti durante la paginazione ...
				// quindi che fare di meglio se non infilarsi in un loop
				// superfluo per settare tale valore ?
				if (numCTypeID == objTmp.getDBIndex()) {
					fod.put("total_result", String.valueOf(arrContents.size()));
				}
			}
			fod.put("arrCTypes", arrCTypes);

			String strValidDate = "";
			String strExpiryDate = "";
			// String strDescr = "";
			boolean bolOnline;
			boolean approved;
			String[][] arrValues = null;

			// Recupero tutti i profili definiti a db
			Vector arrProfili = Group_mgr.fn_GetProfili();
			fod.put("profili", arrProfili);
			Vector arrProfiliObj = Group_mgr.fn_GetProfiliObj();
			fod.put("profiliObj", arrProfiliObj);

			// Contiene il messaggio di errore da visualizzare
			String strWarning = (fod.get(CMSConstants.WARNING_MESSAGE) == null) ? "" : (String) fod.get(CMSConstants.WARNING_MESSAGE);

			if ("update_flags".equals(action)) {
				String id = fod.get("id") != null ? (String) fod.get("id") : "0";
				String isVisible = fod.get("visible") != null ? (String) fod.get("visible") : "";
				String isApproved = fod.get("approved") != null ? (String) fod.get("approved") : "";

				if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_PUBLISHING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)
						|| Content_mgr.canEditContent(id, utente.getIdProfilo(), utente.getIdUtenteAsString(), filterContents, logger)) {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

					int numDBIndex = 0;
					Content objCnt = null;
					ContentType objCType = null;

					if (CMSUtilities.isIntValue(id)) {
						// Recupero i dati del tipo contenuto
						numDBIndex = Integer.parseInt(id);

						objCnt = Content_mgr.fn_GetContentWithAlias(numDBIndex, false, logger, true);

						if (objCnt == null) {
							fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
							return;
						}

						objCType = objCnt.getContentType();

						if (!isVisible.equals("")) {
							objCnt.setOnline(isVisible.equals("true"));
						} else if (!isApproved.equals("")) {
							if (isApproved.equals("true"))
								objCnt.setApproveDate(new Date());
							else
								objCnt.setApproveDate(null);
						}

						Connection conn = null;
						try {
							conn = DatabaseManager.getInstance().getConnection();
							conn.setAutoCommit(false);
							Content_mgr.fn_UpdateContent(conn, objCnt, logger);
							conn.commit();
							fod.put(CMSConstants.UPDATE, "ok");
							fod.put("filter_ctype", objCType.getDBIndex() + "");
							fod.put("objCnt", objCnt);
							fod.put("objCType", objCType);

						} catch (Exception e) {
							conn.rollback();
							strWarning = bundle.getString("msgDatabaseSaveError");
						} finally {
							if (conn != null && !conn.isClosed())
								DatabaseManager.closeConnection(conn);
						}
					} else {
						fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
						return;
					}
				}
			} else if ("search".equals(action)) {

				String idContentType = (String) fod.get("id");
				String data_creazione = (fod.get("data_creazione") != null) ? (String) fod.get("data_creazione") : "";
				String operator_data = (fod.get("operator_data") != null) ? (String) fod.get("operator_data") : CntWhereCondition.OPERATOR_EQUAL;
				String online = (fod.get("online") != null) ? (String) fod.get("online") : "";
				String to_approve = (fod.get("to_approve") != null) ? (String) fod.get("to_approve") : "";

				ArrayList arrFilters = new ArrayList();
				ContentType objCType = Ctype_mgr.fn_GetContentType(Integer.parseInt(idContentType));
				for (int j = 0; j < objCType.getAliasListSize(); j++) {
					CntAlias alias = objCType.getAlias(j);
					if (alias.isInList()) {
						String content = fod.get("content_" + alias.getOrder()) == null ? "" : (String) fod.get("content_" + alias.getOrder());
						String operator = fod.get("operator_" + alias.getOrder()) == null ? "" : (String) fod.get("operator_" + alias.getOrder());
						if (!content.equals("") && !operator.equals("")) {
							CntWhereCondition whereCondition = new CntWhereCondition(alias, operator, content);
							arrFilters.add(whereCondition);
						}
					}
				}

				CntFilter objFilter = new CntFilter(arrFilters, idContentType, data_creazione, operator_data, online, to_approve, "0", CMSConstants.CMS_CONTENTS_RXP);
				CntFilter objFilter2 = new CntFilter(arrFilters, idContentType, data_creazione, operator_data, online, to_approve, "0", "0");
				// objFilter.setOrderBy(orderBy, orderDir);
				Vector arrContents = null;
				Vector arrContents2 = null;
				if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_EDITING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
					if (filterContents) {
						arrContents = Content_mgr.fn_GetContentsByTableCondition(objFilter, arrCTypes, "", utente.getIdUtenteAsString(), logger);
						arrContents2 = Content_mgr.fn_GetContentsByTableCondition(objFilter2, arrCTypes, "", utente.getIdUtenteAsString(), logger);
					} else {
						arrContents = Content_mgr.fn_GetContents(objFilter, arrCTypes, "", logger);
						arrContents2 = Content_mgr.fn_GetContents(objFilter2, arrCTypes, "", logger);
					}
				} else {
					if (filterContents) {
						arrContents = Content_mgr.fn_GetContentsByTableCondition(objFilter, arrCTypes, utente.getIdProfilo(), utente.getIdUtenteAsString(), logger);
						arrContents2 = Content_mgr.fn_GetContentsByTableCondition(objFilter2, arrCTypes, utente.getIdProfilo(), utente.getIdUtenteAsString(), logger);
					} else {
						arrContents = Content_mgr.fn_GetContents(objFilter, arrCTypes, utente.getIdProfilo(), logger);
						arrContents2 = Content_mgr.fn_GetContents(objFilter2, arrCTypes, utente.getIdProfilo(), logger);
					}
				}
				fod.put("arrContents", arrContents);
				fod.put("filter_ctype", objCType.getDBIndex() + "");
				fod.put("total_result", String.valueOf(arrContents2.size()));
				session.setAttribute("objFilter", objFilter);

			} else if ("new".equals(action) && "".equals(strWarning)) {

				if (!"".equals(ctypeID)) {
					try {
						if (!Ctype_mgr.existsContentTYpe(ctypeID)) {
							fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
							fod.put(CMSConstants.WARNING_MESSAGE, bundle.getString("msgWRNContentTypeNotExist"));
							return;
						}

						fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

						// -----------------------------------------------------------------------
						// Creazione di un nuovo contenuto
						// -----------------------------------------------------------------------

						// Controllo che non si sia superato il numero max di
						// contenuti permessi per questo tipo
						if (objSelCType != null) {
							if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_EDITING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN) || Ctype_mgr.canCreateContent(ctypeID, utente.getIdProfilo())) {

								int numMaxCnt = objSelCType.getNumMaxCnt();
								int numCnt = Content_mgr.fn_GetNumContents(objSelCType.getDBIndex());
								if (numMaxCnt > 0 && numCnt >= numMaxCnt) {
									strWarning = CMSUtilities.fn_StringFormatter(bundle.getString("msgWRNContentTypeNameLengthParam"), objSelCType.getName(), "" + numMaxCnt);
									fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
									return;
								}
							} else {
								fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
								strWarning = bundle.getString("msgUserNotAuthorized");
								fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
							}
						}

						if (chkForm) {
							strValidDate = (String) fod.get("date_valid");
							strExpiryDate = (String) fod.get("date_expiry");
							bolOnline = fod.get("online") != null;
							approved = fod.get("approved") != null;
							// strDescr = fod.get("descr")!= null ? (String)
							// fod.get("descr") : "";

							// Recupero lo stato delle checkBox dei profili per
							// la visualizzazione
							Hashtable profiliView = new Hashtable();
							for (int i = 0; i < arrProfili.size(); i++) {
								String profilo = (String) arrProfili.get(i);

								String profilo_base = profilo;
								int pos = profilo_base.lastIndexOf("_");
								if (pos >= 0)
									profilo_base = profilo_base.substring(pos + 1);
								String profilo_base_utente = utente.getIdProfilo();
								pos = profilo_base_utente.lastIndexOf("_");
								if (pos >= 0)
									profilo_base_utente = profilo_base_utente.substring(pos + 1);

								String checkName = "chk_view_" + profilo;
								// if(fod.get(checkName) != null ||
								// utente.getIdProfilo().equals(profilo))
								if (fod.get(checkName) != null || profilo_base.equals(profilo_base_utente)) {
									fod.put(checkName, "checked");
									profiliView.put(profilo, "true");
								} else {
									profiliView.put(profilo, "false");
								}
							}

							arrValues = fn_GetAliasValuesFromRequest(request, objSelCType);
							String strAliasOk = fn_GetAliasOK(objSelCType, arrValues, bundle);

							// Validazione dei campi della form
							if (numCTypeID <= 0)
								strWarning = bundle.getString("msgWRNContentTypeIDNotValid");
							else if (!"".equals(strAliasOk))
								strWarning = strAliasOk;
							else {
								// Salvataggio dei dati del contenuto
								Content objCnt = new Content(0, "", "");
								objCnt.setContentType(objSelCType);
								strValidDate = dateValid + " " + hourValid + ":" + minutesValid;
								strExpiryDate = dateExpiry + " " + hourExpirity + ":" + minutesExpirity;

								objCnt.setValidFromDate(DateUtil.string2Date(strValidDate, "dd/MM/yyyy HH:mm"));
								objCnt.setExpiryDate(DateUtil.string2Date(strExpiryDate, "dd/MM/yyyy HH:mm"));
								objCnt.setOnline(bolOnline);
								objCnt.setValueList(arrValues);
								if (approved)
									objCnt.setApproveDate(new Date());
								else
									objCnt.setApproveDate(null);

								Connection conn = null;
								try {
									conn = DatabaseManager.getInstance().getConnection();
									conn.setAutoCommit(false);

									int new_id = Content_mgr.fn_CreateContent(conn, objCnt, logger);
									Group_mgr.fn_CreateProfiliContenuto(conn, new_id, profiliView, logger);

									conn.commit();
									fod.put(CMSConstants.INSERT, "ok");
									fod.put("filter_ctype", ctypeID);
								} catch (Exception e) {
									conn.rollback();
									strWarning = bundle.getString("msgDatabaseSaveError");
								} finally {
									if (conn != null && !conn.isClosed())
										DatabaseManager.closeConnection(conn);
								}
							}
						} else {
						}
					} catch (Exception e) {
					}
				} else {
					fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
				}
			} else if ("edit".equals(action)) {
				try {
					// -----------------------------------------------------------------------
					// Modifica di un contenuto
					// -----------------------------------------------------------------------

					// Recupero l'ID del tipo contenuto
					String id = fod.get("id") != null ? (String) fod.get("id") : "0";

					if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_EDITING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)
							|| Content_mgr.canEditContent(id, utente.getIdProfilo(), utente.getIdUtenteAsString(), filterContents, logger)) {
						fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

						int numDBIndex = 0;
						Content objCnt = null;
						ContentType objCType = null;

						if (CMSUtilities.isIntValue(id)) {
							// Recupero i dati del tipo contenuto
							numDBIndex = Integer.parseInt(id);

							objCnt = Content_mgr.fn_GetContentWithAlias(numDBIndex, false, logger, true);

							if (objCnt == null) {
								fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
								return;
							}

							objCType = objCnt.getContentType();

							fod.put("objCnt", objCnt);
							fod.put("objCType", objCType);
						} else {
							fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
							return;
						}

						if (chkForm) {
							// Gestione di un postBack
							strValidDate = (String) fod.get("date_valid");
							strExpiryDate = (String) fod.get("date_expiry");
							bolOnline = fod.get("online") != null;
							approved = fod.get("approved") != null;
							// strDescr = fod.get("descr")!= null ? (String)
							// fod.get("descr") : "";

							// Recupero lo stato delle checkBox dei profili per
							// la visualizzazione
							Hashtable profiliView = new Hashtable();
							for (int i = 0; i < arrProfili.size(); i++) {
								String profilo = (String) arrProfili.get(i);

								String profilo_base = profilo;
								int pos = profilo_base.lastIndexOf("_");
								if (pos >= 0)
									profilo_base = profilo_base.substring(pos + 1);
								String profilo_base_utente = utente.getIdProfilo();
								pos = profilo_base_utente.lastIndexOf("_");
								if (pos >= 0)
									profilo_base_utente = profilo_base_utente.substring(pos + 1);

								String checkName = "chk_view_" + profilo;
								// if(fod.get(checkName) != null ||
								// utente.getIdProfilo().equals(profilo))
								if (fod.get(checkName) != null || profilo_base.equals(profilo_base_utente)) {
									fod.put(checkName, "checked");
									profiliView.put(profilo, "true");
								} else {
									profiliView.put(profilo, "false");
								}
							}

							arrValues = fn_GetAliasValuesFromRequest(request, objCType);
							String strAliasOk = fn_GetAliasOK(objCType, arrValues, bundle);

							// Validazione dei campi della form
							if (objCnt.getCTypeDBIndex() <= 0)
								strWarning = bundle.getString("msgWRNContentTypeIDNotValid");
							else if (!"".equals(strAliasOk))
								strWarning = strAliasOk;
							else {
								// Salvataggio del contenuto
								strValidDate = dateValid + " " + hourValid + ":" + minutesValid;
								strExpiryDate = dateExpiry + " " + hourExpirity + ":" + minutesExpirity;

								objCnt.setValidFromDate(DateUtil.string2Date(strValidDate, "dd/MM/yyyy HH:mm"));
								objCnt.setExpiryDate(DateUtil.string2Date(strExpiryDate, "dd/MM/yyyy HH:mm"));
								objCnt.setOnline(bolOnline);
								objCnt.setValueList(arrValues);
								objCnt.setDescr("");
								if (approved)
									objCnt.setApproveDate(new Date());
								else
									objCnt.setApproveDate(null);

								Connection conn = null;
								try {
									conn = DatabaseManager.getInstance().getConnection();
									conn.setAutoCommit(false);

									Content_mgr.fn_UpdateContent(conn, objCnt, logger);
									if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_PUBLISHING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
										Group_mgr.fn_UpdateProfiliContenuto(conn, numDBIndex, profiliView, logger);
									}

									conn.commit();
									fod.put(CMSConstants.UPDATE, "ok");
									fod.put("filter_ctype", objCType.getDBIndex() + "");

								} catch (Exception e) {
									conn.rollback();
									strWarning = bundle.getString("msgDatabaseSaveError");
								} finally {
									if (conn != null && !conn.isClosed())
										DatabaseManager.closeConnection(conn);
								}
							}
						} else {
							// La pagina viene caricata per la prima volta
							strValidDate = DateUtil.date2String(objCnt.getValidFromDate(), "dd/MM/yyyy HH:mm");
							strExpiryDate = DateUtil.date2String(objCnt.getExpiryDate(), "dd/MM/yyyy HH:mm");

							fod.put("date_valid", strValidDate);
							fod.put("date_expiry", strExpiryDate);

							if (objCnt.isOnline())
								fod.put("online", "checked");

							// Quando si modifica un contenuto sottoposto a
							// workflow  necessario
							// approvarlo nuovamente
							// if(objCnt.getApproveDate() != null)
							// fod.put("approved", "checked");

							// fod.put("descr", objCnt.getDescr());

							// Recupero i dati sull'editabilit del tipo
							// contenuto
							Hashtable profiliView = Group_mgr.fn_GetProfiliContenutoView(numDBIndex);
							Enumeration en = profiliView.keys();
							while (en.hasMoreElements()) {
								String profilo = (String) en.nextElement();
								boolean checked = "true".equals((String) profiliView.get(profilo)) ? true : false;
								if (checked)
									fod.put("chk_view_" + profilo, "checked");
							}
						}
					} else {
						fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
						strWarning = bundle.getString("msgUserNotAuthorized");
						fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					}
				} catch (Exception e) {
				}
			} else if ("delete".equals(action)) {
				try {
					// -----------------------------------------------------------------------
					// Eliminazione di un contenuto
					// -----------------------------------------------------------------------

					// Recupero l'ID del contenuto
					String id = fod.get("id") != null ? (String) fod.get("id") : "0";

					if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_EDITING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)
							|| Content_mgr.canEditContent(id, utente.getIdProfilo(), utente.getIdUtenteAsString(), filterContents, logger)) {
						fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");

						int numDBIndex = 0;
						Content objCnt = null;
						ContentType objCType = null;

						if (CMSUtilities.isIntValue(id)) {
							// Recupero i dati del tipo contenuto
							numDBIndex = Integer.parseInt(id);

							objCnt = Content_mgr.fn_GetContentWithAlias(numDBIndex, false, logger, true);

							if (objCnt == null) {
								fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
								return;
							}

							objCType = objCnt.getContentType();

							fod.put("objCnt", objCnt);
							fod.put("objCType", objCType);
						} else {
							fod.put(CMSConstants.WARNING_MESSAGE, CMSConstants.RISORSA_INESISTENTE);
							return;
						}

						fod.put("numDBIndex", id);

						if (chkForm) {
							Connection conn = null;
							try {
								conn = DatabaseManager.getInstance().getConnection();
								conn.setAutoCommit(false);

								Content_mgr.fn_DeleteContent(conn, objCnt.getDBIndex(), logger);

								conn.commit();
								fod.put(CMSConstants.DELETE, "ok");
								fod.put("filter_ctype", objCType.getDBIndex() + "");
							} catch (Exception e) {
								conn.rollback();
								strWarning = bundle.getString("msgDatabaseSaveError");
							} finally {
								if (conn != null && !conn.isClosed())
									DatabaseManager.closeConnection(conn);
							}
						} else {
							fod.put("objCnt", objCnt);
						}
					} else {
						fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
						strWarning = bundle.getString("msgUserNotAuthorized");
						fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
					}
				} catch (Exception e) {
				}
			}
			if (!"search".equals(action)) {

				// Lista dei contenuti
				String filter_ctype = (fod.get("filter_ctype") != null) ? (String) fod.get("filter_ctype") : "0";
				String orderBy = (fod.get("orderBy") != null) ? (String) fod.get("orderBy") : "d12_cmd_dat_creaz";
				String orderDir = (fod.get("orderDir") != null) ? (String) fod.get("orderDir") : "ASC";
				String pag = (fod.get("pag") != null) ? (String) fod.get("pag") : "0";
				String rxp = CMSConstants.CMS_CONTENTS_RXP;

				CntFilter objFilter = null;
				objFilter = (CntFilter) session.getAttribute("objFilter");
				if (objFilter != null && !filter_ctype.equals("0")) {
					objFilter.setPag(pag);
				} else {
					objFilter = new CntFilter(null, filter_ctype, null, "", "", "", pag, rxp);
					session.removeAttribute("objFilter");
				}
				objFilter.setOrderBy(orderBy, orderDir);
				Vector arrContents = null;
				if (chkForm) {

					if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_CONTENTS_EDITING) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
						if (filterContents)
							arrContents = Content_mgr.fn_GetContentsByTableCondition(objFilter, arrCTypes, "", utente.getIdUtenteAsString(), logger);
						else
							arrContents = Content_mgr.fn_GetContents(objFilter, arrCTypes, "", logger);
					} else {
						if (filterContents) {
							arrContents = Content_mgr.fn_GetContentsByTableCondition(objFilter, arrCTypes, utente.getIdProfilo(), utente.getIdUtenteAsString(), logger);
						} else {
							arrContents = Content_mgr.fn_GetContents(objFilter, arrCTypes, utente.getIdProfilo(), logger);
						}
					}
				} else {
					arrContents = new Vector();
				}
				fod.put("arrContents", arrContents);
				fod.put("filter_ctype", filter_ctype);
			}

			// Inserisco nel fod il messaggio di warning
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);

			if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_AREA_ACCESS)) {
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
			} else
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");

		} catch (Exception e) {
			throw new ProcessingException("", e);
		}
	}

	/**
	 * Recupera dalla Request l'elenco dei valori degli alias del contenuto. I
	 * valori trovati vengono validati in base al loro tipo.
	 * 
	 * @param objCType
	 *            : Tipo contenuto, per recuperare i nomi degli alias non
	 *            validi.
	 * @param arrValues
	 *            : Array da riempire con i valori trovati.
	 * 
	 * @return Una stringa contenente eventuali errori di validazione.
	 */
	private String[][] fn_GetAliasValuesFromRequest(HttpServletRequest request, ContentType objCType) {
		String[][] arrValues = null;

		// arrValues = new String[2][arrSize];
		arrValues = new String[2][objCType.getAliasListSize()];
		for (int i = 0; i < objCType.getAliasListSize(); i++) {
			arrValues[0][i] = "";
			arrValues[1][i] = "-1";
		}

		@SuppressWarnings("rawtypes")
		Enumeration en = request.getParameterNames();
		while (en.hasMoreElements()) {
			String elem = (String) en.nextElement();
			if (elem.indexOf("item_") == 0) {
				String[] arrName = elem.split("_");
				if (arrName.length == 3) {
					if (CMSUtilities.isIntValue(arrName[1]) && CMSUtilities.isIntValue(arrName[2])) {
						int numIndex = Integer.parseInt(arrName[1]);
						arrValues[0][numIndex] = request.getParameter(elem);
						arrValues[1][numIndex] = arrName[2];
					}
				}
			}
		}

		return arrValues;
	}

	/*
	 * Controlla se i valori dei campi del contenuto sono validi
	 */
	private String fn_GetAliasOK(ContentType objCType, String[][] arrValues, ResourceBundle bundle) {
		String errorMsg = "";

		int numAlias = 0;
		CntAlias objAlias = null;

		for (int i = 0; i < arrValues[1].length; i++) {
			int value = Integer.parseInt(arrValues[1][i]);
			objAlias = objCType.getAlias(i);

			if (objAlias.isRequested() && (arrValues[0][i] == null || "".equals(arrValues[0][i].trim()))) {
				errorMsg = CMSUtilities.fn_StringFormatter(bundle.getString("msgMFAlias"), objAlias.getValue());
				break;
			}

			switch (value) {
			case 0:
				// campo di testo
				break;
			case 2:
				// intero
				if (!CMSUtilities.isIntValue(arrValues[0][i])) {
					errorMsg = CMSUtilities.fn_StringFormatter(bundle.getString("msgWRNAliasNumber"), objAlias.getValue());
					numAlias = i;
				}
				break;
			case 3:
			case 4:
			case 6:
				// link, image, attach
				if (arrValues[0][i].length() > 255) {
					errorMsg = CMSUtilities.fn_StringFormatter(bundle.getString("msgWRNAliasLength"), objAlias.getValue());
					numAlias = i;
				}
				break;
			case 5:
				// data
				if (arrValues[0][i] != null && !"".equals(arrValues[0][i]) && DateUtil.string2Date(arrValues[0][i], "dd/MM/yyyy") == null) {
					errorMsg = CMSUtilities.fn_StringFormatter(bundle.getString("msgWRNAliasDateFormat"), objAlias.getValue());
					numAlias = i;
				}
				break;
			}

			if (numAlias > 0)
				break;
		}

		return errorMsg;
	}
}