package it.softecspa.jwebber.processRequest;

import it.softecspa.mvc.FwGenericServlet;
import it.softecspa.mvc.businesslogic.ProcessRequest;
import it.softecspa.mvc.exceptions.ProcessingException;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;

import javax.servlet.ServletOutputStream;

/**
 * ProcessRequest che gestisce le varie operazioni di aggiornamento del
 * Tariffario e dei Pagamenti.
 */
public class CMSDownloadFilePR extends ProcessRequest {

	public void doProcess(Hashtable<String,Object> fod) throws ProcessingException {
		String nomefile = null;

		// operazione di download del file il cui nome  in session e la cui
		// directory  dir_immagini del file di configurazione
		try {
			ServletOutputStream servletoutputstream = response.getOutputStream();
			byte abyte[] = new byte[4096];
			nomefile = (String) fod.get("path");

			String inputFileNameCompleto = ((FwGenericServlet) fod.get(FwGenericServlet.SERVLET_FOD_LABEL)).getServletContext().getRealPath(nomefile);

			File file = new File(inputFileNameCompleto);// apertura del file
			FileInputStream fileinputstream = new FileInputStream(file);

			response.setContentType("application/octet-stream");
			response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());

			// copia del file sullo stream
			int len = -1;
			while (!((len = fileinputstream.read(abyte)) == -1)) {
				servletoutputstream.write(abyte, 0, len);
				servletoutputstream.flush();
			}

			servletoutputstream.close();
			fileinputstream.close();
		} catch (Throwable t) {
			// error download
		} finally {
			// exiting download
		}
	}
}
