package it.softecspa.jwebber.processRequest;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.mvc.businesslogic.ProcessRequest;
import it.softecspa.mvc.exceptions.ProcessingException;
import it.softecspa.task.DBTask;
import it.softecspa.task.DBTaskLog;

import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class CMSTasksPR extends ProcessRequest {


	public void doProcess(Hashtable<String,Object> fod) throws ProcessingException {
		String action = (String) fod.get("action");
		Utente utente = (Utente) session.getUser();
		Locale currentLocale = null;
		ResourceBundle bundle = null;
		if (utente.getLanguage() != null) {
			currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
			bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
		}

		// Solo gli utenti dotati della polici ADMIN_PROFILES e ADMIN_SUPERADMIN
		// possono gestire i profili
		if (utente.hasPolicy(CMSConstants.POLICY_ADMIN_TASK_MANAGER) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SUPERADMIN)) {
			fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
		} else {
			fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
			fod.put(CMSConstants.WARNING_MESSAGE, bundle.getString("msgUserNotAuthorized"));
		}
		if ("detail".equals(action)) {
			int idTask = fod.get("idTask") == null ? 0 : Integer.parseInt((String) fod.get("idTask"));
			DBTask dbTask = null;
			DBTaskLog[] dbTaskLog = null;
			try {
				dbTask = new DBTask(idTask);
				dbTaskLog = DBTaskLog.getAllTaskLogs(dbTask.getIdTask());
			} catch (Exception e) {
				e.getStackTrace();
			}
			fod.put("dbTask", dbTask);
			fod.put("dbTaskLog", dbTaskLog);
		}
	}

}
