// Source File Name:   FwGenericServlet.java

package it.softecspa.mvc;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.businesslogic.ProcessRequest;
import it.softecspa.mvc.businesslogic.SecurityManager;
import it.softecspa.mvc.businesslogic.StandardInputValidator;
import it.softecspa.mvc.businesslogic.StandardSecurityManager;
import it.softecspa.mvc.businessobject.User;
import it.softecspa.mvc.exceptions.AppException;
import it.softecspa.mvc.exceptions.AppSecurityException;
import it.softecspa.mvc.exceptions.AuthenticationException;
import it.softecspa.mvc.exceptions.AuthorizationException;
import it.softecspa.mvc.exceptions.ChangePasswordException;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.exceptions.NoSessionException;
import it.softecspa.mvc.exceptions.ProcessingException;
import it.softecspa.mvc.exceptions.SessionEmptyException;
import it.softecspa.mvc.exceptions.WorkflowException;
import it.softecspa.mvc.session.Session;
import it.softecspa.mvc.session.SessionFactory;
import it.softecspa.mvc.utils.GenericServletUtils;
import it.softecspa.mvc.utils.LogUtils;
import it.softecspa.portal.Bundle;
import it.softecspa.sso.common.SsoException;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.apache.log4j.MDC;



@SuppressWarnings("serial")
public abstract class FwGenericServlet extends HttpServlet {

	public static String ERROR_MESSAGE = "MsgErrore";
	
	
	
	private static Logger accessLogger = Logger.getLogger("access");
	private static Logger logger = Logger.getLogger(FwGenericServlet.class);

	
	public static final String SERVLET_FOD_LABEL = "_fw_servletIstance_fw_";
	@SuppressWarnings("unused")
	private static final boolean AUTOCREATESESSION = true;
	
	public static final String NEWSESSIONPARAM 			= "newSession";
	public static final String SESSIONPARAMETER 		= "WebApplSession";
	public static final String REQUESTPARAMETER 		= "WebApplSession";
	public static final String HTTP_SERVLET_REQUEST 	= "http-servlet-request";
	public static final String HTTP_SERVLET_CONTEXT 	= "http-servlet-context";
	
	public static final String WORKFLOW_INFO 			= "WORKFLOW_INFO";
	public static final String SERVLET_NAME 			= "SERVLET_NAME";
	
	public static final String INITERROR 				= "Error in GenericServet initialization: ";
	public static final String INVALIDERRORPAGE 		= "ErrorPage must be a static page";
	public static final String NULLNAVIGATIONLOGIC 		= "One or more null navigation logic null";
	public static final String USERPROFILES 			= "UserProfiles";
	public static final String MSGERRORE 				= FwGenericServlet.ERROR_MESSAGE;
	public static final String MSG_ESITO 				= "resultCode";
	public static final String GENERICERRORMSG 			= "Si e' verificato un errore applicativo";
	public static final String STANDARDPROCESSREQUEST 	= "it.softecspa.mvc.businesslogic.StandardProcessRequest";
	public static final String SUCCESSJSP 				= "successJsp";
	public static final String ORIGINATOR 				= "originatorUri";
	
	public static final String PREFIX_LIST_FIELD 		= "lst_";
	public static final String PREFIX_PRIMARY_KEY = 	"_pkIgs_";
	public static final String PREFIX_CRYPTED_FLD = 	"_crypto_";
	
	
	private String m_ErrorJsp;
	private String m_ErrorPage;
	private SessionFactory m_SessionFactory;
	private SecurityManager m_SecurityManager;
	private String m_ServletCode;
	
	private List<ProcessRequest> m_PCList;
	private List<InputValidator> vInputValidator;
	
	private String m_ContainerJsp;
	private String m_LoginPage;
	private String changePasswordPage;
	private InputValidator m_InputValidator;
	private String sessioneScadutaReturnPage;
	String securityErrorPage;
	private String accessLogWhat;
	private String riempiBusinessObjCampiOk;
	private boolean initSessionSecurityKey;
	
	public FwGenericServlet() {
		m_SecurityManager = null;
		m_ServletCode = null;
		m_PCList = new ArrayList<ProcessRequest>();
		vInputValidator = new ArrayList<InputValidator>();
		m_ContainerJsp = null;
		m_LoginPage = null;
		changePasswordPage = null;
		m_InputValidator = new StandardInputValidator();
		sessioneScadutaReturnPage = null;
		securityErrorPage = null;
		accessLogWhat = null;
		riempiBusinessObjCampiOk = null;
		initSessionSecurityKey = false;
	}

	public void init(ServletConfig config) throws ServletException {
		try {
			super.init(config);
			initSessionFactory(config);
			initBusinessLogic(config);
			initSecurityManager(config);
			initErrorLogic(config);
		} catch (Exception initException) {
			throw new ServletException("Error in GenericServet initialization: " + m_ServletCode, initException);
		}
	}

	private void initSessionFactory(ServletConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
		m_SessionFactory = (SessionFactory) Class.forName(config.getServletContext().getInitParameter("SessionFactory")).newInstance();
	}

	private void initSecurityManager(ServletConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {

		m_ServletCode = config.getInitParameter("servletCode");

		if (config.getInitParameter("SecurityManager") != null) {
			if (logger.isDebugEnabled())
				logger.debug("Servlet code " + m_ServletCode + ", create new instance of " + config.getInitParameter("SecurityManager"));
			m_SecurityManager = (SecurityManager) Class.forName(config.getInitParameter("SecurityManager")).newInstance();
		} else {
			if (logger.isDebugEnabled())
				logger.debug("Servlet code " + m_ServletCode + ", create new instance of " + config.getServletContext().getInitParameter("SecurityManager") + " using ServletContext info!");
			m_SecurityManager = (SecurityManager) Class.forName(config.getServletContext().getInitParameter("SecurityManager")).newInstance();
		}

		securityErrorPage = config.getServletContext().getInitParameter("securityErrorPage");
		changePasswordPage = config.getServletContext().getInitParameter("changePasswordPage");
		accessLogWhat = config.getServletContext().getInitParameter("accessLogWhat");
	}

	@SuppressWarnings("unchecked")
	protected void initBusinessLogic(ServletConfig config) throws Exception {
		m_ContainerJsp = config.getServletContext().getInitParameter("Container");

		m_LoginPage = config.getServletContext().getInitParameter("Login");
		initSuccessJsp(config.getInitParameter("SuccessJsp"));

		GenericServletUtils.stringToArray(getPCList(), config.getInitParameter("ProcessRequest"), "it.softecspa.mvc.businesslogic.StandardProcessRequest", true);
		if (config.getServletContext().getInitParameter("CommonProcessRequest") != null &&
			!config.getServletContext().getInitParameter("CommonProcessRequest").trim().equals("") &&
			config.getInitParameter("DoNotLoadCommonProcessRequest") == null) {
			GenericServletUtils.stringToArray(getPCList(), config.getServletContext().getInitParameter("CommonProcessRequest"), "it.softecspa.mvc.businesslogic.StandardProcessRequest", false);
		}
		m_PCList = (ArrayList<ProcessRequest>) GenericServletUtils.stringArrayToObjectArray(getPCList());
		
		GenericServletUtils.stringToArray(vInputValidator, config.getInitParameter("InputValidator"), true);
		vInputValidator = (ArrayList<InputValidator>) GenericServletUtils.stringArrayToObjectArray(vInputValidator);
		if (config.getInitParameter("Container") != null)
			m_ContainerJsp = config.getInitParameter("Container");
		sessioneScadutaReturnPage = config.getInitParameter("sessioneScadutaReturnPage");
		if (sessioneScadutaReturnPage != null && sessioneScadutaReturnPage.trim().equals(""))
			sessioneScadutaReturnPage = config.getServletContext().getInitParameter("sessioneScadutaReturnPage");
		if (config.getInitParameter("initSessionSecurityKey") != null)
			initSessionSecurityKey = true;
		riempiBusinessObjCampiOk = config.getInitParameter("standardInputValidatorCampiOk");
		if (riempiBusinessObjCampiOk == null)
			riempiBusinessObjCampiOk = "";
	}

	private void initErrorLogic(ServletConfig config) {
		m_ErrorPage = config.getServletContext().getInitParameter("ErrorPage");
		m_ErrorJsp = config.getInitParameter("ErrorJsp");
		if (m_ErrorPage == null || m_ErrorJsp == null)
			throw new IllegalArgumentException("One or more null navigation logic null");
		else
			return;
	}

	private Session getSession(HttpServletRequest request) throws InstantiationException, IllegalAccessException, NoSessionException, AppException {
		HttpSession httpSession = request.getSession(true);
		Session webAppSession = null;
		if (httpSession.getAttribute(SESSIONPARAMETER) != null && 
			request.getParameter(NEWSESSIONPARAM) == null) {
			webAppSession = (Session) httpSession.getAttribute(SESSIONPARAMETER);
			if (initSessionSecurityKey)
				try {
					webAppSession.initSecurityKey();
				} catch (Exception e) {
					webAppSession = null;
					httpSession.invalidate();
					throw new NoSessionException("La sessione di lavoro \350 stata invalidata per un problema nella generazione della chiave di sessione");
				}
			return webAppSession;
		}
		if (sessioneScadutaReturnPage == null) {
			webAppSession = m_SessionFactory.createSession(request);
			try {
				webAppSession.initSecurityKey();
			} catch (Exception e) {
				webAppSession = null;
				httpSession.invalidate();
				throw new NoSessionException("Session invalidated");
			}
			httpSession.setAttribute(SESSIONPARAMETER, webAppSession);
		} else {
			throw new NoSessionException("Session expired");
		}
		return webAppSession;
	}

	@SuppressWarnings("unused")
	private User getUser(HttpServletRequest request) throws IllegalAccessException, InstantiationException, AppException {
		try {
			return getSession(request).getUser();
		} catch (AuthenticationException authException) {
			return null;
		} catch (NoSessionException noSessionException) {
			return null;
		}
	}

	private String getUserMessage(Throwable t) {
		String userMsg = "";
		for (; t != null && it.softecspa.mvc.exceptions.AppException.class.isAssignableFrom(t.getClass()); t = ((AppException) t).getRootCause())
			userMsg = ((AppException) t).getMessage() + " " + userMsg;

		if (userMsg.trim().equals(""))
			userMsg = Bundle.getInstance().getBundle().getString("msgApplicationError");
		return userMsg;
	}

	protected void exceptionManager(HttpServletRequest request, HttpServletResponse response, Throwable t) throws ServletException {
		String userID = "unknown";

		try {
			// m.veroni, gestice l'eccezione causata dalla "caduta" di sessione
			if (t != null && t instanceof ServletException) {
				ServletException se = (ServletException) t;
				if (se.getRootCause() != null && se.getRootCause() instanceof AppSecurityException) {
					AppSecurityException ase = (AppSecurityException) se.getRootCause();
					try {
						// AccessLogger.log(getSession(request).getUser(),
						// request,
						// this, ase.getMessage());
						accessLogger.info(LogUtils.getMessage(getSession(request).getUser(), request, this, ase.getMessage()));
					} catch (Exception exception) {

					}
					LogUtils.errorConTrace(logger, this, "", ase);
					request.getSession(true).invalidate();
					request.setAttribute(FwGenericServlet.ERROR_MESSAGE, ase.getMessage());
					getServletContext().getRequestDispatcher(securityErrorPage).include(request, response);
					return;
				}
			}

			LogUtils.errorConTrace(logger, this, "Exception Managing for " + request.getRemoteAddr(), t);
			if (!getErrorJsp().equals("")) {
				request.setAttribute(FwGenericServlet.ERROR_MESSAGE, getUserMessage(t));
				getServletContext().getRequestDispatcher(getErrorJsp()).forward(request, response);
			}
		} catch (Exception errorJspException) {
			try {
				logger.error("Exception in Exception Managing for " + userID, errorJspException);
				if (getErrorJsp() == null)
					response.getWriter().print(getErrorPage());
			} catch (Exception unrecoverableError) {
				logger.fatal("Exception in Exception in Exception Managing for " + userID, unrecoverableError);
				throw new ServletException("Exception in Exception in Exception Managing for " + userID, unrecoverableError);
			}
		}
	}

	private void performProcessComponentList(Hashtable<String, Object> fod, HttpServletResponse response, Session session) throws ProcessingException {
		for (Iterator<ProcessRequest> prlist = getPCList().iterator(); prlist.hasNext(); ((ProcessRequest) prlist.next()).doProcessEvo(fod, response, session));
	}

	private void performInputValidatorList(HttpServletRequest request, Session session, Hashtable<String, Object> fod) throws InputValidatorException {
		for (int i = 0; i < getVInputValidator().size(); i++) {
			((InputValidator) getVInputValidator().get(i)).doValidate(request, session, fod);
		}
	}

	// -----------------------------------------------------------------------------------------------------------------------
	public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		Session webApplSession = null;
		try {
			request.getQueryString();
			webApplSession = getSession(request);
			checkWorkflow(request, webApplSession);
			Hashtable<String,Object> fod = setFlowOfDatas(request, webApplSession);
			fod.put(FwGenericServlet.SERVLET_NAME, this.getServletName());
			fod.put("_fw_servletIstance_fw_", this);
			fod.put("standardInputValidatorCampiOk", riempiBusinessObjCampiOk);

			String rebound = (String)fod.get("rebound");
			if (XString.isNotBlankNullTrim(rebound)) {
				if (logger.isDebugEnabled()) logger.debug("Required rebound (request) to '"+rebound+"'");
				webApplSession.setAttribute("rebound", rebound);
			} else {
				rebound = (String)webApplSession.getAttribute("rebound");
				if (logger.isDebugEnabled()) if (rebound!=null) logger.debug("Read rebound from attribute: '"+rebound+"'");
			}
			
			
			// Controllo autenticazione
			// ----------------------------------------------------------------------------
			if (m_SecurityManager.login(request, response, fod, webApplSession)) {
				if (logger.isDebugEnabled()) {
					logger.debug("HttpServlet.service [login]-> send redirect!");
				}
				return;
			}
			//----
			if (XString.isNotBlankNullTrim(rebound)) {
				if (logger.isDebugEnabled()) logger.debug("Found rebound to '"+rebound+"'");
				webApplSession.setAttribute("rebound", rebound);
			}
			
			if (m_SecurityManager.checkAuthorization(request, response, fod, webApplSession)) {
				if (logger.isDebugEnabled())
					logger.debug("HttpServlet.service [checkAuthorization]-> send redirect!");
				return;
			}
			if (XString.isNotBlankNullTrim(rebound)) {
				if (logger.isDebugEnabled()) logger.debug("Found rebound to '"+rebound+"'");
				webApplSession.setAttribute("rebound", rebound);
			}
			// --------------------------------------------------------------------------------

			MDC.put("sessionId", request.getSession().getId());
			if (webApplSession.getServletCode().equals("PC-NO_FUNCTION-PC") && webApplSession.isEmpty() && sessioneScadutaReturnPage != null) {
				throw new SessionEmptyException(Bundle.getInstance().getBundle().getString("msgSessionEmpty"));
			}

			// E' presente un "rimbalzo", lo eseguo
			if (XString.isNotBlankNullTrim(rebound)) {
				webApplSession.removeAttribute("rebound");
				if (rebound!=null && !rebound.endsWith("null")) {
					if (logger.isDebugEnabled()) logger.debug("Target rebound to '"+rebound+"'");					
					if (rebound.startsWith(request.getContextPath())) {
						rebound = rebound.substring(request.getContextPath().length());
					}
					
					RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(rebound);
					if (dispatcher == null) {
						logger.error("Dispatcher nullo, impossibile aprire '" + rebound + "'");
					} else {
						dispatcher.forward(request, response);
						return;
					}
				}
			}
			//
			
			
			// ...eseguo la servlet richiamata
			performInputValidatorList(request, webApplSession, fod);
			performProcessComponentList(fod, response, webApplSession);

			writeAccessLog(webApplSession.getUser(), request, fod);
			if (request.getAttribute(WORKFLOW_INFO) == null && fod.get(WORKFLOW_INFO) == null) {
				webApplSession.setServletCode(m_ServletCode);
			}
			// ------------------------------------------------------------------------------------------------
			
			
			
			
			String targetPage = viewControl(request, response, fod, webApplSession);
			if (XString.isNotBlankNullTrim(targetPage)) {
				request.setAttribute(REQUESTPARAMETER, fod);
				RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(targetPage);
				if (dispatcher == null) {
					logger.error("Null dispatcher, problem open page '" + targetPage + "'");
				} else {
					dispatcher.include(request, response);
				}
			}
			// ------------------------------------------------------------------------------------------------

		} catch (ChangePasswordException cpe) {
			LogUtils.errorConTrace(logger, this, "", cpe);
			request.setAttribute(FwGenericServlet.ERROR_MESSAGE, cpe.getMessage());
			request.setAttribute(WORKFLOW_INFO, "");
			getServletContext().getRequestDispatcher(changePasswordPage).include(request, response);
			return;

		} catch (AuthenticationException e) {
			LogUtils.error(logger, this, e);
			if (e.getCause() != null && e.getCause() instanceof SsoException) {
				request.setAttribute(FwGenericServlet.ERROR_MESSAGE, e.getCause().getMessage());
			} else if (e.getCause() != null && e.getCause() instanceof AuthenticationException) {
				request.setAttribute(FwGenericServlet.ERROR_MESSAGE, e.getCause().getMessage());
			} else {
				request.setAttribute(FwGenericServlet.ERROR_MESSAGE, Bundle.getInstance().getBundle().getString("msgUserNotExistSSO"));
			}
			request.setAttribute(WORKFLOW_INFO, "");
			getServletContext().getRequestDispatcher(m_LoginPage != null ? m_LoginPage : m_ErrorPage).include(request, response);
			return;

		} catch (SessionEmptyException e) {
			LogUtils.errorConTrace(logger, this, "", e);
			request.setAttribute(FwGenericServlet.ERROR_MESSAGE, Bundle.getInstance().getBundle().getString("msgSessionEmpty"));
			getServletContext().getRequestDispatcher(sessioneScadutaReturnPage).include(request, response);

		} catch (NoSessionException e) {
			LogUtils.error(logger, this, e);
			request.setAttribute(FwGenericServlet.ERROR_MESSAGE, Bundle.getInstance().getBundle().getString("msgSessionKo"));
			getServletContext().getRequestDispatcher(sessioneScadutaReturnPage).include(request, response);

		} catch (AuthorizationException e) {
			LogUtils.error(logger, this, e);
			request.setAttribute(FwGenericServlet.ERROR_MESSAGE, Bundle.getInstance().getBundle().getString("msgSessionExpired"));
			request.setAttribute(WORKFLOW_INFO, "");
			getServletContext().getRequestDispatcher(securityErrorPage).include(request, response);
			return;

		} catch (WorkflowException e) {
			LogUtils.errorConTrace(logger, this, "", e);
			request.setAttribute(FwGenericServlet.ERROR_MESSAGE, e.getMessage());
			request.setAttribute(WORKFLOW_INFO, "");
			getServletContext().getRequestDispatcher(m_ErrorPage).include(request, response);
			return;

		} catch (InputValidatorException e) {
			exceptionManager(request, response, e);
			return;

		} catch (AppSecurityException e) {
			try {
				// AccessLogger.log(getSession(request).getUser(), request,
				// this, ase.getMessage());
				accessLogger.info(LogUtils.getMessage(getSession(request).getUser(), request, this, e.getMessage()));
			} catch (Exception exception) {

			}
			LogUtils.errorConTrace(logger, this, "", e);
			request.getSession(true).invalidate();
			request.setAttribute(FwGenericServlet.ERROR_MESSAGE, e.getMessage());
			getServletContext().getRequestDispatcher(securityErrorPage).include(request, response);
			return;

		} catch (ServletException jspException) {
			exceptionManager(request, response, jspException);
			return;

		} catch (Exception servletException) {
			request.setAttribute(FwGenericServlet.ERROR_MESSAGE, servletException.getMessage());
			exceptionManager(request, response, servletException);
			return;
		}
	}

	// -----------------------------------------------------------------------------------------------------------------------

	public String getContainerJsp(String targetPage) {
		if (targetPage.endsWith(".jsp"))
			return m_ContainerJsp;
		else
			return targetPage;
	}

	public String getErrorJsp() {
		return m_ErrorJsp;
	}

	public String getErrorPage() {
		return m_ErrorPage;
	}

	public InputValidator getInputValidator() {
		return m_InputValidator;
	}

	public String getLoginPage() {
		return m_LoginPage;
	}

	public List<ProcessRequest> getPCList() {
		return m_PCList;
	}

	public SessionFactory getSessionFactory() {
		return m_SessionFactory;
	}

	public List<InputValidator> getVInputValidator() {
		return vInputValidator;
	}

	public void setVInputValidator(List<InputValidator> list) {
		vInputValidator = list;
	}

	public String getM_ServletCode() {
		return m_ServletCode;
	}

	public void setM_ServletCode(String m_ServletCode) {
		this.m_ServletCode = m_ServletCode;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Hashtable<String,Object> setFlowOfDatas(HttpServletRequest request, Session session) throws ServletException {
		String paramName = null;
		try {
			Hashtable requestParameter = (Hashtable) request.getAttribute(REQUESTPARAMETER);
			if (requestParameter == null) {
				requestParameter = new Hashtable<String,Object>();
				request.setAttribute(REQUESTPARAMETER, requestParameter);
			}
			for (Enumeration<String> e = request.getParameterNames(); e.hasMoreElements();) {
				paramName = (String) e.nextElement();
				String paramValues[] = request.getParameterValues(paramName);
				if (paramValues.length == 1 && !paramName.startsWith("lst_")) {
					if (paramName.indexOf("_pkIgs_") != -1) {
						assegnaDaCampoChiave(requestParameter, paramName, paramValues[0], session);
					} else {
						requestParameter.put(paramName, paramValues[0]);
					}
				} else if (paramName.indexOf("_pkIgs_") != -1) {
					assegnaDaCampoChiave(requestParameter, paramName, paramValues, session);
				} else {
					requestParameter.put(paramName, paramValues);
				}
			}

			// Aggiungo la HttpRequest e ServletContext ai parametri
			requestParameter.put(HTTP_SERVLET_REQUEST, request);
			requestParameter.put(HTTP_SERVLET_CONTEXT, getServletContext());
			//
			
			return requestParameter;
		} catch (AppSecurityException ase) {
			throw ase;
		} catch (Exception e) {
			throw new InputValidatorException(Bundle.getInstance().getBundle().getString("msgFodKo") + " <" + paramName + ">", e);
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void assegnaDaCampoChiave(Hashtable requestParameter, String paramName, String paramValue, Session session) throws Exception {
		requestParameter.put(paramName, StandardSecurityManager.deHashPrimaryKey(paramValue, session.getSecurityKey()));
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void assegnaDaCampoChiave(Hashtable requestParameter, String paramName, String paramValues[], Session session) throws Exception {
		for (int i = 0; i < paramValues.length; i++)
			paramValues[i] = StandardSecurityManager.deHashPrimaryKey(paramValues[i], session.getSecurityKey());

		requestParameter.put(paramName, paramValues);
	}

	public void checkWorkflow(HttpServletRequest request, Session session) throws WorkflowException {
		if (request.getAttribute(REQUESTPARAMETER) == null && 
			getServletConfig().getInitParameter("workflow") != null) {
			
			String servletCodeFrom = session.getServletCode();
			String grantList = getServletConfig().getInitParameter("workflow");
			if (grantList.indexOf(",*,") == -1) {
				if (grantList.indexOf("," + servletCodeFrom + ",") == -1)
					throw new WorkflowException(Bundle.getInstance().getBundle().getString("msgWorkflowKo"), new Exception("Accesso da <" + servletCodeFrom + "> a <" + m_ServletCode + "> NEGATO"));
			} else if (grantList.indexOf(",e." + servletCodeFrom + ",") > -1)
				throw new WorkflowException(Bundle.getInstance().getBundle().getString("msgWorkflowKo"), new Exception("Accesso da <" + servletCodeFrom + "> a <" + m_ServletCode + "> NEGATO"));
		}
	}

	private void writeAccessLog(User user, HttpServletRequest request, Hashtable<String,Object> fod) {
		try {
			if ((accessLogWhat.indexOf(",*,") > -1 || accessLogWhat.indexOf("," + m_ServletCode + ",") > -1) && accessLogWhat.indexOf(",e." + m_ServletCode + ",") == -1)
				// AccessLogger.log(user, request, this, fod);
				accessLogger.info(LogUtils.getMessage(user, request, this, fod));
			// AccessLogger.resetCustomMessage(fod);
			LogUtils.resetCustomMessage(fod);
		} catch (Exception e) {
			accessLogger.error(Bundle.getInstance().getBundle().getString("msgAccessLogError") + " - " + e.getMessage(), e);
		}
	}

	protected abstract String viewControl(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse, Hashtable<String,Object> fod, Session session) throws Exception;

	protected abstract void initSuccessJsp(String s) throws Exception;

	
}