// Source File Name:   GenericServletViewController.java

package it.softecspa.mvc;

import it.softecspa.mvc.businesslogic.StandardViewController;
import it.softecspa.mvc.businesslogic.ViewController;
import it.softecspa.mvc.session.Session;

import java.util.Hashtable;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Referenced classes of package it.softecspa.mvc:
//            FwGenericServlet

@SuppressWarnings("serial")
public class GenericServletViewController extends FwGenericServlet {

	public GenericServletViewController() {
		m_ViewController = new StandardViewController();
	}

	protected void initBusinessLogic(ServletConfig config) throws Exception {
		super.initBusinessLogic(config);
		if (config.getInitParameter("ViewController") != null)
			m_ViewController = (ViewController) Class.forName(config.getInitParameter("ViewController")).newInstance();
	}

	protected String viewControl(HttpServletRequest request, HttpServletResponse response, Hashtable<String,Object> fod, Session webApplSession) throws Exception {
		String targetPage = m_ViewController.doControl(fod, response, webApplSession);
		request.setAttribute("successJsp", targetPage);
		return getContainerJsp(targetPage);
	}

	protected void initSuccessJsp(String successJsp) throws Exception {
		m_ViewController.init(successJsp);
	}

	private ViewController m_ViewController;
}
