// Source File Name:   MVCGenericServlet.java

package it.softecspa.mvc;

import it.softecspa.mvc.businesslogic.RequestController;
import it.softecspa.mvc.businesslogic.StandardRequestController;
import it.softecspa.mvc.session.Session;
import it.softecspa.mvc.utils.GenericServletUtils;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Referenced classes of package it.softecspa.mvc:
//            FwGenericServlet

@SuppressWarnings("serial")
public class MVCGenericServlet extends FwGenericServlet {

	@SuppressWarnings("rawtypes")
	public MVCGenericServlet() {
		m_JspList = new ArrayList();
		m_RequestController = new StandardRequestController();
	}

	protected void initBusinessLogic(ServletConfig config) throws Exception {
		super.initBusinessLogic(config);
		if (config.getInitParameter("RequestController") != null)
			m_RequestController = (RequestController) Class.forName(config.getInitParameter("RequestController")).newInstance();
	}

	protected String viewControl(HttpServletRequest request, HttpServletResponse response, Hashtable<String,Object> fod, Session webApplSession) throws Exception {
		if (m_JspList.size() > 0) {
			// m.veroni, modifica per "download"
			int jspIndex = m_RequestController.doControl(fod, response, webApplSession);
			if (jspIndex >= 0) {
				String targetPage = (String) m_JspList.get(jspIndex);
				request.setAttribute("successJsp", targetPage);
				return getContainerJsp(targetPage);
			}
		}

		return null;
	}

	protected void initSuccessJsp(String successJsp) throws Exception {
		GenericServletUtils.stringToArray(m_JspList, successJsp, true);
	}

	@SuppressWarnings("rawtypes")
	private List m_JspList;
	private RequestController m_RequestController;
}
