// Source File Name:   Paginatore.java

package it.softecspa.mvc.businesslogic;

import it.softecspa.mvc.businessobject.DbGeneric;
import it.softecspa.mvc.exceptions.AppException;

import java.sql.ResultSet;
import java.util.ArrayList;

public class Paginatore {

	@SuppressWarnings("rawtypes")
	public Paginatore() {
		numPagina = 0;
		objPerPagina = 1;
		pagineTotali = 1;
		vBusinessObj = new ArrayList();
		numPagina = -1;
	}

	@SuppressWarnings("rawtypes")
	public Paginatore(int numPagina, int objPerPagina) throws Exception {
		this.numPagina = 0;
		this.objPerPagina = 1;
		pagineTotali = 1;
		vBusinessObj = new ArrayList();
		if (numPagina >= 0 && objPerPagina > 0) {
			this.numPagina = numPagina;
			this.objPerPagina = objPerPagina;
		} else {
			throw new AppException("numero pagina o numero record per pagina errato. numPagina=<" + numPagina + "> record per pagina=<" + objPerPagina + ">");
		}
	}

	@SuppressWarnings("unchecked")
	public void getFromQuery(ResultSet r, DbGeneric bo) throws Exception {
		DbGeneric curRow = null;
		int i = 0;
		try {
			while (r.next()) {
				if (i >= numPagina * objPerPagina && i < (numPagina + 1) * objPerPagina || numPagina == -1) {
					curRow = bo.getIstance();
					curRow.getFromResultSet(r);
					vBusinessObj.add(curRow);
				}
				i++;
			}
			pagineTotali = (int) Math.ceil((float) i / (float) objPerPagina);
		} catch (Exception e) {
			r.close();
			throw new AppException("", e);
		}
	}

	public int getPagineTotali() {
		return pagineTotali;
	}

	@SuppressWarnings("rawtypes")
	public ArrayList getVBusinessObj() {
		return vBusinessObj;
	}

	public void clearVBusinessObj() {
		vBusinessObj.clear();
	}

	public int getNumPagina() {
		return numPagina;
	}

	public String toString() {
		StringBuffer str = new StringBuffer();
		str.append("numPagina   : ").append(numPagina).append("\n");
		str.append("pagineTotali: ").append(pagineTotali).append("\n");
		str.append("objPerPagina: ").append(objPerPagina).append("\n");
		str.append("objExtracted: ").append(vBusinessObj.size()).append("\n");
		return str.toString();
	}

	public static int DEFAULT_OBJ_IN_PAGE = 10;
	private int numPagina;
	private int objPerPagina;
	private int pagineTotali;
	@SuppressWarnings("rawtypes")
	private ArrayList vBusinessObj;

}
