package it.softecspa.mvc.businesslogic;

import it.softecspa.mvc.FwGenericServlet;
import it.softecspa.mvc.exceptions.ProcessingException;
import it.softecspa.mvc.session.Session;
import it.softecspa.portal.Parameters;

import java.util.Hashtable;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

public abstract class ProcessRequest {
	
	protected Parameters parameters = Parameters.getInstance();
	protected Logger logger = Logger.getLogger(getClass());

	
	protected HttpServletRequest request;
	protected HttpServletResponse response;
	protected ServletContext context;
	protected Session session;
	
	
	public void doProcessEvo(Hashtable<String, Object> fod, HttpServletResponse response, Session session) throws ProcessingException {
		this.request = (HttpServletRequest)fod.get(FwGenericServlet.HTTP_SERVLET_REQUEST);
		this.response = response;
		this.context = (ServletContext)fod.get(FwGenericServlet.HTTP_SERVLET_CONTEXT);
		this.session = session;
		
		doProcess(fod);
	}


	public abstract void doProcess(Hashtable<String, Object> fod) throws ProcessingException;


	protected HttpServletRequest getHttpServletRequest() {
		return request;
	}

	protected HttpServletResponse getHttpServletResponse() {
		return response;
	}

	protected ServletContext getServletContext() {
		return context;
	}


	public Session getSession() {
		return session;
	}

}
