// Source File Name:   StandardInputValidator.java

package it.softecspa.mvc.businesslogic;

import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;
import it.softecspa.mvc.utils.GenericUtils;
import it.softecspa.portal.Bundle;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;

// Referenced classes of package it.softecspa.mvc.businesslogic:
//            InputValidator, AppLogger

public class StandardInputValidator extends InputValidator {

	public StandardInputValidator() {
	}

	@Override
	public void doValidate(HttpServletRequest httpservletrequest, Session session, Hashtable<String, Object> fod) throws InputValidatorException {
	}

	public String riempiBusinessObject(Object businessObj, Hashtable<String, Object> fod) {
		return riempiBusinessObjectIdx(businessObj, fod, -1);
	}


	public String riempiBusinessObjectIdx(Object businessObj, Hashtable<String, Object> fod, int idxParam) {
		String campiInclusi = (String) fod.get("standardInputValidatorCampiOk");
		if (campiInclusi == null)
			campiInclusi = "";
		String msgErrore = "";
		Enumeration<String> enume = fod.keys();
		String campoForm = null;
		String labelCampoForm = null;
		Class<?> campoFormType[] = { (new String()).getClass() };
		String vParametro[] = new String[1];
		Method metodo = null;
		String className = businessObj.getClass().getName();
		for (StringTokenizer st = new StringTokenizer(className, "."); st.hasMoreTokens();)
			className = st.nextToken();

		logger.debug("className: <" + className + ">");
		boolean obbligatorio = true;
		boolean chiamaMetodo = false;
		String nomeCampoObj = null;
		while (enume.hasMoreElements()) {
			obbligatorio = true;
			chiamaMetodo = false;
			try {
				campoForm = (String) enume.nextElement();
				if (campiInclusi.indexOf("," + campoForm + ",") != -1) {
					if (campoForm.startsWith(className + "_")) {
						vParametro[0] = (String) fod.get(campoForm);
						nomeCampoObj = GenericUtils.rimpiazzaStringa(campoForm, "_pkIgs_", "");
						nomeCampoObj = nomeCampoObj.substring((className + "_").length());
						chiamaMetodo = true;
					} else if (campoForm.startsWith("lst_" + className + "_")) {
						vParametro[0] = ((String[]) fod.get(campoForm))[idxParam];
						nomeCampoObj = GenericUtils.rimpiazzaStringa(campoForm, "_pkIgs_", "");
						nomeCampoObj = nomeCampoObj.substring(("lst_" + className + "_").length());
						chiamaMetodo = true;
					}
					if (chiamaMetodo) {
						if (campoForm.endsWith("_no")) {
							nomeCampoObj = GenericUtils.rimpiazzaStringa(nomeCampoObj, "_no", "");
							if (vParametro[0] != null && vParametro[0].equals(""))
								obbligatorio = false;
						}
						metodo = businessObj.getClass().getMethod("set" + nomeCampoObj, campoFormType);
						if (obbligatorio || fod.get(campoForm) != null && !((String) fod.get(campoForm)).equals(""))
							metodo.invoke(businessObj, vParametro);
					}
				}
			} catch (Exception e) {
				if (obbligatorio) {
					labelCampoForm = (String) fod.get("label_" + className + "_" + nomeCampoObj);
					if (labelCampoForm == null)
						labelCampoForm = campoForm.substring((className + "_").length());
					msgErrore = msgErrore + "<br>\n- ";
					msgErrore = msgErrore + labelCampoForm + ": " + Bundle.getInstance().getBundle().getString("msgFieldNotCorrect");
				}
			}
		}
		return msgErrore;
	}

	public static final String PREFIX_NON_OBBLIGATORIO = "_no";
	public static final String RIEMPI_BUS_OBJ_CAMPI_OK = "standardInputValidatorCampiOk";
}
