// Source File Name:   StandardSecurityManager.java

package it.softecspa.mvc.businesslogic;

import it.softecspa.mvc.businessobject.DbGeneric;
import it.softecspa.mvc.exceptions.AppSecurityException;
import it.softecspa.mvc.exceptions.AuthenticationException;
import it.softecspa.mvc.exceptions.AuthorizationException;
import it.softecspa.mvc.session.Session;
import it.softecspa.mvc.utils.SecurityUtils;
import it.softecspa.portal.Bundle;

import java.util.Hashtable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

// Referenced classes of package it.softecspa.mvc.businesslogic:
//            SecurityManager

public class StandardSecurityManager implements SecurityManager {

	protected Logger log = Logger.getLogger(getClass());
	
	
	public boolean checkAuthorization(HttpServletRequest request, HttpServletResponse response, Hashtable<String,Object> fod, Session session) throws AuthorizationException {
		if (log.isTraceEnabled()) {
			log.trace("CheckAuthorization from "+getClass().getSimpleName());
		}
		// se TRUE indica un redirect
		return false;
	}

	public boolean login(HttpServletRequest request, HttpServletResponse response, Hashtable<String,Object> fod, Session session) throws AuthenticationException {
		if (log.isDebugEnabled()) {
			log.debug("login from "+StandardSecurityManager.class.getSimpleName());
		}
		// se TRUE indica un redirect
		return false;
	}

	public static String hashPrimaryKey(DbGeneric businessObj, String key) throws Exception {
		String pk = businessObj.getPrimaryKey();
		String nameCoded = businessObj.getCodedName();
		String pkEncoded = SecurityUtils.criptaInStringaByHash(nameCoded + pk + key);
		return nameCoded + "_" + pk + "_" + pkEncoded;
	}

	
	
	public static String hashKey(String nameCoded, String pk, String key) throws Exception {
		String nameCodedHashed = SecurityUtils.criptaInStringaByHash(nameCoded);
		String pkEncoded = SecurityUtils.criptaInStringaByHash(nameCodedHashed + pk + key);
		return nameCodedHashed + "_" + pk + "_" + pkEncoded;
	}

	
	public static String deHashPrimaryKey(String encodedStr, String key) throws Exception {
		int ultimoSep = encodedStr.lastIndexOf("_");
		int classNameSep = encodedStr.indexOf("_");
		String pk = encodedStr.substring(classNameSep + "_".length(), ultimoSep);
		String pkEncoded = encodedStr.substring(ultimoSep + "_".length());
		String codedName = encodedStr.substring(0, classNameSep);
		if (pkEncoded.equals(SecurityUtils.criptaInStringaByHash(codedName + pk + key)))
			return pk;
		else
			throw new AppSecurityException(Bundle.getInstance().getBundle().getString("msgDecodingKo"));
	}

	
	public static final String getSecretKey() {
		return secretKey;
	}

	public static final void setSecretKey(String key) {
		secretKey = key;
	}

	
	private static String secretKey = null;
	@SuppressWarnings("unused")
	private static final String PK_SEP_CHAR = "_";
	@SuppressWarnings("unused")
	private static final String TIPO_PK_SEP_CHAR = "_";

}
