/*
 * Created on 8-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.mvc.businessobject;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DBMS;
import it.softecspa.database.dbconnect.SQLTimeoutException;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

import org.apache.log4j.Logger;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.resourcepool.TimeoutException;

public class StandardConnectionManager extends ConnectionManager {
	
	public final String C3P0_STATS_LOG_CATEGORY = "it.softecspa.database.c3p0.stats";
	
	private Logger log = Logger.getLogger(getClass());
	private Logger logC3P0Stats = Logger.getLogger(C3P0_STATS_LOG_CATEGORY);

	
	final String CONTEXT_NAME = "java:/comp/env";
	private DataSource datasource = null;
	private String name;
	
	public StandardConnectionManager(String datasourceName, DBMS dbms) throws Exception {
		super(dbms);
		try {
			this.name = datasourceName;
			//
			Context initContext = new InitialContext();
			Context envContext = (Context) initContext.lookup(CONTEXT_NAME);
			log.info("DataSource: <" + CONTEXT_NAME + "/" + datasourceName + "> init... ");
			datasource = (DataSource) envContext.lookup(datasourceName);

			if (datasource instanceof ComboPooledDataSource) {
				log.info("Found c3p0 ComboPooledDataSource, marked with name '" + datasourceName + "'");
				if (logC3P0Stats.isTraceEnabled()) {
					log.info("Found c3p0 ComboPooledDataSource, marked with name '" + datasourceName + "'");
				}
				ComboPooledDataSource pds = (ComboPooledDataSource) datasource;
				pds.setDataSourceName(datasourceName);
			/* m.veroni, 2012-12-12 sostituito con blocco sopra	
			} else if (datasource instanceof PooledDataSource) {
				log.info("Found c3p0 PooledDataSource, mark with name '" + datasourceName + "'");
				if (logC3P0Stats.isInfoEnabled()) log.info("Found c3p0 PooledDataSource, mark with name '" + datasourceName + "'");
				PooledDataSource pds = (PooledDataSource) datasource;
				pds.setDataSourceName(datasourceName);
			*/
			} else {
				log.info("DataSource '" + datasourceName + "' is not c3p0 ComboPooledDataSource!");
			}

		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * Recupera una connessione dal connection pool
	 */
	public Connection getConnection() throws SQLException {
		try {			
			// Se il log  impostato stampa alcune informazioni statistiche
			// ----------------------------------------------------------------------------------
			try {
				if (logC3P0Stats.isTraceEnabled()) {
					if (datasource!=null && datasource instanceof ComboPooledDataSource) {
						logC3P0Stats.trace(toJSon((ComboPooledDataSource) datasource, null));				
					}
				}
			} catch (Exception e) {
				/* Nessuna oparazione */ 
			}
			
			// ----------------------------------------------------------------------------------
			Connection conn = datasource.getConnection();
			conn.setAutoCommit(false);
			return conn;
			
		} catch (Exception e) {
			if (datasource!=null) {
				synchronized (datasource) {				
					// --------------------------------------------------------------------------
					if (datasource instanceof ComboPooledDataSource) {
						try {
							log.error(toLog((ComboPooledDataSource) datasource, e));
						} catch (Exception ei) {
							log.warn("Error tracing ComboPooledDataSource statistics: "+ei.toString());
						}
						// --------------------------------------------------------------------------
						try {
							if (logC3P0Stats.isTraceEnabled()) {
								logC3P0Stats.error(toJSon((ComboPooledDataSource) datasource, e));
							}
						} catch (Exception ei) {
							log.warn("Error tracing ComboPooledDataSource statistics in logC3P0Stats file: "+ei.toString());
						}
					}
					
					// --------------------------------------------------------------------------
					if (e instanceof SQLException) {
						if (e.getCause()!=null && e.getCause() instanceof TimeoutException)
						throw new SQLTimeoutException(e.getCause());
					}
					
				}		
			}
			
			// Throw dell'errore
			if (e instanceof SQLException) {
				throw (SQLException)e;
			}
			throw new SQLException("Connection not acquired: " +e.toString());	
		}
	}

	
	/**
	 * Restitutisce lo stato del PooledDataSource in formato JSON
	 * @param pds
	 * @return
	 */
	private String toJSon(ComboPooledDataSource pds, Throwable cause) {
		try {
			return  "{\"name\":\"" + name + "\"" +
				    ",\"identity-token\":\"" + pds.getIdentityToken() + "\"" +
				    ",\"connections\":{\"max\":\"" + pds.getMaxPoolSize() + "\"" +
				    				 ",\"number\":\"" + pds.getNumConnectionsAllUsers() + "\"" +
				   				 	 ",\"busy\":\""+ pds.getNumBusyConnectionsAllUsers() + "\"" +
							 		 ",\"idle\":\"" + pds.getNumIdleConnectionsAllUsers() + "\"" +
							 		 ",\"orphan\":\"" + pds.getNumUnclosedOrphanedConnectionsAllUsers() + "\"" +
							 		 "}" +
					",\"statement-cache\":{\"number\":\""+ pds.getStatementCacheNumStatementsAllUsers() + "\"" +
					 		  		  	 ",\"connection-with\":\"" + pds.getStatementCacheNumConnectionsWithCachedStatementsAllUsers() + "\"" +
							 		  	 ",\"checked-out\":\""+ pds.getStatementCacheNumCheckedOutStatementsAllUsers() + "\"" +
							 		  	 "}" +
					",\"threads\":{\"size\":\"" + pds.getThreadPoolSize() + "\"" +
								 ",\"active\":\"" + pds.getThreadPoolNumActiveThreads() + "\"" +
							 	 ",\"idle\":\"" + pds.getThreadPoolNumIdleThreads() + "\"" +
							 	 ",\"pending\":\"" + pds.getThreadPoolNumTasksPending() + "\"" +
							 	 "}" + 
					(cause!=null?"\"error\":\""+cause+"\"":"") +
					"}";
		} catch (Exception e) {
			return 	"{\"name\":\"" + name + "\"," +
					",\"exception\":\"" + e.toString() + "\"" +
					(cause!=null?"\"error\":\""+cause+"\"":"") +
					"}";
		}
	}
	
	/**
	 * Restitutisce lo stato del PooledDataSource in formato standard
	 * @param pds
	 * @return
	 */
	private String toLog(ComboPooledDataSource pds, Throwable cause) {
		try {
			return "Error getConnection from DataSource '" + name + "'"+(cause!=null?": "+cause.getMessage():"") + "\n" +
				   "------------------------------------------------------------\n" +
				   "Identity-token: '" + pds.getIdentityToken() + "'\n" +
				   "Connections max: " + pds.getMaxPoolSize() + "\n" +
				   "            number: " + pds.getNumConnectionsAllUsers() + "\n" +
				   "            busy: "+ pds.getNumBusyConnectionsAllUsers() + "\n" +
				   "            idle: " + pds.getNumIdleConnectionsAllUsers() + "\n" +
				   "            orphan: " + pds.getNumUnclosedOrphanedConnectionsAllUsers() + "\n" +
				   "Statement-cache number : "+ pds.getStatementCacheNumStatementsAllUsers() + "\n" +
				   "                connection-with: " + pds.getStatementCacheNumConnectionsWithCachedStatementsAllUsers() + "\n" +
				   "                checked-out: "+ pds.getStatementCacheNumCheckedOutStatementsAllUsers() + "\n" +
				   "Threads size: " + pds.getThreadPoolSize() + "\n" +
				   "        active: " + pds.getThreadPoolNumActiveThreads() + "\n" +
				   "        idle: " + pds.getThreadPoolNumIdleThreads() + "\n" +
				   "        pending: " + pds.getThreadPoolNumTasksPending() + "\n" +
				   "------------------------------------------------------------";
		} catch (Exception e) {
			return "Error getConnection from DataSource '" + name + "'"+(cause!=null?": "+cause:"") + "\n" +
					"------------------------------------------------------------\n" +
					"Exception: " + e.toString() + "\n" +
				    "------------------------------------------------------------";
		}
	}
	
	/**
	 * Libera la connessione acquisita dal connection pool
	 */
	public void closeConnection(Connection conn) throws SQLException {
		try {
			if (conn != null && !conn.isClosed())
				conn.close();
		} catch (Exception e) {
			throw new SQLException(e.getMessage());
		}
	}

	/**
	 * Puntatore diretto ala datasource
	 * @return
	 */
	public DataSource getDataSource() {
		return datasource;
	}
}
