package it.softecspa.mvc.businessobject;

import it.softecspa.database.dbconnect.DBMS;

public class StandardDataSourceConfig {

	private String name;
	private String type;
	private DBMS dbms;
	private boolean readonly;

	public StandardDataSourceConfig(String element, boolean readonly) throws Exception {
		String[] info = element.trim().split("#");
		if (info.length != 2)
			throw new Exception("Error in datasource configuration; check properties file, missing DBMS type. Ex: foo.datasource#MYSQL");

		this.name = info[0];
		this.type = info[1].trim().toUpperCase();
		this.dbms = DBMS.getDBMS(type);
		this.readonly = readonly;
	}

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}

	public DBMS getDbms() {
		return dbms;
	}

	public boolean isReadonly() {
		return readonly;
	}
	
	@Override
	public String toString() {
		return name+"-"+type+"-["+(readonly?"readonly":"writable")+"]";
	}

}