// Source File Name:   StandardSession.java

package it.softecspa.mvc.session;

import it.softecspa.mvc.businessobject.User;
import it.softecspa.mvc.utils.SecurityUtils;

import java.util.Hashtable;
import java.util.Iterator;

// Referenced classes of package it.softecspa.mvc.session:
//            Session

@SuppressWarnings("serial")
public class StandardSession implements Session {

	public static final String SERVLET_CODE_NO_FUNCTION = "PC-NO_FUNCTION-PC";
	private User utente;
	@SuppressWarnings("rawtypes")
	private Hashtable sessione;
	private String securityKey;
	private String servletCode;
	private String language;

	@SuppressWarnings("rawtypes")
	public StandardSession() {
		utente = null;
		sessione = new Hashtable();
		securityKey = null;
		servletCode = null;
		language = null;
	}

	public String getLanguage() {
		return language;
	}

	public void setLanguage(String language) {
		this.language = language;
	}

	public Object getAttribute(String attributeName) {
		return sessione.get(attributeName);
	}

	@SuppressWarnings("rawtypes")
	public Iterator getAttributeNames() {
		return null;
	}

	public void removeAttribute(String attributeName) {
		sessione.remove(attributeName);
	}

	@SuppressWarnings("unchecked")
	public void setAttribute(String attributeName, Object attributeValue) {
		sessione.put(attributeName, attributeValue);
	}

	public User getUser() {
		return utente;
	}

	public void setUser(User utente) {
		this.utente = utente;
	}

	public void initSecurityKey() throws Exception {
		securityKey = SecurityUtils.generateRandomString(50);
	}

	public String getSecurityKey() {
		return securityKey;
	}

	public void setServletCode(String servletCode) {
		this.servletCode = servletCode;
	}

	public String getServletCode() {
		return servletCode;
	}

	public void cleanAll() {
		sessione.clear();
		setServletCode("PC-NO_FUNCTION-PC");
	}

	public boolean isEmpty() {
		return sessione.isEmpty();
	}

}
