// Source File Name:   Bits.java

package it.softecspa.mvc.utils;

public class Bits {

	public Bits() {
	}

	public static boolean getBoolean(byte b[], int off) {
		return b[off] != 0;
	}

	public static char getChar(byte b[], int off) {
		return (char) (((b[off + 1] & 0xff) << 0) + ((b[off + 0] & 0xff) << 8));
	}

	public static short getShort(byte b[], int off) {
		return (short) (((b[off + 1] & 0xff) << 0) + ((b[off + 0] & 0xff) << 8));
	}

	public static int getInt(byte b[], int off) {
		return ((b[off + 3] & 0xff) << 0) + ((b[off + 2] & 0xff) << 8) + ((b[off + 1] & 0xff) << 16) + ((b[off + 0] & 0xff) << 24);
	}

	public static float getFloat(byte b[], int off) {
		int i = ((b[off + 3] & 0xff) << 0) + ((b[off + 2] & 0xff) << 8) + ((b[off + 1] & 0xff) << 16) + ((b[off + 0] & 0xff) << 24);
		return Float.intBitsToFloat(i);
	}

	public static long getLong(byte b[], int off) {
		return (((long) b[off + 7] & 255L) << 0) + (((long) b[off + 6] & 255L) << 8) + (((long) b[off + 5] & 255L) << 16) + (((long) b[off + 4] & 255L) << 24) + (((long) b[off + 3] & 255L) << 32) + (((long) b[off + 2] & 255L) << 40)
				+ (((long) b[off + 1] & 255L) << 48) + (((long) b[off + 0] & 255L) << 56);
	}

	public static double getDouble(byte b[], int off) {
		long j = (((long) b[off + 7] & 255L) << 0) + (((long) b[off + 6] & 255L) << 8) + (((long) b[off + 5] & 255L) << 16) + (((long) b[off + 4] & 255L) << 24) + (((long) b[off + 3] & 255L) << 32) + (((long) b[off + 2] & 255L) << 40)
				+ (((long) b[off + 1] & 255L) << 48) + (((long) b[off + 0] & 255L) << 56);
		return Double.longBitsToDouble(j);
	}

	public static void putBoolean(byte b[], int off, boolean val) {
		b[off] = (byte) (val ? 1 : 0);
	}

	public static void putChar(byte b[], int off, char val) {
		b[off + 1] = (byte) (val >>> 0);
		b[off + 0] = (byte) (val >>> 8);
	}

	public static void putShort(byte b[], int off, short val) {
		b[off + 1] = (byte) (val >>> 0);
		b[off + 0] = (byte) (val >>> 8);
	}

	public static void putInt(byte b[], int off, int val) {
		b[off + 3] = (byte) (val >>> 0);
		b[off + 2] = (byte) (val >>> 8);
		b[off + 1] = (byte) (val >>> 16);
		b[off + 0] = (byte) (val >>> 24);
	}

	public static void putFloat(byte b[], int off, float val) {
		int i = Float.floatToIntBits(val);
		b[off + 3] = (byte) (i >>> 0);
		b[off + 2] = (byte) (i >>> 8);
		b[off + 1] = (byte) (i >>> 16);
		b[off + 0] = (byte) (i >>> 24);
	}

	public static void putLong(byte b[], int off, long val) {
		b[off + 7] = (byte) (int) (val >>> 0);
		b[off + 6] = (byte) (int) (val >>> 8);
		b[off + 5] = (byte) (int) (val >>> 16);
		b[off + 4] = (byte) (int) (val >>> 24);
		b[off + 3] = (byte) (int) (val >>> 32);
		b[off + 2] = (byte) (int) (val >>> 40);
		b[off + 1] = (byte) (int) (val >>> 48);
		b[off + 0] = (byte) (int) (val >>> 56);
	}

	public static void putDouble(byte b[], int off, double val) {
		long j = Double.doubleToLongBits(val);
		b[off + 7] = (byte) (int) (j >>> 0);
		b[off + 6] = (byte) (int) (j >>> 8);
		b[off + 5] = (byte) (int) (j >>> 16);
		b[off + 4] = (byte) (int) (j >>> 24);
		b[off + 3] = (byte) (int) (j >>> 32);
		b[off + 2] = (byte) (int) (j >>> 40);
		b[off + 1] = (byte) (int) (j >>> 48);
		b[off + 0] = (byte) (int) (j >>> 56);
	}
}
