// Source File Name:   CodiceFiscale.java

package it.softecspa.mvc.utils;

import java.util.GregorianCalendar;

public class CodiceFiscale {

	public CodiceFiscale() {
		cf = new String();
		mese = 0;
		giorno = 0;
	}

	public void setSesso(String appo) throws Exception {
		sesso = new String(appo);
		if (sesso.compareTo("M") != 0 && sesso.compareTo("F") != 0)
			throw new Exception("Il sesso non \350 corretto");
		else
			return;
	}

	public void setNome(String appo) {
		int i = 0;
		nome = new String(appo);
		i = nome.indexOf(' ');
		if (i != -1)
			nome = nome.substring(0, i) + nome.substring(i + 1, nome.length());
	}

	public void setCognome(String appo) {
		cognome = new String(appo);
	}

	public void setAnno(int appo) {
		anno = new Integer(appo);
		aa = new String(anno.toString());
		if (aa.length() > 2)
			aa = aa.substring(2, 4);
	}

	public void setMese(int appo) {
		if (appo > 0 && appo < 13)
			mese = appo;
	}

	public void setGiorno(int appo) {
		if (appo > 0 && appo < 32)
			giorno = appo;
	}

	public void setCodiceComune(String appo) {
		codicecomune = new String(appo);
	}

	public void setDataNascita(GregorianCalendar dataNascita) {
		setAnno(dataNascita.get(1));
		setMese(dataNascita.get(2) + 1);
		setGiorno(dataNascita.get(5));
	}

	public String getCodiceFiscale() throws Exception {
		if (nome == null || cognome == null || aa == null || codicecomune == null || mese == 0 || giorno == 0 || sesso == null) {
			return null;
		} else {
			aggiungiConsoCognome();
			aggiungiConsoNome();
			cf += aa;
			aggiungiMese();
			aggiungiGiorno();
			cf += codicecomune;
			aggiungiControllo();
			return cf;
		}
	}

	private void aggiungiConsoCognome() {
		String appo = new String();
		int i = 0;
		int j;
		for (j = 0; j < cognome.length(); j++) {
			if (cognome.charAt(j) != 'a' && cognome.charAt(j) != 'e' && cognome.charAt(j) != 'i' && cognome.charAt(j) != 'o' && cognome.charAt(j) != 'a' && cognome.charAt(j) != 'u') {
				appo = appo + cognome.substring(j, j + 1);
				i++;
			}
			if (i == 3)
				break;
		}

		j = 0;
		if (i < 3) {
			for (; j < cognome.length(); j++) {
				if (cognome.charAt(j) == 'a' || cognome.charAt(j) == 'e' || cognome.charAt(j) == 'i' || cognome.charAt(j) == 'o' || cognome.charAt(j) == 'a' || cognome.charAt(j) == 'u') {
					appo = appo + cognome.substring(j, j + 1);
					i++;
				}
				if (i == 3)
					break;
			}

			if (i < 3)
				for (; i < 3; i++)
					appo = appo + 'x';

		}
		cf += appo;
	}

	private void aggiungiConsoNome() {
		String appo = new String();
		int i = 0;
		int j;
		for (j = 0; j < nome.length(); j++) {
			if (nome.charAt(j) != 'a' && nome.charAt(j) != 'e' && nome.charAt(j) != 'i' && nome.charAt(j) != 'o' && nome.charAt(j) != 'a' && nome.charAt(j) != 'u') {
				appo = appo + nome.substring(j, j + 1);
				i++;
			}
			if (i == 4)
				break;
		}

		if (i == 3) {
			cf += appo;
			return;
		}
		if (i == 4) {
			cf = cf + appo.charAt(0) + appo.charAt(2) + appo.charAt(3);
			return;
		}
		j = 0;
		if (i < 3) {
			for (; j < nome.length(); j++) {
				if (nome.charAt(j) == 'a' || nome.charAt(j) == 'e' || nome.charAt(j) == 'i' || nome.charAt(j) == 'o' || nome.charAt(j) == 'a' || nome.charAt(j) == 'u') {
					appo = appo + nome.substring(j, j + 1);
					i++;
				}
				if (i == 3)
					break;
			}

			if (i < 3)
				for (; i < 3; i++)
					appo = appo + 'x';

		}
		cf += appo;
	}

	private void aggiungiMese() {
		char c_mese = ' ';
		if (mese == 1)
			c_mese = 'A';
		if (mese == 2)
			c_mese = 'B';
		if (mese == 3)
			c_mese = 'C';
		if (mese == 4)
			c_mese = 'D';
		if (mese == 5)
			c_mese = 'E';
		if (mese == 6)
			c_mese = 'H';
		if (mese == 7)
			c_mese = 'L';
		if (mese == 8)
			c_mese = 'M';
		if (mese == 9)
			c_mese = 'P';
		if (mese == 10)
			c_mese = 'R';
		if (mese == 11)
			c_mese = 'S';
		if (mese == 12)
			c_mese = 'T';
		cf += c_mese;
	}

	private void aggiungiGiorno() {
		if (sesso.compareTo("F") == 0)
			giorno += 40;
		if (giorno < 10)
			cf = cf + '0' + giorno;
		else
			cf += giorno;
	}

	private void aggiungiControllo() throws Exception {
		cf += calcolaCodiceControllo(cf);
	}

	public boolean checkCodiceControllo(String codiceFiscale) throws Exception {
		boolean esito = false;
		String newCodFiscale = codiceFiscale.substring(0, codiceFiscale.length() - 1);
		newCodFiscale = newCodFiscale + calcolaCodiceControllo(newCodFiscale);
		if (codiceFiscale.toLowerCase().equals(newCodFiscale.toLowerCase()))
			esito = true;
		return esito;
	}

	public char calcolaCodiceControllo(String codiceSenzaControllo) throws Exception {
		int controllo = 0;
		int i = 0;
		int i_appo = 0;
		for (codiceSenzaControllo = codiceSenzaControllo.toUpperCase(); i < codiceSenzaControllo.length(); i += 2) {
			controllo += getValoreDispari(codiceSenzaControllo.charAt(i));
			if (i + 1 < codiceSenzaControllo.length())
				controllo += getValorePari(codiceSenzaControllo.charAt(i + 1));
		}

		i_appo = controllo % 26;
		char appo = getValoreControllo(i_appo);
		return appo;
	}

	private int getValoreDispari(char carattere) throws Exception {
		int codice = 0;
		switch (carattere) {
		case 48: // '0'
			codice = 1;
			break;

		case 49: // '1'
			codice = 0;
			break;

		case 50: // '2'
			codice = 5;
			break;

		case 51: // '3'
			codice = 7;
			break;

		case 52: // '4'
			codice = 9;
			break;

		case 53: // '5'
			codice = 13;
			break;

		case 54: // '6'
			codice = 15;
			break;

		case 55: // '7'
			codice = 17;
			break;

		case 56: // '8'
			codice = 19;
			break;

		case 57: // '9'
			codice = 21;
			break;

		case 65: // 'A'
			codice = 1;
			break;

		case 66: // 'B'
			codice = 0;
			break;

		case 67: // 'C'
			codice = 5;
			break;

		case 68: // 'D'
			codice = 7;
			break;

		case 69: // 'E'
			codice = 9;
			break;

		case 70: // 'F'
			codice = 13;
			break;

		case 71: // 'G'
			codice = 15;
			break;

		case 72: // 'H'
			codice = 17;
			break;

		case 73: // 'I'
			codice = 19;
			break;

		case 74: // 'J'
			codice = 21;
			break;

		case 75: // 'K'
			codice = 2;
			break;

		case 76: // 'L'
			codice = 4;
			break;

		case 77: // 'M'
			codice = 18;
			break;

		case 78: // 'N'
			codice = 20;
			break;

		case 79: // 'O'
			codice = 11;
			break;

		case 80: // 'P'
			codice = 3;
			break;

		case 81: // 'Q'
			codice = 6;
			break;

		case 82: // 'R'
			codice = 8;
			break;

		case 83: // 'S'
			codice = 12;
			break;

		case 84: // 'T'
			codice = 14;
			break;

		case 85: // 'U'
			codice = 16;
			break;

		case 86: // 'V'
			codice = 10;
			break;

		case 87: // 'W'
			codice = 22;
			break;

		case 88: // 'X'
			codice = 25;
			break;

		case 89: // 'Y'
			codice = 24;
			break;

		case 90: // 'Z'
			codice = 23;
			break;

		case 58: // ':'
		case 59: // ';'
		case 60: // '<'
		case 61: // '='
		case 62: // '>'
		case 63: // '?'
		case 64: // '@'
		default:
			throw new Exception("Errore carattere" + carattere);
		}
		return codice;
	}

	private int getValorePari(char carattere) throws Exception {
		int codice = 0;
		switch (carattere) {
		case 48: // '0'
			codice = 0;
			break;

		case 49: // '1'
			codice = 1;
			break;

		case 50: // '2'
			codice = 2;
			break;

		case 51: // '3'
			codice = 3;
			break;

		case 52: // '4'
			codice = 4;
			break;

		case 53: // '5'
			codice = 5;
			break;

		case 54: // '6'
			codice = 6;
			break;

		case 55: // '7'
			codice = 7;
			break;

		case 56: // '8'
			codice = 8;
			break;

		case 57: // '9'
			codice = 9;
			break;

		case 65: // 'A'
			codice = 0;
			break;

		case 66: // 'B'
			codice = 1;
			break;

		case 67: // 'C'
			codice = 2;
			break;

		case 68: // 'D'
			codice = 3;
			break;

		case 69: // 'E'
			codice = 4;
			break;

		case 70: // 'F'
			codice = 5;
			break;

		case 71: // 'G'
			codice = 6;
			break;

		case 72: // 'H'
			codice = 7;
			break;

		case 73: // 'I'
			codice = 8;
			break;

		case 74: // 'J'
			codice = 9;
			break;

		case 75: // 'K'
			codice = 10;
			break;

		case 76: // 'L'
			codice = 11;
			break;

		case 77: // 'M'
			codice = 12;
			break;

		case 78: // 'N'
			codice = 13;
			break;

		case 79: // 'O'
			codice = 14;
			break;

		case 80: // 'P'
			codice = 15;
			break;

		case 81: // 'Q'
			codice = 16;
			break;

		case 82: // 'R'
			codice = 17;
			break;

		case 83: // 'S'
			codice = 18;
			break;

		case 84: // 'T'
			codice = 19;
			break;

		case 85: // 'U'
			codice = 20;
			break;

		case 86: // 'V'
			codice = 21;
			break;

		case 87: // 'W'
			codice = 22;
			break;

		case 88: // 'X'
			codice = 23;
			break;

		case 89: // 'Y'
			codice = 24;
			break;

		case 90: // 'Z'
			codice = 25;
			break;

		case 58: // ':'
		case 59: // ';'
		case 60: // '<'
		case 61: // '='
		case 62: // '>'
		case 63: // '?'
		case 64: // '@'
		default:
			throw new Exception("Errore carattere" + carattere);
		}
		return codice;
	}

	private char getValoreControllo(int valore) {
		char ritorno = ' ';
		switch (valore) {
		case 0: // '\0'
			ritorno = 'A';
			break;

		case 1: // '\001'
			ritorno = 'B';
			break;

		case 2: // '\002'
			ritorno = 'C';
			break;

		case 3: // '\003'
			ritorno = 'D';
			break;

		case 4: // '\004'
			ritorno = 'E';
			break;

		case 5: // '\005'
			ritorno = 'F';
			break;

		case 6: // '\006'
			ritorno = 'G';
			break;

		case 7: // '\007'
			ritorno = 'H';
			break;

		case 8: // '\b'
			ritorno = 'I';
			break;

		case 9: // '\t'
			ritorno = 'J';
			break;

		case 10: // '\n'
			ritorno = 'K';
			break;

		case 11: // '\013'
			ritorno = 'L';
			break;

		case 12: // '\f'
			ritorno = 'M';
			break;

		case 13: // '\r'
			ritorno = 'N';
			break;

		case 14: // '\016'
			ritorno = 'O';
			break;

		case 15: // '\017'
			ritorno = 'P';
			break;

		case 16: // '\020'
			ritorno = 'Q';
			break;

		case 17: // '\021'
			ritorno = 'R';
			break;

		case 18: // '\022'
			ritorno = 'S';
			break;

		case 19: // '\023'
			ritorno = 'T';
			break;

		case 20: // '\024'
			ritorno = 'U';
			break;

		case 21: // '\025'
			ritorno = 'V';
			break;

		case 22: // '\026'
			ritorno = 'W';
			break;

		case 23: // '\027'
			ritorno = 'X';
			break;

		case 24: // '\030'
			ritorno = 'Y';
			break;

		case 25: // '\031'
			ritorno = 'Z';
			break;
		}
		return ritorno;
	}

	public boolean isCodiceFiscale(String cod) {
		char base[] = cod.toCharArray();
		return '0' > base[0] || base[0] > '9';
	}

	public static boolean isMaschio(String codiceFiscale) {
		return Integer.parseInt(codiceFiscale.substring(9, 11)) <= 31;
	}

	private String cf;
	private String nome;
	private String cognome;
	private String aa;
	private String codicecomune;
	private String sesso;
	private Integer anno;
	private int mese;
	private int giorno;
}
