// Source File Name:   FiltroFile.java

package it.softecspa.mvc.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;

// Referenced classes of package it.softecspa.mvc.utils:
//            StringSplitter, GenericUtils

public class FiltroFile implements FileFilter {

	
	@SuppressWarnings("rawtypes")
	ArrayList vFiltro;
	boolean comprendiDir;
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public FiltroFile(String filtro, boolean comprendiDir) throws Exception {
		vFiltro = new ArrayList();
		this.comprendiDir = false;
		if (filtro == null || filtro.trim().equals(""))
			throw new Exception("Filtro file errato");
		for (StringSplitter sp = new StringSplitter(filtro, ","); sp.hasMoreElements(); vFiltro.add(sp.nextToken()))
			;
		this.comprendiDir = comprendiDir;
	}

	@SuppressWarnings("rawtypes")
	public boolean accept(File actualFile) {
		if (actualFile.isDirectory() && comprendiDir)
			return true;
		String stringaFiltro = "";
		Iterator iFiltro = vFiltro.iterator();
		String filtro = "";
		while (iFiltro.hasNext()) {
			filtro = (String) iFiltro.next();
			stringaFiltro = GenericUtils.rimpiazzaStringa(filtro, "*", "");
			if (filtro.startsWith("*") || filtro.endsWith("*")) {
				if (actualFile.getName().indexOf(stringaFiltro) > -1)
					return true;
			} else if (filtro.startsWith("*")) {
				if (actualFile.getName().endsWith(stringaFiltro))
					return true;
			} else if (filtro.endsWith("*")) {
				if (actualFile.getName().startsWith(stringaFiltro))
					return true;
			} else if (filtro.equals(stringaFiltro))
				return true;
		}
		return false;
	}

	
}
